/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import java.util.Set;
import org.joni.WarnCallback;
import org.joni.ast.Node;
import org.joni.exception.InternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsAltNode
extends Node {
    public Node car;
    public ConsAltNode cdr;
    private int type;

    private ConsAltNode(Node node, ConsAltNode consAltNode, int n) {
        this.car = node;
        if (node != null) {
            node.parent = this;
        }
        this.cdr = consAltNode;
        if (consAltNode != null) {
            consAltNode.parent = this;
        }
        this.type = n;
    }

    public static ConsAltNode newAltNode(Node node, ConsAltNode consAltNode) {
        return new ConsAltNode(node, consAltNode, 9);
    }

    public static ConsAltNode newListNode(Node node, ConsAltNode consAltNode) {
        return new ConsAltNode(node, consAltNode, 8);
    }

    public static ConsAltNode listAdd(ConsAltNode consAltNode, Node node) {
        ConsAltNode consAltNode2 = ConsAltNode.newListNode(node, null);
        if (consAltNode != null) {
            while (consAltNode.cdr != null) {
                consAltNode = consAltNode.cdr;
            }
            consAltNode.setCdr(consAltNode2);
        }
        return consAltNode2;
    }

    public void toListNode() {
        this.type = 8;
    }

    public void toAltNode() {
        this.type = 9;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    protected void setChild(Node node) {
        this.car = node;
    }

    @Override
    protected Node getChild() {
        return this.car;
    }

    @Override
    public void swap(Node node) {
        if (this.cdr != null) {
            this.cdr.parent = node;
            if (node instanceof ConsAltNode) {
                ConsAltNode consAltNode = (ConsAltNode)node;
                consAltNode.cdr.parent = this;
                ConsAltNode consAltNode2 = this.cdr;
                this.cdr = consAltNode.cdr;
                consAltNode.cdr = consAltNode2;
            }
        }
        super.swap(node);
    }

    @Override
    public void verifyTree(Set<Node> set, WarnCallback warnCallback) {
        if (!set.contains(this)) {
            set.add(this);
            if (this.car != null) {
                if (this.car.parent != this) {
                    warnCallback.warn("broken list car: " + this.getAddressName() + " -> " + this.car.getAddressName());
                }
                this.car.verifyTree(set, warnCallback);
            }
            if (this.cdr != null) {
                if (this.cdr.parent != this) {
                    warnCallback.warn("broken list cdr: " + this.getAddressName() + " -> " + this.cdr.getAddressName());
                }
                this.cdr.verifyTree(set, warnCallback);
            }
        }
    }

    public Node setCar(Node node) {
        this.car = node;
        node.parent = this;
        return this.car;
    }

    public ConsAltNode setCdr(ConsAltNode consAltNode) {
        this.cdr = consAltNode;
        consAltNode.parent = this;
        return this.cdr;
    }

    @Override
    public String getName() {
        switch (this.type) {
            case 9: {
                return "Alt";
            }
            case 8: {
                return "List";
            }
        }
        throw new InternalException("internal parser error (bug)");
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n  left: " + ConsAltNode.pad(this.car, n + 1));
        stringBuilder.append("\n  right: " + (this.cdr == null ? "NULL" : this.cdr.toString()));
        return stringBuilder.toString();
    }
}

