/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

final class MinMaxLen {
    int min;
    int max;
    private static final short[] distValues = new short[]{1000, 500, 333, 250, 200, 167, 143, 125, 111, 100, 91, 83, 77, 71, 67, 63, 59, 56, 53, 50, 48, 45, 43, 42, 40, 38, 37, 36, 34, 33, 32, 31, 30, 29, 29, 28, 27, 26, 26, 25, 24, 24, 23, 23, 22, 22, 21, 21, 20, 20, 20, 19, 19, 19, 18, 18, 18, 17, 17, 17, 16, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10};
    static final int INFINITE_DISTANCE = Integer.MAX_VALUE;

    MinMaxLen() {
    }

    MinMaxLen(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    int distanceValue() {
        if (this.max == Integer.MAX_VALUE) {
            return 0;
        }
        int n = this.max - this.min;
        return n < distValues.length ? distValues[n] : 1;
    }

    int compareDistanceValue(MinMaxLen minMaxLen, int n, int n2) {
        if (n2 <= 0) {
            return -1;
        }
        if (n <= 0) {
            return 1;
        }
        if ((n2 *= minMaxLen.distanceValue()) > (n *= this.distanceValue())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        if (minMaxLen.min < this.min) {
            return 1;
        }
        if (minMaxLen.min > this.min) {
            return -1;
        }
        return 0;
    }

    boolean equal(MinMaxLen minMaxLen) {
        return this.min == minMaxLen.min && this.max == minMaxLen.max;
    }

    void set(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    void clear() {
        this.max = 0;
        this.min = 0;
    }

    void copy(MinMaxLen minMaxLen) {
        this.min = minMaxLen.min;
        this.max = minMaxLen.max;
    }

    void add(MinMaxLen minMaxLen) {
        this.min = MinMaxLen.distanceAdd(this.min, minMaxLen.min);
        this.max = MinMaxLen.distanceAdd(this.max, minMaxLen.max);
    }

    void addLength(int n) {
        this.min = MinMaxLen.distanceAdd(this.min, n);
        this.max = MinMaxLen.distanceAdd(this.max, n);
    }

    void altMerge(MinMaxLen minMaxLen) {
        if (this.min > minMaxLen.min) {
            this.min = minMaxLen.min;
        }
        if (this.max < minMaxLen.max) {
            this.max = minMaxLen.max;
        }
    }

    static int distanceAdd(int n, int n2) {
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (n <= Integer.MAX_VALUE - n2) {
            return n + n2;
        }
        return Integer.MAX_VALUE;
    }

    static int distanceMultiply(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n < Integer.MAX_VALUE / n2) {
            return n * n2;
        }
        return Integer.MAX_VALUE;
    }

    static String distanceRangeToString(int n, int n2) {
        String string2 = "";
        string2 = n == Integer.MAX_VALUE ? string2 + "inf" : string2 + "(" + n + ")";
        string2 = string2 + "-";
        string2 = n2 == Integer.MAX_VALUE ? string2 + "inf" : string2 + "(" + n2 + ")";
        return string2;
    }
}

