/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.joni.BitSet;
import org.joni.BitStatus;
import org.joni.CaptureTreeNode;
import org.joni.Config;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.StackEntry;
import org.joni.StackMachine;
import org.joni.ast.CClassNode;
import org.joni.exception.InternalException;

class ByteCodeMachine
extends StackMachine {
    private int bestLen;
    private int s = 0;
    private int range;
    private int sprev;
    private int sstart;
    private int sbegin;
    private final int[] code;
    private int ip;
    protected int stkp;
    private byte[] cfbuf;
    private byte[] cfbuf2;

    ByteCodeMachine(Regex regex, byte[] byArray, int n, int n2) {
        super(regex, byArray, n, n2);
        this.code = regex.code;
    }

    private boolean makeCaptureHistoryTree(CaptureTreeNode captureTreeNode) {
        int n = this.stkp;
        while (n < this.stk) {
            StackEntry stackEntry = this.stack[n];
            if (stackEntry.type == 256) {
                int n2 = stackEntry.getMemNum();
                if (n2 > 31 || !BitStatus.bsAt(this.regex.captureHistory, n2)) continue;
                CaptureTreeNode captureTreeNode2 = new CaptureTreeNode();
                captureTreeNode2.group = n2;
                captureTreeNode2.beg = stackEntry.getMemPStr() - this.str;
                captureTreeNode.addChild(captureTreeNode2);
                this.stkp = n + 1;
                if (this.makeCaptureHistoryTree(captureTreeNode2)) {
                    return true;
                }
                n = this.stkp;
                captureTreeNode2.end = stackEntry.getMemPStr() - this.str;
                continue;
            }
            if (stackEntry.type != 33280 || stackEntry.getMemNum() != captureTreeNode.group) continue;
            captureTreeNode.end = stackEntry.getMemPStr() - this.str;
            this.stkp = n;
            return false;
        }
        return true;
    }

    private void checkCaptureHistory(Region region) {
        CaptureTreeNode captureTreeNode;
        if (region.historyRoot == null) {
            captureTreeNode = region.historyRoot = new CaptureTreeNode();
        } else {
            captureTreeNode = region.historyRoot;
            captureTreeNode.clear();
        }
        captureTreeNode.group = 0;
        captureTreeNode.beg = this.sstart - this.str;
        captureTreeNode.end = this.s - this.str;
        this.stkp = 0;
        this.makeCaptureHistoryTree(region.historyRoot);
    }

    protected final byte[] cfbuf() {
        return this.cfbuf == null ? (this.cfbuf = new byte[18]) : this.cfbuf;
    }

    protected final byte[] cfbuf2() {
        return this.cfbuf2 == null ? (this.cfbuf2 = new byte[18]) : this.cfbuf2;
    }

    private boolean stringCmpIC(int n, int n2, IntHolder intHolder, int n3, int n4) {
        byte[] byArray = this.cfbuf();
        byte[] byArray2 = this.cfbuf2();
        int n5 = intHolder.value;
        int n6 = n2 + n3;
        while (n2 < n6) {
            this.value = n2;
            int n7 = this.enc.mbcCaseFold(n, this.bytes, this, n4, byArray);
            n2 = this.value;
            this.value = n5;
            int n8 = this.enc.mbcCaseFold(n, this.bytes, this, n4, byArray2);
            n5 = this.value;
            if (n7 != n8) {
                return false;
            }
            int n9 = 0;
            int n10 = 0;
            while (n7-- > 0) {
                if (byArray[n9] != byArray2[n10]) {
                    return false;
                }
                ++n9;
                ++n10;
            }
        }
        intHolder.value = n5;
        return true;
    }

    private void debugMatchBegin() {
        Config.log.println("match_at: str: " + this.str + ", end: " + this.end + ", start: " + this.sstart + ", sprev: " + this.sprev);
        Config.log.println("size: " + (this.end - this.str) + ", start offset: " + (this.sstart - this.str));
    }

    private void debugMatchLoop() {
    }

    protected final int matchAt(int n, int n2, int n3) {
        this.range = n;
        this.sstart = n2;
        this.sprev = n3;
        this.stk = 0;
        this.ip = 0;
        this.init();
        this.bestLen = -1;
        this.s = n2;
        int[] nArray = this.code;
        block107: while (true) {
            this.sbegin = this.s;
            switch (nArray[this.ip++]) {
                case 1: {
                    if (!this.opEnd()) continue block107;
                    return this.finish();
                }
                case 2: {
                    this.opExact1();
                    continue block107;
                }
                case 3: {
                    this.opExact2();
                    continue block107;
                }
                case 4: {
                    this.opExact3();
                    continue block107;
                }
                case 5: {
                    this.opExact4();
                    continue block107;
                }
                case 6: {
                    this.opExact5();
                    continue block107;
                }
                case 7: {
                    this.opExactN();
                    continue block107;
                }
                case 8: {
                    this.opExactMB2N1();
                    continue block107;
                }
                case 9: {
                    this.opExactMB2N2();
                    continue block107;
                }
                case 10: {
                    this.opExactMB2N3();
                    continue block107;
                }
                case 11: {
                    this.opExactMB2N();
                    continue block107;
                }
                case 12: {
                    this.opExactMB3N();
                    continue block107;
                }
                case 13: {
                    this.opExactMBN();
                    continue block107;
                }
                case 14: {
                    this.opExact1IC();
                    continue block107;
                }
                case 15: {
                    this.opExactNIC();
                    continue block107;
                }
                case 16: {
                    this.opCClass();
                    continue block107;
                }
                case 17: {
                    this.opCClassMB();
                    continue block107;
                }
                case 18: {
                    this.opCClassMIX();
                    continue block107;
                }
                case 19: {
                    this.opCClassNot();
                    continue block107;
                }
                case 20: {
                    this.opCClassMBNot();
                    continue block107;
                }
                case 21: {
                    this.opCClassMIXNot();
                    continue block107;
                }
                case 22: {
                    this.opCClassNode();
                    continue block107;
                }
                case 23: {
                    this.opAnyChar();
                    continue block107;
                }
                case 24: {
                    this.opAnyCharML();
                    continue block107;
                }
                case 25: {
                    this.opAnyCharStar();
                    continue block107;
                }
                case 26: {
                    this.opAnyCharMLStar();
                    continue block107;
                }
                case 27: {
                    this.opAnyCharStarPeekNext();
                    continue block107;
                }
                case 28: {
                    this.opAnyCharMLStarPeekNext();
                    continue block107;
                }
                case 84: {
                    this.opStateCheckAnyCharStar();
                    continue block107;
                }
                case 85: {
                    this.opStateCheckAnyCharMLStar();
                    continue block107;
                }
                case 29: {
                    this.opWord();
                    continue block107;
                }
                case 30: {
                    this.opNotWord();
                    continue block107;
                }
                case 31: {
                    this.opWordBound();
                    continue block107;
                }
                case 32: {
                    this.opNotWordBound();
                    continue block107;
                }
                case 33: {
                    this.opWordBegin();
                    continue block107;
                }
                case 34: {
                    this.opWordEnd();
                    continue block107;
                }
                case 35: {
                    this.opBeginBuf();
                    continue block107;
                }
                case 36: {
                    this.opEndBuf();
                    continue block107;
                }
                case 37: {
                    this.opBeginLine();
                    continue block107;
                }
                case 38: {
                    this.opEndLine();
                    continue block107;
                }
                case 39: {
                    this.opSemiEndBuf();
                    continue block107;
                }
                case 40: {
                    this.opBeginPosition();
                    continue block107;
                }
                case 49: {
                    this.opMemoryStartPush();
                    continue block107;
                }
                case 48: {
                    this.opMemoryStart();
                    continue block107;
                }
                case 50: {
                    this.opMemoryEndPush();
                    continue block107;
                }
                case 52: {
                    this.opMemoryEnd();
                    continue block107;
                }
                case 51: {
                    this.opMemoryEndPushRec();
                    continue block107;
                }
                case 53: {
                    this.opMemoryEndRec();
                    continue block107;
                }
                case 41: {
                    this.opBackRef1();
                    continue block107;
                }
                case 42: {
                    this.opBackRef2();
                    continue block107;
                }
                case 43: {
                    this.opBackRefN();
                    continue block107;
                }
                case 44: {
                    this.opBackRefNIC();
                    continue block107;
                }
                case 45: {
                    this.opBackRefMulti();
                    continue block107;
                }
                case 46: {
                    this.opBackRefMultiIC();
                    continue block107;
                }
                case 47: {
                    this.opBackRefAtLevel();
                    continue block107;
                }
                case 66: {
                    this.opNullCheckStart();
                    continue block107;
                }
                case 67: {
                    this.opNullCheckEnd();
                    continue block107;
                }
                case 68: {
                    this.opNullCheckEndMemST();
                    continue block107;
                }
                case 69: {
                    this.opNullCheckEndMemSTPush();
                    continue block107;
                }
                case 55: {
                    this.opJump();
                    continue block107;
                }
                case 56: {
                    this.opPush();
                    continue block107;
                }
                case 81: {
                    this.opStateCheckPush();
                    continue block107;
                }
                case 82: {
                    this.opStateCheckPushOrJump();
                    continue block107;
                }
                case 83: {
                    this.opStateCheck();
                    continue block107;
                }
                case 57: {
                    this.opPop();
                    continue block107;
                }
                case 58: {
                    this.opPushOrJumpExact1();
                    continue block107;
                }
                case 59: {
                    this.opPushIfPeekNext();
                    continue block107;
                }
                case 60: {
                    this.opRepeat();
                    continue block107;
                }
                case 61: {
                    this.opRepeatNG();
                    continue block107;
                }
                case 62: {
                    this.opRepeatInc();
                    continue block107;
                }
                case 64: {
                    this.opRepeatIncSG();
                    continue block107;
                }
                case 63: {
                    this.opRepeatIncNG();
                    continue block107;
                }
                case 65: {
                    this.opRepeatIncNGSG();
                    continue block107;
                }
                case 70: {
                    this.opPushPos();
                    continue block107;
                }
                case 71: {
                    this.opPopPos();
                    continue block107;
                }
                case 72: {
                    this.opPushPosNot();
                    continue block107;
                }
                case 73: {
                    this.opFailPos();
                    continue block107;
                }
                case 74: {
                    this.opPushStopBT();
                    continue block107;
                }
                case 75: {
                    this.opPopStopBT();
                    continue block107;
                }
                case 76: {
                    this.opLookBehind();
                    continue block107;
                }
                case 77: {
                    this.opPushLookBehindNot();
                    continue block107;
                }
                case 78: {
                    this.opFailLookBehindNot();
                    continue block107;
                }
                case 79: {
                    this.opCall();
                    continue block107;
                }
                case 80: {
                    this.opReturn();
                    continue block107;
                }
                case 96: {
                    this.opCClassSb();
                    continue block107;
                }
                case 97: {
                    this.opCClassNotSb();
                    continue block107;
                }
                case 88: {
                    this.opAnyCharSb();
                    continue block107;
                }
                case 89: {
                    this.opAnyCharMLSb();
                    continue block107;
                }
                case 90: {
                    this.opAnyCharStarSb();
                    continue block107;
                }
                case 91: {
                    this.opAnyCharMLStarSb();
                    continue block107;
                }
                case 92: {
                    this.opAnyCharStarPeekNextSb();
                    continue block107;
                }
                case 93: {
                    this.opAnyCharMLStarPeekNextSb();
                    continue block107;
                }
                case 94: {
                    this.opStateCheckAnyCharStarSb();
                    continue block107;
                }
                case 95: {
                    this.opStateCheckAnyCharMLStarSb();
                    continue block107;
                }
                case 98: {
                    this.opWordSb();
                    continue block107;
                }
                case 99: {
                    this.opNotWordSb();
                    continue block107;
                }
                case 100: {
                    this.opWordBoundSb();
                    continue block107;
                }
                case 101: {
                    this.opNotWordBoundSb();
                    continue block107;
                }
                case 102: {
                    this.opWordBeginSb();
                    continue block107;
                }
                case 103: {
                    this.opWordEndSb();
                    continue block107;
                }
                case 104: {
                    this.opLookBehindSb();
                    continue block107;
                }
                case 105: {
                    this.opExact1ICSb();
                    continue block107;
                }
                case 106: {
                    this.opExactNICSb();
                    continue block107;
                }
                case 0: {
                    return this.finish();
                }
                case 54: {
                    this.opFail();
                    continue block107;
                }
            }
            break;
        }
        throw new InternalException("undefined bytecode (bug)");
    }

    private boolean opEnd() {
        int n = this.s - this.sstart;
        if (n > this.bestLen) {
            if (Option.isFindLongest(this.regex.options)) {
                if (n > this.msaBestLen) {
                    this.msaBestLen = n;
                    this.msaBestS = this.sstart;
                } else {
                    return this.endBestLength();
                }
            }
            this.bestLen = n;
            Region region = this.msaRegion;
            if (region != null) {
                region.beg[0] = this.msaBegin = this.sstart - this.str;
                region.end[0] = this.msaEnd = this.s - this.str;
                for (int i = 1; i <= this.regex.numMem; ++i) {
                    if (this.repeatStk[this.memEndStk + i] != -1) {
                        region.beg[i] = BitStatus.bsAt(this.regex.btMemStart, i) ? this.stack[this.repeatStk[this.memStartStk + i]].getMemPStr() - this.str : this.repeatStk[this.memStartStk + i] - this.str;
                        region.end[i] = BitStatus.bsAt(this.regex.btMemEnd, i) ? this.stack[this.repeatStk[this.memEndStk + i]].getMemPStr() : this.repeatStk[this.memEndStk + i] - this.str;
                        continue;
                    }
                    region.end[i] = -1;
                    region.beg[i] = -1;
                }
            } else {
                this.msaBegin = this.sstart - this.str;
                this.msaEnd = this.s - this.str;
            }
        } else {
            Region region = this.msaRegion;
            if (!Option.isPosixRegion(this.regex.options)) {
                if (region != null) {
                    region.clear();
                } else {
                    this.msaEnd = 0;
                    this.msaBegin = 0;
                }
            }
        }
        return this.endBestLength();
    }

    private boolean endBestLength() {
        if (Option.isFindCondition(this.regex.options)) {
            if (Option.isFindNotEmpty(this.regex.options) && this.s == this.sstart) {
                this.bestLen = -1;
                this.opFail();
                return false;
            }
            if (Option.isFindLongest(this.regex.options) && this.s < this.range) {
                this.opFail();
                return false;
            }
        }
        return true;
    }

    private void opExact1() {
        if (this.s >= this.range || this.code[this.ip] != this.bytes[this.s++]) {
            this.opFail();
            return;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opExact2() {
        if (this.s + 2 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExact3() {
        if (this.s + 3 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExact4() {
        if (this.s + 4 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExact5() {
        if (this.s + 5 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExactN() {
        int n;
        if (this.s + (n = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        while (n-- > 0) {
            if (this.code[this.ip++] == this.bytes[this.s++]) continue;
            this.opFail();
            return;
        }
        this.sprev = this.s - 1;
    }

    private void opExactMB2N1() {
        if (this.s + 2 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opExactMB2N2() {
        if (this.s + 4 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExactMB2N3() {
        if (this.s + 6 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExactMB2N() {
        int n;
        if ((n = this.code[this.ip++]) * 2 > this.range) {
            this.opFail();
            return;
        }
        while (n-- > 0) {
            if (this.code[this.ip] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++this.s;
            if (this.code[this.ip] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++this.s;
        }
        this.sprev = this.s - 2;
    }

    private void opExactMB3N() {
        int n;
        if ((n = this.code[this.ip++]) * 3 > this.range) {
            this.opFail();
            return;
        }
        while (n-- > 0) {
            if (this.code[this.ip] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++this.s;
            if (this.code[this.ip] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++this.s;
            if (this.code[this.ip] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++this.s;
        }
        this.sprev = this.s - 3;
    }

    private void opExactMBN() {
        int n = this.code[this.ip++];
        int n2 = this.code[this.ip++];
        if (this.s + (n2 *= n) > this.range) {
            this.opFail();
            return;
        }
        while (n2-- > 0) {
            if (this.code[this.ip] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++this.s;
        }
        this.sprev = this.s - n;
    }

    private void opExact1IC() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        byte[] byArray = this.cfbuf();
        this.value = this.s;
        int n = this.enc.mbcCaseFold(this.regex.caseFoldFlag, this.bytes, this, this.end, byArray);
        this.s = this.value;
        if (this.s > this.range) {
            this.opFail();
            return;
        }
        int n2 = 0;
        while (n-- > 0) {
            if (this.code[this.ip] != byArray[n2]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++n2;
        }
        this.sprev = this.sbegin;
    }

    private void opExact1ICSb() {
        if (this.s >= this.range || this.code[this.ip] != this.enc.toLowerCaseTable()[this.bytes[this.s++] & 0xFF]) {
            this.opFail();
            return;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opExactNIC() {
        int n = this.code[this.ip++];
        int n2 = this.ip + n;
        byte[] byArray = this.cfbuf();
        while (this.ip < n2) {
            this.sprev = this.s;
            if (this.s >= this.range) {
                this.opFail();
                return;
            }
            this.value = this.s;
            int n3 = this.enc.mbcCaseFold(this.regex.caseFoldFlag, this.bytes, this, this.end, byArray);
            this.s = this.value;
            if (this.s > this.range) {
                this.opFail();
                return;
            }
            int n4 = 0;
            while (n3-- > 0) {
                if (this.code[this.ip] != byArray[n4]) {
                    this.opFail();
                    return;
                }
                ++this.ip;
                ++n4;
            }
        }
    }

    private void opExactNICSb() {
        int n;
        if (this.s + (n = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        byte[] byArray = this.enc.toLowerCaseTable();
        while (n-- > 0) {
            if (this.code[this.ip++] == byArray[this.bytes[this.s++] & 0xFF]) continue;
            this.opFail();
            return;
        }
        this.sprev = this.s - 1;
    }

    private boolean isInBitSet() {
        int n = this.bytes[this.s] & 0xFF;
        return (this.code[this.ip + (n >>> BitSet.ROOM_SHIFT)] & 1 << n) != 0;
    }

    private void opCClass() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        this.s += this.enc.length(this.bytes, this.s, this.end);
        if (this.s > this.end) {
            this.s = this.end;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassSb() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private boolean isInClassMB() {
        int n = this.code[this.ip++];
        if (this.s >= this.range) {
            return false;
        }
        int n2 = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + n2 > this.range) {
            return false;
        }
        int n3 = this.s;
        this.s += n2;
        int n4 = this.enc.mbcToCode(this.bytes, n3, this.s);
        if (!CodeRange.isInCodeRange(this.code, this.ip, n4)) {
            return false;
        }
        this.ip += n;
        return true;
    }

    private void opCClassMB() {
        if (this.s >= this.range || !this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        if (!this.isInClassMB()) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMIX() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.ip += 8;
            if (!this.isInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (!this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int n = this.code[this.ip++];
            this.ip += n;
            ++this.s;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassNot() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        this.s += this.enc.length(this.bytes, this.s, this.end);
        if (this.s > this.end) {
            this.s = this.end;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassNotSb() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private boolean isNotInClassMB() {
        int n = this.code[this.ip++];
        int n2 = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + n2 > this.range) {
            if (this.s >= this.range) {
                return false;
            }
            this.s = this.end;
            this.ip += n;
            return true;
        }
        int n3 = this.s;
        this.s += n2;
        int n4 = this.enc.mbcToCode(this.bytes, n3, this.s);
        if (CodeRange.isInCodeRange(this.code, this.ip, n4)) {
            return false;
        }
        this.ip += n;
        return true;
    }

    private void opCClassMBNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (!this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            ++this.s;
            int n = this.code[this.ip++];
            this.ip += n;
            this.sprev = this.sbegin;
            return;
        }
        if (!this.isNotInClassMB()) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMIXNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.ip += 8;
            if (!this.isNotInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int n = this.code[this.ip++];
            this.ip += n;
            ++this.s;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassNode() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        CClassNode cClassNode = (CClassNode)this.regex.operands[this.code[this.ip++]];
        int n = this.enc.length(this.bytes, this.s, this.end);
        int n2 = this.s;
        this.s += n;
        if (this.s > this.range) {
            this.opFail();
            return;
        }
        int n3 = this.enc.mbcToCode(this.bytes, n2, this.s);
        if (!cClassNode.isCodeInCCLength(n, n3)) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyChar() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        int n = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += n;
        this.sprev = this.sbegin;
    }

    private void opAnyCharSb() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.bytes[this.s] == 10) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opAnyCharML() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        int n = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        this.s += n;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLSb() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opAnyCharStar() {
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            int n = this.enc.length(byArray, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            if (this.enc.isNewLine(byArray, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharStarSb() {
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            if (byArray[this.s] == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStar() {
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            int n = this.enc.length(byArray, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarSb() {
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharStarPeekNext() {
        byte by = (byte)this.code[this.ip];
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            int n;
            if (by == byArray[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            if (this.s + (n = this.enc.length(byArray, this.s, this.end)) > this.range || this.enc.isNewLine(byArray, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharStarPeekNextSb() {
        byte by = (byte)this.code[this.ip];
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            byte by2 = byArray[this.s];
            if (by == by2) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            if (by2 == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarPeekNext() {
        byte by = (byte)this.code[this.ip];
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            int n;
            if (by == byArray[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            if (this.s + (n = this.enc.length(byArray, this.s, this.end)) > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarPeekNextSb() {
        byte by = (byte)this.code[this.ip];
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            if (by == byArray[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            this.sprev = this.s++;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharStar() {
        int n = this.code[this.ip++];
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, n)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, n);
            int n2 = this.enc.length(byArray, this.s, this.end);
            if (this.s + n2 > this.range || this.enc.isNewLine(byArray, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n2;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharStarSb() {
        int n = this.code[this.ip++];
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, n)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, n);
            if (byArray[this.s] == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharMLStar() {
        int n = this.code[this.ip++];
        byte[] byArray = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, n)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, n);
            int n2 = this.enc.length(byArray, this.s, this.end);
            if (this.s + n2 > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n2;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharMLStarSb() {
        int n = this.code[this.ip++];
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, n)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, n);
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opWord() {
        if (this.s >= this.range || !this.enc.isMbcWord(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opWordSb() {
        if (this.s >= this.range || !this.enc.isWord(this.bytes[this.s] & 0xFF)) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opNotWord() {
        if (this.s >= this.range || this.enc.isMbcWord(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opNotWordSb() {
        if (this.s >= this.range || this.enc.isWord(this.bytes[this.s] & 0xFF)) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opWordBound() {
        if (this.s == this.str) {
            if (this.s >= this.range || !this.enc.isMbcWord(this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (!this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isMbcWord(this.bytes, this.s, this.end) == this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opWordBoundSb() {
        if (this.s == this.str) {
            if (this.s >= this.range || !this.enc.isWord(this.bytes[this.s] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev >= this.end || !this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isWord(this.bytes[this.s] & 0xFF) == this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
            this.opFail();
            return;
        }
    }

    private void opNotWordBound() {
        if (this.s == this.str) {
            if (this.s < this.range && this.enc.isMbcWord(this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isMbcWord(this.bytes, this.s, this.end) != this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opNotWordBoundSb() {
        if (this.s == this.str) {
            if (this.s < this.range && this.enc.isWord(this.bytes[this.s] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev < this.end && this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isWord(this.bytes[this.s] & 0xFF) != this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
            this.opFail();
            return;
        }
    }

    private void opWordBegin() {
        if (this.s < this.range && this.enc.isMbcWord(this.bytes, this.s, this.end) && (this.s == this.str || !this.enc.isMbcWord(this.bytes, this.sprev, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opWordBeginSb() {
        if (this.s < this.range && this.enc.isWord(this.bytes[this.s] & 0xFF) && (this.s == this.str || !this.enc.isWord(this.bytes[this.sprev] & 0xFF))) {
            return;
        }
        this.opFail();
    }

    private void opWordEnd() {
        if (this.s != this.str && this.enc.isMbcWord(this.bytes, this.sprev, this.end) && (this.s == this.end || !this.enc.isMbcWord(this.bytes, this.s, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opWordEndSb() {
        if (this.s != this.str && this.enc.isWord(this.bytes[this.sprev] & 0xFF) && (this.s == this.end || !this.enc.isWord(this.bytes[this.s] & 0xFF))) {
            return;
        }
        this.opFail();
    }

    private void opBeginBuf() {
        if (this.s != this.str) {
            this.opFail();
        }
    }

    private void opEndBuf() {
        if (this.s != this.end) {
            this.opFail();
        }
    }

    private void opBeginLine() {
        if (this.s == this.str) {
            if (Option.isNotBol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.sprev, this.end) && this.s != this.end) {
            return;
        }
        this.opFail();
    }

    private void opEndLine() {
        if (this.s == this.end) {
            if ((this.str == this.end || !this.enc.isNewLine(this.bytes, this.sprev, this.end)) && Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end)) {
            return;
        }
        this.opFail();
    }

    private void opSemiEndBuf() {
        if (this.s == this.end) {
            if ((this.str == this.end || !this.enc.isNewLine(this.bytes, this.sprev, this.end)) && Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end) && this.s + this.enc.length(this.bytes, this.s, this.end) == this.end) {
            return;
        }
        this.opFail();
    }

    private void opBeginPosition() {
        if (this.s != this.msaStart) {
            this.opFail();
        }
    }

    private void opMemoryStartPush() {
        int n = this.code[this.ip++];
        this.pushMemStart(n, this.s);
    }

    private void opMemoryStart() {
        int n = this.code[this.ip++];
        this.repeatStk[this.memStartStk + n] = this.s;
    }

    private void opMemoryEndPush() {
        int n = this.code[this.ip++];
        this.pushMemEnd(n, this.s);
    }

    private void opMemoryEnd() {
        int n = this.code[this.ip++];
        this.repeatStk[this.memEndStk + n] = this.s;
    }

    private void opMemoryEndPushRec() {
        int n = this.code[this.ip++];
        int n2 = this.getMemStart(n);
        this.pushMemEnd(n, this.s);
        this.repeatStk[this.memStartStk + n] = n2;
    }

    private void opMemoryEndRec() {
        int n = this.code[this.ip++];
        this.repeatStk[this.memEndStk + n] = this.s;
        int n2 = this.getMemStart(n);
        this.repeatStk[this.memStartStk + n] = BitStatus.bsAt(this.regex.btMemStart, n) ? n2 : this.stack[n2].getMemPStr();
        this.pushMemEndMark(n);
    }

    private boolean backrefInvalid(int n) {
        return this.repeatStk[this.memEndStk + n] == -1 || this.repeatStk[this.memStartStk + n] == -1;
    }

    private int backrefStart(int n) {
        return BitStatus.bsAt(this.regex.btMemStart, n) ? this.stack[this.repeatStk[this.memStartStk + n]].getMemPStr() : this.repeatStk[this.memStartStk + n];
    }

    private int backrefEnd(int n) {
        return BitStatus.bsAt(this.regex.btMemEnd, n) ? this.stack[this.repeatStk[this.memEndStk + n]].getMemPStr() : this.repeatStk[this.memEndStk + n];
    }

    private void backref(int n) {
        if (n > this.regex.numMem || this.backrefInvalid(n)) {
            this.opFail();
            return;
        }
        int n2 = this.backrefStart(n);
        int n3 = this.backrefEnd(n);
        int n4 = n3 - n2;
        if (this.s + n4 > this.range) {
            this.opFail();
            return;
        }
        this.sprev = this.s;
        while (n4-- > 0) {
            if (this.bytes[n2++] == this.bytes[this.s++]) continue;
            this.opFail();
            return;
        }
        if (this.sprev < this.range) {
            int n5;
            while (this.sprev + (n5 = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += n5;
            }
        }
    }

    private void opBackRef1() {
        this.backref(1);
    }

    private void opBackRef2() {
        this.backref(2);
    }

    private void opBackRefN() {
        this.backref(this.code[this.ip++]);
    }

    private void opBackRefNIC() {
        int n;
        int n2;
        if ((n2 = this.code[this.ip++]) > this.regex.numMem || this.backrefInvalid(n2)) {
            this.opFail();
            return;
        }
        int n3 = this.backrefStart(n2);
        int n4 = this.backrefEnd(n2);
        int n5 = n4 - n3;
        if (this.s + n5 > this.range) {
            this.opFail();
            return;
        }
        this.sprev = this.s;
        this.value = this.s;
        if (!this.stringCmpIC(this.regex.caseFoldFlag, n3, this, n5, this.end)) {
            this.opFail();
            return;
        }
        this.s = this.value;
        while (this.sprev + (n = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
            this.sprev += n;
        }
    }

    private void opBackRefMulti() {
        int n;
        int n2 = this.code[this.ip++];
        block0: for (n = 0; n < n2; ++n) {
            int n3;
            if (this.backrefInvalid(n3 = this.code[this.ip++])) continue;
            int n4 = this.backrefStart(n3);
            int n5 = this.backrefEnd(n3);
            int n6 = n5 - n4;
            if (this.s + n6 > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            int n7 = this.s;
            while (n6-- > 0) {
                if (this.bytes[n4++] == this.bytes[n7++]) continue;
                continue block0;
            }
            this.s = n7;
            if (this.sprev < this.range) {
                int n8;
                while (this.sprev + (n8 = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                    this.sprev += n8;
                }
            }
            this.ip += n2 - n - 1;
            break;
        }
        if (n == n2) {
            this.opFail();
            return;
        }
    }

    private void opBackRefMultiIC() {
        int n;
        int n2 = this.code[this.ip++];
        for (n = 0; n < n2; ++n) {
            int n3;
            int n4;
            if (this.backrefInvalid(n4 = this.code[this.ip++])) continue;
            int n5 = this.backrefStart(n4);
            int n6 = this.backrefEnd(n4);
            int n7 = n6 - n5;
            if (this.s + n7 > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.value = this.s;
            if (!this.stringCmpIC(this.regex.caseFoldFlag, n5, this, n7, this.end)) continue;
            this.s = this.value;
            while (this.sprev + (n3 = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += n3;
            }
            this.ip += n2 - n - 1;
            break;
        }
        if (n == n2) {
            this.opFail();
            return;
        }
    }

    private boolean memIsInMemp(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (n != (n4 = this.code[n3++])) continue;
            return true;
        }
        return false;
    }

    private boolean backrefMatchAtNestedLevel(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = 0;
        for (int i = this.stk - 1; i >= 0; --i) {
            StackEntry stackEntry = this.stack[i];
            if (stackEntry.type == 2048) {
                --n6;
                continue;
            }
            if (stackEntry.type == 2304) {
                ++n6;
                continue;
            }
            if (n6 != n2) continue;
            if (stackEntry.type == 256) {
                if (!this.memIsInMemp(stackEntry.getMemNum(), n3, n4)) continue;
                int n7 = stackEntry.getMemPStr();
                if (n5 == -1) continue;
                if (n5 - n7 > this.end - this.s) {
                    return false;
                }
                int n8 = n7;
                this.value = this.s;
                if (bl) {
                    if (!this.stringCmpIC(n, n7, this, n5 - n7, this.end)) {
                        return false;
                    }
                } else {
                    while (n8 < n5) {
                        if (this.bytes[n8++] == this.bytes[this.value++]) continue;
                        return false;
                    }
                }
                this.s = this.value;
                return true;
            }
            if (stackEntry.type != 33280 || !this.memIsInMemp(stackEntry.getMemNum(), n3, n4)) continue;
            n5 = stackEntry.getMemPStr();
        }
        return false;
    }

    private void opBackRefAtLevel() {
        int n = this.code[this.ip++];
        int n2 = this.code[this.ip++];
        int n3 = this.code[this.ip++];
        this.sprev = this.s;
        if (this.backrefMatchAtNestedLevel(n != 0, this.regex.caseFoldFlag, n2, n3, this.ip)) {
            int n4;
            while (this.sprev + (n4 = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += n4;
            }
            this.ip += n3;
        } else {
            this.opFail();
            return;
        }
    }

    private void opSetOptionPush() {
        this.pushAlt(this.ip, this.s, this.sprev);
        this.ip += 3;
    }

    private void opSetOption() {
    }

    private void opNullCheckStart() {
        int n = this.code[this.ip++];
        this.pushNullCheckStart(n, this.s);
    }

    private void nullCheckFound() {
        switch (this.code[this.ip++]) {
            case 55: 
            case 56: {
                ++this.ip;
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                ++this.ip;
                break;
            }
            default: {
                throw new InternalException("unexpected bytecode (bug)");
            }
        }
    }

    private void opNullCheckEnd() {
        int n;
        int n2;
        if ((n2 = this.nullCheck(n = this.code[this.ip++], this.s)) != 0) {
            this.nullCheckFound();
        }
    }

    private void opNullCheckEndMemST() {
        int n;
        int n2;
        if ((n2 = this.nullCheckMemSt(n = this.code[this.ip++], this.s)) != 0) {
            if (n2 == -1) {
                this.opFail();
                return;
            }
            this.nullCheckFound();
        }
    }

    private void opNullCheckEndMemSTPush() {
        int n;
        int n2;
        if ((n2 = this.nullCheckMemStRec(n = this.code[this.ip++], this.s)) != 0) {
            if (n2 == -1) {
                this.opFail();
                return;
            }
            this.nullCheckFound();
        } else {
            this.pushNullCheckEnd(n);
        }
    }

    private void opJump() {
        this.ip += this.code[this.ip] + 1;
    }

    private void opPush() {
        int n = this.code[this.ip++];
        this.pushAlt(this.ip + n, this.s, this.sprev);
    }

    private void opStateCheckPush() {
        int n;
        if (this.stateCheckVal(this.s, n = this.code[this.ip++])) {
            this.opFail();
            return;
        }
        int n2 = this.code[this.ip++];
        this.pushAltWithStateCheck(this.ip + n2, this.s, this.sprev, n);
    }

    private void opStateCheckPushOrJump() {
        int n = this.code[this.ip++];
        int n2 = this.code[this.ip++];
        if (this.stateCheckVal(this.s, n)) {
            this.ip += n2;
        } else {
            this.pushAltWithStateCheck(this.ip + n2, this.s, this.sprev, n);
        }
    }

    private void opStateCheck() {
        int n;
        if (this.stateCheckVal(this.s, n = this.code[this.ip++])) {
            this.opFail();
            return;
        }
        this.pushStateCheck(this.s, n);
    }

    private void opPop() {
        this.popOne();
    }

    private void opPushOrJumpExact1() {
        int n = this.code[this.ip++];
        if (this.code[this.ip] == this.bytes[this.s] && this.s < this.range) {
            ++this.ip;
            this.pushAlt(this.ip + n, this.s, this.sprev);
            return;
        }
        this.ip += n + 1;
    }

    private void opPushIfPeekNext() {
        int n = this.code[this.ip++];
        if (this.s < this.range && this.code[this.ip] == this.bytes[this.s]) {
            ++this.ip;
            this.pushAlt(this.ip + n, this.s, this.sprev);
            return;
        }
        ++this.ip;
    }

    private void opRepeat() {
        int n = this.code[this.ip++];
        int n2 = this.code[this.ip++];
        this.repeatStk[n] = this.stk;
        this.pushRepeat(n, this.ip);
        if (this.regex.repeatRangeLo[n] == 0) {
            this.pushAlt(this.ip + n2, this.s, this.sprev);
        }
    }

    private void opRepeatNG() {
        int n = this.code[this.ip++];
        int n2 = this.code[this.ip++];
        this.repeatStk[n] = this.stk;
        this.pushRepeat(n, this.ip);
        if (this.regex.repeatRangeLo[n] == 0) {
            this.pushAlt(this.ip, this.s, this.sprev);
            this.ip += n2;
        }
    }

    private void repeatInc(int n, int n2) {
        StackEntry stackEntry = this.stack[n2];
        stackEntry.increaseRepeatCount();
        if (stackEntry.getRepeatCount() < this.regex.repeatRangeHi[n]) {
            if (stackEntry.getRepeatCount() >= this.regex.repeatRangeLo[n]) {
                this.pushAlt(this.ip, this.s, this.sprev);
                this.ip = stackEntry.getRepeatPCode();
            } else {
                this.ip = stackEntry.getRepeatPCode();
            }
        }
        this.pushRepeatInc(n2);
    }

    private void opRepeatInc() {
        int n = this.code[this.ip++];
        int n2 = this.repeatStk[n];
        this.repeatInc(n, n2);
    }

    private void opRepeatIncSG() {
        int n = this.code[this.ip++];
        int n2 = this.getRepeat(n);
        this.repeatInc(n, n2);
    }

    private void repeatIncNG(int n, int n2) {
        StackEntry stackEntry = this.stack[n2];
        stackEntry.increaseRepeatCount();
        if (stackEntry.getRepeatCount() < this.regex.repeatRangeHi[n]) {
            if (stackEntry.getRepeatCount() >= this.regex.repeatRangeLo[n]) {
                int n3 = stackEntry.getRepeatPCode();
                this.pushRepeatInc(n2);
                this.pushAlt(n3, this.s, this.sprev);
            } else {
                this.ip = stackEntry.getRepeatPCode();
                this.pushRepeatInc(n2);
            }
        } else if (stackEntry.getRepeatCount() == this.regex.repeatRangeHi[n]) {
            this.pushRepeatInc(n2);
        }
    }

    private void opRepeatIncNG() {
        int n = this.code[this.ip++];
        int n2 = this.repeatStk[n];
        this.repeatIncNG(n, n2);
    }

    private void opRepeatIncNGSG() {
        int n = this.code[this.ip++];
        int n2 = this.getRepeat(n);
        this.repeatIncNG(n, n2);
    }

    private void opPushPos() {
        this.pushPos(this.s, this.sprev);
    }

    private void opPopPos() {
        StackEntry stackEntry = this.stack[this.posEnd()];
        this.s = stackEntry.getStatePStr();
        this.sprev = stackEntry.getStatePStrPrev();
    }

    private void opPushPosNot() {
        int n = this.code[this.ip++];
        this.pushPosNot(this.ip + n, this.s, this.sprev);
    }

    private void opFailPos() {
        this.popTilPosNot();
        this.opFail();
    }

    private void opPushStopBT() {
        this.pushStopBT();
    }

    private void opPopStopBT() {
        this.stopBtEnd();
    }

    private void opLookBehind() {
        int n = this.code[this.ip++];
        this.s = this.enc.stepBack(this.bytes, this.str, this.s, this.end, n);
        if (this.s == -1) {
            this.opFail();
            return;
        }
        this.sprev = this.enc.prevCharHead(this.bytes, this.str, this.s, this.end);
    }

    private void opLookBehindSb() {
        int n = this.code[this.ip++];
        this.s -= n;
        if (this.s < this.str) {
            this.opFail();
            return;
        }
        this.sprev = this.s == this.str ? -1 : this.s - 1;
    }

    private void opPushLookBehindNot() {
        int n;
        int n2;
        int n3 = this.code[this.ip++];
        if ((n2 = this.enc.stepBack(this.bytes, this.str, this.s, this.end, n = this.code[this.ip++])) == -1) {
            this.ip += n3;
        } else {
            this.pushLookBehindNot(this.ip + n3, this.s, this.sprev);
            this.s = n2;
            this.sprev = this.enc.prevCharHead(this.bytes, this.str, this.s, this.end);
        }
    }

    private void opFailLookBehindNot() {
        this.popTilLookBehindNot();
        this.opFail();
    }

    private void opCall() {
        int n = this.code[this.ip++];
        this.pushCallFrame(this.ip);
        this.ip = n;
    }

    private void opReturn() {
        this.ip = this.sreturn();
        this.pushReturn();
    }

    private void opFail() {
        if (this.stack == null) {
            this.ip = this.regex.codeLength - 1;
            return;
        }
        StackEntry stackEntry = this.pop();
        this.ip = stackEntry.getStatePCode();
        this.s = stackEntry.getStatePStr();
        this.sprev = stackEntry.getStatePStrPrev();
    }

    private int finish() {
        return this.bestLen;
    }
}

