/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

public final class BitSet {
    static final int BITS_PER_BYTE = 8;
    public static final int SINGLE_BYTE_SIZE = 256;
    private static final int BITS_IN_ROOM = 32;
    static final int BITSET_SIZE = 8;
    static final int ROOM_SHIFT = BitSet.log2(32);
    final int[] bits = new int[8];
    private static final int BITS_TO_STRING_WRAP = 4;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BitSet");
        for (int i = 0; i < 256; ++i) {
            if (i % 64 == 0) {
                stringBuilder.append("\n  ");
            }
            stringBuilder.append(this.at(i) ? "1" : "0");
        }
        return stringBuilder.toString();
    }

    public boolean at(int n) {
        return (this.bits[n >>> ROOM_SHIFT] & BitSet.bit(n)) != 0;
    }

    public void set(int n) {
        int n2 = n >>> ROOM_SHIFT;
        this.bits[n2] = this.bits[n2] | BitSet.bit(n);
    }

    public void clear(int n) {
        int n2 = n >>> ROOM_SHIFT;
        this.bits[n2] = this.bits[n2] & ~BitSet.bit(n);
    }

    public void invert(int n) {
        int n2 = n >>> ROOM_SHIFT;
        this.bits[n2] = this.bits[n2] ^ BitSet.bit(n);
    }

    public void clear() {
        for (int i = 0; i < 8; ++i) {
            this.bits[i] = 0;
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < 8; ++i) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void setRange(int n, int n2) {
        for (int i = n; i <= n2 && i < 256; ++i) {
            this.set(i);
        }
    }

    public void setAll() {
        for (int i = 0; i < 8; ++i) {
            this.bits[i] = -1;
        }
    }

    public void invert() {
        for (int i = 0; i < 8; ++i) {
            this.bits[i] = ~this.bits[i];
        }
    }

    public void invertTo(BitSet bitSet) {
        for (int i = 0; i < 8; ++i) {
            bitSet.bits[i] = ~this.bits[i];
        }
    }

    public void and(BitSet bitSet) {
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & bitSet.bits[i];
        }
    }

    public void or(BitSet bitSet) {
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | bitSet.bits[i];
        }
    }

    public void copy(BitSet bitSet) {
        for (int i = 0; i < 8; ++i) {
            this.bits[i] = bitSet.bits[i];
        }
    }

    public int numOn() {
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.at(i)) continue;
            ++n;
        }
        return n;
    }

    static int bit(int n) {
        return 1 << n % 256;
    }

    private static int log2(int n) {
        int n2 = 0;
        while ((n >>>= 1) != 0) {
            ++n2;
        }
        return n2;
    }
}

