/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.io.FileOutputStream;
import java.io.IOException;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.joni.Analyser;
import org.joni.Compiler;
import org.joni.Config;
import org.joni.MatcherFactory;
import org.joni.constants.AsmConstants;

abstract class AsmCompilerSupport
extends Compiler
implements Opcodes,
AsmConstants {
    protected ClassWriter factory;
    protected MethodVisitor factoryInit;
    protected String factoryName;
    protected ClassWriter machine;
    protected MethodVisitor machineInit;
    protected MethodVisitor match;
    protected String machineName;
    protected int maxStack = 1;
    protected int maxVars = 6;
    protected int bitsets;
    protected int ranges;
    protected int templates;
    static int REG_NUM = 0;
    private static final DummyClassLoader loader = new DummyClassLoader();

    AsmCompilerSupport(Analyser analyser) {
        super(analyser);
    }

    protected final void prepareFactory() {
        this.factory = new ClassWriter(1);
        this.factoryName = "org/joni/MatcherFactory" + REG_NUM;
        this.factory.visit(48, 17, this.factoryName, null, "org/joni/MatcherFactory", null);
        MethodVisitor methodVisitor = this.factory.visitMethod(4096, "create", "(Lorg/joni/Regex;[BII)Lorg/joni/Matcher;", null, null);
        methodVisitor.visitTypeInsn(187, this.machineName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(21, 3);
        methodVisitor.visitVarInsn(21, 4);
        methodVisitor.visitMethodInsn(183, this.machineName, "<init>", "(Lorg/joni/Regex;[BII)V");
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected final void prepareFactoryInit() {
        this.factoryInit = this.factory.visitMethod(1, "<init>", "()V", null, null);
        this.factoryInit.visitVarInsn(25, 0);
        this.factoryInit.visitMethodInsn(183, "org/joni/MatcherFactory", "<init>", "()V");
    }

    protected final void setupFactoryInit() {
        this.factoryInit.visitInsn(177);
        this.factoryInit.visitMaxs(0, 0);
        this.factoryInit.visitEnd();
    }

    protected final void prepareMachine() {
        this.machine = new ClassWriter(1);
        this.machineName = "org/joni/NativeMachine" + REG_NUM;
    }

    protected final void prepareMachineInit() {
        this.machine.visit(48, 17, this.machineName, null, "org/joni/NativeMachine", null);
        this.machineInit = this.machine.visitMethod(4, "<init>", "(Lorg/joni/Regex;[BII)V", null, null);
        this.machineInit.visitVarInsn(25, 0);
        this.machineInit.visitVarInsn(25, 1);
        this.machineInit.visitVarInsn(25, 2);
        this.machineInit.visitVarInsn(21, 3);
        this.machineInit.visitVarInsn(21, 4);
        this.machineInit.visitMethodInsn(183, "org/joni/NativeMachine", "<init>", "(Lorg/joni/Regex;[BII)V");
    }

    protected final void setupMachineInit() {
        if (this.bitsets + this.ranges + this.templates > 0) {
            this.machine.visitField(18, "factory", "L" + this.factoryName + ";", null, null);
            this.machineInit.visitVarInsn(25, 0);
            this.machineInit.visitVarInsn(25, 1);
            this.machineInit.visitFieldInsn(180, "org/joni/Regex", "factory", "Lorg/joni/MatcherFactory;");
            this.machineInit.visitTypeInsn(192, this.factoryName);
            this.machineInit.visitFieldInsn(181, this.machineName, "factory", "L" + this.factoryName + ";");
        }
        this.machineInit.visitInsn(177);
        this.machineInit.visitMaxs(0, 0);
        this.machineInit.visitEnd();
    }

    protected final void prepareMachineMatch() {
        this.match = this.machine.visitMethod(4096, "matchAt", "(III)I", null, null);
        this.move(4, 2);
        this.load("bytes", "[B");
        this.astore(5);
    }

    protected final void setupMachineMatch() {
        this.match.visitInsn(2);
        this.match.visitInsn(172);
        this.match.visitMaxs(this.maxStack, this.maxVars);
        this.match.visitEnd();
    }

    protected final void setupClasses() {
        Object object;
        byte[] byArray = this.factory.toByteArray();
        byte[] byArray2 = this.machine.toByteArray();
        try {
            object = new FileOutputStream(this.factoryName.substring(this.factoryName.lastIndexOf(47) + 1) + ".class");
            ((FileOutputStream)object).write(byArray);
            ((FileOutputStream)object).close();
            object = new FileOutputStream(this.machineName.substring(this.machineName.lastIndexOf(47) + 1) + ".class");
            ((FileOutputStream)object).write(byArray2);
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(Config.err);
        }
        loader.defineClass(this.machineName.replace('/', '.'), byArray2);
        object = loader.defineClass(this.factoryName.replace('/', '.'), byArray);
        try {
            this.regex.factory = (MatcherFactory)((Class)object).newInstance();
        }
        catch (Exception exception2) {
            exception2.printStackTrace(Config.err);
        }
    }

    protected final void aload(int n) {
        this.match.visitVarInsn(25, n);
    }

    protected final void astore(int n) {
        this.match.visitVarInsn(58, n);
    }

    protected final void loadThis() {
        this.match.visitVarInsn(25, 0);
    }

    protected final void load(int n) {
        this.match.visitVarInsn(21, n);
    }

    protected final void store(int n) {
        this.match.visitVarInsn(54, n);
    }

    protected final void move(int n, int n2) {
        this.load(n2);
        this.store(n);
    }

    protected final void load(String string2, String string3) {
        this.loadThis();
        this.match.visitFieldInsn(180, this.machineName, string2, string3);
    }

    protected final void load(String string2) {
        this.load(string2, "I");
    }

    protected final void store(String string2, String string3) {
        this.loadThis();
        this.match.visitFieldInsn(181, this.machineName, string2, string3);
    }

    protected final void store(String string2) {
        this.store(string2, "I");
    }

    protected final String installTemplate(byte[] byArray, int n, int n2) {
        String string2 = "template" + ++this.templates;
        this.installArray(string2, byArray, n, n2);
        return string2;
    }

    protected final String installCodeRange(int[] nArray) {
        String string2 = "range" + ++this.ranges;
        this.installArray(string2, nArray);
        return string2;
    }

    protected final String installBitSet(int[] nArray) {
        String string2 = "bitset" + ++this.bitsets;
        this.installArray(string2, nArray);
        return string2;
    }

    private void installArray(String string2, int[] nArray) {
        this.factory.visitField(18, string2, "[I", null, null);
        this.factoryInit.visitVarInsn(25, 0);
        this.loadInt(this.factoryInit, nArray.length);
        this.factoryInit.visitIntInsn(188, 10);
        for (int i = 0; i < nArray.length; ++i) {
            this.buildArray(i, nArray[i], 79);
        }
        this.factoryInit.visitFieldInsn(181, this.factoryName, string2, "[I");
    }

    private void installArray(String string2, byte[] byArray, int n, int n2) {
        this.factory.visitField(18, string2, "[B", null, null);
        this.factoryInit.visitVarInsn(25, 0);
        this.loadInt(this.factoryInit, byArray.length);
        this.factoryInit.visitIntInsn(188, 8);
        int n3 = n;
        int n4 = 0;
        while (n3 < n + n2) {
            this.buildArray(n4, byArray[n3] & 0xFF, 84);
            ++n3;
            ++n4;
        }
        this.factoryInit.visitFieldInsn(181, this.factoryName, string2, "[B");
    }

    private void buildArray(int n, int n2, int n3) {
        this.factoryInit.visitInsn(89);
        this.loadInt(this.factoryInit, n);
        this.loadInt(this.factoryInit, n2);
        this.factoryInit.visitInsn(n3);
    }

    private void loadInt(MethodVisitor methodVisitor, int n) {
        if (n >= -1 && n <= 5) {
            methodVisitor.visitInsn(n + 3);
        } else if (n >= 6 && n <= 127 || n >= -128 && n <= -2) {
            methodVisitor.visitIntInsn(16, n);
        } else if (n >= 128 && n <= Short.MAX_VALUE || n >= Short.MIN_VALUE && n <= -129) {
            methodVisitor.visitIntInsn(17, n);
        } else {
            methodVisitor.visitLdcInsn(new Integer(n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyClassLoader
    extends ClassLoader {
        private DummyClassLoader() {
        }

        public Class<?> defineClass(String string2, byte[] byArray) {
            return super.defineClass(string2, byArray, 0, byArray.length);
        }
    }
}

