# PDF-O-Matic is copyright (c) 2009, Brett Neumeier.
#
# PDF-O-Matic may be used under the terms of the GPL.  See
# COPYING.GPL, provided in this distribution, for full details.
#
# DOJ and CompNet Design, Inc., are granted a perpetual license to
# use, extend, modify, and redistribute the PDF-O-Matic software as
# they wish, without restriction.

require 'pdf_helpers'
require 'item_box'

class ManeuverBox < ItemBox

  class ManeuverItem < ItemBoxItem
    def initialize(pdf, item)
      super(pdf, item)
      @name = item['alias'] || ''
      @phase = item['man_phase'] || ''
      @ocv = item['man_ocv'] || ''
      @dcv = item['man_dcv'] || ''
      @text = item['man_notes'].gsub(' / ','/') || ''
    end
    attr_reader :name, :phase, :ocv, :dcv, :text
  end

  def add_all(character)
    return self unless Enumerable === character['martial_arts']
    character['martial_arts'].select { |item|
      if item['xmlid'] == 'MANEUVER'
        items << ManeuverItem.new(pdf, item)
      end
    }
    self
  end

end
