/*
 * PDF-O-Matic is copyright (c) 2009, Brett Neumeier.
 * 
 * PDF-O-Matic may be used under the terms of the GPL.  See
 * COPYING.GPL, provided in this distribution, for full details.
 * 
 * DOJ and CompNet Design, Inc., are granted a perpetual license to
 * use, extend, modify, and redistribute the PDF-O-Matic software as
 * they wish, without restriction.
 */

package com.hero.pdf;

import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;

public class HeroDesignerIntegration {
    private PdfOMatic pom;

    public HeroDesignerIntegration() {
        String script = "lib/pdf_o_matic.rb";
        ScriptingContainer container = new ScriptingContainer();
        Object receiver = container.runScriptlet(PathType.CLASSPATH, script);
        pom = container.getInstance(receiver, PdfOMatic.class);
        String resourceDir = System.getProperty("user.dir") +
            System.getProperty("file.separator") + "resources";
        pom.setResourceDir(resourceDir);
    }

    public void characterFifth(String yaml, String outputFile) {
        pom.characterFifth(yaml, outputFile);
    }

    public void characterSixth(String yaml, String outputFile) {
        pom.characterSixth(yaml, outputFile);
    }

    public static void main(String[] args) {
        HeroDesignerIntegration hdi = new HeroDesignerIntegration();
        hdi.characterFifth(args[0], args[1]);
    }
}
