/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TipTree
extends JTree {
    private static final long serialVersionUID = 1176303450230758065L;

    public static String normalizeText(String string) {
        int n = 0;
        if ((string = string.trim()).startsWith("(") && string.indexOf(")") > 0) {
            n = string.indexOf(")") + 1;
        }
        if (n <= 0) {
            return "<html>" + string + "</html>";
        }
        String string2 = "<html><b>" + string.substring(0, n) + "</b><br><br>";
        string = string.substring(n, string.length());
        string2 = string2 + string + "</html>";
        return string2;
    }

    public static String removeTabs(String string) {
        while (string.indexOf("\t") >= 0) {
            if (string.indexOf("\t") == 0) {
                string = string.substring(1, string.length());
                continue;
            }
            if (string.indexOf("\t") < string.length() - 1) {
                String string2 = string.substring(0, string.indexOf("\t"));
                String string3 = string.substring(string.indexOf("\t") + 1, string.length());
                string = string2 + string3;
                continue;
            }
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public TipTree() {
    }

    public TipTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
    }

    public TipTree(Object[] objectArray) {
        super(objectArray);
    }

    public TipTree(TreeModel treeModel) {
        super(treeModel);
    }

    public TipTree(TreeNode treeNode) {
        super(treeNode);
    }

    public TipTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
    }

    public TipTree(Vector<?> vector) {
        super(vector);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        jToolTip.setPreferredSize(this.getToolTipSize(this.getToolTipText()));
        jToolTip.setMinimumSize(this.getToolTipSize(this.getToolTipText()));
        return jToolTip;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        String string = this.getToolTipText(mouseEvent);
        Dimension dimension = this.getToolTipSize(string);
        Point point = mouseEvent.getPoint();
        if (point.getY() + (double)dimension.height > HeroDesigner.getAppFrame().getLocation().getY() + (double)HeroDesigner.getAppFrame().getSize().height) {
            point = new Point(point.x, point.y - dimension.height);
            return point;
        }
        return super.getToolTipLocation(mouseEvent);
    }

    private Dimension getToolTipSize(String string) {
        int n;
        int n2;
        if (string == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = n2 = fontMetrics.stringWidth(string);
        int n4 = n = fontMetrics.getHeight();
        int n5 = 1;
        while (n3 > 100 && n4 * 3 < n3) {
            int n6;
            int n7 = 2;
            int n8 = n2 / ++n5;
            int n9 = 0;
            int n10 = 0;
            for (n6 = 0; n6 < string.length(); ++n6) {
                char c;
                String string2 = string.substring(n10, n6);
                if (string2.length() > 0 && ((c = string2.charAt(string2.length() - 1)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
                    n9 = n6;
                }
                if (fontMetrics.stringWidth(string2) > n8) {
                    ++n7;
                    if (n9 == n10) {
                        n10 = n6;
                        n9 = n6;
                        continue;
                    }
                    n10 = n9;
                    n6 = n9;
                    continue;
                }
                if (string2.length() <= 0 || string2.charAt(string2.length() - 1) != '\n' && string2.charAt(string2.length() - 1) != '\r') continue;
                ++n7;
                n10 = n6;
                n9 = n6;
            }
            n6 = n * n7;
            if (n8 / n6 < 2) break;
            n3 = n8;
            n4 = n6;
        }
        return new Dimension(n3, n4);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (!HeroDesigner.getInstance().getPrefs().showPopupDefinitions()) {
            this.setToolTipText("");
            return "";
        }
        TreePath treePath = this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        GenericObject genericObject = (GenericObject)defaultMutableTreeNode.getUserObject();
        if (genericObject.getDefinition() != null && genericObject.getDefinition().trim().length() > 0) {
            String string = TipTree.normalizeText(TipTree.removeTabs(genericObject.getDefinition()));
            this.setToolTipText(string);
            return string;
        }
        this.setToolTipText("");
        return "";
    }
}

