/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.HeroDesigner;
import com.hero.Prefab;
import com.hero.objects.GenericObject;
import com.hero.ui.SelectionList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PrefabOutlookBar
extends JPanel
implements ActionListener {
    public static final int SKILLLIST = 1;
    public static final int TALENTLIST = 2;
    public static final int PERKLIST = 3;
    public static final int MANEUVERLIST = 4;
    public static final int POWERLIST = 5;
    public static final int DISADLIST = 6;
    public static final int EQUIPMENTLIST = 7;
    private int listType;
    private JPanel topPanel = new JPanel(new GridLayout(1, 1));
    private JPanel bottomPanel = new JPanel(new GridLayout(1, 1));
    private Map bars = new LinkedHashMap();
    private int visibleBar = 0;
    private SelectionList visibleComponent = new SelectionList(new ArrayList<GenericObject>(), true);

    public PrefabOutlookBar(int n) {
        this.listType = n;
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.visibleComponent, "Center");
        this.add((Component)this.bottomPanel, "South");
    }

    public void addBar(String string, File file) {
        BarInfo barInfo = new BarInfo(string, file);
        barInfo.getButton().addActionListener(this);
        this.bars.put(string, barInfo);
        this.render();
    }

    public void addBar(String string, Icon icon, File file) {
        BarInfo barInfo = new BarInfo(string, icon, file);
        barInfo.getButton().addActionListener(this);
        this.bars.put(string, barInfo);
        this.render();
    }

    public void removeBar(String string) {
        this.bars.remove(string);
        this.render();
    }

    public int getVisibleBar() {
        return this.visibleBar;
    }

    public void setVisibleBar(int n) {
        if (n > 0 && n < this.bars.size() - 1) {
            this.visibleBar = n;
            this.render();
        }
    }

    public void render() {
        int n = this.bars.size();
        int n2 = this.visibleBar + 1;
        int n3 = n - n2;
        Iterator iterator = this.bars.keySet().iterator();
        this.topPanel.removeAll();
        GridLayout gridLayout = (GridLayout)this.topPanel.getLayout();
        gridLayout.setRows(n2);
        BarInfo barInfo = null;
        for (int i = 0; i < n2; ++i) {
            String string = (String)iterator.next();
            barInfo = (BarInfo)this.bars.get(string);
            this.topPanel.add(barInfo.getButton());
        }
        this.topPanel.validate();
        this.bottomPanel.removeAll();
        GridLayout gridLayout2 = (GridLayout)this.bottomPanel.getLayout();
        gridLayout2.setRows(n3);
        for (int i = 0; i < n3; ++i) {
            String string = (String)iterator.next();
            barInfo = (BarInfo)this.bars.get(string);
            this.bottomPanel.add(barInfo.getButton());
        }
        this.bottomPanel.validate();
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        for (String string : this.bars.keySet()) {
            BarInfo barInfo = (BarInfo)this.bars.get(string);
            if (barInfo.getButton() == actionEvent.getSource()) {
                this.visibleBar = n;
                this.visibleComponent.setAvailableList(barInfo.getPrefab());
                this.render();
            } else {
                barInfo.clearList();
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            HeroDesigner heroDesigner = HeroDesigner.getInstance();
            heroDesigner.openHero(new File("C:\\Documents and Settings\\Dan Simon\\My Documents\\HDv3\\Acid Powers.hdp"), false);
            JFrame jFrame = new JFrame("JOutlookBar Test");
            PrefabOutlookBar prefabOutlookBar = new PrefabOutlookBar(5);
            prefabOutlookBar.addBar("Acid Powers", new File("C:\\Documents and Settings\\Dan Simon\\My Documents\\HDv3\\Prefabs\\Acid Powers.hdp"));
            prefabOutlookBar.addBar("Air and Wind Powers", new File("C:\\Documents and Settings\\Dan Simon\\My Documents\\HDv3\\Prefabs\\Air and Wind Powers.hdp"));
            prefabOutlookBar.addBar("Animal Powers (Aquatic Powers)", new File("C:\\Documents and Settings\\Dan Simon\\My Documents\\HDv3\\Prefabs\\Animal Powers (Aquatic Powers).hdp"));
            prefabOutlookBar.addBar("Animal Powers (Avian Powers)", new File("C:\\Documents and Settings\\Dan Simon\\My Documents\\HDv3\\Prefabs\\Animal Powers (Avian Powers).hdp"));
            prefabOutlookBar.addBar("Animal Powers (General)", new File("C:\\Documents and Settings\\Dan Simon\\My Documents\\HDv3\\Prefabs\\Animal Powers (General).hdp"));
            prefabOutlookBar.addBar("Body Control Powers", new File("C:\\Documents and Settings\\Dan Simon\\My Documents\\HDv3\\Prefabs\\Body Control Powers.hdp"));
            prefabOutlookBar.setVisibleBar(2);
            jFrame.getContentPane().add(prefabOutlookBar);
            jFrame.setSize(800, 600);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setLocation(dimension.width / 2 - 400, dimension.height / 2 - 300);
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class BarInfo {
        private String name;
        private JButton button;
        private ArrayList<GenericObject> availableList;
        private File file;

        public BarInfo(String string, File file) {
            this.name = string;
            this.file = file;
            this.button = new JButton(string);
        }

        public BarInfo(String string, Icon icon, File file) {
            this.name = string;
            this.file = file;
            this.button = new JButton(string, icon);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public JButton getButton() {
            return this.button;
        }

        public void clearList() {
            this.availableList = null;
        }

        public ArrayList<GenericObject> getPrefab() {
            if (this.availableList != null) {
                return this.availableList;
            }
            System.out.println("Loading prefab...");
            Prefab prefab = new Prefab(this.file);
            System.out.println(prefab.getPowers().size());
            switch (PrefabOutlookBar.this.listType) {
                case 1: {
                    this.availableList = prefab.getSkills();
                    break;
                }
                case 2: {
                    this.availableList = prefab.getTalents();
                    break;
                }
                case 3: {
                    this.availableList = prefab.getPerks();
                    break;
                }
                case 4: {
                    this.availableList = prefab.getManeuvers();
                    break;
                }
                case 5: {
                    this.availableList = prefab.getPowers();
                    break;
                }
                case 7: {
                    this.availableList = prefab.getEquipment();
                    break;
                }
                case 6: {
                    this.availableList = prefab.getDisads();
                }
            }
            System.out.println("List size = " + this.availableList.size());
            return this.availableList;
        }
    }
}

