/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.ui.widgets.MessageWindow;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class PopupMessage
extends MessageWindow {
    private static final long serialVersionUID = 8384186899512899068L;
    public static final int TIMEOUT = 2000;
    private static Hashtable visiblePopups = new Hashtable();
    private static List<String> doNotShow = new ArrayList<String>();
    boolean timesUp = false;
    private JCheckBox disableCB;
    private String message;
    boolean disabled = false;
    private boolean showDisable = false;
    private Icon icon;

    public static PopupMessage getInstance(JFrame jFrame, JComponent jComponent, String string, boolean bl) {
        string = PopupMessage.removeTabs(string);
        string = PopupMessage.normalizeText(string);
        PopupMessage popupMessage = new PopupMessage(jFrame, jComponent, string.trim(), bl);
        return popupMessage;
    }

    public static String normalizeText(String string) {
        String string2;
        String string3;
        int n = 0;
        if ((string = string.trim()).startsWith("(") && string.indexOf(")") > 0) {
            n = string.indexOf(")") + 1;
        }
        if (n <= 0) {
            return string;
        }
        String string4 = string.substring(0, n) + "\n\n";
        string = string.substring(n, string.length());
        while (string.indexOf("\n") >= 0) {
            if (string.indexOf("\n") == 0) {
                string = string.substring(1, string.length());
                continue;
            }
            if (string.indexOf("\n") < string.length() - 1) {
                string3 = string.substring(0, string.indexOf("\n"));
                string2 = string.substring(string.indexOf("\n") + 1, string.length());
                string = string3 + " " + string2;
                continue;
            }
            string = string.substring(0, string.length() - 1);
        }
        while (string.indexOf("\r") >= 0) {
            if (string.indexOf("\r") == 0) {
                string = string.substring(1, string.length());
                continue;
            }
            if (string.indexOf("\r") < string.length() - 1) {
                string3 = string.substring(0, string.indexOf("\r"));
                string2 = string.substring(string.indexOf("\r") + 1, string.length());
                string = string3 + string2;
                continue;
            }
            string = string.substring(0, string.length() - 1);
        }
        string4 = string4 + string;
        return string4;
    }

    public static String removeTabs(String string) {
        while (string.indexOf("\t") >= 0) {
            if (string.indexOf("\t") == 0) {
                string = string.substring(1, string.length());
                continue;
            }
            if (string.indexOf("\t") < string.length() - 1) {
                String string2 = string.substring(0, string.indexOf("\t"));
                String string3 = string.substring(string.indexOf("\t") + 1, string.length());
                string = string2 + string3;
                continue;
            }
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private PopupMessage(JFrame jFrame, JComponent jComponent, String string, boolean bl) {
        super(jFrame, jComponent, string);
        this.message = string.trim();
        this.showDisable = bl;
        this.icon = bl ? UIManager.getIcon("OptionPane.errorIcon") : UIManager.getIcon("OptionPane.informationIcon");
        this.init();
        this.initListeners();
    }

    @Override
    protected void init() {
        super.init();
        this.disableCB = new JCheckBox("Do not show this again");
        this.disableCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupMessage.this.disabled = true;
                doNotShow.add(PopupMessage.this.message);
                PopupMessage.this.setVisible(false);
            }
        });
        this.disableCB.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)new JLabel(this.icon), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 15;
        if (this.showDisable) {
            this.getContentPane().add((Component)this.disableCB, gridBagConstraints);
        }
        this.pack();
    }

    protected void initListeners() {
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PopupMessage.this.setVisible(false);
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){});
        this.addMouseListener(new MouseAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (PopupMessage.this.timesUp) {
                    PopupMessage.this.setVisible(false);
                }
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                if (PopupMessage.this.timesUp) {
                    PopupMessage.this.setVisible(false);
                } else {
                    PopupMessage.this.toFront();
                }
            }
        });
    }

    @Override
    protected void setParent(JComponent jComponent) {
        this.parent = jComponent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVisible(boolean bl) {
        if (this.parent == null || this.owner == null || this.message == null || this.message.trim().length() == 0) {
            return;
        }
        if (bl && visiblePopups.get(this.parent) != null) {
            PopupMessage popupMessage = (PopupMessage)visiblePopups.get(this.parent);
            if (popupMessage.message.equals(this.message)) return;
            popupMessage.setVisible(false);
        } else if (!bl && visiblePopups.get(this.parent) != null) {
            visiblePopups.remove(this.parent);
        }
        if (this.disabled || doNotShow.contains(this.message)) {
            super.setVisible(false);
            return;
        }
        if (bl) {
            visiblePopups.put(this.parent, this);
        }
        this.timesUp = true;
        super.setVisible(bl);
        if (!bl || !this.showDisable) return;
        Toolkit.getDefaultToolkit().beep();
    }
}

