/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.modifiers.TimeLimit;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.ui.widgets.FractionTF;
import com.hero.ui.widgets.LevelTF;
import com.hero.ui.widgets.PopupMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ModifierPanel
extends JPanel {
    private static final long serialVersionUID = -2429582580726557971L;
    Modifier modifier;
    GenericObject parent;
    GenericDialog main;
    JCheckBox checkbox;
    FractionTF fractionTF;
    LevelTF levelTF;
    JLabel valueLbl;
    JTextField aliasTF;
    ArrayList<ActionListener> listeners;
    ActionListener checkboxListener;
    ItemListener comboListener;
    DocumentListener comboDocListener;
    JButton editBtn;
    JButton helpBtn;
    JComboBox combo;
    ModifierPanel childPanel;
    boolean selectionLocked = false;

    public ModifierPanel(GenericObject genericObject, Modifier modifier, GenericDialog genericDialog) {
        super(new GridBagLayout());
        this.setOpaque(true);
        this.listeners = new ArrayList();
        this.setBackground(Color.white);
        this.modifier = modifier;
        this.parent = genericObject;
        this.main = genericDialog;
        this.aliasTF = new JTextField(this.modifier.getAlias());
        this.aliasTF.setOpaque(false);
        this.aliasTF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.aliasTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ModifierPanel.this.modifier.setAlias(ModifierPanel.this.aliasTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ModifierPanel.this.modifier.setAlias(ModifierPanel.this.aliasTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ModifierPanel.this.modifier.setAlias(ModifierPanel.this.aliasTF.getText());
            }
        });
        this.checkbox = new JCheckBox();
        this.checkbox.setOpaque(false);
        if (!this.modifier.isPrivate() || !(this.parent instanceof List)) {
            this.checkbox.setSelected(this.parent.getAssignedModifiers().contains(this.modifier));
        } else {
            this.checkbox.setSelected(((List)this.main.getObject()).getPrivateMods().contains(this.modifier));
        }
        this.aliasTF.setFont(this.checkbox.getFont());
        this.checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModifierPanel.this.checkbox.isSelected()) {
                    Object object;
                    for (int i = 0; i < ModifierPanel.this.modifier.getExcludes().size(); ++i) {
                        Object object2;
                        int n;
                        object = ModifierPanel.this.modifier.getExcludes().get(i).trim().toUpperCase();
                        Modifier modifier = null;
                        ArrayList arrayList = (ArrayList)ModifierPanel.this.main.getObject().getAssignedModifiers().clone();
                        if (ModifierPanel.this.main.getObject() instanceof List) {
                            arrayList.addAll(((List)ModifierPanel.this.main.getObject()).getPrivateMods());
                        }
                        for (n = 0; n < arrayList.size(); ++n) {
                            object2 = (Modifier)arrayList.get(n);
                            if (!((GenericObject)object2).getXMLID().equals(object)) continue;
                            modifier = object2;
                            break;
                        }
                        if (modifier == null) continue;
                        for (n = 0; n < ModifierPanel.this.main.getModifierPanels().size(); ++n) {
                            object2 = ModifierPanel.this.main.getModifierPanels().get(n);
                            if (!((ModifierPanel)object2).getModifier().getXMLID().trim().toUpperCase().equals(object)) continue;
                            ((ModifierPanel)object2).setSelected(false);
                        }
                    }
                    ModifierPanel.this.addToParent();
                    if (!ModifierPanel.this.modifier.isExclusive() && ModifierPanel.this.childPanel == null) {
                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridwidth = 0;
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.anchor = 17;
                        object = ModifierPanel.this.modifier.clone();
                        ((GenericObject)object).resetID();
                        ModifierPanel.this.childPanel = new ModifierPanel(ModifierPanel.this.parent, (Modifier)object, ModifierPanel.this.main);
                        ModifierPanel.this.childPanel.setSelected(false);
                        ModifierPanel.this.add((Component)ModifierPanel.this.childPanel, gridBagConstraints);
                    } else if (ModifierPanel.this.childPanel != null) {
                        ModifierPanel.this.childPanel.setVisible(true);
                    }
                } else {
                    ModifierPanel.this.removeFromParent();
                    if (ModifierPanel.this.childPanel != null && !ModifierPanel.this.childPanel.isSelected()) {
                        ModifierPanel.this.childPanel.setVisible(false);
                    }
                }
                if (!ModifierPanel.this.parent.verifyModifiers()) {
                    ModifierPanel.this.main.resetMods();
                }
                ModifierPanel.this.revalidate();
                ModifierPanel.this.dispatch();
            }
        };
        this.checkbox.addActionListener(this.checkboxListener);
        this.combo = new JComboBox<Object>(this.modifier.getOptions().toArray());
        this.combo.setBackground(Color.white);
        if (this.modifier.getSelectedOption() != null) {
            this.combo.setSelectedItem(this.modifier.getSelectedOption());
        }
        this.comboListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ModifierPanel.this.combo.getSelectedItem() == null || !(ModifierPanel.this.combo.getSelectedItem() instanceof Adder)) {
                    return;
                }
                Adder adder = (Adder)ModifierPanel.this.combo.getSelectedItem();
                ModifierPanel.this.modifier.setSelectedOption(adder);
                ModifierPanel.this.updateValues();
                ModifierPanel.this.dispatch();
            }
        };
        this.combo.addItemListener(this.comboListener);
        if (this.modifier.getSelectedOption() == null && this.combo.getItemCount() > 0) {
            this.modifier.setSelectedOption((Adder)this.combo.getItemAt(0));
        }
        this.combo.setEditable(true);
        if (this.modifier.getSelectedOption() != null) {
            ((JTextField)this.combo.getEditor().getEditorComponent()).setText(this.modifier.getSelectedOption().getAlias());
        }
        this.comboDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (ModifierPanel.this.modifier.getSelectedOption() != null) {
                    ModifierPanel.this.modifier.getSelectedOption().setAlias(((JTextField)ModifierPanel.this.combo.getEditor().getEditorComponent()).getText());
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (ModifierPanel.this.modifier.getSelectedOption() != null) {
                    ModifierPanel.this.modifier.getSelectedOption().setAlias(((JTextField)ModifierPanel.this.combo.getEditor().getEditorComponent()).getText());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (ModifierPanel.this.modifier.getSelectedOption() != null) {
                    ModifierPanel.this.modifier.getSelectedOption().setAlias(((JTextField)ModifierPanel.this.combo.getEditor().getEditorComponent()).getText());
                }
            }
        };
        ((JTextField)this.combo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.comboDocListener);
        this.levelTF = new LevelTF(this.modifier.getLevels(), 999, this.modifier.getMinimumLevel());
        this.levelTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierPanel.this.modifier.setLevels(ModifierPanel.this.levelTF.getCurrent());
                ModifierPanel.this.updateValues();
                ModifierPanel.this.dispatch();
            }
        });
        this.helpBtn = new JButton(" ? ");
        this.helpBtn.setOpaque(false);
        this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
        this.helpBtn.setBorderPainted(false);
        this.helpBtn.setFocusPainted(false);
        this.helpBtn.setContentAreaFilled(false);
        this.helpBtn.setForeground(Color.blue);
        if (this.modifier.getDefinition() != null && this.modifier.getDefinition().trim().length() > 0) {
            this.helpBtn.setVisible(true);
        } else {
            this.helpBtn.setVisible(false);
        }
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModifierPanel.this.modifier == null) {
                    return;
                }
                if (ModifierPanel.this.modifier.getDefinition() == null) {
                    return;
                }
                if (ModifierPanel.this.modifier.getDefinition().trim().length() == 0) {
                    return;
                }
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), ModifierPanel.this.helpBtn, ModifierPanel.this.modifier.getDefinition(), false);
                popupMessage.setVisible(true);
            }
        });
        this.valueLbl = new JLabel("(" + this.modifier.getFraction(this.modifier.getTotalValue()) + ")");
        this.valueLbl.setPreferredSize(new JLabel("(+9 1/2)").getPreferredSize());
        this.valueLbl.setHorizontalTextPosition(4);
        this.valueLbl.setHorizontalAlignment(4);
        if (!this.modifier.isFixedValue()) {
            this.fractionTF = new FractionTF(this.modifier.getTotalValue(), this.modifier.getMaxCost(), this.modifier.getMinimumCost(), this.modifier.useMultiplier());
            this.fractionTF.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ModifierPanel.this.modifier.setBaseCost(ModifierPanel.this.fractionTF.getCurrent());
                    ModifierPanel.this.main.updateValues();
                }
            });
        }
        this.editBtn = new JButton("Edit");
        this.editBtn.setOpaque(false);
        this.editBtn.setMargin(new Insets(0, 0, 0, 0));
        this.editBtn.setBorderPainted(false);
        this.editBtn.setFocusPainted(false);
        this.editBtn.setContentAreaFilled(false);
        this.editBtn.setForeground(Color.blue);
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModifierPanel.this.modifier.noDisplayDialog()) {
                    List list;
                    Modifier modifier = ModifierPanel.this.modifier.clone();
                    modifier.setID(ModifierPanel.this.modifier.getID());
                    ModifierDialog modifierDialog = modifier.getDialog(ModifierPanel.this.parent, false);
                    modifierDialog.setLocationRelativeTo(ModifierPanel.this.editBtn);
                    modifierDialog.setVisible(true);
                    if (!modifierDialog.okButtonClicked) {
                        return;
                    }
                    ArrayList<Modifier> arrayList = ModifierPanel.this.parent.getAssignedModifiers();
                    int n = arrayList.indexOf(ModifierPanel.this.modifier);
                    if (n >= 0) {
                        arrayList.set(n, modifier);
                    } else if (ModifierPanel.this.parent instanceof List && (n = (arrayList = (list = (List)ModifierPanel.this.parent).getPrivateMods()).indexOf(ModifierPanel.this.modifier)) >= 0) {
                        arrayList.set(n, modifier);
                    }
                    ModifierPanel.this.modifier = modifier;
                    ModifierPanel.this.main.updateValues();
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 3);
        this.add((Component)this.checkbox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.aliasTF, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        if (!this.modifier.noDisplayDialog()) {
            this.add((Component)this.editBtn, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        if (this.modifier.getOptions().size() > 0) {
            this.add((Component)this.combo, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        this.add((Component)this.helpBtn, gridBagConstraints);
        ++gridBagConstraints.gridx;
        if (this.modifier.getLevelValue() != 0.0 && this.modifier.getLevelCost() != 0.0 && this.modifier.noDisplayDialog()) {
            this.add((Component)this.levelTF, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.modifier.isFixedValue()) {
            this.add((Component)this.valueLbl, gridBagConstraints);
        } else {
            this.add((Component)this.fractionTF, gridBagConstraints);
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierPanel.this.main.updateValues();
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    private void addToParent() {
        if (!this.modifier.isPrivate() || !(this.parent instanceof List)) {
            if (!this.parent.getAssignedModifiers().contains(this.modifier) || !this.modifier.isExclusive()) {
                this.parent.getAssignedModifiers().add(this.modifier);
            }
        } else if (!((List)this.main.getObject()).getPrivateMods().contains(this.modifier) || !this.modifier.isExclusive()) {
            ((List)this.main.getObject()).getPrivateMods().add(this.modifier);
        }
    }

    private void dispatch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ModifierPanel.this.listeners.size(); ++i) {
                    ActionListener actionListener = ModifierPanel.this.listeners.get(i);
                    actionListener.actionPerformed(null);
                }
            }
        });
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public boolean isSelected() {
        return this.checkbox.isSelected();
    }

    private void removeFromParent() {
        if (!this.modifier.isPrivate() || !(this.parent instanceof List)) {
            this.parent.getAssignedModifiers().remove(this.modifier);
        } else {
            ((List)this.parent).getPrivateMods().remove(this.modifier);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.checkbox.setEnabled(bl);
        this.valueLbl.setEnabled(bl);
        this.aliasTF.setEnabled(bl);
    }

    public void setSelected(boolean bl) {
        this.checkbox.setSelected(bl);
        if (bl) {
            this.addToParent();
        } else {
            this.removeFromParent();
        }
    }

    public void setSelectionLocked(boolean bl) {
        this.selectionLocked = bl;
    }

    public void updateValues() {
        this.checkbox.removeActionListener(this.checkboxListener);
        if (!this.modifier.isPrivate() || !(this.parent instanceof List)) {
            this.checkbox.setSelected(this.parent.getAssignedModifiers().contains(this.modifier));
        } else {
            this.checkbox.setSelected(((List)this.main.getObject()).getPrivateMods().contains(this.modifier));
        }
        this.checkbox.addActionListener(this.checkboxListener);
        this.combo.removeItemListener(this.comboListener);
        ((JTextField)this.combo.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this.comboDocListener);
        this.combo.removeAllItems();
        for (int i = 0; i < this.modifier.getOptions().size(); ++i) {
            Adder adder = this.modifier.getOptions().get(i);
            this.combo.addItem(adder);
            if (!adder.getXMLID().equals(this.modifier.getSelectedOption().getXMLID())) continue;
            this.combo.setSelectedIndex(i);
        }
        this.combo.addItemListener(this.comboListener);
        ((JTextField)this.combo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.comboDocListener);
        if (this.modifier instanceof TimeLimit) {
            this.modifier.setBaseCost(this.modifier.getSelectedOption().getBaseCost());
        }
        if (this.valueLbl != null) {
            this.valueLbl.setText("(" + this.modifier.getFraction(this.modifier.getTotalValue()) + ")");
        }
        if (this.fractionTF != null) {
            this.fractionTF.setCurrent(this.modifier.getTotalValue());
        }
        if (this.levelTF != null) {
            this.levelTF.setCurrent(this.modifier.getLevels());
        }
        this.aliasTF.setText(this.modifier.getAlias());
    }
}

