/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class MessageWindow
extends JDialog {
    private static final long serialVersionUID = -7636027891614060053L;
    private static Color background = new Color(230, 230, 230);
    protected static boolean debug = true;
    protected SizingTextPane editor;
    protected String message = "";
    protected JFrame owner = null;
    protected JComponent parent = null;

    public MessageWindow(JFrame jFrame, JComponent jComponent, String string) {
        super((Frame)jFrame, true);
        this.owner = jFrame;
        this.parent = jComponent;
        this.message = string;
        this.editor = new SizingTextPane();
        this.editor.setText(string);
    }

    protected void init() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 5);
        this.editor.setOpaque(false);
        jPanel.add((Component)this.editor, gridBagConstraints);
        jPanel.setBackground(background);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.setContentPane(jPanel);
        this.pack();
    }

    private void setLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n4 = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n5 = (int)this.owner.getLocationOnScreen().getY();
        int n6 = n5 + this.owner.getHeight();
        int n7 = (int)this.parent.getLocationOnScreen().getY();
        int n8 = n7 + this.parent.getHeight();
        int n9 = (int)this.parent.getLocationOnScreen().getX();
        int n10 = n9 + this.parent.getWidth();
        int n11 = this.getHeight();
        int n12 = this.getWidth();
        n = n9 + (n10 - n9) / 2 - n12 / 2 - 6;
        if (n < 0) {
            n = 0;
        }
        if (n + n12 > n3 && (n = n3 - n12) < 0) {
            n /= 2;
        }
        if (((n2 = n8) + n11 > n6 || n2 + n11 > n4) && (n2 = n7 - n11 - 5) < n5) {
            n2 = n8 + n11 < n4 ? n8 : (n7 - n11 > 0 ? n7 - n11 : (n4 - n11) / 2);
        }
        this.setLocation(n, n2);
    }

    public void setMessage(String string) {
        this.message = string;
    }

    protected void setParent(JComponent jComponent) {
        this.parent = jComponent;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation();
        }
        super.setVisible(bl);
    }

    class SizingTextPane
    extends JTextArea {
        private static final long serialVersionUID = -3624727298744098408L;
        private int minWidth = 200;

        public SizingTextPane() {
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            this.setEditable(false);
        }

        @Override
        public Dimension getMaximumSize() {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int n;
            int n2;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = n2 = fontMetrics.stringWidth(this.getText());
            int n4 = n = fontMetrics.getHeight();
            int n5 = 1;
            while (n3 > this.minWidth && n4 * 3 < n3) {
                int n6;
                int n7 = 3;
                int n8 = n2 / ++n5;
                int n9 = 0;
                int n10 = 0;
                for (n6 = 0; n6 < this.getText().length(); ++n6) {
                    char c;
                    String string = this.getText().substring(n10, n6);
                    if (string.length() > 0 && ((c = string.charAt(string.length() - 1)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
                        n9 = n6;
                    }
                    if (fontMetrics.stringWidth(string) > n8) {
                        ++n7;
                        if (fontMetrics.stringWidth(string) <= n8) continue;
                        ++n7;
                        if (n9 == n10) {
                            n10 = n6;
                            n9 = n6;
                            continue;
                        }
                        n10 = n9;
                        n6 = n9;
                        continue;
                    }
                    if (string.length() <= 0 || string.charAt(string.length() - 1) != '\n' && string.charAt(string.length() - 1) != '\r') continue;
                    ++n7;
                    n10 = n6;
                    n9 = n6;
                }
                n6 = n * n7;
                if (n8 / n6 < 2) break;
                n3 = n8;
                n4 = n6;
            }
            return new Dimension(n3, n4);
        }
    }
}

