/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.model.NumericDocument;
import com.hero.objects.GenericObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LevelTF
extends JComponent {
    private static final long serialVersionUID = -5052663705888531663L;
    int start;
    int max;
    int min;
    int oldVal = -999999;
    int holder = 0;
    JTextField tf;
    JButton inc;
    JButton dec;
    DocumentListener tfListener;
    boolean incMouseDown;
    boolean decMouseDown;
    private GenericObject trackObject;

    public LevelTF(int n, int n2, int n3) {
        this.setLayout(new BorderLayout());
        this.start = n;
        this.max = n2;
        this.min = n3;
        this.oldVal = this.start;
        this.holder = this.start;
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.setCurrent(this.start);
    }

    public void setTrackObject(GenericObject genericObject) {
        this.trackObject = genericObject;
    }

    public GenericObject getTrackObject() {
        return this.trackObject;
    }

    public int getCurrent() {
        return this.holder;
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    private void initListeners() {
        this.inc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                try {
                    n = Integer.parseInt(LevelTF.this.tf.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (++n <= LevelTF.this.max) {
                    LevelTF.this.setCurrent(n);
                }
            }
        });
        this.inc.addMouseListener(new MouseAdapter(){
            Thread runner;
            int current;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LevelTF.this.incMouseDown = true;
                if (this.runner == null || !this.runner.isAlive()) {
                    this.runner = new Thread(){

                        @Override
                        public void run() {
                            int n = 0;
                            while (LevelTF.this.incMouseDown) {
                                try {
                                    Thread.sleep(n == 0 ? 1000L : (n > 10 ? 200L : (n > 50 ? 100L : 500L)));
                                    ++n;
                                    if (!LevelTF.this.incMouseDown) {
                                        return;
                                    }
                                    current = Integer.parseInt(LevelTF.this.tf.getText());
                                    ++current;
                                    if (current <= LevelTF.this.max) {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                LevelTF.this.setCurrent(current);
                                            }
                                        });
                                        continue;
                                    }
                                    return;
                                }
                                catch (Exception exception) {
                                    return;
                                }
                            }
                        }
                    };
                    this.runner.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LevelTF.this.incMouseDown = false;
                LevelTF.this.firePropertyChange("Level", LevelTF.this.holder - 1, LevelTF.this.holder);
            }
        });
        this.inc.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                LevelTF.this.incMouseDown = false;
                LevelTF.this.firePropertyChange("Level", LevelTF.this.holder - 1, LevelTF.this.holder);
            }
        });
        this.dec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                try {
                    n = Integer.parseInt(LevelTF.this.tf.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (--n >= LevelTF.this.min) {
                    LevelTF.this.setCurrent(n);
                }
            }
        });
        this.dec.addMouseListener(new MouseAdapter(){
            Thread runner;
            int current;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LevelTF.this.decMouseDown = true;
                if (this.runner == null || !this.runner.isAlive()) {
                    this.runner = new Thread(){

                        @Override
                        public void run() {
                            int n = 0;
                            while (LevelTF.this.decMouseDown) {
                                try {
                                    Thread.sleep(n == 0 ? 1000L : (n > 10 ? 200L : (n > 50 ? 100L : 500L)));
                                    ++n;
                                    if (!LevelTF.this.decMouseDown) {
                                        return;
                                    }
                                    current = Integer.parseInt(LevelTF.this.tf.getText());
                                    --current;
                                    if (current >= LevelTF.this.min) {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                LevelTF.this.setCurrent(current);
                                            }
                                        });
                                        continue;
                                    }
                                    return;
                                }
                                catch (Exception exception) {
                                    return;
                                }
                            }
                        }
                    };
                    this.runner.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LevelTF.this.decMouseDown = false;
                LevelTF.this.firePropertyChange("Level", LevelTF.this.holder - 1, LevelTF.this.holder);
            }
        });
        this.dec.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                LevelTF.this.decMouseDown = false;
                LevelTF.this.firePropertyChange("Level", LevelTF.this.holder - 1, LevelTF.this.holder);
            }
        });
        this.tfListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (LevelTF.this.tf.getText().trim().length() == 0) {
                    return;
                }
                try {
                    int n = Integer.parseInt(LevelTF.this.tf.getText());
                    if (n <= LevelTF.this.max && (n >= LevelTF.this.min || LevelTF.this.getCurrent() < LevelTF.this.min)) {
                        LevelTF.this.setCurrent(n);
                    } else if (n > LevelTF.this.max) {
                        LevelTF.this.setCurrent(LevelTF.this.max);
                    } else if (n < LevelTF.this.min) {
                        LevelTF.this.setCurrent(LevelTF.this.min);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LevelTF.this.setCurrent(LevelTF.this.getCurrent());
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (LevelTF.this.tf.getText().trim().length() == 0) {
                    return;
                }
                try {
                    int n = Integer.parseInt(LevelTF.this.tf.getText());
                    if (n <= LevelTF.this.max && (n >= LevelTF.this.min || LevelTF.this.getCurrent() < LevelTF.this.min)) {
                        LevelTF.this.setCurrent(n);
                    } else if (n > LevelTF.this.max) {
                        LevelTF.this.setCurrent(LevelTF.this.max);
                    } else if (n < LevelTF.this.min) {
                        LevelTF.this.setCurrent(LevelTF.this.min);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LevelTF.this.setCurrent(LevelTF.this.getCurrent());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (LevelTF.this.tf.getText().trim().length() == 0) {
                    return;
                }
                try {
                    int n = Integer.parseInt(LevelTF.this.tf.getText());
                    if (n <= LevelTF.this.max && (n >= LevelTF.this.min || LevelTF.this.getCurrent() < LevelTF.this.min)) {
                        LevelTF.this.setCurrent(n);
                    } else if (n > LevelTF.this.max) {
                        LevelTF.this.setCurrent(LevelTF.this.max);
                    } else if (n < LevelTF.this.min) {
                        LevelTF.this.setCurrent(LevelTF.this.min);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LevelTF.this.setCurrent(LevelTF.this.getCurrent());
                }
            }
        };
        this.tf.getDocument().addDocumentListener(this.tfListener);
        this.tf.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                LevelTF.this.tf.selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (LevelTF.this.tf.getText().trim().length() == 0) {
                    LevelTF.this.tf.setText("" + LevelTF.this.getCurrent());
                }
                LevelTF.this.incMouseDown = false;
                LevelTF.this.decMouseDown = false;
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                LevelTF.this.incMouseDown = false;
                LevelTF.this.decMouseDown = false;
            }
        });
    }

    private void initWidgets() {
        int n = 4;
        if (this.max > 9999) {
            n = 7;
        }
        this.tf = new JTextField(new NumericDocument(this.max, this.min), "" + this.start, n);
        this.tf.setHorizontalAlignment(0);
        this.inc = new JButton(">");
        this.inc.setMargin(new Insets(0, 0, 0, 0));
        this.inc.setFocusable(false);
        this.dec = new JButton("<");
        this.dec.setMargin(new Insets(0, 0, 0, 0));
        this.dec.setFocusable(false);
    }

    private void layoutComponent() {
        this.add((Component)this.dec, "West");
        this.add((Component)this.tf, "Center");
        this.add((Component)this.inc, "East");
    }

    public synchronized void setCurrent(int n) {
        this.holder = n;
        this.tf.getDocument().removeDocumentListener(this.tfListener);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LevelTF.this.tf.getText().equals("" + LevelTF.this.holder)) {
                        return;
                    }
                    LevelTF.this.tf.setText("" + LevelTF.this.holder);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.holder >= this.max) {
            this.inc.setEnabled(false);
        } else {
            this.inc.setEnabled(true);
        }
        if (this.holder <= this.min) {
            this.dec.setEnabled(false);
        } else {
            this.dec.setEnabled(true);
        }
        if (this.holder != this.oldVal) {
            int n2 = this.oldVal;
            this.oldVal = this.holder;
            if (!this.incMouseDown && !this.decMouseDown) {
                this.firePropertyChange("Level", n2, this.holder);
            }
        }
        this.tf.getDocument().addDocumentListener(this.tfListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.tf.setEnabled(bl);
        this.inc.setEnabled(bl);
        this.dec.setEnabled(bl);
    }

    public void setMax(int n) {
        this.max = n;
        ((NumericDocument)this.tf.getDocument()).setMax(this.max);
        if (this.getCurrent() > this.max) {
            this.setCurrent(this.max);
        } else if (this.getCurrent() < this.max) {
            this.inc.setEnabled(true);
        } else {
            this.inc.setEnabled(false);
        }
    }

    public void setMin(int n) {
        this.min = n;
        ((NumericDocument)this.tf.getDocument()).setMin(this.min);
        if (this.getCurrent() < this.min) {
            this.setCurrent(this.min);
        } else if (this.getCurrent() > this.min) {
            this.dec.setEnabled(true);
        } else {
            this.dec.setEnabled(false);
        }
    }
}

