/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.model.FractionDocument;
import com.hero.model.MultiplierDocument;
import com.hero.util.Rounder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class FractionTF
extends JComponent {
    private static final long serialVersionUID = -3419149473699452202L;
    double current;
    double max;
    double min;
    JTextField tf;
    JButton inc;
    JButton dec;
    DocumentListener tfListener;
    boolean incMouseDown;
    boolean decMouseDown;
    boolean useMultiplier = false;
    double oldVal = -9999999.0;

    public FractionTF(double d, double d2, double d3) {
        this.setLayout(new BorderLayout());
        this.current = d;
        this.max = d2;
        this.min = d3;
        if (d2 < d3) {
            d2 = d3;
        }
        if (this.current < d3) {
            this.current = d3;
        }
        if (this.current > d2) {
            this.current = d2;
        }
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.setCurrent(this.current);
    }

    public FractionTF(double d, double d2, double d3, boolean bl) {
        this.setLayout(new BorderLayout());
        this.useMultiplier = bl;
        this.current = d;
        this.max = d2;
        this.min = d3;
        if (d2 < d3) {
            d2 = d3;
        }
        if (this.current < d3) {
            this.current = d3;
        }
        if (this.current > d2) {
            this.current = d2;
        }
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.setCurrent(this.current);
    }

    void checkTF() {
        String string = this.tf.getText();
        if (string.length() == 0) {
            return;
        }
        try {
            int n = 1;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (!this.useMultiplier) {
                if (string.startsWith("+")) {
                    string = string.substring(1, string.length());
                } else if (string.startsWith("-")) {
                    string = string.substring(1, string.length());
                    n = -1;
                }
                if (string.length() == 0) {
                    this.setForeground(Color.red);
                    return;
                }
                if (string.indexOf(" ") > 0) {
                    n2 = Integer.parseInt(string.substring(0, string.indexOf(" ")));
                    if ((string = string.substring(string.indexOf(" ") + 1, string.length())).indexOf("/") > 0) {
                        n3 = Integer.parseInt(string.substring(0, string.indexOf("/")));
                        if (string.indexOf("/") < string.length() - 1) {
                            n4 = Integer.parseInt(string.substring(string.indexOf("/") + 1, string.length()));
                        }
                    }
                } else if (string.indexOf("/") > 0) {
                    n3 = Integer.parseInt(string.substring(0, string.indexOf("/")));
                    if (string.indexOf("/") < string.length() - 1) {
                        n4 = Integer.parseInt(string.substring(string.indexOf("/") + 1, string.length()));
                    }
                } else {
                    n2 = Integer.parseInt(string);
                }
                if ((double)(n2 *= n) < this.min || (double)n2 > this.max) {
                    this.tf.setForeground(Color.red);
                } else if (n3 > 0 && n4 == 0) {
                    this.tf.setForeground(Color.red);
                } else {
                    this.tf.setForeground(Color.black);
                    double d = n2;
                    if (n4 != 0) {
                        d *= (double)n;
                        d += (double)n3 / (double)n4;
                        d *= (double)n;
                    }
                    this.setCurrent(d);
                }
            } else {
                if (string.startsWith("x")) {
                    string = string.substring(1, string.length());
                }
                if (string.startsWith("-")) {
                    string = string.substring(1, string.length());
                    n = -1;
                }
                if (string.length() == 0) {
                    this.setForeground(Color.red);
                    return;
                }
                if (string.indexOf(" ") > 0) {
                    n2 = Integer.parseInt(string.substring(0, string.indexOf(" ")));
                    if ((string = string.substring(string.indexOf(" ") + 1, string.length())).indexOf("/") > 0) {
                        n3 = Integer.parseInt(string.substring(0, string.indexOf("/")));
                        if (string.indexOf("/") < string.length() - 1) {
                            n4 = Integer.parseInt(string.substring(string.indexOf("/") + 1, string.length()));
                        }
                    }
                } else if (string.indexOf("/") > 0) {
                    n3 = Integer.parseInt(string.substring(0, string.indexOf("/")));
                    if (string.indexOf("/") < string.length() - 1) {
                        n4 = Integer.parseInt(string.substring(string.indexOf("/") + 1, string.length()));
                    }
                } else {
                    n2 = Integer.parseInt(string);
                }
                n2 *= n;
                if (n3 > 0 && n4 == 0) {
                    this.tf.setForeground(Color.red);
                } else {
                    this.tf.setForeground(Color.black);
                    double d = n2;
                    if (n4 != 0) {
                        d *= (double)n;
                        d += (double)n3 / (double)n4;
                        d *= (double)n;
                        d -= 1.0;
                    }
                    if (d < this.min || d > this.max) {
                        this.tf.setForeground(Color.red);
                    }
                    this.setCurrent(d);
                }
            }
        }
        catch (Exception exception) {
            this.setCurrent(this.current);
            exception.printStackTrace();
        }
    }

    public double getCurrent() {
        return this.current;
    }

    public Document getDocument() {
        return this.tf.getDocument();
    }

    public String getFraction(double d) {
        return this.getFraction(d, this.useMultiplier);
    }

    private String getFraction(double d, boolean bl) {
        String string = "";
        if (d == 0.0) {
            if (bl) {
                return "x1";
            }
            return "+0";
        }
        if (bl) {
            string = "x";
            boolean bl2 = false;
            if (d < 0.0) {
                bl2 = true;
                d = Math.abs(d);
            }
            String string2 = "";
            long l = Rounder.roundDown(d + 1.0E-7);
            if ((double)l < d && (string2 = this.getFraction(d - (double)l, false)).startsWith("+")) {
                string2 = string2.substring(1, string2.length());
            }
            if (string2.trim().length() > 0) {
                string2 = " " + string2;
            }
            string = bl2 ? string + "1/" + l + string2 : string + ++l + string2;
            return string;
        }
        string = d < 0.0 ? string + "-" : string + "+";
        if ((d = Math.abs(d)) > 1.0) {
            string = bl ? string + (int)Rounder.roundDown(d + 1.0) : string + (int)Rounder.roundDown(d);
            d -= (double)Rounder.roundDown(d);
        }
        if (d == 0.0) {
            return string;
        }
        String string3 = "";
        double d2 = 1.0;
        if (Math.abs(0.25 - d) < d2) {
            d2 = Math.abs(0.25 - d);
            string3 = "1/4";
        }
        if (Math.abs(0.5 - d) < d2) {
            d2 = Math.abs(0.5 - d);
            string3 = "1/2";
        }
        if (Math.abs(0.75 - d) < d2) {
            d2 = Math.abs(0.75 - d);
            string3 = "3/4";
        }
        if (Math.abs(1.0 - d) < d2) {
            string3 = "";
            if (string.length() > 1) {
                int n = Integer.parseInt(string.substring(1, string.length()));
                string = string.substring(0, 1) + (n + 1);
            } else {
                string = string.length() == 1 && !string.equals("+") && !string.equals("-") && !string.equals("x") ? "" + (Integer.parseInt(string) + 1) : (string.trim().length() == 0 || string.trim().equals("+") ? "+1" : "-1");
            }
        }
        if (string.length() > 1) {
            string = string + " ";
        }
        string = string + string3;
        string = string.trim();
        return string;
    }

    private void initListeners() {
        this.inc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = FractionTF.this.current + 0.25;
                if (d <= FractionTF.this.max) {
                    FractionTF.this.setCurrent(d);
                }
            }
        });
        this.inc.addMouseListener(new MouseAdapter(){
            Thread runner;
            double check;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FractionTF.this.incMouseDown = true;
                if (this.runner == null || !this.runner.isAlive()) {
                    this.runner = new Thread(){

                        @Override
                        public void run() {
                            int n = 0;
                            while (FractionTF.this.incMouseDown) {
                                try {
                                    Thread.sleep(n == 0 ? 1000L : (n > 10 ? 200L : (n > 50 ? 100L : 500L)));
                                    ++n;
                                    if (!FractionTF.this.incMouseDown) {
                                        return;
                                    }
                                    check = FractionTF.this.current + 0.25;
                                    if (check <= FractionTF.this.max) {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                FractionTF.this.setCurrent(check);
                                            }
                                        });
                                        continue;
                                    }
                                    return;
                                }
                                catch (Exception exception) {
                                    return;
                                }
                            }
                        }
                    };
                    this.runner.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FractionTF.this.incMouseDown = false;
            }
        });
        this.inc.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FractionTF.this.incMouseDown = false;
            }
        });
        this.dec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = FractionTF.this.current - 0.25;
                if (d >= FractionTF.this.min) {
                    FractionTF.this.setCurrent(d);
                }
            }
        });
        this.dec.addMouseListener(new MouseAdapter(){
            Thread runner;
            double check;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FractionTF.this.decMouseDown = true;
                if (this.runner == null || !this.runner.isAlive()) {
                    this.runner = new Thread(){

                        @Override
                        public void run() {
                            int n = 0;
                            while (FractionTF.this.decMouseDown) {
                                try {
                                    Thread.sleep(n == 0 ? 1000L : (n > 10 ? 200L : (n > 50 ? 100L : 500L)));
                                    ++n;
                                    if (!FractionTF.this.decMouseDown) {
                                        return;
                                    }
                                    check = FractionTF.this.current - 0.25;
                                    if (check >= FractionTF.this.min) {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                FractionTF.this.setCurrent(check);
                                            }
                                        });
                                        continue;
                                    }
                                    return;
                                }
                                catch (Exception exception) {
                                    return;
                                }
                            }
                        }
                    };
                    this.runner.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FractionTF.this.decMouseDown = false;
            }
        });
        this.dec.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FractionTF.this.decMouseDown = false;
            }
        });
        this.tfListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FractionTF.this.checkTF();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FractionTF.this.checkTF();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FractionTF.this.checkTF();
            }
        };
        this.tf.getDocument().addDocumentListener(this.tfListener);
        this.tf.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                FractionTF.this.setCurrent(FractionTF.this.current);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FractionTF.this.setCurrent(FractionTF.this.current);
            }
        });
    }

    private void initWidgets() {
        this.tf = this.useMultiplier ? new JTextField(new MultiplierDocument(this.max, this.min), this.getFraction(this.current), 5) : new JTextField(new FractionDocument(this.max, this.min), this.getFraction(this.current), 5);
        this.tf.setHorizontalAlignment(0);
        this.inc = new JButton(">");
        this.inc.setMargin(new Insets(0, 0, 0, 0));
        this.dec = new JButton("<");
        this.dec.setMargin(new Insets(0, 0, 0, 0));
    }

    private void layoutComponent() {
        this.add((Component)this.dec, "West");
        this.add((Component)this.tf, "Center");
        this.add((Component)this.inc, "East");
    }

    public void setCurrent(double d) {
        this.tf.getDocument().removeDocumentListener(this.tfListener);
        try {
            this.tf.setText(this.getFraction(d));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.current = d;
        if (this.getCurrent() >= this.max) {
            this.inc.setEnabled(false);
        } else {
            this.inc.setEnabled(true);
        }
        if (this.getCurrent() <= this.min) {
            this.dec.setEnabled(false);
        } else {
            this.dec.setEnabled(true);
        }
        if (this.getCurrent() != this.oldVal) {
            double d2 = this.oldVal;
            this.oldVal = this.getCurrent();
            this.firePropertyChange("Level", d2, this.getCurrent());
        }
        this.tf.getDocument().addDocumentListener(this.tfListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.tf.setEnabled(bl);
        this.inc.setEnabled(bl);
        this.dec.setEnabled(bl);
        if (bl) {
            this.setCurrent(this.getCurrent());
        }
    }
}

