/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.FractionTF;
import com.hero.ui.widgets.LevelTF;
import com.hero.util.Rounder;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CustomAdderPanel
extends JPanel {
    private static final long serialVersionUID = 8344531362573596991L;
    Adder adder;
    GenericObject parent;
    GenericDialog main;
    JCheckBox checkbox;
    LevelTF pointsTF;
    FractionTF fracTF;
    JTextField aliasTF;
    ArrayList<ActionListener> listeners;
    ActionListener checkboxListener;
    boolean selectionLocked = false;

    public CustomAdderPanel(GenericObject genericObject, Adder adder, GenericDialog genericDialog) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.listeners = new ArrayList();
        this.setBackground(Color.white);
        this.adder = adder;
        this.parent = genericObject;
        this.main = genericDialog;
        this.aliasTF = new JTextField(this.adder.getAlias());
        this.aliasTF.setOpaque(false);
        this.aliasTF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.aliasTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CustomAdderPanel.this.adder.setAlias(CustomAdderPanel.this.aliasTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CustomAdderPanel.this.adder.setAlias(CustomAdderPanel.this.aliasTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CustomAdderPanel.this.adder.setAlias(CustomAdderPanel.this.aliasTF.getText());
            }
        });
        this.checkbox = new JCheckBox();
        this.checkbox.setOpaque(false);
        this.checkbox.setSelected(this.adder.isSelected());
        this.aliasTF.setFont(this.checkbox.getFont());
        this.checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomAdderPanel.this.checkbox.isSelected()) {
                    CustomAdderPanel.this.addToParent();
                } else {
                    CustomAdderPanel.this.removeFromParent();
                }
                CustomAdderPanel.this.revalidate();
                CustomAdderPanel.this.dispatch();
            }
        };
        this.checkbox.addActionListener(this.checkboxListener);
        if (this.parent instanceof Modifier) {
            this.fracTF = new FractionTF(this.adder.getBaseCost(), 10.0, -10.0);
            this.fracTF.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    CustomAdderPanel.this.adder.setBaseCost(CustomAdderPanel.this.fracTF.getCurrent());
                    CustomAdderPanel.this.dispatch();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    CustomAdderPanel.this.adder.setBaseCost(CustomAdderPanel.this.fracTF.getCurrent());
                    CustomAdderPanel.this.dispatch();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    CustomAdderPanel.this.adder.setBaseCost(CustomAdderPanel.this.fracTF.getCurrent());
                    CustomAdderPanel.this.dispatch();
                }
            });
        } else {
            this.pointsTF = new LevelTF((int)Rounder.roundHalfDown(this.adder.getBaseCost()), 999, -999);
            this.pointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CustomAdderPanel.this.adder.setBaseCost(CustomAdderPanel.this.pointsTF.getCurrent());
                    CustomAdderPanel.this.dispatch();
                }
            });
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 3);
        this.add((Component)this.checkbox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.aliasTF, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        if (this.parent instanceof Modifier) {
            this.add((Component)this.fracTF, gridBagConstraints);
        } else {
            this.add((Component)this.pointsTF, gridBagConstraints);
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomAdderPanel.this.main.updateValues();
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    private void addToParent() {
        this.adder = this.adder.clone();
        this.adder.setSelected(this.checkbox.isSelected());
        if (this.parent instanceof List && this.adder.isPrivate()) {
            if (!((List)this.parent).getPrivateAdders().contains(this.adder)) {
                ((List)this.parent).getPrivateAdders().add(this.adder);
            }
        } else if (!this.parent.getAssignedAdders().contains(this.adder)) {
            this.parent.getAssignedAdders().add(this.adder);
        }
    }

    public void dispatch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < CustomAdderPanel.this.listeners.size(); ++i) {
                    ActionListener actionListener = CustomAdderPanel.this.listeners.get(i);
                    actionListener.actionPerformed(null);
                }
            }
        });
    }

    public Adder getAdder() {
        return this.adder;
    }

    public boolean isSelected() {
        return this.checkbox.isSelected();
    }

    private void removeFromParent() {
        this.adder.setSelected(this.checkbox.isSelected());
        if (!this.adder.isSelected() && this.adder.getAssignedAdders().size() == 0) {
            if (this.parent instanceof List && this.adder.isPrivate()) {
                ((List)this.parent).getPrivateAdders().remove(this.adder);
            } else {
                this.parent.getAssignedAdders().remove(this.adder);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.checkbox.setEnabled(bl);
        if (this.parent instanceof Modifier) {
            this.fracTF.setEnabled(bl);
        } else {
            this.pointsTF.setEnabled(bl);
        }
        this.aliasTF.setEnabled(bl);
    }

    public void setSelected(boolean bl) {
        this.checkbox.setSelected(bl);
        this.adder.setSelected(bl);
        if (bl) {
            this.addToParent();
        } else {
            this.removeFromParent();
        }
    }

    public void setSelectionLocked(boolean bl) {
        this.selectionLocked = bl;
    }

    public void updateValues() {
        this.checkbox.removeActionListener(this.checkboxListener);
        this.checkbox.setSelected(this.parent.getAssignedAdders().contains(this.adder) && this.adder.isSelected());
        this.checkbox.addActionListener(this.checkboxListener);
        if (this.parent instanceof Modifier) {
            this.fracTF.setCurrent(this.adder.getBaseCost());
        } else {
            this.pointsTF.setCurrent((int)Rounder.roundHalfDown(this.adder.getBaseCost()));
        }
    }
}

