/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.widgets;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.ChangeEnvironment;
import com.hero.objects.powers.Clairsentience;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.Sense;
import com.hero.objects.powers.SenseAdder;
import com.hero.objects.powers.SenseAffectingPower;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.FractionTF;
import com.hero.ui.widgets.LevelTF;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AdderPanel
extends JPanel {
    private static final long serialVersionUID = -3290019588585813848L;
    Adder adder;
    AdderPanel parentPanel;
    AdderPanel childPanel;
    GenericObject parent;
    GenericDialog main;
    JCheckBox checkbox;
    JComboBox combo;
    JLabel inputLbl;
    JComboBox examples;
    LevelTF levelTF;
    FractionTF fractionTF;
    JTextField aliasTF;
    JLabel adderLbl;
    JButton helpBtn;
    JLabel pointsLbl;
    ArrayList<ActionListener> listeners;
    ActionListener checkboxListener;
    LevelTF valueTF;
    boolean isChild;
    boolean selectionLocked = false;

    public AdderPanel(GenericObject genericObject, Adder adder, AdderPanel adderPanel, GenericDialog genericDialog) {
        this(genericObject, adder, adderPanel, genericDialog, false);
    }

    AdderPanel(GenericObject genericObject, Adder adder, AdderPanel adderPanel, GenericDialog genericDialog, boolean bl) {
        Object object;
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.listeners = new ArrayList();
        this.setBackground(Color.white);
        this.adder = adder;
        this.parent = genericObject;
        this.parentPanel = adderPanel;
        this.isChild = bl;
        this.main = genericDialog;
        this.adder.setLevels(this.adder.getLevels());
        if (!this.adder.isSelectable()) {
            this.adderLbl = new JLabel(this.adder.getAlias());
            this.adderLbl.setOpaque(false);
        } else {
            this.aliasTF = new JTextField(this.adder.getAlias());
            this.aliasTF.setOpaque(false);
            this.aliasTF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.aliasTF.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    AdderPanel.this.adder.setAlias(AdderPanel.this.aliasTF.getText());
                    GenericObject.lastEdit = System.currentTimeMillis();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    AdderPanel.this.adder.setAlias(AdderPanel.this.aliasTF.getText());
                    GenericObject.lastEdit = System.currentTimeMillis();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    AdderPanel.this.adder.setAlias(AdderPanel.this.aliasTF.getText());
                    GenericObject.lastEdit = System.currentTimeMillis();
                }
            });
            this.checkbox = new JCheckBox();
            this.checkbox.setOpaque(false);
            this.checkbox.setSelected(this.adder.isSelected());
            this.aliasTF.setFont(this.checkbox.getFont());
            if (this.checkbox.isSelected() && !this.adder.isExclusive() && this.childPanel == null && !this.main.hasAvailable(this.adder.getXMLID())) {
                this.setChildVisibility(true);
            }
            this.checkboxListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    if (AdderPanel.this.checkbox.isSelected()) {
                        object = AdderPanel.this.adder.getExcludes().iterator();
                        while (object.hasNext()) {
                            String string = object.next();
                            String string2 = string.trim().toUpperCase();
                            Adder adder = AdderPanel.this.main.getAdderFromList(string2, AdderPanel.this.main.getObject().getAssignedAdders());
                            if (adder == null || !adder.isSelected()) continue;
                            for (AdderPanel adderPanel : AdderPanel.this.main.getAdderPanels()) {
                                if (!adderPanel.getAdder().getXMLID().trim().toUpperCase().equals(string2)) continue;
                                adderPanel.setSelected(false);
                            }
                        }
                        AdderPanel.this.addToParent();
                    } else {
                        AdderPanel.this.removeFromParent();
                    }
                    AdderPanel.this.setChildVisibility(AdderPanel.this.checkbox.isSelected());
                    AdderPanel.this.revalidate();
                    AdderPanel.this.dispatch(true);
                    if (AdderPanel.this.parent instanceof SenseAdder || AdderPanel.this.parent instanceof Sense) {
                        Power.lastSenseEdit = System.currentTimeMillis();
                    }
                    if (AdderPanel.this.parent instanceof SenseAdder || AdderPanel.this.parent instanceof Sense || AdderPanel.this.parent instanceof SenseAffectingPower || AdderPanel.this.parent instanceof Clairsentience || AdderPanel.this.parent instanceof ChangeEnvironment) {
                        AdderPanel.this.main.layoutExtrasPanel();
                        if (AdderPanel.this.main.optionsCB.getSelectedItem() instanceof Adder && !((Adder)(object = (Adder)AdderPanel.this.main.optionsCB.getSelectedItem())).equals(AdderPanel.this.parent.getSelectedOption())) {
                            AdderPanel.this.main.optionsCB.setSelectedItem(AdderPanel.this.parent.getSelectedOption());
                        }
                    }
                    GenericObject.lastEdit = System.currentTimeMillis();
                }
            };
            this.checkbox.addActionListener(this.checkboxListener);
        }
        if (this.adder.getDefinition() != null && this.adder.getDefinition().trim().length() > 0) {
            this.helpBtn = new JButton(" ? ");
            this.helpBtn.setOpaque(false);
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.helpBtn.setBorderPainted(false);
            this.helpBtn.setFocusPainted(false);
            this.helpBtn.setContentAreaFilled(false);
            this.helpBtn.setForeground(Color.blue);
            this.helpBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AdderPanel.this.adder == null) {
                        return;
                    }
                    if (AdderPanel.this.adder.getDefinition() == null) {
                        return;
                    }
                    if (AdderPanel.this.adder.getDefinition().trim().length() == 0) {
                        return;
                    }
                    PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), AdderPanel.this.helpBtn, AdderPanel.this.adder.getDefinition(), false);
                    popupMessage.setVisible(true);
                }
            });
        }
        if (this.adder.getOptions().size() > 0) {
            this.combo = new JComboBox<Object>(this.adder.getOptions().toArray());
            this.combo.setBackground(Color.white);
            this.combo.setSelectedItem(this.combo.getSelectedItem());
            this.combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!(AdderPanel.this.combo.getSelectedItem() instanceof Adder)) {
                        return;
                    }
                    Adder adder = (Adder)AdderPanel.this.combo.getSelectedItem();
                    AdderPanel.this.adder.setSelectedOption(adder);
                    AdderPanel.this.updateValues();
                    AdderPanel.this.dispatch(true);
                    adder.setAlias(adder.getDisplay());
                    ((JTextField)AdderPanel.this.combo.getEditor().getEditorComponent()).setText(adder.getDisplay());
                    GenericObject.lastEdit = System.currentTimeMillis();
                }
            });
            this.combo.setEditable(true);
            ((JTextField)this.combo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (AdderPanel.this.adder.getSelectedOption() != null) {
                        AdderPanel.this.adder.getSelectedOption().setAlias(((JTextField)AdderPanel.this.combo.getEditor().getEditorComponent()).getText());
                        GenericObject.lastEdit = System.currentTimeMillis();
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (AdderPanel.this.adder.getSelectedOption() != null) {
                        AdderPanel.this.adder.getSelectedOption().setAlias(((JTextField)AdderPanel.this.combo.getEditor().getEditorComponent()).getText());
                        GenericObject.lastEdit = System.currentTimeMillis();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (AdderPanel.this.adder.getSelectedOption() != null) {
                        AdderPanel.this.adder.getSelectedOption().setAlias(((JTextField)AdderPanel.this.combo.getEditor().getEditorComponent()).getText());
                        GenericObject.lastEdit = System.currentTimeMillis();
                    }
                }
            });
        }
        if (this.adder.isUserInput()) {
            this.inputLbl = new JLabel(this.adder.getInputLabel());
            this.examples = this.adder.getExamples() != null ? new JComboBox<Object>(this.adder.getExamples().toArray()) : new JComboBox();
            this.examples.setBackground(Color.white);
            this.examples.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (AdderPanel.this.examples.getSelectedItem() != null) {
                        String string = AdderPanel.this.examples.getSelectedItem().toString();
                        AdderPanel.this.adder.setInput(string);
                        GenericObject.lastEdit = System.currentTimeMillis();
                        AdderPanel.this.dispatch(false);
                    }
                }
            });
            if (this.adder.otherInputAllowed()) {
                this.examples.setEditable(true);
                ((JTextField)this.examples.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        String string = ((JTextField)AdderPanel.this.examples.getEditor().getEditorComponent()).getText();
                        AdderPanel.this.adder.setInput(string);
                        GenericObject.lastEdit = System.currentTimeMillis();
                        AdderPanel.this.dispatch(false);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        String string = ((JTextField)AdderPanel.this.examples.getEditor().getEditorComponent()).getText();
                        AdderPanel.this.adder.setInput(string);
                        GenericObject.lastEdit = System.currentTimeMillis();
                        AdderPanel.this.dispatch(false);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        String string = ((JTextField)AdderPanel.this.examples.getEditor().getEditorComponent()).getText();
                        AdderPanel.this.adder.setInput(string);
                        GenericObject.lastEdit = System.currentTimeMillis();
                        AdderPanel.this.dispatch(false);
                    }
                });
                ((JTextField)this.examples.getEditor().getEditorComponent()).setText(this.adder.getInput());
            } else {
                this.examples.setSelectedItem(this.adder.getInput());
            }
        }
        if (this.adder.getLevelCost() != 0.0 && this.adder.getLevelValue() != 0.0) {
            this.levelTF = this.parent instanceof Entangle ? new LevelTF(this.adder.getLevels(), this.adder.getMaxLevel(), this.adder.getMinimumLevel()) : new LevelTF(this.adder.getLevels(), 999, this.adder.getMinimumLevel());
            this.levelTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AdderPanel.this.adder.setLevels(AdderPanel.this.levelTF.getCurrent());
                    GenericObject.lastEdit = System.currentTimeMillis();
                    AdderPanel.this.dispatch(false);
                }
            });
        }
        if (this.parent instanceof Modifier && this.adder.getMinimumCost() != this.adder.getMaxCost()) {
            this.fractionTF = new FractionTF(this.adder.getBaseCost(), this.adder.getMaxCost(), this.adder.getMinimumCost());
            this.fractionTF.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AdderPanel.this.adder.setBaseCost(AdderPanel.this.fractionTF.getCurrent());
                    GenericObject.lastEdit = System.currentTimeMillis();
                    AdderPanel.this.dispatch(true);
                }
            });
        }
        if (this.adder.isFixedValue()) {
            this.pointsLbl = new JLabel("(" + Rounder.roundUp(this.adder.getTotalCost(true)) + (Rounder.roundUp(this.adder.getTotalCost(true)) != 1L ? " pts)" : " pt)"));
            this.pointsLbl.setPreferredSize(new JLabel("(9999 pts)").getPreferredSize());
            this.pointsLbl.setHorizontalTextPosition(4);
            this.pointsLbl.setHorizontalAlignment(4);
        } else {
            this.valueTF = new LevelTF((int)this.adder.getBaseCost(), (int)this.adder.getMaxCost(), (int)this.adder.getMinimumCost());
            this.valueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AdderPanel.this.adder.setBaseCost(AdderPanel.this.valueTF.getCurrent());
                    if (AdderPanel.this.adder.getSelectedOption() != null) {
                        AdderPanel.this.adder.getSelectedOption().setBaseCost(AdderPanel.this.valueTF.getCurrent());
                    }
                    GenericObject.lastEdit = System.currentTimeMillis();
                    AdderPanel.this.dispatch(false);
                }
            });
        }
        if (this.parent instanceof Modifier) {
            this.pointsLbl.setText("(" + ((Modifier)this.parent).getFraction(this.adder.getDoubleTotal(false)) + ")");
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 3);
        if (this.adder.isSelectable()) {
            this.add((Component)this.checkbox, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.aliasTF, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
        } else {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.adderLbl, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
        }
        ++gridBagConstraints.gridx;
        if (this.adder.getOptions().size() > 0) {
            this.add((Component)this.combo, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.adder.isUserInput()) {
            this.add((Component)this.inputLbl, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.examples, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.adder.getLevelCost() != 0.0 && this.adder.getLevelValue() > 0.0) {
            this.add((Component)this.levelTF, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        if (this.adder.getDefinition() != null && this.adder.getDefinition().trim().length() > 0) {
            this.add((Component)this.helpBtn, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        if (this.adder.isSelectable()) {
            if (this.parent instanceof Modifier && (this.adder.getLevelCost() == 0.0 || !(this.adder.getLevelValue() > 0.0)) && this.fractionTF != null) {
                this.add((Component)this.fractionTF, gridBagConstraints);
            } else if (this.adder.isFixedValue()) {
                this.add((Component)this.pointsLbl, gridBagConstraints);
            } else {
                this.add((Component)this.valueTF, gridBagConstraints);
            }
        }
        if (this.parent instanceof Adder) {
            object = (Adder)this.parent;
            if (((Adder)object).isSelected()) {
                this.setEnabled(false);
                this.checkbox.removeActionListener(this.checkboxListener);
                this.checkbox.setSelected(true);
            } else {
                this.setEnabled(true);
            }
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdderPanel.this.main.updateValues();
            }
        });
        if (this.adder.getOptions().size() > 0) {
            object = this.adder.getSelectedOption().getAlias();
            this.combo.setSelectedItem(this.adder.getSelectedOption());
            ((JTextField)this.combo.getEditor().getEditorComponent()).setText((String)object);
        }
        this.adder.setSelectedOption(this.adder.getSelectedOption());
        if (!this.adder.isSelectable() && this.adder.getTotalCost(true) != 0.0) {
            this.setEnabled(this.adder.isSelectable());
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    private void addChild() {
        if (!this.adder.isExclusive() && this.childPanel == null && !this.main.hasAvailable(this.adder.getXMLID())) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            Adder adder = this.adder.clone();
            adder.setAlias(adder.getDisplay());
            adder.setBaseCost(adder.getOrigBaseCost());
            if (adder.getSelectedOption() != null) {
                Adder adder2 = adder.getSelectedOption();
                adder2.setAlias(adder2.getDisplay());
                adder2.setBaseCost(adder2.getOrigBaseCost());
                adder.setSelectedOption(adder2);
            }
            adder.setInput("");
            adder.resetID();
            adder.setSelected(false);
            adder.setLevels(0);
            this.childPanel = new AdderPanel(this.parent, adder, this, this.main, true);
            this.add((Component)this.childPanel, gridBagConstraints);
        }
    }

    private void addToParent() {
        this.adder.setSelected(this.checkbox != null ? this.checkbox.isSelected() : false);
        if (this.parent.getAssignedAdders().contains(this.adder)) {
            this.parent.getAssignedAdders().remove(this.adder);
        }
        this.adder.resetID();
        if (this.parent.canAdd(this.adder)) {
            this.parent.getAssignedAdders().add(this.adder);
        }
        if (this.parent instanceof Adder) {
            this.parentPanel.addToParent();
        } else {
            GenericObject.lastEdit = System.currentTimeMillis();
        }
    }

    private void dispatch(boolean bl) {
        if (this.parent instanceof Modifier) {
            Modifier modifier = (Modifier)this.parent;
            if (bl) {
                modifier.setRefreshAddersOnUpdate(true);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AdderPanel.this.parent instanceof Modifier) {
                    if (AdderPanel.this.adder.isSelected() && AdderPanel.this.adder.isFixedValue()) {
                        AdderPanel.this.pointsLbl.setText("(" + ((Modifier)AdderPanel.this.parent).getFraction(AdderPanel.this.adder.getDoubleTotal()) + ")");
                    } else if (AdderPanel.this.adder.isFixedValue()) {
                        AdderPanel.this.pointsLbl.setText("(" + ((Modifier)AdderPanel.this.parent).getFraction(AdderPanel.this.adder.getDoubleTotal(false)) + ")");
                    }
                    Modifier modifier = (Modifier)AdderPanel.this.parent;
                    if (modifier.refreshAddersOnUpdate()) {
                        modifier.setSelectedOption(modifier.getSelectedOption());
                    }
                } else if (AdderPanel.this.adder.isFixedValue()) {
                    AdderPanel.this.pointsLbl.setText("(" + Rounder.roundUp(AdderPanel.this.adder.getTotalCost(true)) + (Rounder.roundUp(AdderPanel.this.adder.getTotalCost(true) - 0.5) != 1L ? " pts)" : " pt)"));
                }
                for (ActionListener actionListener : AdderPanel.this.listeners) {
                    actionListener.actionPerformed(null);
                }
            }
        });
    }

    public Adder getAdder() {
        return this.adder;
    }

    public boolean hasAvailable() {
        if (!this.isSelected() && this.isVisible()) {
            return true;
        }
        if (this.childPanel != null) {
            return this.childPanel.hasAvailable();
        }
        return false;
    }

    private boolean isChildSelected() {
        if (this.adder.isSelected()) {
            return true;
        }
        if (this.childPanel != null) {
            return this.childPanel.isChildSelected();
        }
        return false;
    }

    public boolean isSelected() {
        if (this.checkbox != null) {
            return this.checkbox.isSelected();
        }
        return false;
    }

    private boolean parentIsAvailable() {
        AdderPanel adderPanel = this.parentPanel;
        while (adderPanel != null) {
            if (!adderPanel.isSelected()) {
                return true;
            }
            adderPanel = adderPanel.parentPanel;
        }
        return false;
    }

    private void removeFromParent() {
        this.adder.setSelected(this.checkbox != null ? this.checkbox.isSelected() : false);
        if (!this.adder.isSelected()) {
            if (this.adder.getAssignedAdders().size() == 0) {
                this.parent.getAssignedAdders().remove(this.adder);
            }
            if (this.parent instanceof Adder) {
                this.parentPanel.removeFromParent();
            }
        }
    }

    private void setChildVisibility(boolean bl) {
        if (this.childPanel == null) {
            if (bl && this.isSelected() && this.parent.canAdd(this.adder)) {
                this.addChild();
            }
            return;
        }
        if (!bl) {
            if (!this.childPanel.isSelected()) {
                this.childPanel.setVisible(false);
            }
            this.childPanel.setChildVisibility(false);
        } else {
            this.childPanel.setVisible(this.parent.canAdd(this.adder) && !this.parentIsAvailable());
            if (this.childPanel.isSelected()) {
                this.childPanel.setChildVisibility(bl);
            } else {
                this.childPanel.setChildVisibility(false);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.checkbox != null) {
            this.checkbox.setEnabled(bl);
        }
        if (this.combo != null) {
            this.combo.setEnabled(bl);
        }
        if (this.inputLbl != null) {
            this.inputLbl.setEnabled(bl);
        }
        if (this.examples != null) {
            this.examples.setEnabled(bl);
        }
        if (this.levelTF != null) {
            this.levelTF.setEnabled(bl);
        }
        if (this.fractionTF != null) {
            this.fractionTF.setEnabled(bl);
        }
        if (this.aliasTF != null) {
            this.aliasTF.setEnabled(bl);
        }
        if (this.adderLbl != null) {
            this.adderLbl.setEnabled(bl);
        }
        if (this.adder.getDefinition() != null && this.adder.getDefinition().trim().length() > 0) {
            this.helpBtn.setEnabled(true);
        }
        if (this.adder.isFixedValue()) {
            this.pointsLbl.setEnabled(bl);
        }
        if (this.childPanel != null) {
            this.childPanel.setEnabled(bl);
        }
    }

    public void setSelected(boolean bl) {
        if (this.checkbox != null) {
            this.checkbox.setSelected(bl);
        }
        this.adder.setSelected(bl);
        if (bl) {
            this.addToParent();
        } else {
            this.removeFromParent();
        }
        if (this.parent instanceof SenseAdder || this.parent instanceof Sense) {
            Power.lastSenseEdit = System.currentTimeMillis();
        }
    }

    public void setSelectionLocked(boolean bl) {
        this.selectionLocked = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            super.setVisible(bl);
        }
        if (this.isChildSelected()) {
            return;
        }
        super.setVisible(bl);
    }

    public void updateValues() {
        if (this.aliasTF != null) {
            this.aliasTF.setText(this.adder.getAlias());
        }
        if (this.parent instanceof Adder && !this.selectionLocked) {
            Adder adder = (Adder)this.parent;
            if (adder.isSelected() && !this.isChild) {
                this.setEnabled(false);
                if (this.checkbox != null) {
                    this.checkbox.removeActionListener(this.checkboxListener);
                    this.checkbox.setSelected(true);
                    this.checkbox.addActionListener(this.checkboxListener);
                }
            } else {
                this.setEnabled(true);
                if (this.checkbox != null) {
                    this.checkbox.removeActionListener(this.checkboxListener);
                    this.checkbox.setSelected(this.parent.getAssignedAdders().contains(this.adder) && this.adder.isSelected());
                    this.checkbox.addActionListener(this.checkboxListener);
                }
            }
        } else if (this.checkbox != null) {
            this.checkbox.removeActionListener(this.checkboxListener);
            this.checkbox.setSelected(this.parent.getAssignedAdders().contains(this.adder) && this.adder.isSelected());
            this.checkbox.addActionListener(this.checkboxListener);
        }
        if (this.parent instanceof Modifier) {
            if (this.adder.isSelected() && this.adder.isFixedValue()) {
                this.pointsLbl.setText("(" + ((Modifier)this.parent).getFraction(this.adder.getDoubleTotal()) + ")");
            } else if (this.adder.isFixedValue()) {
                this.pointsLbl.setText("(" + ((Modifier)this.parent).getFraction(this.adder.getDoubleTotal(false)) + ")");
            }
        } else if (this.adder.isFixedValue()) {
            this.pointsLbl.setText("(" + Rounder.roundUp(this.adder.getTotalCost(true)) + (Rounder.roundUp(this.adder.getTotalCost(true)) != 1L ? " pts)" : " pt)"));
        } else if (this.valueTF != null && (double)this.valueTF.getCurrent() != this.adder.getBaseCost()) {
            this.valueTF.setCurrent((int)this.adder.getBaseCost());
            this.valueTF.setMax((int)this.adder.getMaxCost());
            this.valueTF.setMin((int)this.adder.getMinimumCost());
        }
        if (this.childPanel != null) {
            this.childPanel.updateValues();
        }
    }
}

