/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.perks.Vehicle;
import com.hero.ui.dialog.PerkDialog;
import com.hero.ui.widgets.LevelTF;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class VehicleDialog
extends PerkDialog {
    private static final long serialVersionUID = -4711582739828144785L;
    private JLabel basePointsLbl;
    private JLabel disadPointsLbl;
    private JLabel numberLbl;
    LevelTF basePointsTF;
    LevelTF disadPointsTF;
    LevelTF numberTF;
    JButton fileAssociationBtn;
    private JLabel fileAssociationLbl;

    public VehicleDialog(Vehicle vehicle, boolean bl, boolean bl2) {
        super(vehicle, bl, bl2);
    }

    @Override
    protected JPanel getModsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.fileAssociationBtn);
        jPanel.add(this.customAdderBtn);
        jPanel.add(this.privateAdderBtn);
        jPanel.add(this.addModifierBtn);
        return jPanel;
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel.add((Component)this.basePointsLbl, gridBagConstraints);
        gridBagConstraints.gridy = 40;
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            jPanel.add((Component)this.disadPointsLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 50;
        jPanel.add((Component)this.numberLbl, gridBagConstraints);
        gridBagConstraints.gridy = 29;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.fileAssociationLbl, gridBagConstraints);
        gridBagConstraints.gridy = 30;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.basePointsTF, gridBagConstraints);
        gridBagConstraints.gridy = 40;
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            jPanel.add((Component)this.disadPointsTF, gridBagConstraints);
        }
        gridBagConstraints.gridy = 50;
        jPanel.add((Component)this.numberTF, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.fileAssociationBtn.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                Vehicle vehicle = (Vehicle)VehicleDialog.this.perk;
                if (vehicle.getFilePath() != null && vehicle.getFilePath().trim().length() > 0) {
                    vehicle.clearFilePath();
                    VehicleDialog.this.fileAssociationBtn.setText("Associate File...");
                    VehicleDialog.this.updateValues();
                    return;
                }
                while (file == null) {
                    int n;
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDC");
                            }

                            @Override
                            public String getDescription() {
                                return "Hero Designer Character Files";
                            }
                        });
                        this.chooser.setApproveButtonText("Associate Character");
                        this.chooser.setDialogTitle("Open");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.getInstance().getPrefs().getSaveDir() != null && HeroDesigner.getInstance().getPrefs().getSaveDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getSaveDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if ((n = this.chooser.showOpenDialog(VehicleDialog.this)) == 1) {
                        return;
                    }
                    if (n != 0 || (file = this.chooser.getSelectedFile()).exists()) continue;
                    file = null;
                }
                if (file == null || file.isDirectory()) {
                    return;
                }
                ((Vehicle)VehicleDialog.this.perk).setFilePath(file.getAbsolutePath());
                VehicleDialog.this.basePointsTF.setCurrent(((Vehicle)VehicleDialog.this.perk).getBasePoints());
                VehicleDialog.this.disadPointsTF.setCurrent(((Vehicle)VehicleDialog.this.perk).getDisadPoints());
                VehicleDialog.this.fileAssociationBtn.setText("Remove File Association");
                VehicleDialog.this.updateValues();
            }
        });
        this.basePointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((Vehicle)VehicleDialog.this.perk).setBasePoints(VehicleDialog.this.basePointsTF.getCurrent());
                VehicleDialog.this.updateValues();
            }
        });
        this.disadPointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((Vehicle)VehicleDialog.this.perk).setDisadPoints(VehicleDialog.this.disadPointsTF.getCurrent());
                VehicleDialog.this.updateValues();
            }
        });
        this.numberTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((Vehicle)VehicleDialog.this.perk).setMultiples(VehicleDialog.this.numberTF.getCurrent());
                VehicleDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        if (this.pointsLbl != null) {
            this.pointsLbl.setVisible(false);
        }
        if (this.pointsTF != null) {
            this.pointsTF.setVisible(false);
        }
        if (this.inputLbl != null) {
            this.inputLbl.setVisible(false);
        }
        if (this.exampleCombo != null) {
            this.exampleCombo.setVisible(false);
        }
        if (this.levelsLbl != null) {
            this.levelsLbl.setVisible(false);
        }
        if (this.levelTF != null) {
            this.levelTF.setVisible(false);
        }
        this.basePointsLbl = new JLabel("Base Points:");
        this.disadPointsLbl = new JLabel("Disad Points:");
        this.numberLbl = new JLabel("Number of Multiples:");
        this.basePointsTF = new LevelTF(((Vehicle)this.perk).getBasePoints(), 9999, 0);
        this.disadPointsTF = new LevelTF(((Vehicle)this.perk).getDisadPoints(), 9999, 0);
        this.numberTF = new LevelTF(((Vehicle)this.perk).getMultiples(), 9999, 1);
        this.fileAssociationBtn = new JButton("Associate File...");
        Vehicle vehicle = (Vehicle)this.perk;
        if (vehicle.getFilePath() != null && vehicle.getFilePath().trim().length() > 0) {
            this.fileAssociationBtn.setText("Remove File Association");
        }
        this.fileAssociationLbl = new JLabel("");
    }

    @Override
    public void updateValues() {
        super.updateValues();
        Vehicle vehicle = (Vehicle)this.perk;
        if (vehicle.getFilePath() != null) {
            this.fileAssociationLbl.setVisible(true);
            File file = new File(vehicle.getFilePath());
            this.fileAssociationLbl.setText("(associated with " + file.getName() + ")");
        } else {
            this.fileAssociationLbl.setVisible(false);
        }
    }
}

