/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.GenericObject;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.SenseAdder;
import com.hero.ui.dialog.AvailableModifiersDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.LevelTF;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VPPDialog
extends GenericDialog {
    private static final long serialVersionUID = 375183157339119851L;
    private JButton privateModBtn;
    protected JLabel quantityLbl;
    protected LevelTF quantityTF;

    public VPPDialog(VariablePowerPool variablePowerPool, boolean bl, boolean bl2) {
        super(variablePowerPool, bl, bl2);
        if (bl) {
            this.setTitle("New Variable Power Pool");
        } else {
            this.setTitle(variablePowerPool.getAlias());
        }
        this.init();
        this.displayLbl.setText("VPP Name:");
        this.levelsLbl.setText("Pool Points:");
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        jPanel.remove(this.levelsLbl);
        jPanel.remove(this.levelTF);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.levelsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.levelTF, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 84;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.quantityLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.quantityTF, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.quantityTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (VPPDialog.this.object.getQuantity() == VPPDialog.this.quantityTF.getCurrent()) {
                    return;
                }
                VPPDialog.this.object.setQuantity(VPPDialog.this.quantityTF.getCurrent());
                GenericObject.lastEdit = System.currentTimeMillis();
                VPPDialog.this.updateValues();
                if (VPPDialog.this.object instanceof SenseAdder || VPPDialog.this.object instanceof Entangle) {
                    VPPDialog.this.layoutExtrasPanel();
                }
            }
        });
        this.privateModBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AvailableModifiersDialog availableModifiersDialog = new AvailableModifiersDialog(VPPDialog.this.object, VPPDialog.this, true);
                availableModifiersDialog.setVisible(true);
            }
        });
        this.displayTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                VPPDialog.this.okBtn.setEnabled(VPPDialog.this.displayTF.getText().trim().length() > 0);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                VPPDialog.this.okBtn.setEnabled(VPPDialog.this.displayTF.getText().trim().length() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                VPPDialog.this.okBtn.setEnabled(VPPDialog.this.displayTF.getText().trim().length() > 0);
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.quantityLbl = new JLabel("Quantity:");
        this.quantityTF = new LevelTF(this.object.getQuantity(), 9999, 1);
        this.addModifierBtn.setText("Add Common Modifier...");
        this.privateModBtn = new JButton("Add VPP-only Modifier...");
    }

    @Override
    protected void layoutComponent() {
        this.layoutExtrasPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.extrasPanel.add((Component)this.adderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.privateAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.customAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        this.extrasPanel.add((Component)this.modifierPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 11;
        this.extrasPanel.add((Component)this.privateModifierPanel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.getTopPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.activePointsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.displayActivePointsCB, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.realCostLbl, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.extrasScroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.customAdderBtn);
        jPanel2.add(this.privateAdderBtn);
        jPanel2.add(this.addModifierBtn);
        jPanel2.add(this.privateModBtn);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 15;
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.notesBtn);
        jPanel3.add(this.multiplierBtn);
        jPanel3.add(this.okBtn);
        jPanel3.add(this.deleteBtn);
        jPanel3.add(this.cancelBtn);
        jPanel3.add(this.defineBtn);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.setContentPane(jPanel);
    }
}

