/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.powers.Summon;
import com.hero.ui.dialog.PowerDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class SummonDialog
extends PowerDialog {
    private static final long serialVersionUID = -1224455897089997949L;
    JButton fileAssociationBtn;

    public SummonDialog(Summon summon, boolean bl) {
        super(summon, bl, true);
    }

    @Override
    protected JPanel getModsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.fileAssociationBtn);
        jPanel.add(this.customAdderBtn);
        jPanel.add(this.privateAdderBtn);
        jPanel.add(this.addModifierBtn);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.fileAssociationBtn.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                Summon summon = (Summon)SummonDialog.this.power;
                if (summon.getFilePath() != null && summon.getFilePath().trim().length() > 0) {
                    summon.clearFilePath();
                    SummonDialog.this.fileAssociationBtn.setText("Associate File...");
                    SummonDialog.this.updateValues();
                    return;
                }
                while (file == null) {
                    int n;
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDC");
                            }

                            @Override
                            public String getDescription() {
                                return "Hero Designer Character Files";
                            }
                        });
                        this.chooser.setApproveButtonText("Associate Character");
                        this.chooser.setDialogTitle("Open");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.getInstance().getPrefs().getSaveDir() != null && HeroDesigner.getInstance().getPrefs().getSaveDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getSaveDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if ((n = this.chooser.showOpenDialog(SummonDialog.this)) == 1) {
                        return;
                    }
                    if (n != 0 || (file = this.chooser.getSelectedFile()).exists()) continue;
                    file = null;
                }
                if (file == null || file.isDirectory()) {
                    return;
                }
                ((Summon)SummonDialog.this.power).setFilePath(file.getAbsolutePath());
                SummonDialog.this.levelTF.setCurrent(((Summon)SummonDialog.this.power).getLevels());
                SummonDialog.this.fileAssociationBtn.setText("Remove File Association");
                SummonDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.fileAssociationBtn = new JButton("Associate File...");
        Summon summon = (Summon)this.power;
        if (summon.getFilePath() != null && summon.getFilePath().trim().length() > 0) {
            this.fileAssociationBtn.setText("Remove File Association");
        }
    }

    @Override
    public void updateValues() {
        super.updateValues();
        Summon summon = (Summon)this.power;
        if (summon.getFilePath() != null) {
            File file = new File(summon.getFilePath());
            this.damageLbl.setText(this.power.getDamageDisplay() + " (associated with " + file.getName() + ")");
        } else {
            this.damageLbl.setText(this.power.getDamageDisplay());
        }
    }
}

