/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.skills.CharacteristicChoice;
import com.hero.objects.skills.Skill;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Constants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SkillDialog
extends GenericDialog {
    private static final long serialVersionUID = 8465445026655479055L;
    protected Skill skill;
    private JLabel characteristicLbl;
    private JLabel rollLbl;
    JComboBox characteristicCombo;
    JCheckBox familiarityCheck;
    JCheckBox proficiencyCheck;
    JCheckBox everymanCheck;
    JCheckBox levelsOnlyCheck;

    public SkillDialog(Skill skill, boolean bl, boolean bl2) {
        super(skill, bl, bl2);
        this.skill = skill;
        this.init();
        if (this.pointsLbl != null) {
            this.pointsLbl.setVisible(false);
        }
        if (this.pointsTF != null) {
            this.pointsTF.setVisible(false);
        }
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        if (this.skill.getCharacteristicChoices() != null && this.skill.getCharacteristicChoices().size() > 0) {
            jPanel.add((Component)this.characteristicLbl, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        if (this.skill.getCharacteristicChoices() != null && this.skill.getCharacteristicChoices().size() > 0) {
            if (this.skill.getCharacteristicChoices().size() == 1) {
                CharacteristicChoice characteristicChoice = this.skill.getCharacteristicChoices().get(0);
                if (characteristicChoice.getBaseCost() >= 0.0) {
                    this.skill.setBaseCost(characteristicChoice.getBaseCost());
                }
                this.skill.setCharacteristic(characteristicChoice.getCharacteristic());
                if (characteristicChoice.getLevelCost() >= 0.0) {
                    this.skill.setLevelCost(characteristicChoice.getLevelCost());
                }
                if (characteristicChoice.getLevelValue() >= 0.0) {
                    this.skill.setLevelValue(characteristicChoice.getLevelValue());
                }
                if (characteristicChoice.getMinimumCost() > -999.0) {
                    this.skill.setMinimumCost(characteristicChoice.getMinimumCost());
                }
                if (characteristicChoice.getMinimumLevel() >= 0) {
                    this.skill.setMinimumLevel(characteristicChoice.getMinimumLevel());
                }
                this.updateValues();
                jPanel.add((Component)new JLabel(Constants.getCharacteristicString(characteristicChoice.getCharacteristic())), gridBagConstraints);
            } else {
                jPanel.add((Component)this.characteristicCombo, gridBagConstraints);
            }
        }
        gridBagConstraints.gridy = 70;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        if (this.skill.getRoll().trim().length() > 0) {
            jPanel.add((Component)this.rollLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 80;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        if (this.skill.levelsOnlyAllowed()) {
            jPanel.add((Component)this.levelsOnlyCheck, gridBagConstraints);
            gridBagConstraints.gridy = 81;
        }
        if (this.skill.includeFamiliarity()) {
            jPanel.add((Component)this.familiarityCheck, gridBagConstraints);
            gridBagConstraints.gridy = 82;
            jPanel.add((Component)this.everymanCheck, gridBagConstraints);
        }
        if (this.skill.includeProficiency()) {
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.proficiencyCheck, gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.characteristicCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SkillDialog.this.updateValues();
            }
        });
        this.levelsOnlyCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SkillDialog.this.skill.setLevelsOnly(SkillDialog.this.levelsOnlyCheck.isSelected());
                SkillDialog.this.familiarityCheck.setEnabled(!SkillDialog.this.levelsOnlyCheck.isSelected());
                SkillDialog.this.proficiencyCheck.setEnabled(!SkillDialog.this.levelsOnlyCheck.isSelected());
                if (SkillDialog.this.levelsOnlyCheck.isSelected()) {
                    SkillDialog.this.everymanCheck.setVisible(false);
                    SkillDialog.this.levelTF.setEnabled(true);
                    SkillDialog.this.levelsLbl.setEnabled(true);
                }
                SkillDialog.this.updateValues();
            }
        });
        this.familiarityCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SkillDialog.this.levelTF.setEnabled(!SkillDialog.this.familiarityCheck.isSelected());
                SkillDialog.this.everymanCheck.setVisible(SkillDialog.this.familiarityCheck.isSelected());
                SkillDialog.this.skill.setFamiliarity(SkillDialog.this.familiarityCheck.isSelected());
                if (SkillDialog.this.familiarityCheck.isSelected()) {
                    SkillDialog.this.levelsOnlyCheck.setEnabled(false);
                    SkillDialog.this.skill.setProficiency(false);
                    SkillDialog.this.proficiencyCheck.setSelected(false);
                    SkillDialog.this.proficiencyCheck.setEnabled(false);
                } else {
                    SkillDialog.this.levelsOnlyCheck.setEnabled(true);
                    SkillDialog.this.proficiencyCheck.setEnabled(true);
                }
                SkillDialog.this.updateValues();
            }
        });
        this.proficiencyCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SkillDialog.this.levelTF.setEnabled(!SkillDialog.this.proficiencyCheck.isSelected());
                SkillDialog.this.skill.setProficiency(SkillDialog.this.proficiencyCheck.isSelected());
                if (SkillDialog.this.proficiencyCheck.isSelected()) {
                    SkillDialog.this.levelsOnlyCheck.setEnabled(false);
                    SkillDialog.this.everymanCheck.setVisible(false);
                    SkillDialog.this.familiarityCheck.setSelected(false);
                    SkillDialog.this.skill.setFamiliarity(false);
                    SkillDialog.this.familiarityCheck.setEnabled(false);
                } else {
                    SkillDialog.this.levelsOnlyCheck.setEnabled(true);
                    SkillDialog.this.familiarityCheck.setEnabled(true);
                }
                SkillDialog.this.updateValues();
            }
        });
        this.everymanCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SkillDialog.this.skill.setEveryman(SkillDialog.this.everymanCheck.isSelected());
                SkillDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.characteristicLbl = new JLabel("Characteristic:");
        this.rollLbl = new JLabel("Roll:");
        this.characteristicCombo = new JComboBox<Object>(this.skill.getCharacteristicChoices().toArray());
        this.levelsOnlyCheck = new JCheckBox("Skill Levels Only (do not purchase actual Skill)");
        if (this.skill.levelsOnly()) {
            this.levelsOnlyCheck.setSelected(true);
        } else {
            this.levelsOnlyCheck.setSelected(false);
        }
        this.familiarityCheck = new JCheckBox("Familiarity Only");
        this.everymanCheck = new JCheckBox("Everyman Skill");
        this.proficiencyCheck = new JCheckBox("Proficiency");
        if (this.skill.isFamiliarity()) {
            this.familiarityCheck.setSelected(true);
            this.skill.setLevels(0);
            this.levelTF.setCurrent(0);
            this.levelTF.setEnabled(false);
            this.levelsLbl.setEnabled(false);
            this.proficiencyCheck.setEnabled(false);
        } else {
            this.familiarityCheck.setSelected(false);
            this.levelTF.setEnabled(true);
            this.levelsLbl.setEnabled(true);
        }
        if (this.skill.isFamiliarity()) {
            this.everymanCheck.setVisible(true);
            this.everymanCheck.setSelected(this.skill.isEveryman());
        } else {
            this.everymanCheck.setVisible(false);
            this.everymanCheck.setSelected(false);
        }
        if (this.skill.isProficiency()) {
            this.proficiencyCheck.setSelected(true);
            this.skill.setLevels(0);
            this.levelTF.setCurrent(0);
            this.levelTF.setEnabled(false);
            this.levelsLbl.setEnabled(false);
            this.familiarityCheck.setEnabled(false);
        } else {
            this.proficiencyCheck.setSelected(false);
        }
        if (this.skill.getCharacteristicChoices() != null && this.skill.getCharacteristicChoices().size() > 0) {
            if (this.skill.getCharacteristicChoices().size() == 1) {
                CharacteristicChoice characteristicChoice = this.skill.getCharacteristicChoices().get(0);
                if (characteristicChoice.getBaseCost() >= 0.0) {
                    this.skill.setBaseCost(characteristicChoice.getBaseCost());
                }
                this.skill.setCharacteristic(characteristicChoice.getCharacteristic());
                if (characteristicChoice.getLevelCost() >= 0.0) {
                    this.skill.setLevelCost(characteristicChoice.getLevelCost());
                }
                if (characteristicChoice.getLevelValue() >= 0.0) {
                    this.skill.setLevelValue(characteristicChoice.getLevelValue());
                }
                if (characteristicChoice.getMinimumCost() > -999.0) {
                    this.skill.setMinimumCost(characteristicChoice.getMinimumCost());
                }
                if (characteristicChoice.getMinimumLevel() >= 0) {
                    this.skill.setMinimumLevel(characteristicChoice.getMinimumLevel());
                }
                this.updateValues();
            } else {
                for (int i = 0; i < this.skill.getCharacteristicChoices().size(); ++i) {
                    CharacteristicChoice characteristicChoice = this.skill.getCharacteristicChoices().get(i);
                    if (characteristicChoice.getCharacteristic() != this.skill.getCharacteristic()) continue;
                    this.characteristicCombo.setSelectedIndex(i);
                    break;
                }
                this.updateValues();
            }
        }
    }

    @Override
    public void updateValues() {
        CharacteristicChoice characteristicChoice = (CharacteristicChoice)this.characteristicCombo.getSelectedItem();
        if (characteristicChoice != null) {
            this.skill.setCharacteristic(characteristicChoice.getCharacteristic());
        }
        if (this.skill.levelsOnly()) {
            this.familiarityCheck.setEnabled(false);
            this.proficiencyCheck.setEnabled(false);
            this.everymanCheck.setVisible(false);
            this.levelTF.setEnabled(true);
            this.levelsLbl.setEnabled(true);
        } else if (this.skill.isFamiliarity()) {
            this.proficiencyCheck.setEnabled(false);
            this.familiarityCheck.setEnabled(true);
            this.everymanCheck.setVisible(true);
        } else if (this.skill.isProficiency()) {
            this.proficiencyCheck.setEnabled(true);
            this.familiarityCheck.setEnabled(false);
            this.everymanCheck.setVisible(false);
        } else {
            this.familiarityCheck.setEnabled(true);
            this.proficiencyCheck.setEnabled(true);
            this.levelTF.setEnabled(!this.skill.isFamiliarity() && !this.skill.isProficiency());
            this.levelsLbl.setEnabled(!this.skill.isFamiliarity() && !this.skill.isProficiency());
            this.everymanCheck.setVisible(this.skill.isFamiliarity());
        }
        this.rollLbl.setText(this.skill.getRoll());
        super.updateValues();
    }
}

