/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.GenericObject;
import com.hero.objects.powers.Sense;
import com.hero.objects.powers.SenseGroup;
import com.hero.ui.dialog.PowerDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SenseDialog
extends PowerDialog {
    private static final long serialVersionUID = -3434669773489751150L;
    protected JLabel groupLbl;
    protected JComboBox groupCombo;
    protected JLabel groupValueLbl;
    protected JLabel activeLbl;
    protected JComboBox activeCombo;
    protected JLabel activeValueLbl;

    public SenseDialog(Sense sense, boolean bl, boolean bl2) {
        super(sense, bl, bl2);
    }

    @Override
    protected JPanel getTopPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        JPanel jPanel = super.getTopPanel();
        gridBagConstraints.gridy = 22;
        jPanel.add((Component)this.activeLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        if (((Sense)this.object).isActiveSelectable()) {
            jPanel.add((Component)this.activeCombo, gridBagConstraints);
        } else {
            jPanel.add((Component)this.activeValueLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.groupLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        if (((Sense)this.object).getAvailableGroups().size() > 1) {
            jPanel.add((Component)this.groupCombo, gridBagConstraints);
        } else {
            jPanel.add((Component)this.groupValueLbl, gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.groupCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (SenseDialog.this.groupCombo.getSelectedItem() != null) {
                    SenseGroup senseGroup = (SenseGroup)SenseDialog.this.groupCombo.getSelectedItem();
                    ((Sense)SenseDialog.this.object).setGroup(senseGroup);
                    GenericObject.lastEdit = System.currentTimeMillis();
                    SenseDialog.this.updateValues();
                    SenseDialog.this.layoutExtrasPanel();
                }
            }
        });
        this.activeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (SenseDialog.this.activeCombo.getSelectedItem() != null) {
                    ((Sense)SenseDialog.this.object).setActive(SenseDialog.this.activeCombo.getSelectedItem().toString().equals("Active"));
                    GenericObject.lastEdit = System.currentTimeMillis();
                    SenseDialog.this.updateValues();
                    SenseDialog.this.layoutExtrasPanel();
                }
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.groupLbl = new JLabel("Sense Group:");
        this.groupCombo = new JComboBox<Object>(((Sense)this.object).getAvailableGroups().toArray());
        this.groupCombo.setSelectedItem(((Sense)this.object).getGroup());
        this.groupValueLbl = new JLabel(((Sense)this.object).getGroup().getDisplay());
        this.activeLbl = new JLabel("Type:");
        this.activeValueLbl = new JLabel(((Sense)this.object).isActive() ? "Active" : "Passive");
        String[] stringArray = new String[]{"Active", "Passive"};
        this.activeCombo = new JComboBox<String>(stringArray);
        this.activeCombo.setSelectedItem(((Sense)this.object).isActive() ? "Active" : "Passive");
    }
}

