/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.model.DoubleDocument;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.ui.widgets.LevelTF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class RulesDialog
extends JDialog {
    private static final long serialVersionUID = -4461617275751042646L;
    private JLabel basePointsLbl;
    private LevelTF basePointsTF;
    private JLabel disadPointsLbl;
    private LevelTF disadPointsTF;
    private JLabel attackAPMaxValueLbl;
    private LevelTF attackAPMaxValueTF;
    private JLabel attackAPMaxResponseLbl;
    private JComboBox attackAPMaxResponseCombo;
    private JLabel availDisadPointsResponseLbl;
    private JComboBox availDisadPointsResponseCombo;
    private JLabel availTotalPointsResponseLbl;
    private JComboBox availTotalPointsResponseCombo;
    private JLabel defenseAPMaxResponseLbl;
    private JComboBox defenseAPMaxResponseCombo;
    private JLabel defenseAPMaxValueLbl;
    private LevelTF defenseAPMaxValueTF;
    private JLabel disadCategoryMaxResponseLbl;
    private JComboBox disadCategoryMaxResponseCombo;
    private JLabel disadCategoryMaxValueLbl;
    private LevelTF disadCategoryMaxValueTF;
    private JLabel maneuverMaxResponseLbl;
    private JComboBox maneuverMaxResponseCombo;
    private JLabel maneuverMaxValueLbl;
    private LevelTF maneuverMaxValueTF;
    private JLabel perkMaxResponseLbl;
    private JComboBox perkMaxResponseCombo;
    private JLabel perkMaxValueLbl;
    private LevelTF perkMaxValueTF;
    private JLabel powerMaxResponseLbl;
    private JComboBox powerMaxResponseCombo;
    private JLabel powerMaxValueLbl;
    private LevelTF powerMaxValueTF;
    private JLabel skillMaxResponseLbl;
    private JComboBox skillMaxResponseCombo;
    private JLabel skillMaxValueLbl;
    private LevelTF skillMaxValueTF;
    private JLabel talentMaxResponseLbl;
    private JComboBox talentMaxResponseCombo;
    private JLabel talentMaxValueLbl;
    private LevelTF talentMaxValueTF;
    private JLabel apPerENDLbl;
    private LevelTF apPerENDTF;
    private JLabel strApPerENDLbl;
    private LevelTF strApPerENDTF;
    private JCheckBox equipmentAllowedCB;
    private JCheckBox ncmSelectedCB;
    private JCheckBox ncmUserChangeableCB;
    private JPanel equipmentPanel;
    private JLabel equipmentCostConversionLbl;
    private JTextField equipmentCostConversionTF;
    private LevelTF equipmentCostDecimalPlacesTF;
    private JLabel equipmentCostDecimalPlacesLbl;
    private JLabel equipmentCostUnitsLbl;
    private JTextField equipmentCostUnitsTF;
    private JCheckBox equipmentUnitsPrefixCB;
    private JLabel equipmentCostValueLbl;
    private LevelTF equipmentCostValueTF;
    private JLabel equipmentCostResponseLbl;
    private JComboBox equipmentCostResponseCombo;
    private JLabel equipmentCostExampleLbl;
    private JPanel skillsPanel;
    private JCheckBox useSkillMaximaCB;
    private JLabel skillMaximaLimitLbl;
    private LevelTF skillMaximaLimitTF;
    private JCheckBox useSkillMultiplierCB;
    private JPanel languageFamiliarityPanel;
    private JCheckBox useLanguageFamiliarityChartCB;
    private JCheckBox penalizeNoLevel1SimilarityCB;
    private JCheckBox literacyFreeCB;
    private JCheckBox nativeLiteracyFreeCB;
    private JCheckBox languagesAsINTSkillCB;
    private JPanel characteristicsPanel;
    private JCheckBox onlySellOneFiguredCB;
    private JCheckBox useIncreasedDamageDifferentiationCB;
    private JPanel frameworksPanel;
    private JLabel linkAcrossFrameworkLbl;
    private JComboBox linkAcrossFrameworkCombo;
    private JLabel specialTypeInFrameworkLbl;
    private JComboBox specialTypeInFrameworkCombo;
    private JLabel nonENDUsingAbilityInECLbl;
    private JComboBox nonENDUsingAbilityInECCombo;
    private JCheckBox automaticallyApplyNoFiguredCB;
    private JPanel standardEffectPanel;
    private JCheckBox standardEffectAllowedCB;
    private JCheckBox defaultStandardEffectCB;
    private JPanel powersPanel;
    private JCheckBox useExpandedGrowthChartCB;
    private JPanel generalPanel;
    private JCheckBox multiplierAllowedCB;
    private JPanel notesPanel;
    private JCheckBox useNotes1CB;
    private JTextField notes1LabelTF;
    private JCheckBox useNotes2CB;
    private JTextField notes2LabelTF;
    private JCheckBox useNotes3CB;
    private JTextField notes3LabelTF;
    private JCheckBox useNotes4CB;
    private JTextField notes4LabelTF;
    private JCheckBox useNotes5CB;
    private JTextField notes5LabelTF;
    private Rules rules;
    private JButton saveBtn;
    private JButton saveAsBtn;
    private JButton cancelBtn;
    private boolean cancelButtonClicked = false;
    private JLabel nameLbl;
    private JTextField nameTF;
    private JLabel skillRollCalculationBaseLbl;
    private LevelTF skillRollCalculationBaseTF;
    private JLabel skillRollCalculationDenominatorLbl;
    private LevelTF skillRollCalculationDenominatorTF;
    private JLabel charRollCalculationBaseLbl;
    private LevelTF charRollCalculationBaseTF;
    private JLabel charRollCalculationDenominatorLbl;
    private LevelTF charRollCalculationDenominatorTF;

    public RulesDialog() {
        super(HeroDesigner.getAppFrame(), "View/Edit Rules", true);
        HeroDesigner.getInstance();
        this.rules = HeroDesigner.getActiveHero().getRules();
        this.init();
        this.pack();
    }

    public boolean cancelButtonClicked() {
        return this.cancelButtonClicked;
    }

    private void init() {
        Cloneable cloneable;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Point Limits", new JScrollPane(jPanel2));
        if (HeroDesigner.getActiveTemplate().is6E()) {
            jTabbedPane.add("Characteristic Maxima", new JScrollPane(jPanel5));
        }
        jTabbedPane.add("Rules", new JScrollPane(jPanel4));
        jTabbedPane.add("Settings", new JScrollPane(jPanel3));
        this.saveBtn = new JButton("Save");
        this.saveAsBtn = new JButton("Save As...");
        this.cancelBtn = new JButton("Cancel");
        this.saveBtn.setEnabled(!this.rules.isDefault());
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.saveRulesDefinition(RulesDialog.this.rules.getCurrentSet());
                HeroDesigner.getActiveHero().setBasePoints(RulesDialog.this.rules.getBasePoints());
                HeroDesigner.getActiveHero().setDisadPoints(RulesDialog.this.rules.getDisadPoints());
                RulesDialog.this.setVisible(false);
                RulesDialog.this.cancelButtonClicked = false;
            }
        });
        this.saveAsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.getName().toUpperCase().endsWith(".HDR");
                    }

                    @Override
                    public String getDescription() {
                        return "Hero Designer Campaign Rules Files";
                    }
                });
                jFileChooser.setApproveButtonText("Save Rules");
                jFileChooser.setDialogTitle("Save Campaign Rules");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getRulesDir()));
                if (!RulesDialog.this.rules.getCurrentSet().equals("Default")) {
                    object = RulesDialog.this.rules.getCurrentSet();
                    String string2 = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                    string = string2 + ".hdr";
                    jFileChooser.setSelectedFile(new File(string));
                }
                object = null;
                while (object == null) {
                    String string3;
                    int n = jFileChooser.showSaveDialog(RulesDialog.this);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0) continue;
                    object = jFileChooser.getSelectedFile();
                    HeroDesigner.getInstance().getPrefs().setRulesDir(((File)object).getParent());
                    string = ((File)object).getName();
                    if (string.indexOf(".") < 0) {
                        string = string + ".hdr";
                    } else {
                        string3 = string.substring(string.lastIndexOf("."), string.length());
                        if (!string3.equalsIgnoreCase(".hdr")) {
                            string = string.substring(0, string.lastIndexOf("."));
                            string = string + ".hdr";
                        }
                    }
                    if (!string.equals(((File)object).getName())) {
                        string3 = "";
                        if (((File)object).getParentFile() != null) {
                            string3 = ((File)object).getParent();
                            if (!string3.endsWith(File.separator)) {
                                string3 = string3 + File.separator;
                            }
                        }
                        object = new File(string3 + string);
                    }
                    if (!((File)object).exists()) continue;
                    int n2 = JOptionPane.showConfirmDialog(RulesDialog.this, ((File)object).getName() + " already exists.\n\nOverwrite?");
                    if (n2 == 2) {
                        return;
                    }
                    if (n2 != 1) continue;
                    object = null;
                }
                HeroDesigner.getInstance().getPrefs().setRulesDir(((File)object).getParent());
                HeroDesigner.getInstance().getPrefs().setLastRule(((File)object).getAbsolutePath());
                RulesDialog.this.rules.saveRulesDefinition(((File)object).getAbsolutePath());
                HeroDesigner.getActiveHero().setBasePoints(RulesDialog.this.rules.getBasePoints());
                HeroDesigner.getActiveHero().setDisadPoints(RulesDialog.this.rules.getDisadPoints());
                RulesDialog.this.cancelButtonClicked = false;
                RulesDialog.this.setVisible(false);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RulesDialog.this.rules.getCurrentSet().equals("Default")) {
                    RulesDialog.this.rules.useDefault();
                } else {
                    RulesDialog.this.rules.loadRulesDefinition(RulesDialog.this.rules.getCurrentSet());
                }
                RulesDialog.this.cancelButtonClicked = true;
                RulesDialog.this.setVisible(false);
            }
        });
        JPanel jPanel6 = new JPanel(new FlowLayout(1));
        jPanel6.add(this.saveBtn);
        jPanel6.add(this.saveAsBtn);
        jPanel6.add(this.cancelBtn);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        this.nameLbl = new JLabel("<html><b>Ruleset Name:</b></html>");
        this.nameTF = new JTextField(this.rules.getName());
        this.nameTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setName(RulesDialog.this.nameTF.getText().trim());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setName(RulesDialog.this.nameTF.getText().trim());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setName(RulesDialog.this.nameTF.getText().trim());
            }
        });
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)this.nameLbl, "West");
        jPanel8.add((Component)this.nameTF, "Center");
        jPanel7.add((Component)jPanel8, "North");
        jPanel7.add((Component)jTabbedPane, "Center");
        jPanel7.add((Component)jPanel6, "South");
        this.setContentPane(jPanel7);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        if (HeroDesigner.getActiveTemplate().is6E()) {
            jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder("Maximum Value Before Cost Doubles"));
            gridBagConstraints.fill = 1;
            jPanel5.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            cloneable = HeroDesigner.getActiveTemplate().getCharacteristics();
            for (GenericObject genericObject : cloneable) {
                Characteristic characteristic = (Characteristic)genericObject;
                int n = this.rules.getCharacteristicMaxima(characteristic.getXMLID());
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 13;
                gridBagConstraints.weightx = 0.0;
                jPanel.add((Component)new JLabel(characteristic.getDisplay()), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
                LevelTF levelTF = new LevelTF(n, 999, 0);
                levelTF.setTrackObject(characteristic);
                levelTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (!propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) {
                            LevelTF levelTF = (LevelTF)propertyChangeEvent.getSource();
                            Characteristic characteristic = (Characteristic)levelTF.getTrackObject();
                            System.out.println("Setting for " + characteristic.getDisplay() + " val = " + propertyChangeEvent.getNewValue());
                            RulesDialog.this.rules.setCharacteristicMaxima(characteristic, (Integer)propertyChangeEvent.getNewValue());
                        }
                    }
                });
                jPanel.add((Component)levelTF, gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridx = 0;
            }
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        jPanel = new JPanel(new GridBagLayout());
        this.apPerENDLbl = new JLabel("Active Points per END:");
        this.apPerENDTF = new LevelTF(this.rules.getAPPerEND(), 999999, 0);
        this.apPerENDTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setAPPerEND(RulesDialog.this.apPerENDTF.getCurrent());
            }
        });
        jPanel.add((Component)this.apPerENDLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.apPerENDTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        this.strApPerENDLbl = new JLabel("Active Points per END (STR):");
        this.strApPerENDTF = new LevelTF(this.rules.getSTRAPPerEND(), 999999, 0);
        this.strApPerENDTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setSTRAPPerEND(RulesDialog.this.strApPerENDTF.getCurrent());
            }
        });
        jPanel.add((Component)this.strApPerENDLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.strApPerENDTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        jPanel3.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            this.ncmSelectedCB = new JCheckBox("NCM Selected");
            this.ncmSelectedCB.setSelected(this.rules.isNCMSelected());
            this.ncmSelectedCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesDialog.this.rules.setNCMSelected(RulesDialog.this.ncmSelectedCB.isSelected());
                }
            });
            jPanel3.add((Component)this.ncmSelectedCB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            this.ncmUserChangeableCB = new JCheckBox("User can change NCM selection");
            this.ncmUserChangeableCB.setSelected(this.rules.isNCMUserChangeable());
            this.ncmUserChangeableCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesDialog.this.rules.setNCMUserChangeable(RulesDialog.this.ncmUserChangeableCB.isSelected());
                }
            });
            jPanel3.add((Component)this.ncmUserChangeableCB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
        }
        this.equipmentPanel = new JPanel(new GridBagLayout());
        this.equipmentPanel.setBorder(BorderFactory.createTitledBorder("Equipment"));
        this.equipmentAllowedCB = new JCheckBox("Equipment Allowed");
        this.equipmentAllowedCB.setSelected(this.rules.isEquipmentAllowed());
        this.equipmentAllowedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setEquipmentAllowed(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostValueLbl.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostValueTF.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostResponseLbl.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostResponseCombo.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostUnitsLbl.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostUnitsTF.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentUnitsPrefixCB.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostConversionLbl.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostConversionTF.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostDecimalPlacesLbl.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostDecimalPlacesTF.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
                RulesDialog.this.equipmentCostExampleLbl.setEnabled(RulesDialog.this.equipmentAllowedCB.isSelected());
            }
        });
        this.equipmentPanel.add((Component)this.equipmentAllowedCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.equipmentCostUnitsLbl = new JLabel("Monetary Units:");
        this.equipmentPanel.add((Component)this.equipmentCostUnitsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.equipmentCostUnitsTF = new JTextField(this.rules.getEquipmentCostUnits(), 12);
        this.equipmentCostUnitsTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setEquipmentCostUnits(RulesDialog.this.equipmentCostUnitsTF.getText());
                RulesDialog.this.setEquipmentCostExample();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setEquipmentCostUnits(RulesDialog.this.equipmentCostUnitsTF.getText());
                RulesDialog.this.setEquipmentCostExample();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setEquipmentCostUnits(RulesDialog.this.equipmentCostUnitsTF.getText());
                RulesDialog.this.setEquipmentCostExample();
            }
        });
        this.equipmentPanel.add((Component)this.equipmentCostUnitsTF, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.equipmentUnitsPrefixCB = new JCheckBox("Prepend unit string to value");
        this.equipmentUnitsPrefixCB.setSelected(this.rules.isEquipmentUnitsPrefix());
        this.equipmentUnitsPrefixCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setEquipmentUnitsPrefix(RulesDialog.this.equipmentUnitsPrefixCB.isSelected());
                RulesDialog.this.setEquipmentCostExample();
            }
        });
        this.equipmentPanel.add((Component)this.equipmentUnitsPrefixCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        this.equipmentCostConversionLbl = new JLabel(this.rules.getEquipmentCostUnits() + " per 1 CU:");
        this.equipmentPanel.add((Component)this.equipmentCostConversionLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.equipmentCostConversionTF = new JTextField(new DoubleDocument(9.99999999999999E14, 0.0), "" + this.rules.getEquipmentCostConversion(), 12);
        this.equipmentCostConversionTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (RulesDialog.this.equipmentCostConversionTF.getText().trim().length() == 0) {
                    RulesDialog.this.rules.setEquipmentCostConversion(1.0);
                    RulesDialog.this.setEquipmentCostExample();
                    return;
                }
                RulesDialog.this.rules.setEquipmentCostConversion(Double.parseDouble(RulesDialog.this.equipmentCostConversionTF.getText()));
                RulesDialog.this.setEquipmentCostExample();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (RulesDialog.this.equipmentCostConversionTF.getText().trim().length() == 0) {
                    RulesDialog.this.rules.setEquipmentCostConversion(1.0);
                    RulesDialog.this.setEquipmentCostExample();
                    return;
                }
                RulesDialog.this.rules.setEquipmentCostConversion(Double.parseDouble(RulesDialog.this.equipmentCostConversionTF.getText()));
                RulesDialog.this.setEquipmentCostExample();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (RulesDialog.this.equipmentCostConversionTF.getText().trim().length() == 0) {
                    RulesDialog.this.rules.setEquipmentCostConversion(1.0);
                    RulesDialog.this.setEquipmentCostExample();
                    return;
                }
                RulesDialog.this.rules.setEquipmentCostConversion(Double.parseDouble(RulesDialog.this.equipmentCostConversionTF.getText()));
                RulesDialog.this.setEquipmentCostExample();
            }
        });
        this.equipmentPanel.add((Component)this.equipmentCostConversionTF, gridBagConstraints);
        this.equipmentCostDecimalPlacesLbl = new JLabel("decimal places:");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        this.equipmentPanel.add((Component)this.equipmentCostDecimalPlacesLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.equipmentCostDecimalPlacesTF = new LevelTF(this.rules.getEquipmentCostDecimalPlaces(), 6, 0);
        this.equipmentCostDecimalPlacesTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setEquipmentCostDecimalPlaces(RulesDialog.this.equipmentCostDecimalPlacesTF.getCurrent());
                RulesDialog.this.setEquipmentCostExample();
            }
        });
        this.equipmentPanel.add((Component)this.equipmentCostDecimalPlacesTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        this.equipmentCostExampleLbl = new JLabel();
        this.setEquipmentCostExample();
        gridBagConstraints.insets = new Insets(2, 30, 2, 5);
        this.equipmentPanel.add((Component)this.equipmentCostExampleLbl, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)this.equipmentPanel, gridBagConstraints);
        this.useNotes1CB = new JCheckBox();
        this.useNotes1CB.setSelected(this.rules.useNotes1());
        this.useNotes1CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseNotes1(RulesDialog.this.useNotes1CB.isSelected());
                RulesDialog.this.notes1LabelTF.setEnabled(RulesDialog.this.useNotes1CB.isSelected());
            }
        });
        this.notes1LabelTF = new JTextField(this.rules.getNotes1Label());
        this.notes1LabelTF.setEnabled(this.rules.useNotes1());
        this.notes1LabelTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes1Label(RulesDialog.this.notes1LabelTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes1Label(RulesDialog.this.notes1LabelTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes1Label(RulesDialog.this.notes1LabelTF.getText());
            }
        });
        this.useNotes2CB = new JCheckBox();
        this.useNotes2CB.setSelected(this.rules.useNotes2());
        this.useNotes2CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseNotes2(RulesDialog.this.useNotes2CB.isSelected());
                RulesDialog.this.notes2LabelTF.setEnabled(RulesDialog.this.useNotes2CB.isSelected());
            }
        });
        this.notes2LabelTF = new JTextField(this.rules.getNotes2Label());
        this.notes2LabelTF.setEnabled(this.rules.useNotes2());
        this.notes2LabelTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes2Label(RulesDialog.this.notes2LabelTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes2Label(RulesDialog.this.notes2LabelTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes2Label(RulesDialog.this.notes2LabelTF.getText());
            }
        });
        this.useNotes3CB = new JCheckBox();
        this.useNotes3CB.setSelected(this.rules.useNotes3());
        this.useNotes3CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseNotes3(RulesDialog.this.useNotes3CB.isSelected());
                RulesDialog.this.notes3LabelTF.setEnabled(RulesDialog.this.useNotes3CB.isSelected());
            }
        });
        this.notes3LabelTF = new JTextField(this.rules.getNotes3Label());
        this.notes3LabelTF.setEnabled(this.rules.useNotes3());
        this.notes3LabelTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes3Label(RulesDialog.this.notes3LabelTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes3Label(RulesDialog.this.notes3LabelTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes3Label(RulesDialog.this.notes3LabelTF.getText());
            }
        });
        this.useNotes4CB = new JCheckBox();
        this.useNotes4CB.setSelected(this.rules.useNotes4());
        this.useNotes4CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseNotes4(RulesDialog.this.useNotes4CB.isSelected());
                RulesDialog.this.notes4LabelTF.setEnabled(RulesDialog.this.useNotes4CB.isSelected());
            }
        });
        this.notes4LabelTF = new JTextField(this.rules.getNotes4Label());
        this.notes4LabelTF.setEnabled(this.rules.useNotes4());
        this.notes4LabelTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes4Label(RulesDialog.this.notes4LabelTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes4Label(RulesDialog.this.notes4LabelTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes4Label(RulesDialog.this.notes4LabelTF.getText());
            }
        });
        this.useNotes5CB = new JCheckBox();
        this.useNotes5CB.setSelected(this.rules.useNotes5());
        this.useNotes5CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseNotes5(RulesDialog.this.useNotes5CB.isSelected());
                RulesDialog.this.notes5LabelTF.setEnabled(RulesDialog.this.useNotes5CB.isSelected());
            }
        });
        this.notes5LabelTF = new JTextField(this.rules.getNotes5Label());
        this.notes5LabelTF.setEnabled(this.rules.useNotes5());
        this.notes5LabelTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes5Label(RulesDialog.this.notes5LabelTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes5Label(RulesDialog.this.notes5LabelTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RulesDialog.this.rules.setNotes5Label(RulesDialog.this.notes5LabelTF.getText());
            }
        });
        this.notesPanel = new JPanel(new GridBagLayout());
        this.notesPanel.setBorder(BorderFactory.createTitledBorder("Notes Tabs"));
        this.notesPanel.add((Component)new JLabel("Enabled"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)new JLabel("Tab Title"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.useNotes1CB, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.notes1LabelTF, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.useNotes2CB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.notes2LabelTF, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.useNotes3CB, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.notes3LabelTF, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.useNotes4CB, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.notes4LabelTF, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.useNotes5CB, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.notesPanel.add((Component)this.notes5LabelTF, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)this.notesPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.basePointsLbl = new JLabel("Base Points:");
        this.basePointsTF = new LevelTF(this.rules.getBasePoints(), 9999, 0);
        this.basePointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setBasePoints(RulesDialog.this.basePointsTF.getCurrent());
            }
        });
        jPanel2.add((Component)this.basePointsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)this.basePointsTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.disadPointsLbl = new JLabel("Disad Points:");
        if (HeroDesigner.getActiveTemplate().is6E()) {
            this.disadPointsLbl.setText("Complication Points:");
        }
        this.disadPointsTF = new LevelTF(this.rules.getDisadPoints(), 9999, 0);
        this.disadPointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setDisadPoints(RulesDialog.this.disadPointsTF.getCurrent());
            }
        });
        jPanel2.add((Component)this.disadPointsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)this.disadPointsTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.availTotalPointsResponseLbl = new JLabel("If Available Total Points Exceeded:");
        this.availTotalPointsResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.availTotalPointsResponseCombo.setSelectedIndex(this.rules.getAvailTotalPointsResponse());
        this.availTotalPointsResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setAvailTotalPointsResponse(RulesDialog.this.availTotalPointsResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.availTotalPointsResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)this.availTotalPointsResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.availDisadPointsResponseLbl = new JLabel("If Available Disad Points Exceeded:");
        if (HeroDesigner.getActiveTemplate().is6E()) {
            this.availDisadPointsResponseLbl.setText("If Available Complication Points Exceeded:");
        }
        this.availDisadPointsResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.availDisadPointsResponseCombo.setSelectedIndex(this.rules.getAvailDisadPointsResponse());
        this.availDisadPointsResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setAvailDisadPointsResponse(RulesDialog.this.availDisadPointsResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.availDisadPointsResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)this.availDisadPointsResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.disadCategoryMaxValueLbl = new JLabel("Max Points from one category of Disadvantages:");
        if (HeroDesigner.getActiveTemplate().is6E()) {
            this.disadCategoryMaxValueLbl.setText("Max Points from one category of Complications:");
        }
        this.disadCategoryMaxValueTF = new LevelTF(this.rules.getDisadCategoryMaxValue(), 9999, 0);
        this.disadCategoryMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setDisadCategoryMaxValue(RulesDialog.this.disadCategoryMaxValueTF.getCurrent());
            }
        });
        this.disadCategoryMaxResponseLbl = new JLabel("Action if exceeded:");
        this.disadCategoryMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.disadCategoryMaxResponseCombo.setSelectedIndex(this.rules.getDisadCategoryMaxResponse());
        this.disadCategoryMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setDisadCategoryMaxResponse(RulesDialog.this.disadCategoryMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.disadCategoryMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.disadCategoryMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.disadCategoryMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.disadCategoryMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.attackAPMaxValueLbl = new JLabel("Max Active Points per Attack:");
        this.attackAPMaxValueTF = new LevelTF(this.rules.getAttackAPMaxValue(), 9999, 0);
        this.attackAPMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setAttackAPMaxValue(RulesDialog.this.attackAPMaxValueTF.getCurrent());
            }
        });
        this.attackAPMaxResponseLbl = new JLabel("Action if exceeded:");
        this.attackAPMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.attackAPMaxResponseCombo.setSelectedIndex(this.rules.getAttackAPMaxResponse());
        this.attackAPMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setAttackAPMaxResponse(RulesDialog.this.attackAPMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.attackAPMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.attackAPMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.attackAPMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.attackAPMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.defenseAPMaxValueLbl = new JLabel("Max Active Points per Defense:");
        this.defenseAPMaxValueTF = new LevelTF(this.rules.getDefenseAPMaxValue(), 9999, 0);
        this.defenseAPMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setDefenseAPMaxValue(RulesDialog.this.defenseAPMaxValueTF.getCurrent());
            }
        });
        this.defenseAPMaxResponseLbl = new JLabel("Action if exceeded:");
        this.defenseAPMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.defenseAPMaxResponseCombo.setSelectedIndex(this.rules.getDefenseAPMaxResponse());
        this.defenseAPMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setDefenseAPMaxResponse(RulesDialog.this.defenseAPMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.defenseAPMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.defenseAPMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.defenseAPMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.defenseAPMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.skillMaxValueLbl = new JLabel("Max Points in Skills:");
        this.skillMaxValueTF = new LevelTF(this.rules.getSkillMaxValue(), 9999, 0);
        this.skillMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setSkillMaxValue(RulesDialog.this.skillMaxValueTF.getCurrent());
            }
        });
        this.skillMaxResponseLbl = new JLabel("Action if exceeded:");
        this.skillMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.skillMaxResponseCombo.setSelectedIndex(this.rules.getSkillMaxResponse());
        this.skillMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setSkillMaxResponse(RulesDialog.this.skillMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.skillMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.skillMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.skillMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.skillMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.perkMaxValueLbl = new JLabel("Max Points in Perks:");
        this.perkMaxValueTF = new LevelTF(this.rules.getPerkMaxValue(), 9999, 0);
        this.perkMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setPerkMaxValue(RulesDialog.this.perkMaxValueTF.getCurrent());
            }
        });
        this.perkMaxResponseLbl = new JLabel("Action if exceeded:");
        this.perkMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.perkMaxResponseCombo.setSelectedIndex(this.rules.getPerkMaxResponse());
        this.perkMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setPerkMaxResponse(RulesDialog.this.perkMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.perkMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.perkMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.perkMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.perkMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.talentMaxValueLbl = new JLabel("Max Points in Talents:");
        this.talentMaxValueTF = new LevelTF(this.rules.getTalentMaxValue(), 9999, 0);
        this.talentMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setTalentMaxValue(RulesDialog.this.talentMaxValueTF.getCurrent());
            }
        });
        this.talentMaxResponseLbl = new JLabel("Action if exceeded:");
        this.talentMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.talentMaxResponseCombo.setSelectedIndex(this.rules.getTalentMaxResponse());
        this.talentMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setTalentMaxResponse(RulesDialog.this.talentMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.talentMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.talentMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.talentMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.talentMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.maneuverMaxValueLbl = new JLabel("Max Points in Martial Arts:");
        this.maneuverMaxValueTF = new LevelTF(this.rules.getManeuverMaxValue(), 9999, 0);
        this.maneuverMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setManeuverMaxValue(RulesDialog.this.maneuverMaxValueTF.getCurrent());
            }
        });
        this.maneuverMaxResponseLbl = new JLabel("Action if exceeded:");
        this.maneuverMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.maneuverMaxResponseCombo.setSelectedIndex(this.rules.getManeuverMaxResponse());
        this.maneuverMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setManeuverMaxResponse(RulesDialog.this.maneuverMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.maneuverMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.maneuverMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.maneuverMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.maneuverMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.powerMaxValueLbl = new JLabel("Max Points in Powers:");
        this.powerMaxValueTF = new LevelTF(this.rules.getPowerMaxValue(), 9999, 0);
        this.powerMaxValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setPowerMaxValue(RulesDialog.this.powerMaxValueTF.getCurrent());
            }
        });
        this.powerMaxResponseLbl = new JLabel("Action if exceeded:");
        this.powerMaxResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.powerMaxResponseCombo.setSelectedIndex(this.rules.getPowerMaxResponse());
        this.powerMaxResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setPowerMaxResponse(RulesDialog.this.powerMaxResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.powerMaxValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.powerMaxValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.powerMaxResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.powerMaxResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.equipmentCostValueLbl = new JLabel("Max Total Value in Equipment:");
        this.equipmentCostValueTF = new LevelTF(this.rules.getEquipmentCostValue(), 9999, 0);
        this.equipmentCostValueTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setEquipmentCostValue(RulesDialog.this.equipmentCostValueTF.getCurrent());
            }
        });
        this.equipmentCostResponseLbl = new JLabel("Action if exceeded:");
        this.equipmentCostResponseCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.equipmentCostResponseCombo.setSelectedIndex(this.rules.getPowerMaxResponse());
        this.equipmentCostResponseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setEquipmentCostResponse(RulesDialog.this.equipmentCostResponseCombo.getSelectedIndex());
            }
        });
        jPanel2.add((Component)this.equipmentCostValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.equipmentCostValueTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.equipmentCostResponseLbl, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.equipmentCostResponseCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)new JPanel(), gridBagConstraints);
        this.equipmentAllowedCB.doClick();
        this.equipmentAllowedCB.doClick();
        this.equipmentAllowedCB.setSelected(this.rules.isEquipmentAllowed());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.generalPanel = new JPanel(new GridBagLayout());
        this.generalPanel.setBorder(BorderFactory.createTitledBorder("General"));
        this.multiplierAllowedCB = new JCheckBox("Allow Cost Multipliers");
        this.multiplierAllowedCB.setSelected(this.rules.multiplierAllowed());
        this.multiplierAllowedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setMultiplierAllowed(RulesDialog.this.multiplierAllowedCB.isSelected());
            }
        });
        this.generalPanel.add((Component)this.multiplierAllowedCB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel4.add((Component)this.generalPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.languageFamiliarityPanel = new JPanel();
        this.languageFamiliarityPanel.setLayout(new BoxLayout(this.languageFamiliarityPanel, 1));
        this.languageFamiliarityPanel.setBorder(BorderFactory.createTitledBorder("Languages"));
        this.useLanguageFamiliarityChartCB = new JCheckBox("Use Language Familiarity Chart");
        this.useLanguageFamiliarityChartCB.setSelected(this.rules.isLanguageSimilaritiesUsed());
        this.useLanguageFamiliarityChartCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setLanguageSimilaritiesUsed(RulesDialog.this.useLanguageFamiliarityChartCB.isSelected());
                if (RulesDialog.this.useLanguageFamiliarityChartCB.isSelected()) {
                    RulesDialog.this.penalizeNoLevel1SimilarityCB.setEnabled(true);
                } else {
                    RulesDialog.this.penalizeNoLevel1SimilarityCB.setEnabled(false);
                }
            }
        });
        this.penalizeNoLevel1SimilarityCB = new JCheckBox("Penalize for no 1 Point Similarity");
        this.penalizeNoLevel1SimilarityCB.setSelected(this.rules.penalizeNoLevel1());
        this.penalizeNoLevel1SimilarityCB.setEnabled(this.rules.isLanguageSimilaritiesUsed());
        this.penalizeNoLevel1SimilarityCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setPenalizeNoLevel1(RulesDialog.this.penalizeNoLevel1SimilarityCB.isSelected());
            }
        });
        this.literacyFreeCB = new JCheckBox("Literacy free for all Languages");
        this.literacyFreeCB.setSelected(this.rules.isLiteracyFree());
        this.literacyFreeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setLiteracyFree(RulesDialog.this.literacyFreeCB.isSelected());
                RulesDialog.this.nativeLiteracyFreeCB.setEnabled(!RulesDialog.this.literacyFreeCB.isSelected());
            }
        });
        this.nativeLiteracyFreeCB = new JCheckBox("Literacy free for Native Language");
        this.nativeLiteracyFreeCB.setSelected(this.rules.isNativeLiteracyFree());
        this.nativeLiteracyFreeCB.setEnabled(!this.rules.isLiteracyFree());
        this.nativeLiteracyFreeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setNativeLiteracyFree(RulesDialog.this.nativeLiteracyFreeCB.isSelected());
            }
        });
        this.languagesAsINTSkillCB = new JCheckBox("Languages as INT-based Skill");
        this.languagesAsINTSkillCB.setSelected(this.rules.useLanguagesAsINTSkill());
        this.languagesAsINTSkillCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setLanguagesAsINTSkill(RulesDialog.this.languagesAsINTSkillCB.isSelected());
            }
        });
        this.languageFamiliarityPanel.add(this.useLanguageFamiliarityChartCB);
        this.languageFamiliarityPanel.add(this.penalizeNoLevel1SimilarityCB);
        this.languageFamiliarityPanel.add(this.literacyFreeCB);
        this.languageFamiliarityPanel.add(this.nativeLiteracyFreeCB);
        this.languageFamiliarityPanel.add(this.languagesAsINTSkillCB);
        jPanel4.add((Component)this.languageFamiliarityPanel, gridBagConstraints);
        this.skillsPanel = new JPanel(new GridBagLayout());
        this.skillsPanel.setBorder(BorderFactory.createTitledBorder("Skills"));
        this.useSkillMaximaCB = new JCheckBox("Use Normal Skill Maxima");
        this.useSkillMaximaCB.setSelected(this.rules.getUseSkillMaxima());
        this.useSkillMaximaCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseSkillMaxima(RulesDialog.this.useSkillMaximaCB.isSelected());
            }
        });
        this.useSkillMultiplierCB = new JCheckBox("Use Skill Multipliers");
        this.useSkillMultiplierCB.setSelected(this.rules.useSkillMultipliers());
        this.useSkillMultiplierCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseSkillMultipliers(RulesDialog.this.useSkillMultiplierCB.isSelected());
            }
        });
        this.skillMaximaLimitLbl = new JLabel("Limit:");
        this.skillMaximaLimitTF = new LevelTF(this.rules.getSkillMaximaLimit(), 40, 8);
        this.skillMaximaLimitTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setSkillMaximaLimit(RulesDialog.this.skillMaximaLimitTF.getCurrent());
            }
        });
        this.skillRollCalculationBaseLbl = new JLabel("Skill Roll Base:");
        this.skillRollCalculationDenominatorLbl = new JLabel("Skill Roll Denominator:");
        this.skillRollCalculationBaseTF = new LevelTF(this.rules.getSkillRollBase(), 99, -99);
        this.skillRollCalculationBaseTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setSkillRollBase(RulesDialog.this.skillRollCalculationBaseTF.getCurrent());
            }
        });
        this.skillRollCalculationDenominatorTF = new LevelTF((int)this.rules.getSkillRollDenominator(), 99, -99);
        this.skillRollCalculationDenominatorTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setSkillRollDenominator(RulesDialog.this.skillRollCalculationDenominatorTF.getCurrent());
            }
        });
        this.charRollCalculationBaseLbl = new JLabel("Characteristic Roll Base:");
        this.charRollCalculationDenominatorLbl = new JLabel("Characteristic Roll Denominator:");
        this.charRollCalculationBaseTF = new LevelTF(this.rules.getCharRollBase(), 99, -99);
        this.charRollCalculationBaseTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setCharRollBase(RulesDialog.this.charRollCalculationBaseTF.getCurrent());
            }
        });
        this.charRollCalculationDenominatorTF = new LevelTF((int)this.rules.getCharRollDenominator(), 99, -99);
        this.charRollCalculationDenominatorTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RulesDialog.this.rules.setCharRollDenominator(RulesDialog.this.charRollCalculationDenominatorTF.getCurrent());
            }
        });
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).gridy = 0;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        ((GridBagConstraints)cloneable).weighty = 0.0;
        ((GridBagConstraints)cloneable).anchor = 17;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).insets = new Insets(3, 3, 3, 3);
        this.skillsPanel.add((Component)this.useSkillMaximaCB, cloneable);
        ((GridBagConstraints)cloneable).gridx = 1;
        this.skillsPanel.add((Component)this.skillMaximaLimitLbl, cloneable);
        ((GridBagConstraints)cloneable).gridx = 2;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        this.skillsPanel.add((Component)this.skillMaximaLimitTF, cloneable);
        ((GridBagConstraints)cloneable).gridx = 0;
        ++((GridBagConstraints)cloneable).gridy;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        this.skillsPanel.add((Component)this.useSkillMultiplierCB, cloneable);
        ++((GridBagConstraints)cloneable).gridy;
        this.skillsPanel.add((Component)this.skillRollCalculationBaseLbl, cloneable);
        ((GridBagConstraints)cloneable).gridx = 2;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        this.skillsPanel.add((Component)this.skillRollCalculationBaseTF, cloneable);
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        ++((GridBagConstraints)cloneable).gridy;
        this.skillsPanel.add((Component)this.skillRollCalculationDenominatorLbl, cloneable);
        ((GridBagConstraints)cloneable).gridx = 2;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        this.skillsPanel.add((Component)this.skillRollCalculationDenominatorTF, cloneable);
        ((GridBagConstraints)cloneable).gridx = 0;
        ++((GridBagConstraints)cloneable).gridy;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        this.generalPanel.add((Component)this.charRollCalculationBaseLbl, cloneable);
        ((GridBagConstraints)cloneable).gridx = 2;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        this.generalPanel.add((Component)this.charRollCalculationBaseTF, cloneable);
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        ++((GridBagConstraints)cloneable).gridy;
        this.generalPanel.add((Component)this.charRollCalculationDenominatorLbl, cloneable);
        ((GridBagConstraints)cloneable).gridx = 2;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        this.generalPanel.add((Component)this.charRollCalculationDenominatorTF, cloneable);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.fill = 1;
        jPanel4.add((Component)this.skillsPanel, gridBagConstraints);
        this.characteristicsPanel = new JPanel(new GridBagLayout());
        this.characteristicsPanel.setBorder(BorderFactory.createTitledBorder("Characteristics"));
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            this.onlySellOneFiguredCB = new JCheckBox("Only allow one Figured Characteristic to be sold off");
            if (this.rules.onlySellOneFigured()) {
                this.onlySellOneFiguredCB.setSelected(true);
            } else {
                this.onlySellOneFiguredCB.setSelected(false);
            }
            this.onlySellOneFiguredCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesDialog.this.rules.setOnlySellOneFigured(RulesDialog.this.onlySellOneFiguredCB.isSelected());
                }
            });
        }
        this.useIncreasedDamageDifferentiationCB = new JCheckBox("Use Increased Damage Differentiation on STR");
        if (this.rules.useIncreasedDamageDifferentiation()) {
            this.useIncreasedDamageDifferentiationCB.setSelected(true);
        } else {
            this.useIncreasedDamageDifferentiationCB.setSelected(false);
        }
        this.useIncreasedDamageDifferentiationCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setUseIncreasedDamageDifferentiation(RulesDialog.this.useIncreasedDamageDifferentiationCB.isSelected());
            }
        });
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            this.characteristicsPanel.add((Component)this.onlySellOneFiguredCB, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        this.characteristicsPanel.add((Component)this.useIncreasedDamageDifferentiationCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        jPanel4.add((Component)this.characteristicsPanel, gridBagConstraints);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridy = 0;
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).anchor = 13;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).gridwidth = 1;
        ((GridBagConstraints)cloneable).insets = new Insets(3, 3, 3, 3);
        this.frameworksPanel = new JPanel(new GridBagLayout());
        this.frameworksPanel.setBorder(BorderFactory.createTitledBorder("Power Frameworks"));
        this.linkAcrossFrameworkLbl = new JLabel("Link different slots of a Power Framework:");
        this.linkAcrossFrameworkCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.linkAcrossFrameworkCombo.setSelectedIndex(this.rules.getLinkAcrossFramework());
        this.linkAcrossFrameworkCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setLinkAcrossFramework(RulesDialog.this.linkAcrossFrameworkCombo.getSelectedIndex());
            }
        });
        this.frameworksPanel.add((Component)this.linkAcrossFrameworkLbl, cloneable);
        ((GridBagConstraints)cloneable).gridx = 1;
        ((GridBagConstraints)cloneable).anchor = 17;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        ((GridBagConstraints)cloneable).gridwidth = 1;
        this.frameworksPanel.add((Component)this.linkAcrossFrameworkCombo, cloneable);
        ++((GridBagConstraints)cloneable).gridy;
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).anchor = 13;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).gridwidth = 1;
        this.specialTypeInFrameworkLbl = new JLabel("\"Special\" type Powers in Frameworks:");
        this.specialTypeInFrameworkCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
        this.specialTypeInFrameworkCombo.setSelectedIndex(this.rules.getSpecialTypeInFramework());
        this.specialTypeInFrameworkCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RulesDialog.this.rules.setSpecialTypeInFramework(RulesDialog.this.specialTypeInFrameworkCombo.getSelectedIndex());
            }
        });
        this.frameworksPanel.add((Component)this.specialTypeInFrameworkLbl, cloneable);
        ((GridBagConstraints)cloneable).gridx = 1;
        ((GridBagConstraints)cloneable).anchor = 17;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        ((GridBagConstraints)cloneable).gridwidth = 1;
        this.frameworksPanel.add((Component)this.specialTypeInFrameworkCombo, cloneable);
        ++((GridBagConstraints)cloneable).gridy;
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).anchor = 13;
        ((GridBagConstraints)cloneable).weightx = 0.0;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).gridwidth = 1;
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            this.nonENDUsingAbilityInECLbl = new JLabel("Non-END Using abilities in an Elemental Control:");
            this.nonENDUsingAbilityInECCombo = new JComboBox<String>(new String[]{"Ignore", "Warn", "Do not allow"});
            this.nonENDUsingAbilityInECCombo.setSelectedIndex(this.rules.getNonENDUsingAbilityInEC());
            this.nonENDUsingAbilityInECCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    RulesDialog.this.rules.setNonENDUsingAbilityInEC(RulesDialog.this.nonENDUsingAbilityInECCombo.getSelectedIndex());
                }
            });
            this.frameworksPanel.add((Component)this.nonENDUsingAbilityInECLbl, cloneable);
            ((GridBagConstraints)cloneable).gridx = 1;
            ((GridBagConstraints)cloneable).anchor = 17;
            ((GridBagConstraints)cloneable).fill = 0;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            ((GridBagConstraints)cloneable).gridwidth = 1;
            this.frameworksPanel.add((Component)this.nonENDUsingAbilityInECCombo, cloneable);
            ++((GridBagConstraints)cloneable).gridy;
            ((GridBagConstraints)cloneable).gridx = 0;
            ((GridBagConstraints)cloneable).anchor = 17;
            ((GridBagConstraints)cloneable).weightx = 0.0;
            ((GridBagConstraints)cloneable).fill = 0;
            ((GridBagConstraints)cloneable).gridwidth = 2;
            this.automaticallyApplyNoFiguredCB = new JCheckBox("Automatically Apply \"No Figured Characteristics\" to Primary Characteristics placed in Framework");
            this.automaticallyApplyNoFiguredCB.setSelected(this.rules.automaticallyApplyNoFigured());
            this.automaticallyApplyNoFiguredCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RulesDialog.this.rules.setAutomaticallyApplyNoFigured(RulesDialog.this.automaticallyApplyNoFiguredCB.isSelected());
                }
            });
            this.frameworksPanel.add((Component)this.automaticallyApplyNoFiguredCB, cloneable);
        }
        ++gridBagConstraints.gridy;
        jPanel4.add((Component)this.frameworksPanel, gridBagConstraints);
        ((GridBagConstraints)cloneable).gridy = 0;
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).anchor = 17;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).gridwidth = 1;
        ((GridBagConstraints)cloneable).insets = new Insets(3, 3, 3, 3);
        this.standardEffectPanel = new JPanel(new GridBagLayout());
        this.standardEffectPanel.setBorder(BorderFactory.createTitledBorder("Standard Effect"));
        this.standardEffectAllowedCB = new JCheckBox("Standard Effect allowed");
        this.standardEffectAllowedCB.setSelected(this.rules.isStandardEffectAllowed());
        this.standardEffectAllowedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setStandardEffectAllowed(RulesDialog.this.standardEffectAllowedCB.isSelected());
                RulesDialog.this.defaultStandardEffectCB.setEnabled(RulesDialog.this.standardEffectAllowedCB.isSelected());
            }
        });
        this.standardEffectPanel.add((Component)this.standardEffectAllowedCB, cloneable);
        ++((GridBagConstraints)cloneable).gridy;
        this.defaultStandardEffectCB = new JCheckBox("Standard Effect selected by default");
        this.defaultStandardEffectCB.setEnabled(this.rules.isStandardEffectAllowed());
        this.defaultStandardEffectCB.setSelected(this.rules.defaultStandardEffect());
        this.defaultStandardEffectCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog.this.rules.setDefaultStandardEffect(RulesDialog.this.defaultStandardEffectCB.isSelected());
            }
        });
        this.standardEffectPanel.add((Component)this.defaultStandardEffectCB, cloneable);
        ++gridBagConstraints.gridy;
        jPanel4.add((Component)this.standardEffectPanel, gridBagConstraints);
        ((GridBagConstraints)cloneable).gridy = 0;
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).anchor = 17;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        ((GridBagConstraints)cloneable).fill = 0;
        ((GridBagConstraints)cloneable).gridwidth = 1;
        ((GridBagConstraints)cloneable).insets = new Insets(3, 3, 3, 3);
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            this.powersPanel = new JPanel(new GridBagLayout());
            this.powersPanel.setBorder(BorderFactory.createTitledBorder("Powers"));
            if (!HeroDesigner.getActiveTemplate().is6E()) {
                this.useExpandedGrowthChartCB = new JCheckBox("Use Expanded Growth Chart (from The Ultimate Brick)");
                this.useExpandedGrowthChartCB.setSelected(this.rules.useExpandedGrowthChart());
                this.useExpandedGrowthChartCB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RulesDialog.this.rules.setUseExpandedGrowthChart(RulesDialog.this.useExpandedGrowthChartCB.isSelected());
                    }
                });
                this.powersPanel.add((Component)this.useExpandedGrowthChartCB, cloneable);
            }
            ++((GridBagConstraints)cloneable).gridy;
            ++gridBagConstraints.gridy;
            jPanel4.add((Component)this.powersPanel, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel4.add((Component)new JPanel(), gridBagConstraints);
    }

    private void setEquipmentCostExample() {
        if (this.equipmentCostValueLbl != null) {
            this.equipmentCostValueLbl.setText("Max Total Value in Equipment (" + this.rules.getEquipmentCostUnits() + "):");
        }
        this.equipmentCostConversionLbl.setText(" # CU per " + (this.rules.isEquipmentUnitsPrefix() ? this.rules.getEquipmentCostUnits() : "") + "1" + (this.rules.isEquipmentUnitsPrefix() ? "" : this.rules.getEquipmentCostUnits()) + ":");
        String string = "";
        if (this.rules.isEquipmentUnitsPrefix()) {
            string = string + this.rules.getEquipmentCostUnits();
        }
        try {
            double d = 100.0 / this.rules.getEquipmentCostConversion();
            BigDecimal bigDecimal = new BigDecimal(d);
            bigDecimal = bigDecimal.setScale(this.rules.getEquipmentCostDecimalPlaces(), 4);
            string = string + bigDecimal.toString();
            if (!this.rules.isEquipmentUnitsPrefix()) {
                string = string + this.rules.getEquipmentCostUnits();
            }
            this.equipmentCostExampleLbl.setText("example:  100 CU = " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

