/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.GenericObject;
import com.hero.objects.perks.ResourcePool;
import com.hero.ui.dialog.PerkDialog;
import com.hero.ui.widgets.LevelTF;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ResourcePoolDialog
extends PerkDialog {
    private static final long serialVersionUID = -6126546559060075704L;
    private JLabel freePointsLbl;
    private LevelTF freePointsTF;

    public ResourcePoolDialog(ResourcePool resourcePool, boolean bl, boolean bl2) {
        super(resourcePool, bl, bl2);
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 68;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel.add((Component)this.freePointsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.freePointsTF, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.freePointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ResourcePool resourcePool = (ResourcePool)ResourcePoolDialog.this.perk;
                int n = resourcePool.getFreePoints();
                if (n == ResourcePoolDialog.this.freePointsTF.getCurrent()) {
                    return;
                }
                resourcePool.setFreePoints(ResourcePoolDialog.this.freePointsTF.getCurrent());
                GenericObject.lastEdit = System.currentTimeMillis();
                ResourcePoolDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.freePointsLbl = new JLabel("Starting Points:");
        this.freePointsTF = new LevelTF(((ResourcePool)this.perk).getFreePoints(), 9999, 0);
    }

    @Override
    public void updateValues() {
        super.updateValues();
        ResourcePool resourcePool = (ResourcePool)this.perk;
        this.freePointsTF.setCurrent(resourcePool.getFreePoints());
        if (resourcePool.getLevelCost() < 1.0 || resourcePool.getLevelValue() < 1.0) {
            this.levelsLbl.setVisible(false);
            this.levelTF.setVisible(false);
            resourcePool.setLevels(0);
        } else {
            this.levelsLbl.setVisible(true);
            this.levelTF.setVisible(true);
        }
    }
}

