/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.SenseAdder;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.LevelTF;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PowerDialog
extends GenericDialog {
    private static final long serialVersionUID = 5901102773385534530L;
    protected Power power;
    protected JLabel damageLbl;
    protected JCheckBox useStandardEffectCB;
    protected JComboBox affectsCombo;
    protected JLabel affectsLbl;
    protected JLabel quantityLbl;
    protected LevelTF quantityTF;

    public PowerDialog(Power power, boolean bl, boolean bl2) {
        super(power, bl, bl2);
        if (bl && power.standardEffectAllowed()) {
            power.setUseStandardEffect(HeroDesigner.getActiveHero().getRules().defaultStandardEffect());
        }
        this.power = power;
        this.init();
    }

    public PowerDialog(Power power, boolean bl, boolean bl2, boolean bl3) {
        super(power, bl, bl2);
        if (bl && power.standardEffectAllowed()) {
            power.setUseStandardEffect(HeroDesigner.getActiveHero().getRules().defaultStandardEffect());
        }
        this.power = power;
        if (bl3) {
            this.init();
        }
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 70;
        if (this.power.getLevelCost() > 0.0 && this.power.getLevelValue() > 0.0) {
            jPanel.add((Component)this.damageLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 71;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        if (HeroDesigner.getActiveHero().getRules().isStandardEffectAllowed() && this.power.standardEffectAllowed()) {
            jPanel.add((Component)this.useStandardEffectCB, gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 84;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.quantityLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.quantityTF, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 75;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.affectsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.affectsCombo, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.useStandardEffectCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerDialog.this.power.setUseStandardEffect(PowerDialog.this.useStandardEffectCB.isSelected());
                PowerDialog.this.updateValues();
            }
        });
        this.quantityTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PowerDialog.this.power.getQuantity() == PowerDialog.this.quantityTF.getCurrent()) {
                    return;
                }
                PowerDialog.this.power.setQuantity(PowerDialog.this.quantityTF.getCurrent());
                GenericObject.lastEdit = System.currentTimeMillis();
                PowerDialog.this.updateValues();
                if (PowerDialog.this.object instanceof SenseAdder || PowerDialog.this.object instanceof Entangle) {
                    PowerDialog.this.layoutExtrasPanel();
                }
            }
        });
        this.affectsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (PowerDialog.this.power.canAffectPrimary()) {
                    if (PowerDialog.this.affectsCombo.getSelectedIndex() == 1) {
                        PowerDialog.this.power.setAffectPrimary(false);
                        PowerDialog.this.power.setAffectTotal(true);
                    } else if (PowerDialog.this.affectsCombo.getSelectedIndex() == 2) {
                        PowerDialog.this.power.setAffectPrimary(false);
                        PowerDialog.this.power.setAffectTotal(false);
                    } else {
                        PowerDialog.this.power.setAffectPrimary(true);
                        PowerDialog.this.power.setAffectTotal(true);
                    }
                } else if (PowerDialog.this.affectsCombo.getSelectedIndex() == 0) {
                    PowerDialog.this.power.setAffectPrimary(false);
                    PowerDialog.this.power.setAffectTotal(true);
                } else {
                    PowerDialog.this.power.setAffectPrimary(false);
                    PowerDialog.this.power.setAffectTotal(false);
                }
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.quantityLbl = new JLabel("Quantity:");
        this.quantityTF = new LevelTF(this.power.getQuantity(), 9999, 1);
        this.damageLbl = new JLabel(this.power.getDamageDisplay());
        this.affectsLbl = new JLabel("Totaling Options:");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.power.canAffectPrimary()) {
            arrayList.add("Add to Primary Value");
        }
        arrayList.add("Add to Secondary Value");
        arrayList.add("Do not add to Totals");
        this.affectsCombo = new JComboBox<Object>(arrayList.toArray());
        if (this.power.canAffectPrimary() && this.power.getAffectPrimary()) {
            this.affectsCombo.setSelectedIndex(0);
        } else if (!this.power.canAffectPrimary() && this.power.getAffectTotal()) {
            this.affectsCombo.setSelectedIndex(0);
        } else if (this.power.getAffectTotal()) {
            this.affectsCombo.setSelectedIndex(1);
        } else if (!this.power.canAffectPrimary()) {
            this.affectsCombo.setSelectedIndex(1);
        } else {
            this.affectsCombo.setSelectedIndex(2);
        }
        if (!this.power.isSummable()) {
            this.affectsLbl.setVisible(false);
            this.affectsCombo.setVisible(false);
        }
        this.useStandardEffectCB = new JCheckBox("Use Standard Effect");
        this.useStandardEffectCB.setSelected(this.power.useStandardEffect());
    }

    @Override
    public void updateValues() {
        super.updateValues();
        this.damageLbl.setText(this.power.getDamageDisplay());
        if (this.power.isSummable()) {
            this.affectsLbl.setVisible(true);
            this.affectsCombo.setVisible(true);
        } else {
            this.affectsLbl.setVisible(false);
            this.affectsCombo.setVisible(false);
        }
    }
}

