/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.GenericObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NotesDialog
extends JDialog {
    private static final long serialVersionUID = -1682716594008160708L;
    JTextArea notesTA;
    private JScrollPane notesScroll;
    JCheckBox includeInPrintoutCheck;
    JButton closeBtn;
    GenericObject object;

    public NotesDialog(GenericObject genericObject, JDialog jDialog) {
        super(jDialog, "Notes for " + genericObject.getDisplay(), true);
        this.object = genericObject;
        this.setDefaultCloseOperation(2);
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.pack();
    }

    private void initListeners() {
        this.notesTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                NotesDialog.this.object.setNotes(NotesDialog.this.notesTA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                NotesDialog.this.object.setNotes(NotesDialog.this.notesTA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                NotesDialog.this.object.setNotes(NotesDialog.this.notesTA.getText());
            }
        });
        this.includeInPrintoutCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotesDialog.this.object.setIncludeNotesInPrintout(NotesDialog.this.includeInPrintoutCheck.isSelected());
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotesDialog.this.setVisible(false);
            }
        });
    }

    private void initWidgets() {
        this.notesTA = new JTextArea(this.object.getNotes(), 6, 20);
        this.notesTA.setWrapStyleWord(true);
        this.notesTA.setLineWrap(true);
        this.notesScroll = new JScrollPane(this.notesTA);
        this.notesScroll.setPreferredSize(this.notesTA.getPreferredSize());
        this.includeInPrintoutCheck = new JCheckBox("Include in print out");
        this.includeInPrintoutCheck.setSelected(this.object.isIncludeNotesInPrintout());
        this.closeBtn = new JButton("Close");
    }

    private void layoutComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.notesScroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.includeInPrintoutCheck, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.closeBtn, gridBagConstraints);
        this.setContentPane(jPanel);
    }
}

