/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.SenseAdder;
import com.hero.ui.dialog.AvailableModifiersDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.LevelTF;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MultipowerDialog
extends GenericDialog {
    private static final long serialVersionUID = 3384148243011997616L;
    private JButton privateModBtn;
    protected JLabel quantityLbl;
    protected LevelTF quantityTF;

    public MultipowerDialog(Multipower multipower, boolean bl) {
        super(multipower, bl, true);
        if (bl) {
            this.setTitle("New Multipower");
        } else {
            this.setTitle(multipower.getAlias());
        }
        this.init();
        this.displayLbl.setText("Multipower Name:");
        this.pointsLbl.setText("Base Points:");
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 84;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.quantityLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.quantityTF, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.quantityTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (MultipowerDialog.this.object.getQuantity() == MultipowerDialog.this.quantityTF.getCurrent()) {
                    return;
                }
                MultipowerDialog.this.object.setQuantity(MultipowerDialog.this.quantityTF.getCurrent());
                GenericObject.lastEdit = System.currentTimeMillis();
                MultipowerDialog.this.updateValues();
                if (MultipowerDialog.this.object instanceof SenseAdder || MultipowerDialog.this.object instanceof Entangle) {
                    MultipowerDialog.this.layoutExtrasPanel();
                }
            }
        });
        this.privateModBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AvailableModifiersDialog availableModifiersDialog = new AvailableModifiersDialog(MultipowerDialog.this.object, MultipowerDialog.this, true);
                availableModifiersDialog.setVisible(true);
            }
        });
        this.displayTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                MultipowerDialog.this.okBtn.setEnabled(MultipowerDialog.this.displayTF.getText().trim().length() > 0);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                MultipowerDialog.this.okBtn.setEnabled(MultipowerDialog.this.displayTF.getText().trim().length() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                MultipowerDialog.this.okBtn.setEnabled(MultipowerDialog.this.displayTF.getText().trim().length() > 0);
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.quantityLbl = new JLabel("Quantity:");
        this.quantityTF = new LevelTF(this.object.getQuantity(), 9999, 1);
        this.addModifierBtn.setText("Add Common Modifier...");
        this.privateModBtn = new JButton("Add MP-only Modifier...");
    }

    @Override
    protected void layoutComponent() {
        this.layoutExtrasPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.extrasPanel.add((Component)this.adderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.privateAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.customAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        this.extrasPanel.add((Component)this.modifierPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        this.extrasPanel.add((Component)this.privateModifierPanel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.getTopPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.activePointsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.displayActivePointsCB, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.realCostLbl, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.extrasScroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.customAdderBtn);
        jPanel2.add(this.privateAdderBtn);
        jPanel2.add(this.addModifierBtn);
        jPanel2.add(this.privateModBtn);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 15;
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.notesBtn);
        jPanel3.add(this.multiplierBtn);
        jPanel3.add(this.okBtn);
        jPanel3.add(this.deleteBtn);
        jPanel3.add(this.cancelBtn);
        jPanel3.add(this.defineBtn);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.setContentPane(jPanel);
    }
}

