/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.powers.Multiform;
import com.hero.ui.dialog.PowerDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class MultiformDialog
extends PowerDialog {
    private static final long serialVersionUID = -2872942666134863846L;
    JButton fileAssociationBtn;

    public MultiformDialog(Multiform multiform, boolean bl) {
        super(multiform, bl, true);
    }

    @Override
    protected JPanel getModsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.fileAssociationBtn);
        jPanel.add(this.customAdderBtn);
        jPanel.add(this.privateAdderBtn);
        jPanel.add(this.addModifierBtn);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.fileAssociationBtn.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                Multiform multiform = (Multiform)MultiformDialog.this.power;
                if (multiform.getFilePath() != null && multiform.getFilePath().trim().length() > 0) {
                    multiform.clearFilePath();
                    MultiformDialog.this.fileAssociationBtn.setText("Associate File...");
                    MultiformDialog.this.updateValues();
                    return;
                }
                while (file == null) {
                    int n;
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDC");
                            }

                            @Override
                            public String getDescription() {
                                return "Hero Designer Character Files";
                            }
                        });
                        this.chooser.setApproveButtonText("Associate Character");
                        this.chooser.setDialogTitle("Open");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.getInstance().getPrefs().getSaveDir() != null && HeroDesigner.getInstance().getPrefs().getSaveDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getSaveDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if ((n = this.chooser.showOpenDialog(MultiformDialog.this)) == 1) {
                        return;
                    }
                    if (n != 0 || (file = this.chooser.getSelectedFile()).exists()) continue;
                    file = null;
                }
                if (file == null || file.isDirectory()) {
                    return;
                }
                ((Multiform)MultiformDialog.this.power).setFilePath(file.getAbsolutePath());
                MultiformDialog.this.levelTF.setCurrent(((Multiform)MultiformDialog.this.power).getLevels());
                MultiformDialog.this.fileAssociationBtn.setText("Remove File Association");
                MultiformDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.fileAssociationBtn = new JButton("Associate File...");
        Multiform multiform = (Multiform)this.power;
        if (multiform.getFilePath() != null && multiform.getFilePath().trim().length() > 0) {
            this.fileAssociationBtn.setText("Remove File Association");
        }
    }

    @Override
    public void updateValues() {
        super.updateValues();
        Multiform multiform = (Multiform)this.power;
        if (multiform.getFilePath() != null) {
            File file = new File(multiform.getFilePath());
            this.damageLbl.setText(this.power.getDamageDisplay() + " (associated with " + file.getName() + ")");
        } else {
            this.damageLbl.setText(this.power.getDamageDisplay());
        }
    }
}

