/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.GenericObject;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.FractionTF;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ModifierDialog
extends GenericDialog {
    private static final long serialVersionUID = 916471573286595020L;
    protected JLabel fixedValueLbl;
    protected Modifier modifier;
    protected GenericObject parent;
    protected JLabel valueLbl;
    protected FractionTF valueTF;
    protected JLabel commentsLbl;
    protected JTextField commentsTF;
    protected JLabel levelInfoLbl;

    public ModifierDialog(Modifier modifier, boolean bl, GenericObject genericObject) {
        super(modifier, bl, false);
        this.modifier = modifier;
        this.parent = genericObject;
        this.init();
        if (modifier.getXMLID().equals("MODIFIER")) {
            this.displayTF.requestFocus();
            this.displayTF.selectAll();
        }
        if (this.pointsLbl != null) {
            this.pointsLbl.setVisible(false);
        }
        if (this.pointsTF != null) {
            this.pointsTF.setVisible(false);
        }
        this.multiplierBtn.setVisible(false);
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 49;
        jPanel.add((Component)this.commentsLbl, gridBagConstraints);
        gridBagConstraints.gridy = 50;
        jPanel.add((Component)this.valueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 49;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.commentsTF, gridBagConstraints);
        gridBagConstraints.gridy = 50;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        if (!this.modifier.isFixedValue()) {
            jPanel.add((Component)this.valueTF, gridBagConstraints);
        } else {
            jPanel.add((Component)this.fixedValueLbl, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 70;
        jPanel.add((Component)this.levelInfoLbl, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        if (!this.modifier.isFixedValue()) {
            this.valueTF.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ModifierDialog.this.modifier.setBaseCost(ModifierDialog.this.valueTF.getCurrent());
                    ModifierDialog.this.updateValues();
                }
            });
        }
        this.commentsTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ModifierDialog.this.modifier.setComments(ModifierDialog.this.commentsTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ModifierDialog.this.modifier.setComments(ModifierDialog.this.commentsTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ModifierDialog.this.modifier.setComments(ModifierDialog.this.commentsTF.getText());
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.levelInfoLbl = new JLabel(this.modifier.getLevelInfo());
        this.valueLbl = new JLabel("Value:");
        this.valueTF = new FractionTF(this.modifier.getTotalValue(), this.modifier.getMaxCost(), this.parent instanceof Maneuver ? 0.0 : this.modifier.getMinimumCost(), this.modifier.useMultiplier());
        this.fixedValueLbl = new JLabel("" + this.modifier.getFraction(this.modifier.getTotalValue()));
        this.notesBtn.setVisible(false);
        this.deleteBtn.setVisible(false);
        this.addModifierBtn.setVisible(false);
        this.customAdderBtn.setVisible(false);
        this.activePointsLbl.setVisible(false);
        this.realCostLbl.setVisible(false);
        if (this.modifier.getAvailableAdders().size() == 0 && this.modifier.getAvailableModifiers().size() == 0) {
            this.extrasScroll.setVisible(false);
        }
        this.nameLbl.setVisible(false);
        this.nameTF.setVisible(false);
        this.commentsLbl = new JLabel("Comments:");
        this.commentsTF = new JTextField();
        this.commentsTF.setText(this.modifier.getComments());
    }

    @Override
    public void updateValues() {
        this.modifier.setSelectedOption(this.modifier.getSelectedOption());
        this.levelInfoLbl.setText(this.modifier.getLevelInfo());
        if (this.valueTF.isShowing()) {
            this.valueTF.setCurrent(this.modifier.getBaseCost());
        }
        this.fixedValueLbl.setText(this.modifier.getFraction(this.modifier.getTotalValue()));
        super.updateValues();
        if (this.modifier.refreshAddersOnUpdate()) {
            this.layoutExtrasPanel();
            this.modifier.setRefreshAddersOnUpdate(false);
        }
        this.addModifierBtn.setVisible(false);
        this.customAdderBtn.setVisible(false);
        if (this.modifier.getAvailableAdders().size() == 0 && this.modifier.getAvailableModifiers().size() == 0) {
            this.extrasScroll.setVisible(false);
        } else {
            this.extrasScroll.setVisible(true);
        }
    }
}

