/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.martialarts.Maneuver;
import com.hero.ui.dialog.GenericDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ManeuverDialog
extends GenericDialog {
    private static final long serialVersionUID = 3066754225637879001L;
    protected Maneuver maneuver;
    private JLabel typeLbl;
    JComboBox typeCombo;
    private JLabel phaseLbl;
    private JLabel phaseValueLbl;
    private JLabel ocvLbl;
    private JLabel ocvValueLbl;
    private JLabel dcvLbl;
    private JLabel dcvValueLbl;
    private JLabel rangeLbl;
    private JLabel rangeValueLbl;
    private JLabel effectLbl;
    private JLabel effectValueLbl;

    public ManeuverDialog(Maneuver maneuver, boolean bl, boolean bl2) {
        super(maneuver, bl, bl2);
        this.maneuver = maneuver;
        this.init();
        this.customAdderBtn.setVisible(false);
        this.addModifierBtn.setVisible(maneuver.getEffectiveActiveCost() > 0.0);
        this.pack();
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        if (this.maneuver.getWeaponEffect() != null && this.maneuver.getWeaponEffect().trim().length() > 0) {
            jPanel.add((Component)this.typeLbl, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.typeCombo, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 41;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.phaseLbl, gridBagConstraints);
        gridBagConstraints.gridy = 42;
        jPanel.add((Component)this.ocvLbl, gridBagConstraints);
        gridBagConstraints.gridy = 43;
        jPanel.add((Component)this.dcvLbl, gridBagConstraints);
        gridBagConstraints.gridy = 44;
        if (this.maneuver.getCategory().equalsIgnoreCase("Ranged")) {
            jPanel.add((Component)this.rangeLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 45;
        jPanel.add((Component)this.effectLbl, gridBagConstraints);
        gridBagConstraints.gridy = 41;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.phaseValueLbl, gridBagConstraints);
        gridBagConstraints.gridy = 42;
        jPanel.add((Component)this.ocvValueLbl, gridBagConstraints);
        gridBagConstraints.gridy = 43;
        jPanel.add((Component)this.dcvValueLbl, gridBagConstraints);
        gridBagConstraints.gridy = 44;
        if (this.maneuver.getCategory().equalsIgnoreCase("Ranged")) {
            jPanel.add((Component)this.rangeValueLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 45;
        jPanel.add((Component)this.effectValueLbl, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ManeuverDialog.this.maneuver.setUseWeapon(ManeuverDialog.this.typeCombo.getSelectedIndex() == 1);
                ManeuverDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.typeLbl = new JLabel("Type");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Empty Hand");
        arrayList.add("Weapon");
        this.typeCombo = new JComboBox<Object>(arrayList.toArray());
        if (this.maneuver.useWeapon()) {
            this.typeCombo.setSelectedIndex(1);
        }
        this.phaseLbl = new JLabel("Phase:");
        this.phaseValueLbl = new JLabel(this.maneuver.getPhase());
        this.ocvLbl = new JLabel("OCV:");
        this.ocvValueLbl = new JLabel(this.maneuver.getOCV());
        this.dcvLbl = new JLabel("DCV:");
        this.dcvValueLbl = new JLabel(this.maneuver.getDCV());
        this.rangeLbl = new JLabel("Range:");
        this.rangeValueLbl = new JLabel("" + (this.maneuver.getRanged() >= 0 ? "+" : "-") + this.maneuver.getRange());
        this.effectLbl = new JLabel("Effect:");
        this.effectValueLbl = new JLabel(this.maneuver.useWeapon() ? this.maneuver.getWeaponEffect() : this.maneuver.getEffect());
        this.setNameVisible(false);
    }

    @Override
    public void updateValues() {
        super.updateValues();
        if (this.maneuver.useWeapon()) {
            this.effectValueLbl.setText(this.maneuver.getWeaponEffect());
        } else {
            this.effectValueLbl.setText(this.maneuver.getEffect());
        }
    }
}

