/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.model.DoubleDocument;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.disads.Disadvantage;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.modifiers.PartialCoverage;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.ExtraLimbs;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.Sense;
import com.hero.objects.powers.SenseAdder;
import com.hero.ui.dialog.AvailableModifiersDialog;
import com.hero.ui.dialog.NotesDialog;
import com.hero.ui.widgets.AdderPanel;
import com.hero.ui.widgets.CustomAdderPanel;
import com.hero.ui.widgets.LevelTF;
import com.hero.ui.widgets.ModifierPanel;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;

public class GenericDialog
extends JDialog {
    private static final long serialVersionUID = -6523068785490967657L;
    protected JLabel activePointsLbl;
    protected JPanel adderPanel;
    protected ArrayList<AdderPanel> adderPanels;
    protected JButton addModifierBtn;
    protected JButton cancelBtn;
    public boolean cancelButtonClicked;
    protected JButton customAdderBtn;
    protected JButton privateAdderBtn;
    protected JPanel customAdderPanel;
    protected JButton defineBtn;
    protected JButton deleteBtn;
    protected JButton multiplierBtn;
    public boolean deleteButtonClicked;
    protected JCheckBox displayActivePointsCB;
    protected JLabel displayLbl;
    protected DocumentListener displayListener;
    protected JTextField displayTF;
    protected JComboBox exampleCombo;
    protected ItemListener exampleItemListener;
    protected DocumentListener exampleDocumentListener;
    protected JPanel extrasPanel;
    protected JScrollPane extrasScroll;
    protected JLabel inputLbl;
    protected boolean isNew;
    protected boolean isPower;
    public JLabel levelsLbl;
    protected LevelTF levelTF;
    protected JPanel modifierPanel;
    protected JPanel privateModifierPanel;
    protected JPanel privateAdderPanel;
    protected JPanel multiplierPanel;
    protected ArrayList<ModifierPanel> modifierPanels;
    public JLabel nameLbl;
    public JTextField nameTF;
    protected JButton notesBtn;
    protected GenericObject object;
    protected JButton okBtn;
    public boolean okButtonClicked;
    public JComboBox optionsCB;
    public ItemListener optionListener;
    public DocumentListener optionAliasListener;
    public JLabel optionsLbl;
    public JLabel pointsLbl;
    protected LevelTF pointsTF;
    public JLabel realCostLbl;
    protected ArrayList<Adder> requiredAdderAdders;
    protected ArrayList<Adder> requiredLevelAdderAdders;
    protected ArrayList<JComboBox> requiredAdderCombos;
    protected ArrayList<LevelTF> requiredLevelAdderTFs;
    protected Hashtable<JLabel, Adder> requiredLevelAdderLabels = new Hashtable();
    protected JCheckBox ultraCB;
    protected JPanel equipmentPanel;
    protected JCheckBox carriedCB;
    protected JTextField priceTF;
    protected JLabel priceLbl;
    protected JTextField weightTF;
    protected JLabel weightLbl;
    protected JLabel endSourceLbl;
    protected JComboBox endSourceCombo;
    protected JLabel sfxLbl;
    protected JComboBox sfxCombo;

    public GenericDialog(GenericObject genericObject, boolean bl, boolean bl2) {
        super(HeroDesigner.getAppFrame(), genericObject.getDisplay(), true);
        this.object = genericObject;
        genericObject.setPower(bl2);
        this.isNew = bl;
        this.isPower = bl2;
        if (genericObject.isPower()) {
            this.isPower = true;
        }
        this.setDefaultCloseOperation(1);
    }

    public int display() {
        this.setVisible(true);
        if (this.cancelButtonClicked) {
            return 0;
        }
        if (this.deleteButtonClicked) {
            return -1;
        }
        if (this.okButtonClicked) {
            return 1;
        }
        return 0;
    }

    public Adder getAdderFromList(String string, ArrayList<Adder> arrayList) {
        for (Adder adder : arrayList) {
            Adder adder2;
            if (adder.getXMLID() != null && adder.getXMLID().trim().toUpperCase().equals(string.trim().toUpperCase())) {
                return adder;
            }
            if (adder.getAssignedAdders().size() <= 0 || (adder2 = this.getAdderFromList(string, adder.getAssignedAdders())) == null) continue;
            return adder2;
        }
        return null;
    }

    public ArrayList<AdderPanel> getAdderPanels() {
        return this.adderPanels;
    }

    public Modifier getModifierFromList(String string, ArrayList<Modifier> arrayList) {
        for (Modifier modifier : arrayList) {
            Modifier modifier2;
            if (modifier.getXMLID() != null && modifier.getXMLID().trim().toUpperCase().equals(string.trim().toUpperCase())) {
                return modifier;
            }
            if (modifier.getAssignedModifiers().size() <= 0 || (modifier2 = this.getModifierFromList(string, modifier.getAssignedModifiers())) == null) continue;
            return modifier2;
        }
        return null;
    }

    public ArrayList<ModifierPanel> getModifierPanels() {
        return this.modifierPanels;
    }

    protected JPanel getModsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.customAdderBtn);
        jPanel.add(this.privateAdderBtn);
        jPanel.add(this.addModifierBtn);
        return jPanel;
    }

    public GenericObject getObject() {
        return this.object;
    }

    protected JPanel getTopPanel() {
        Object object;
        int n;
        JPanel jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.carriedCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        this.equipmentPanel.add((Component)this.weightLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.weightTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.equipmentPanel.add((Component)new JLabel(HeroDesigner.getInstance().getPrefs().isMetric() ? "kg" : "lbs"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.priceLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            jPanel.add(this.priceTF);
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        } else {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.priceTF);
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        }
        this.equipmentPanel.setBorder(BorderFactory.createTitledBorder("Equipment Info."));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.nameLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.nameTF, gridBagConstraints);
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.displayLbl, gridBagConstraints);
        gridBagConstraints.gridy = 24;
        if (this.object.getOptions().size() > 0) {
            jPanel.add((Component)this.optionsLbl, gridBagConstraints);
        }
        for (n = 0; n < this.requiredAdderAdders.size() && n < 5; ++n) {
            ++gridBagConstraints.gridy;
            object = this.requiredAdderAdders.get(n);
            jPanel.add((Component)new JLabel(((GenericObject)object).getAlias()), gridBagConstraints);
        }
        for (n = 0; n < this.requiredLevelAdderAdders.size() && n < 5; ++n) {
            ++gridBagConstraints.gridy;
            object = this.requiredLevelAdderAdders.get(n);
            JLabel jLabel = new JLabel(((GenericObject)object).getAlias());
            this.requiredLevelAdderLabels.put(jLabel, (Adder)object);
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints.gridy = 30;
        if (this.object.getMinimumCost() != this.object.getMaxCost() && this.object.isMinSet() && this.object.isMaxSet()) {
            jPanel.add((Component)this.pointsLbl, gridBagConstraints);
        }
        if (this.object instanceof ExtraLimbs || this.object instanceof PartialCoverage || this.object.getLevelCost() > 0.0 && this.object.getLevelValue() > 0.0) {
            gridBagConstraints.gridy = 70;
            jPanel.add((Component)this.levelsLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.displayTF, gridBagConstraints);
        gridBagConstraints.gridy = 24;
        if (this.object.getOptions().size() > 0) {
            jPanel.add((Component)this.optionsCB, gridBagConstraints);
        }
        for (n = 0; n < this.requiredAdderCombos.size() && n < 5; ++n) {
            ++gridBagConstraints.gridy;
            object = this.requiredAdderCombos.get(n);
            jPanel.add((Component)object, gridBagConstraints);
        }
        for (n = 0; n < this.requiredLevelAdderTFs.size() && n < 5; ++n) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            object = this.requiredLevelAdderTFs.get(n);
            jPanel.add((Component)object, gridBagConstraints);
        }
        gridBagConstraints.gridy = 30;
        if (this.object.getMinimumCost() != this.object.getMaxCost() && this.object.isMinSet() && this.object.isMaxSet()) {
            gridBagConstraints.fill = 0;
            jPanel.add((Component)this.pointsTF, gridBagConstraints);
            gridBagConstraints.fill = 2;
        }
        if (this.object.isUserInput()) {
            gridBagConstraints.gridy = 40;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.inputLbl, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.exampleCombo, gridBagConstraints);
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        if (this.object instanceof ExtraLimbs || this.object.getLevelCost() != 0.0 && this.object.getLevelValue() != 0.0) {
            gridBagConstraints.gridy = 70;
            jPanel.add((Component)this.levelTF, gridBagConstraints);
        }
        if (!(this.object instanceof Disadvantage || this.object instanceof Modifier || this.object.getParentList() != null && this.object.getParentList() instanceof ElementalControl)) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 69;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)this.sfxLbl, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.sfxCombo, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 91;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.endSourceLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.endSourceCombo, gridBagConstraints);
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        if (this.object.isEquipment()) {
            jPanel.add((Component)this.equipmentPanel, gridBagConstraints);
        }
        return jPanel;
    }

    public boolean hasAvailable(String string) {
        for (int i = 0; i < this.adderPanels.size(); ++i) {
            AdderPanel adderPanel = this.adderPanels.get(i);
            if (!adderPanel.getAdder().getXMLID().equals(string) || !adderPanel.hasAvailable()) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        Cloneable cloneable;
        if (this.isNew) {
            cloneable = this.object.getAssignedAdders();
            ArrayList<Adder> arrayList = this.object.getAvailableAdders();
            for (int i = 0; i < arrayList.size(); ++i) {
                Adder adder = arrayList.get(i);
                if (!adder.isRequired()) continue;
                adder = adder.clone();
                adder.setSelected(true);
                adder.setAlias(adder.getDisplay());
                boolean bl = false;
                for (int j = 0; j < ((ArrayList)cloneable).size(); ++j) {
                    Adder adder2 = (Adder)((ArrayList)cloneable).get(j);
                    if (!adder2.getXMLID().equals(adder.getXMLID())) continue;
                    ((ArrayList)cloneable).set(j, adder);
                    bl = true;
                }
                if (bl) continue;
                ((ArrayList)cloneable).add(adder);
            }
        }
        if (this.object.getOptions().size() > 0 && (this.isNew || this.object.getSelectedOption() == null)) {
            cloneable = this.object.getOptions().get(0);
            this.object.setSelectedOption((Adder)cloneable);
        }
        this.initWidgets();
        if (this.object.getSelectedOption() != null) {
            double d = this.object.getBaseCost();
            String string = this.object.getSelectedOption().getAlias();
            this.optionsCB.setSelectedItem(this.object.getSelectedOption());
            ((JTextField)this.optionsCB.getEditor().getEditorComponent()).setText(string);
            if (this.pointsTF != null) {
                this.pointsTF.setCurrent((int)Rounder.roundHalfUp(d));
            }
        }
        this.pack();
        if (HeroDesigner.getInstance().getPrefs().isRememberDialogPosition()) {
            if (HeroDesigner.getInstance().getPrefs().getDialogX() > 50 && HeroDesigner.getInstance().getPrefs().getDialogY() > 50) {
                this.setSize(new Dimension(HeroDesigner.getInstance().getPrefs().getDialogX(), HeroDesigner.getInstance().getPrefs().getDialogY()));
            } else {
                this.setSize(this.getPreferredSize());
            }
            if (HeroDesigner.getInstance().getPrefs().getDialogScreenX() > 0 && HeroDesigner.getInstance().getPrefs().getDialogScreenY() > 0) {
                this.setLocation(HeroDesigner.getInstance().getPrefs().getDialogScreenX(), HeroDesigner.getInstance().getPrefs().getDialogScreenY());
            } else {
                this.setLocationRelativeTo(HeroDesigner.getAppFrame());
            }
        } else {
            this.setSize(new Dimension(700, 550));
            this.setLocationRelativeTo(HeroDesigner.getAppFrame());
        }
        this.initListeners();
        this.layoutComponent();
        this.updateValues();
        if (!HeroDesigner.getActiveHero().getRules().multiplierAllowed()) {
            this.multiplierBtn.setVisible(false);
        } else {
            this.multiplierBtn.setVisible(true);
        }
        this.layoutExtrasPanel();
        this.updateValues();
    }

    protected void initListeners() {
        Adder adder;
        JComponent jComponent;
        int n;
        this.endSourceCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GenericDialog.this.object.setUseENDReserve(GenericDialog.this.endSourceCombo.getSelectedIndex() == 1);
            }
        });
        this.multiplierBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiplierDialog multiplierDialog = new MultiplierDialog();
                multiplierDialog.setLocationRelativeTo(GenericDialog.this);
                multiplierDialog.setVisible(true);
                multiplierDialog.dispose();
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.updateValues();
            }
        });
        this.carriedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDialog.this.object.setCarried(GenericDialog.this.carriedCB.isSelected());
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        });
        this.priceTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.priceTF.getText().trim().length() == 0) {
                    GenericDialog.this.object.setPrice(0.0);
                } else {
                    GenericDialog.this.object.setPrice(Double.parseDouble(GenericDialog.this.priceTF.getText()));
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.priceTF.getText().trim().length() == 0) {
                    GenericDialog.this.object.setPrice(0.0);
                } else {
                    GenericDialog.this.object.setPrice(Double.parseDouble(GenericDialog.this.priceTF.getText()));
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.priceTF.getText().trim().length() == 0) {
                    GenericDialog.this.object.setPrice(0.0);
                } else {
                    GenericDialog.this.object.setPrice(Double.parseDouble(GenericDialog.this.priceTF.getText()));
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        });
        this.weightTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.weightTF.getText().trim().length() == 0) {
                    GenericDialog.this.object.setWeight(0.0);
                } else {
                    GenericDialog.this.object.setWeight(Double.parseDouble(GenericDialog.this.weightTF.getText()));
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.weightTF.getText().trim().length() == 0) {
                    GenericDialog.this.object.setWeight(0.0);
                } else {
                    GenericDialog.this.object.setWeight(Double.parseDouble(GenericDialog.this.weightTF.getText()));
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.weightTF.getText().trim().length() == 0) {
                    GenericDialog.this.object.setWeight(0.0);
                } else {
                    GenericDialog.this.object.setWeight(Double.parseDouble(GenericDialog.this.weightTF.getText()));
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        });
        for (n = 0; n < this.requiredAdderCombos.size(); ++n) {
            jComponent = this.requiredAdderCombos.get(n);
            adder = this.requiredAdderAdders.get(n);
            ((JComboBox)jComponent).addItemListener(new RequiredAdderComboListener(adder, (JComboBox)jComponent));
        }
        for (n = 0; n < this.requiredLevelAdderTFs.size(); ++n) {
            jComponent = this.requiredLevelAdderTFs.get(n);
            adder = this.requiredLevelAdderAdders.get(n);
            jComponent.addPropertyChangeListener(new RequiredAdderLevelListener(adder, (LevelTF)jComponent));
        }
        this.displayActivePointsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDialog.this.object.setDisplayActiveCost(GenericDialog.this.displayActivePointsCB.isSelected());
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        });
        this.ultraCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDialog.this.object.setUltra(GenericDialog.this.ultraCB.isSelected());
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.updateValues();
            }
        });
        this.nameTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setName(GenericDialog.this.nameTF.getText());
                GenericObject.lastEdit = System.currentTimeMillis();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setName(GenericDialog.this.nameTF.getText());
                GenericObject.lastEdit = System.currentTimeMillis();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setName(GenericDialog.this.nameTF.getText());
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        });
        this.optionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (GenericDialog.this.optionsCB.getSelectedItem() instanceof Adder) {
                    Adder adder = (Adder)GenericDialog.this.optionsCB.getSelectedItem();
                    String string = adder.getAlias();
                    String string2 = adder.getDisplay();
                    GenericDialog.this.object.setSelectedOption(adder);
                    GenericObject.lastEdit = System.currentTimeMillis();
                    GenericDialog.this.updateValues();
                    GenericDialog.this.layoutExtrasPanel();
                    if (GenericDialog.this.object.getSelectedOption() != null) {
                        GenericDialog.this.object.getSelectedOption().setAlias(string);
                        if (GenericDialog.this.object.getSelectedOption().getDisplay().equals(string2)) {
                            ((JTextField)GenericDialog.this.optionsCB.getEditor().getEditorComponent()).setText(string);
                        } else {
                            ((JTextField)GenericDialog.this.optionsCB.getEditor().getEditorComponent()).setText(GenericDialog.this.object.getSelectedOption().getDisplay());
                        }
                    }
                }
            }
        };
        this.optionsCB.addItemListener(this.optionListener);
        this.optionAliasListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.object.getSelectedOption() != null) {
                    GenericDialog.this.object.getSelectedOption().setAlias(((JTextField)GenericDialog.this.optionsCB.getEditor().getEditorComponent()).getText());
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (GenericDialog.this.object.getSelectedOption() != null) {
                    GenericDialog.this.object.getSelectedOption().setAlias(((JTextField)GenericDialog.this.optionsCB.getEditor().getEditorComponent()).getText());
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        };
        ((JTextField)this.optionsCB.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.optionAliasListener);
        this.privateAdderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!(GenericDialog.this.object instanceof List)) {
                    return;
                }
                Adder adder = new Adder(new Element("ADDER"));
                adder.setDisplay("Private Adder");
                adder.setAlias("Private Adder");
                adder.setPrivate(true);
                adder.setBaseCost(0.0);
                adder.setSelected(true);
                adder.setExclusive(false);
                ((List)GenericDialog.this.object).getPrivateAdders().add(adder);
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.layoutExtrasPanel();
                GenericDialog.this.validate();
                GenericDialog.this.privateAdderPanel.scrollRectToVisible(GenericDialog.this.privateAdderPanel.getBounds());
                GenericDialog.this.updateValues();
            }
        });
        this.customAdderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Adder adder = new Adder(new Element("ADDER"));
                adder.setDisplay(GenericDialog.this.object instanceof List ? "Common Adder" : "Custom Adder");
                adder.setAlias(GenericDialog.this.object instanceof List ? "Common Adder" : "Custom Adder");
                adder.setBaseCost(0.0);
                adder.setSelected(true);
                adder.setExclusive(false);
                GenericDialog.this.object.getAssignedAdders().add(adder);
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.layoutExtrasPanel();
                GenericDialog.this.validate();
                GenericDialog.this.customAdderPanel.scrollRectToVisible(GenericDialog.this.customAdderPanel.getBounds());
                GenericDialog.this.updateValues();
            }
        });
        this.displayListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setAlias(GenericDialog.this.displayTF.getText());
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.updateValues();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setAlias(GenericDialog.this.displayTF.getText());
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.updateValues();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setAlias(GenericDialog.this.displayTF.getText());
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.updateValues();
            }
        };
        this.displayTF.getDocument().addDocumentListener(this.displayListener);
        this.exampleItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (GenericDialog.this.object.isOtherInputAllowed()) {
                    GenericDialog.this.object.setInput(((JTextField)GenericDialog.this.exampleCombo.getEditor().getEditorComponent()).getText());
                } else {
                    GenericDialog.this.object.setInput(GenericDialog.this.exampleCombo.getSelectedItem().toString());
                }
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        };
        this.exampleCombo.addItemListener(this.exampleItemListener);
        if (this.object.isOtherInputAllowed()) {
            this.exampleDocumentListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    String string = ((JTextField)GenericDialog.this.exampleCombo.getEditor().getEditorComponent()).getText();
                    GenericDialog.this.object.setInput(string);
                    GenericObject.lastEdit = System.currentTimeMillis();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    String string = ((JTextField)GenericDialog.this.exampleCombo.getEditor().getEditorComponent()).getText();
                    GenericDialog.this.object.setInput(string);
                    GenericObject.lastEdit = System.currentTimeMillis();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    String string = ((JTextField)GenericDialog.this.exampleCombo.getEditor().getEditorComponent()).getText();
                    GenericDialog.this.object.setInput(string);
                    GenericObject.lastEdit = System.currentTimeMillis();
                }
            };
            ((JTextField)this.exampleCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.exampleDocumentListener);
        }
        this.levelTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (GenericDialog.this.object.getLevels() == GenericDialog.this.levelTF.getCurrent()) {
                    return;
                }
                GenericDialog.this.object.setLevels(GenericDialog.this.levelTF.getCurrent());
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.updateValues();
                if (GenericDialog.this.object instanceof SenseAdder || GenericDialog.this.object instanceof Entangle) {
                    GenericDialog.this.layoutExtrasPanel();
                }
            }
        });
        this.defineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GenericDialog.this.object == null) {
                    return;
                }
                if (GenericDialog.this.object.getDefinition() == null) {
                    return;
                }
                if (GenericDialog.this.object.getDefinition().trim().length() == 0) {
                    return;
                }
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), GenericDialog.this.defineBtn, GenericDialog.this.object.getDefinition(), false);
                popupMessage.setVisible(true);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDialog.this.cancelButtonClicked = true;
                GenericDialog.this.deleteButtonClicked = false;
                GenericDialog.this.okButtonClicked = false;
                GenericDialog.this.setVisible(false);
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObject.lastEdit = System.currentTimeMillis();
                GenericDialog.this.cancelButtonClicked = false;
                GenericDialog.this.deleteButtonClicked = false;
                GenericDialog.this.okButtonClicked = true;
                GenericDialog.this.setVisible(false);
                GenericDialog.this.updateValues();
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDialog.this.cancelButtonClicked = false;
                GenericDialog.this.deleteButtonClicked = true;
                GenericDialog.this.okButtonClicked = false;
                GenericDialog.this.setVisible(false);
                GenericDialog.this.updateValues();
            }
        });
        this.notesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotesDialog notesDialog = new NotesDialog(GenericDialog.this.object, GenericDialog.this);
                notesDialog.setSize(GenericDialog.this.getSize());
                notesDialog.setLocationRelativeTo(GenericDialog.this);
                notesDialog.setVisible(true);
                GenericDialog.this.updateValues();
            }
        });
        this.addModifierBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AvailableModifiersDialog availableModifiersDialog = new AvailableModifiersDialog(GenericDialog.this.object, GenericDialog.this);
                availableModifiersDialog.setVisible(true);
                GenericObject.lastEdit = System.currentTimeMillis();
            }
        });
        if (this.object.getMinimumCost() != this.object.getMaxCost() && this.object.isMinSet() && this.object.isMaxSet()) {
            this.pointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    GenericDialog.this.object.setBaseCost(GenericDialog.this.pointsTF.getCurrent());
                    GenericObject.lastEdit = System.currentTimeMillis();
                    GenericDialog.this.updateValues();
                }
            });
        }
        this.sfxCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GenericDialog.this.object.setSFX(((JTextField)GenericDialog.this.sfxCombo.getEditor().getEditorComponent()).getText());
            }
        });
        ((JTextField)this.sfxCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setSFX(((JTextField)GenericDialog.this.sfxCombo.getEditor().getEditorComponent()).getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setSFX(((JTextField)GenericDialog.this.sfxCombo.getEditor().getEditorComponent()).getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GenericDialog.this.object.setSFX(((JTextField)GenericDialog.this.sfxCombo.getEditor().getEditorComponent()).getText());
            }
        });
    }

    protected void initWidgets() {
        Cloneable cloneable;
        this.multiplierBtn = new JButton("Cost Multiplier");
        this.equipmentPanel = new JPanel(new GridBagLayout());
        this.carriedCB = new JCheckBox("Carried");
        this.carriedCB.setSelected(this.object.isCarried());
        this.priceLbl = new JLabel("Price: ");
        this.weightLbl = new JLabel("Weight: ");
        BigDecimal bigDecimal = new BigDecimal(this.object.getPrice());
        bigDecimal = bigDecimal.setScale(HeroDesigner.getActiveHero().getRules().getEquipmentCostDecimalPlaces(), 4);
        this.priceTF = new JTextField(new DoubleDocument(9.9999999999E10, -9.9999999999E10), bigDecimal.toString(), 6);
        bigDecimal = new BigDecimal(this.object.getWeight());
        bigDecimal = bigDecimal.setScale(2, 4);
        this.weightTF = new JTextField(new DoubleDocument(9.9999999999E10, -9.9999999999E10), bigDecimal.toString(), 6);
        this.requiredAdderCombos = new ArrayList();
        this.requiredAdderAdders = new ArrayList();
        this.requiredLevelAdderTFs = new ArrayList();
        this.requiredLevelAdderAdders = new ArrayList();
        for (int i = 0; i < this.object.getAssignedAdders().size(); ++i) {
            JComponent jComponent;
            cloneable = this.object.getAssignedAdders().get(i);
            if (!((Adder)cloneable).isRequired()) continue;
            if (this.isNew) {
                ((GenericObject)cloneable).setAlias(((GenericObject)cloneable).getDisplay());
            }
            if (((GenericObject)cloneable).getOptions() != null && ((GenericObject)cloneable).getOptions().size() > 0) {
                jComponent = new JComboBox<Object>(((GenericObject)cloneable).getOptions().toArray());
                ((JComboBox)jComponent).setEditable(true);
                ((JComboBox)jComponent).setSelectedItem(((GenericObject)cloneable).getSelectedOption());
                ((JTextField)((JComboBox)jComponent).getEditor().getEditorComponent()).setText(((GenericObject)cloneable).getSelectedOption().getAlias());
                this.requiredAdderCombos.add((JComboBox)jComponent);
                this.requiredAdderAdders.add((Adder)cloneable);
                continue;
            }
            if (!(((GenericObject)cloneable).getLevelCost() > 0.0)) continue;
            jComponent = new LevelTF(((GenericObject)cloneable).getLevels(), ((GenericObject)cloneable).getMaxLevel(), ((GenericObject)cloneable).getMinimumLevel());
            this.requiredLevelAdderAdders.add((Adder)cloneable);
            this.requiredLevelAdderTFs.add((LevelTF)jComponent);
        }
        this.adderPanels = new ArrayList();
        this.modifierPanels = new ArrayList();
        this.optionsLbl = new JLabel(this.object.getOptionLabel() + ":");
        this.optionsCB = new JComboBox<Object>(this.object.getOptions().toArray());
        this.optionsCB.setEditable(true);
        this.displayLbl = new JLabel("Display:");
        this.levelsLbl = new JLabel(this.object.getLevelsLabel());
        this.inputLbl = new JLabel(this.object.getInputLabel());
        this.activePointsLbl = new JLabel("Active Point:  " + Rounder.roundUp(this.object.getActiveCost()));
        this.realCostLbl = new JLabel("Real Cost:  " + Rounder.roundUp(this.object.getRealCost()));
        this.displayActivePointsCB = new JCheckBox("Display Active Points");
        this.displayActivePointsCB.setSelected(this.object.getDisplayActiveCost());
        this.displayTF = new JTextField(this.object.getAlias(), 20);
        this.levelTF = new LevelTF(this.object.getLevels(), this.object.getMaxLevel(), this.object.getMinimumLevel());
        this.exampleCombo = new JComboBox<Object>(this.object.getExamples().toArray());
        this.exampleCombo.setEditable(this.object.isOtherInputAllowed());
        this.exampleCombo.setFont(this.displayTF.getFont());
        if (this.object.getInput() != null && this.object.getExamples().size() > 0) {
            this.exampleCombo.setSelectedItem(this.object.getInput());
        } else if (this.object.getInput() != null) {
            ((JTextField)this.exampleCombo.getEditor().getEditorComponent()).setText(this.object.getInput());
        }
        this.extrasPanel = new JPanel(new GridBagLayout());
        this.extrasPanel.setBackground(Color.white);
        this.extrasPanel.setOpaque(true);
        this.extrasScroll = new JScrollPane(this.extrasPanel);
        this.extrasScroll.getVerticalScrollBar().setUnitIncrement(10);
        this.extrasScroll.setPreferredSize(new Dimension(650, 150));
        this.extrasScroll.getVerticalScrollBar().setUnitIncrement(5);
        this.extrasScroll.getViewport().setBackground(Color.white);
        this.extrasScroll.getViewport().setOpaque(true);
        this.customAdderPanel = new JPanel(new GridBagLayout());
        this.customAdderPanel.setBorder(BorderFactory.createTitledBorder(this.object instanceof List ? "Common Adders" : "Custom Adders"));
        this.customAdderPanel.setOpaque(false);
        this.adderPanel = new JPanel(new GridBagLayout());
        this.adderPanel.setBorder(BorderFactory.createTitledBorder((this.object instanceof List ? "Common " : "") + "Adders"));
        this.adderPanel.setOpaque(false);
        this.modifierPanel = new JPanel(new GridBagLayout());
        this.modifierPanel.setBorder(BorderFactory.createTitledBorder((this.object instanceof List ? "Common " : "") + "Modifiers"));
        this.modifierPanel.setOpaque(false);
        this.privateModifierPanel = new JPanel(new GridBagLayout());
        this.privateModifierPanel.setBorder(BorderFactory.createTitledBorder("Private Modifiers"));
        this.privateModifierPanel.setOpaque(false);
        this.privateAdderPanel = new JPanel(new GridBagLayout());
        this.privateAdderPanel.setBorder(BorderFactory.createTitledBorder("Private Adders"));
        this.privateAdderPanel.setOpaque(false);
        this.multiplierPanel = new JPanel(new GridBagLayout());
        this.multiplierPanel.setBorder(BorderFactory.createTitledBorder("Cost Multipliers"));
        this.multiplierPanel.setOpaque(false);
        this.customAdderBtn = new JButton(this.object instanceof List ? "Common Adder" : "Custom Adder");
        this.customAdderBtn.setVisible(this.object.allowsOtherAdders());
        this.privateAdderBtn = new JButton("Private Adder");
        this.privateAdderBtn.setVisible(this.object instanceof List);
        this.addModifierBtn = new JButton("Add Modifier...");
        this.addModifierBtn.setVisible(this.object.allowsOtherModifiers());
        this.notesBtn = new JButton("Notes...");
        this.okBtn = new JButton("OK");
        this.deleteBtn = new JButton("Delete");
        this.deleteBtn.setVisible(!this.isNew);
        this.cancelBtn = new JButton("Cancel");
        this.defineBtn = new JButton("Define");
        if (this.object.getDefinition() != null && this.object.getDefinition().trim().length() > 0) {
            this.defineBtn.setEnabled(true);
        } else {
            this.defineBtn.setEnabled(false);
        }
        if (this.object.getMinimumCost() != this.object.getMaxCost()) {
            this.pointsLbl = new JLabel("Points:");
            this.pointsTF = new LevelTF((int)this.object.getBaseCost(), (int)this.object.getMaxCost(), (int)this.object.getMinimumCost());
        }
        this.nameLbl = new JLabel("Name:");
        this.nameTF = new JTextField(this.object.getName());
        Font font = this.nameTF.getFont();
        font = new Font(font.getFontName(), 2, font.getSize());
        this.nameTF.setFont(font);
        this.ultraCB = HeroDesigner.getActiveTemplate().is6E() ? new JCheckBox("Fixed Slot") : new JCheckBox("Ultra Slot");
        this.ultraCB.setSelected(this.object.isUltra());
        this.sfxLbl = new JLabel("Special Effect:");
        cloneable = new ArrayList();
        for (int i = 0; i < GenericObject.standardSFX.length; ++i) {
            ((ArrayList)cloneable).add(GenericObject.standardSFX[i]);
        }
        this.sfxCombo = new JComboBox<Object>(((ArrayList)cloneable).toArray());
        this.sfxCombo.setEditable(true);
        this.sfxCombo.setSelectedItem(this.object.getSFX());
        this.endSourceLbl = new JLabel("END Source:");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Personal END");
        arrayList.add("END Reserve");
        this.endSourceCombo = new JComboBox<Object>(arrayList.toArray());
        if (this.object.getUseENDReserve()) {
            this.endSourceCombo.setSelectedIndex(1);
        } else {
            this.endSourceCombo.setSelectedIndex(0);
        }
        if (this.object.getEndUsage() == 0 || GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") == null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment(), "ENDURANCERESERVE") == null || GenericObject.findObjectByID(this.object.getAssignedModifiers(), "ENDRESERVEOREND") != null) {
            this.endSourceLbl.setVisible(false);
            this.endSourceCombo.setVisible(false);
        }
    }

    private void insertAdder(Adder adder, GenericObject genericObject, AdderPanel adderPanel, GridBagConstraints gridBagConstraints, int n) {
        if (adder.isRequired() && !(genericObject instanceof Adder) && !(genericObject instanceof Modifier)) {
            return;
        }
        gridBagConstraints.insets = new Insets(0, n * 20, 0, 0);
        AdderPanel adderPanel2 = new AdderPanel(genericObject, adder, adderPanel, this);
        this.adderPanels.add(adderPanel2);
        this.adderPanel.add((Component)adderPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (adder.getAvailableAdders() != null) {
            for (int i = 0; i < adder.getAvailableAdders().size(); ++i) {
                try {
                    Adder adder2 = adder.getAvailableAdders().get(i);
                    adder2 = adder2.clone();
                    adder2.setAlias(adder2.getDisplay());
                    adder2.setSelected(false);
                    adder2.setAvailableCheck(true);
                    boolean bl = false;
                    for (int j = 0; j < adder.getAssignedAdders().size(); ++j) {
                        Adder adder3 = adder.getAssignedAdders().get(j);
                        if (!adder3.equals(adder2)) continue;
                        this.insertAdder(adder3, adder, adderPanel2, gridBagConstraints, n + 1);
                        bl = true;
                    }
                    adder2.setAvailableCheck(false);
                    if (bl) continue;
                    this.insertAdder(adder2, adder, adderPanel2, gridBagConstraints, n + 1);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void insertModifier(Modifier modifier, GenericObject genericObject, GridBagConstraints gridBagConstraints, int n) {
        gridBagConstraints.insets = new Insets(0, n * 20, 0, 0);
        ModifierPanel modifierPanel = new ModifierPanel(this.object, modifier, this);
        this.modifierPanels.add(modifierPanel);
        ++gridBagConstraints.gridy;
        if (modifier.isPrivate()) {
            this.privateModifierPanel.add((Component)modifierPanel, gridBagConstraints);
        } else {
            this.modifierPanel.add((Component)modifierPanel, gridBagConstraints);
        }
    }

    private void insertMultiplier(Modifier modifier, GenericObject genericObject, GridBagConstraints gridBagConstraints, int n) {
        gridBagConstraints.insets = new Insets(0, n * 20, 0, 0);
        ModifierPanel modifierPanel = new ModifierPanel(this.object, modifier, this);
        this.modifierPanels.add(modifierPanel);
        ++gridBagConstraints.gridy;
        this.multiplierPanel.add((Component)modifierPanel, gridBagConstraints);
    }

    protected void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        this.extrasPanel.add((Component)this.adderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.privateAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.customAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.extrasPanel.add((Component)this.multiplierPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.modifierPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.privateModifierPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        this.extrasPanel.add((Component)jPanel, gridBagConstraints);
        this.extrasPanel.setOpaque(true);
        this.extrasPanel.setBackground(Color.white);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.getTopPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jPanel2.add((Component)this.activePointsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.displayActivePointsCB);
        if (this.isPower && this.object.getParentList() != null && this.object.getParentList() instanceof Multipower && this.object.getMainPower() == null) {
            jPanel3.add(this.ultraCB);
        }
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)this.realCostLbl, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.extrasScroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        jPanel2.add((Component)this.getModsPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 15;
        ++gridBagConstraints.gridy;
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        jPanel4.add(this.notesBtn);
        jPanel4.add(this.multiplierBtn);
        jPanel4.add(this.okBtn);
        jPanel4.add(this.deleteBtn);
        jPanel4.add(this.cancelBtn);
        jPanel4.add(this.defineBtn);
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        this.setContentPane(new JScrollPane(jPanel2));
    }

    public void layoutExtrasPanel() {
        Modifier modifier;
        int n;
        int n2;
        GenericObject genericObject;
        Adder adder;
        int n3;
        this.object.verifyModifiers();
        this.adderPanel.removeAll();
        this.customAdderPanel.removeAll();
        this.modifierPanel.removeAll();
        this.privateModifierPanel.removeAll();
        this.privateAdderPanel.removeAll();
        this.multiplierPanel.removeAll();
        this.adderPanels.clear();
        this.modifierPanels.clear();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        ArrayList<Adder> arrayList2 = this.object.getAvailableAdders();
        ArrayList<Adder> arrayList3 = this.object.getAssignedAdders();
        ArrayList<Object> arrayList4 = new ArrayList();
        if (this.object instanceof List) {
            arrayList4 = ((List)this.object).getPrivateAdders();
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            try {
                adder = arrayList2.get(n3);
                if (adder.isRequired()) continue;
                adder = adder.clone();
                adder.setSelected(false);
                boolean bl = false;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    genericObject = arrayList3.get(i);
                    if (!genericObject.getXMLID().equals(adder.getXMLID()) || !((Adder)genericObject).display.equals(adder.display) || genericObject.getXMLID().equals("ADDER") || genericObject.getXMLID().equals("GENERIC_OBJECT")) continue;
                    adder = genericObject;
                    arrayList.add(adder);
                    this.insertAdder(adder, this.object, null, gridBagConstraints, 0);
                    bl = true;
                }
                if (bl) continue;
                this.insertAdder(adder, this.object, null, gridBagConstraints, 0);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (gridBagConstraints.gridy > 0) {
            this.adderPanel.setVisible(true);
        } else {
            this.adderPanel.setVisible(false);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        for (n3 = 0; n3 < arrayList3.size(); ++n3) {
            adder = arrayList3.get(n3);
            if (arrayList.contains(adder) || adder.isRequired()) continue;
            CustomAdderPanel customAdderPanel = new CustomAdderPanel(this.object, adder, this);
            this.customAdderPanel.add((Component)customAdderPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        if (gridBagConstraints.gridy > 0) {
            this.customAdderPanel.setVisible(true);
        } else {
            this.customAdderPanel.setVisible(false);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        for (n3 = 0; n3 < arrayList4.size(); ++n3) {
            adder = (Adder)arrayList4.get(n3);
            if (!adder.isSelected()) continue;
            CustomAdderPanel customAdderPanel = new CustomAdderPanel(this.object, adder, this);
            this.privateAdderPanel.add((Component)customAdderPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.privateAdderPanel.setVisible(gridBagConstraints.gridy > 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.multiplierPanel.setVisible(false);
        this.modifierPanel.setVisible(false);
        this.privateModifierPanel.setVisible(false);
        n3 = 0;
        int n4 = 0;
        ArrayList arrayList5 = this.object.getAssignedModifiers();
        arrayList5 = (ArrayList)arrayList5.clone();
        if (this.object instanceof List) {
            List list = (List)this.object;
            arrayList5.addAll(list.getPrivateMods());
        }
        for (n2 = 0; n2 < this.object.getAvailableModifiers().size(); ++n2) {
            genericObject = this.object.getAvailableModifiers().get(n2);
            if (!((Modifier)genericObject).useMultiplier() || ((Modifier)genericObject).included(this.object).trim().length() > 0) continue;
            genericObject = ((Modifier)genericObject).clone();
            genericObject.setAlias(genericObject.getDisplay());
            ((Modifier)genericObject).setAvailableCheck(true);
            for (n = 0; n < arrayList5.size(); ++n) {
                modifier = (Modifier)arrayList5.get(n);
                modifier.setAvailableCheck(true);
                if (modifier.equals(genericObject)) {
                    genericObject = modifier;
                    modifier.setAvailableCheck(false);
                    break;
                }
                modifier.setAvailableCheck(false);
            }
            ((Modifier)genericObject).setAvailableCheck(false);
            this.insertMultiplier((Modifier)genericObject, this.object, gridBagConstraints, 0);
            this.multiplierPanel.setVisible(true);
        }
        for (n2 = 0; n2 < arrayList5.size(); ++n2) {
            genericObject = (Modifier)arrayList5.get(n2);
            ((Modifier)genericObject).setAvailableCheck(true);
            if (((Modifier)genericObject).useMultiplier() && !genericObject.getXMLID().equals("GENERIC_OBJECT") && !genericObject.getXMLID().equals("CUSTOM_MODIFIER")) {
                for (n = 0; n < this.object.getAvailableModifiers().size(); ++n) {
                    modifier = this.object.getAvailableModifiers().get(n);
                    modifier.setAvailableCheck(true);
                    if (!modifier.equals(genericObject)) continue;
                    modifier.setAvailableCheck(false);
                    genericObject = null;
                    break;
                }
            }
            if (genericObject == null) continue;
            ((Modifier)genericObject).setAvailableCheck(false);
            if (((Modifier)genericObject).useMultiplier()) {
                this.insertMultiplier((Modifier)genericObject, this.object, gridBagConstraints, 0);
                this.multiplierPanel.setVisible(true);
                continue;
            }
            this.insertModifier((Modifier)genericObject, this.object, gridBagConstraints, 0);
            if (((Modifier)genericObject).isPrivate()) {
                ++n4;
                continue;
            }
            ++n3;
        }
        if (n3 > 0) {
            this.modifierPanel.setVisible(true);
        }
        if (n4 > 0) {
            this.privateModifierPanel.setVisible(true);
        }
        this.modifierPanel.revalidate();
        this.privateModifierPanel.revalidate();
        this.extrasPanel.revalidate();
        this.extrasScroll.revalidate();
    }

    public void recalc() {
        this.layoutExtrasPanel();
        this.validate();
        Rectangle rectangle = this.modifierPanel.getBounds();
        rectangle = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, rectangle.height);
        this.modifierPanel.scrollRectToVisible(rectangle);
        this.updateValues();
    }

    public void resetMods() {
        ArrayList<Modifier> arrayList = this.object.getAssignedModifiers();
        for (int i = 0; i < this.modifierPanels.size(); ++i) {
            ModifierPanel modifierPanel = this.modifierPanels.get(i);
            if (GenericObject.findObjectByID(arrayList, modifierPanel.getModifier().getXMLID()) != null) continue;
            modifierPanel.setSelected(false);
        }
        this.updateValues();
    }

    @Override
    public void setLocationRelativeTo(Component component) {
        if (!HeroDesigner.getInstance().getPrefs().isRememberDialogPosition()) {
            super.setLocationRelativeTo(component);
        }
    }

    public void setNameVisible(boolean bl) {
        this.nameTF.setVisible(bl);
        this.nameLbl.setVisible(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        this.object.setAppAdjusted(false);
        if (this.object instanceof Sense || this.object instanceof SenseAdder) {
            Power.lastSenseEdit = System.currentTimeMillis();
        }
        if (!bl && this.isShowing()) {
            HeroDesigner.getInstance().getPrefs().setDialogScreenX((int)this.getLocationOnScreen().getX());
            HeroDesigner.getInstance().getPrefs().setDialogScreenY((int)this.getLocationOnScreen().getY());
            HeroDesigner.getInstance().getPrefs().setDialogX(this.getSize().width);
            HeroDesigner.getInstance().getPrefs().setDialogY(this.getSize().height);
        }
        if (!bl && this.isVisible()) {
            super.setVisible(false);
            this.dispose();
        } else {
            super.setVisible(bl);
        }
    }

    public void updateValues() {
        GenericObject genericObject;
        Object object;
        String string;
        int n;
        Object object2;
        int n2;
        if (this.object.getAssignedModifiers() != null) {
            for (Modifier modifier : this.object.getAssignedModifiers()) {
                modifier.setParent(this.object);
            }
        }
        if (this.object.getEndUsage() == 0 || GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") == null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment(), "ENDURANCERESERVE") == null || GenericObject.findObjectByID(this.object.getAssignedModifiers(), "ENDRESERVEOREND") != null) {
            this.endSourceLbl.setVisible(false);
            this.endSourceCombo.setVisible(false);
        } else {
            this.endSourceLbl.setVisible(true);
            this.endSourceCombo.setVisible(true);
        }
        if (this.object.getNotes() != null && this.object.getNotes().trim().length() > 0) {
            this.notesBtn.setText("Edit Notes...");
        } else {
            this.notesBtn.setText("Create Notes...");
        }
        if (this.levelTF != null) {
            this.levelTF.setMin(this.object.getMinimumLevel());
            this.levelTF.setMax(this.object.getMaxLevel());
            this.levelTF.setCurrent(this.object.getLevels());
        }
        if (!(this.object.getActiveCost() == this.object.getTotalCost() && this.object.getRealCost() == this.object.getTotalCost() || this.object instanceof Modifier || this.object instanceof Disadvantage)) {
            this.displayActivePointsCB.setVisible(true);
        } else {
            this.displayActivePointsCB.setVisible(false);
        }
        this.customAdderBtn.setVisible(this.object.allowsOtherAdders());
        this.addModifierBtn.setVisible(this.object.allowsOtherModifiers());
        if (this.pointsTF != null && this.pointsTF.isShowing()) {
            this.pointsTF.setMin((int)Rounder.roundHalfUp(this.object.getMinimumCost()));
            this.pointsTF.setMax((int)Rounder.roundHalfUp(this.object.getMaxCost()));
            this.pointsTF.setCurrent((int)Rounder.roundHalfUp(this.object.getBaseCost()));
        }
        this.activePointsLbl.setText("Active Points: " + Rounder.roundUp(this.object.getActiveCost()));
        this.realCostLbl.setText("Real Cost: " + Rounder.roundUp(this.object.getRealCost()));
        if (!this.object.getAlias().equals(this.displayTF.getText())) {
            try {
                this.displayTF.setText(this.object.getAlias());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<String> arrayList = new ArrayList();
        for (n2 = 0; n2 < this.adderPanels.size(); ++n2) {
            object2 = this.adderPanels.get(n2);
            if (!((AdderPanel)object2).isSelected()) continue;
            for (n = 0; n < ((AdderPanel)object2).getAdder().getExcludes().size(); ++n) {
                String string2 = ((AdderPanel)object2).getAdder().getExcludes().get(n);
                arrayList.add(string2.toUpperCase().trim());
            }
        }
        for (n2 = 0; n2 < this.adderPanels.size(); ++n2) {
            object2 = this.adderPanels.get(n2);
            if (arrayList.size() > 0 && arrayList.contains(((AdderPanel)object2).getAdder().getXMLID().toUpperCase().trim())) {
                ((AdderPanel)object2).setSelectionLocked(true);
                ((AdderPanel)object2).setSelected(false);
            } else {
                ((AdderPanel)object2).setSelectionLocked(false);
            }
            n = ((AdderPanel)object2).getAdder().getRequires().size() == 0 ? 1 : 0;
            for (int i = 0; i < ((AdderPanel)object2).getAdder().getRequires().size(); ++i) {
                string = ((AdderPanel)object2).getAdder().getRequires().get(i).toUpperCase().trim();
                object = this.getAdderFromList(string, this.object.getAssignedAdders());
                if (object != null && ((Adder)object).isSelected()) {
                    ((AdderPanel)object2).setSelectionLocked(false);
                    ((AdderPanel)object2).setEnabled(true);
                    n = 1;
                    break;
                }
                genericObject = this.getModifierFromList(string, this.object.getAssignedModifiers());
                if (genericObject == null) continue;
                ((AdderPanel)object2).setSelectionLocked(false);
                ((AdderPanel)object2).setEnabled(true);
                n = 1;
                break;
            }
            if (n == 0) {
                ((AdderPanel)object2).setSelectionLocked(true);
                ((AdderPanel)object2).setSelected(false);
                ((AdderPanel)object2).setEnabled(false);
            }
            ((AdderPanel)object2).updateValues();
        }
        arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < this.modifierPanels.size(); ++n2) {
            object2 = this.modifierPanels.get(n2);
            if (!((ModifierPanel)object2).isSelected()) continue;
            for (n = 0; n < ((ModifierPanel)object2).getModifier().getExcludes().size(); ++n) {
                String string3 = ((ModifierPanel)object2).getModifier().getExcludes().get(n);
                arrayList.add(string3.toUpperCase().trim());
            }
        }
        for (n2 = 0; n2 < this.modifierPanels.size(); ++n2) {
            object2 = this.modifierPanels.get(n2);
            if (arrayList.size() > 0 && arrayList.contains(((ModifierPanel)object2).getModifier().getXMLID().toUpperCase().trim())) {
                ((ModifierPanel)object2).setSelectionLocked(true);
                ((ModifierPanel)object2).setSelected(false);
            } else {
                ((ModifierPanel)object2).setSelectionLocked(false);
            }
            n = ((ModifierPanel)object2).getModifier().getRequires().size() == 0 ? 1 : 0;
            for (int i = 0; i < ((ModifierPanel)object2).getModifier().getRequires().size(); ++i) {
                GenericObject genericObject2;
                int n3;
                string = ((ModifierPanel)object2).getModifier().getRequires().get(i).toUpperCase().trim();
                object = null;
                if (string.indexOf(".") > 0 && string.indexOf(".") < string.length() - 1) {
                    object = string.substring(string.indexOf(".") + 1, string.length());
                    if (((String)object).trim().length() == 0) {
                        object = null;
                    }
                    string = string.substring(0, string.indexOf("."));
                }
                genericObject = null;
                for (n3 = 0; n3 < this.object.getAssignedModifiers().size(); ++n3) {
                    genericObject2 = this.object.getAssignedModifiers().get(n3);
                    if (!genericObject2.getXMLID().equals(string) || object != null && (genericObject2.getSelectedOption() == null || !genericObject2.getSelectedOption().getXMLID().equalsIgnoreCase((String)object))) continue;
                    genericObject = genericObject2;
                    break;
                }
                if (genericObject == null) {
                    for (n3 = 0; n3 < this.object.getAssignedAdders().size(); ++n3) {
                        genericObject2 = this.object.getAssignedAdders().get(n3);
                        if (!genericObject2.getXMLID().equals(string) || object != null && (genericObject2.getSelectedOption() == null || !genericObject2.getSelectedOption().getXMLID().equalsIgnoreCase((String)object))) continue;
                        genericObject = genericObject2;
                        break;
                    }
                }
                if (genericObject == null) continue;
                ((ModifierPanel)object2).setSelectionLocked(false);
                ((ModifierPanel)object2).setEnabled(true);
                n = 1;
                break;
            }
            if (n == 0) {
                ((ModifierPanel)object2).setSelectionLocked(true);
                ((ModifierPanel)object2).setSelected(false);
                ((ModifierPanel)object2).setEnabled(false);
            }
            ((ModifierPanel)object2).updateValues();
        }
        if (this.object instanceof SenseAdder) {
            this.optionsCB.removeItemListener(this.optionListener);
            ((JTextField)this.optionsCB.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this.optionAliasListener);
            ArrayList<Adder> arrayList2 = this.object.getOptions();
            this.optionsCB.removeAllItems();
            object2 = this.object.getSelectedOption();
            for (n = 0; n < arrayList2.size(); ++n) {
                this.optionsCB.addItem(arrayList2.get(n));
            }
            this.optionsCB.setSelectedItem(object2);
            this.optionsCB.addItemListener(this.optionListener);
            ((JTextField)this.optionsCB.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.optionAliasListener);
        }
        if (this.object.getExamples() != null && this.object.getExamples().size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = ((JTextField)GenericDialog.this.exampleCombo.getEditor().getEditorComponent()).getText();
                    GenericDialog.this.exampleCombo.removeAllItems();
                    for (String string2 : GenericDialog.this.object.getExamples()) {
                        GenericDialog.this.exampleCombo.addItem(string2);
                    }
                    ((JTextField)GenericDialog.this.exampleCombo.getEditor().getEditorComponent()).setText(string);
                }
            });
        }
        Enumeration<JLabel> enumeration = this.requiredLevelAdderLabels.keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            Adder adder = this.requiredLevelAdderLabels.get(object2);
            ((JLabel)object2).setText(adder.getAlias());
        }
        this.validate();
    }

    private class RequiredAdderComboListener
    implements ItemListener {
        Adder adder;
        JComboBox combo;
        DocumentListener listener;

        public RequiredAdderComboListener(Adder adder, JComboBox jComboBox) {
            this.adder = adder;
            this.combo = jComboBox;
            this.listener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (RequiredAdderComboListener.this.adder.getSelectedOption() != null) {
                        RequiredAdderComboListener.this.adder.getSelectedOption().setAlias(((JTextField)RequiredAdderComboListener.this.combo.getEditor().getEditorComponent()).getText());
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (RequiredAdderComboListener.this.adder.getSelectedOption() != null) {
                        RequiredAdderComboListener.this.adder.getSelectedOption().setAlias(((JTextField)RequiredAdderComboListener.this.combo.getEditor().getEditorComponent()).getText());
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (RequiredAdderComboListener.this.adder.getSelectedOption() != null) {
                        RequiredAdderComboListener.this.adder.getSelectedOption().setAlias(((JTextField)RequiredAdderComboListener.this.combo.getEditor().getEditorComponent()).getText());
                    }
                }
            };
            ((JTextField)this.combo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.listener);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.combo.getSelectedItem() == null) {
                return;
            }
            if (this.combo.getSelectedItem() instanceof Adder) {
                ((JTextField)this.combo.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this.listener);
                Adder adder = (Adder)this.combo.getSelectedItem();
                String string = adder.getAlias();
                this.adder.setSelectedOption(adder);
                GenericDialog.this.updateValues();
                GenericDialog.this.layoutExtrasPanel();
                ((JTextField)this.combo.getEditor().getEditorComponent()).setText(string);
                this.adder.getSelectedOption().setAlias(string);
                ((JTextField)this.combo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.listener);
            }
        }
    }

    private class RequiredAdderLevelListener
    implements PropertyChangeListener {
        Adder adder;
        LevelTF tf;

        public RequiredAdderLevelListener(Adder adder, LevelTF levelTF) {
            this.adder = adder;
            this.tf = levelTF;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.adder.setLevels(this.tf.getCurrent());
            GenericDialog.this.updateValues();
        }
    }

    protected class MultiplierDialog
    extends JDialog {
        private static final long serialVersionUID = 3337484664394711637L;
        private JLabel multiplierLbl;
        private JTextField multiplierTF;
        private JLabel notesLbl;
        private JButton closeBtn;
        private MultiplierDialog dialogRef;

        public MultiplierDialog() {
            super(GenericDialog.this, "Cost Multiplier", true);
            this.dialogRef = this;
            this.initWidgets();
            this.initListeners();
            this.layoutComponent();
            this.pack();
        }

        private void initListeners() {
            this.multiplierTF.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (MultiplierDialog.this.multiplierTF.getText().trim().length() > 0) {
                        GenericDialog.this.object.setMultiplier(Double.parseDouble(MultiplierDialog.this.multiplierTF.getText()));
                    } else {
                        GenericDialog.this.object.setMultiplier(1.0);
                    }
                    GenericDialog.this.updateValues();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (MultiplierDialog.this.multiplierTF.getText().trim().length() > 0) {
                        GenericDialog.this.object.setMultiplier(Double.parseDouble(MultiplierDialog.this.multiplierTF.getText()));
                    } else {
                        GenericDialog.this.object.setMultiplier(1.0);
                    }
                    GenericDialog.this.updateValues();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (MultiplierDialog.this.multiplierTF.getText().trim().length() > 0) {
                        GenericDialog.this.object.setMultiplier(Double.parseDouble(MultiplierDialog.this.multiplierTF.getText()));
                    } else {
                        GenericDialog.this.object.setMultiplier(1.0);
                    }
                    GenericDialog.this.updateValues();
                }
            });
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultiplierDialog.this.dialogRef.setVisible(false);
                }
            });
        }

        private void initWidgets() {
            this.multiplierLbl = new JLabel("Cost Multiplier: ");
            this.multiplierTF = new JTextField(new DoubleDocument(500.0, 0.0), "" + GenericDialog.this.object.getMultiplier(), 6);
            this.notesLbl = new JLabel("<html><b>Note:</b>  A cost multiplier is intended as a convenience item only.<br>It is not an official part of the Hero System 5th Edition or the Hero System 6th Edition rules<br>and should only be used with GM permission.");
            this.closeBtn = new JButton("Close");
        }

        private void layoutComponent() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.multiplierLbl, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.multiplierTF, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 15, 5, 15);
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)this.notesLbl, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 15;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)this.closeBtn, gridBagConstraints);
            this.setContentPane(jPanel);
        }
    }
}

