/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.util.HTMLWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExportTemplateDialog
extends JFileChooser {
    private static final long serialVersionUID = -4653550701748791856L;
    JList availableList;
    JScrollPane availableScroll;
    JEditorPane descriptionTA;
    JScrollPane descriptionScroll;
    JLabel availableLbl;
    JLabel descriptionLbl;
    JButton selectBtn;
    JButton cancelBtn;
    String extension;
    boolean cancelButtonClicked;
    private File dir;

    public ExportTemplateDialog() {
        this(".HDE");
    }

    public ExportTemplateDialog(String string) {
        File file;
        this.extension = string;
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.setControlButtonsAreShown(false);
        this.setDialogTitle("Select Export Template");
        this.setMultiSelectionEnabled(false);
        this.setFileSelectionMode(1);
        String string2 = HeroDesigner.getInstance().getPrefs().getExportTemplateDir();
        if (string2 == null) {
            string2 = "ExportTemplates";
        }
        if ((file = new File(string2)).exists()) {
            this.setCurrentDirectory(file.getAbsoluteFile());
            this.setSelectedFile(file.getAbsoluteFile());
            try {
                this.setListItems();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        javax.swing.filechooser.FileFilter fileFilter = new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    try {
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Export Template Directories";
            }
        };
        this.setFileFilter(fileFilter);
        this.setMaximumSize(HeroDesigner.getAppFrame().getSize());
        if (this.availableList.getSelectedValue() == null) {
            if (this.availableList.getModel().getSize() > 0) {
                this.descriptionTA.setText("Please select a template...");
            } else {
                this.descriptionTA.setText("Please select a directory which contains Export Templates (" + this.extension + " files)");
            }
        }
    }

    public boolean canceled() {
        return this.cancelButtonClicked;
    }

    public String getSelectedPath() {
        if (this.cancelButtonClicked || this.availableList.getSelectedValue() == null) {
            return null;
        }
        ExportListItem exportListItem = (ExportListItem)this.availableList.getSelectedValue();
        return exportListItem.getPath();
    }

    private void initListeners() {
        this.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ExportTemplateDialog.this.setListItems();
                    if (ExportTemplateDialog.this.availableList.getSelectedValue() == null) {
                        if (ExportTemplateDialog.this.availableList.getModel().getSize() > 0) {
                            ExportTemplateDialog.this.descriptionTA.setText("Please select a template...");
                        } else {
                            ExportTemplateDialog.this.descriptionTA.setText("Please select a directory which contains Export Templates (" + ExportTemplateDialog.this.extension + " files)");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportTemplateDialog.this.cancelButtonClicked = true;
                ExportTemplateDialog.this.cancelSelection();
            }
        });
        this.selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportTemplateDialog.this.cancelButtonClicked = false;
                ExportTemplateDialog.this.approveSelection();
            }
        });
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ExportTemplateDialog.this.availableList.getSelectedValue() != null) {
                    ExportListItem exportListItem = (ExportListItem)ExportTemplateDialog.this.availableList.getSelectedValue();
                    ExportTemplateDialog.this.descriptionTA.setText(exportListItem.getDescription());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ExportTemplateDialog.this.descriptionScroll.getVerticalScrollBar().setValue(0);
                            ExportTemplateDialog.this.selectBtn.setEnabled(true);
                        }
                    });
                } else {
                    if (ExportTemplateDialog.this.availableList.getModel().getSize() > 0) {
                        ExportTemplateDialog.this.descriptionTA.setText("Please select a template...");
                    } else {
                        ExportTemplateDialog.this.descriptionTA.setText("Please select a directory which contains Export Templates (" + ExportTemplateDialog.this.extension + " files)");
                    }
                    ExportTemplateDialog.this.selectBtn.setEnabled(false);
                }
            }
        });
        this.availableList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ExportTemplateDialog.this.selectBtn.doClick();
                }
            }
        });
    }

    private void initWidgets() {
        this.availableList = new JList();
        this.availableList.setSelectionMode(0);
        this.availableScroll = new JScrollPane(this.availableList);
        this.availableScroll.setPreferredSize(new Dimension(400, 200));
        this.descriptionTA = new JEditorPane();
        this.descriptionTA.setContentType("text/html");
        this.descriptionTA.setEditable(false);
        this.descriptionTA.setBackground(Color.white);
        this.descriptionScroll = new JScrollPane(this.descriptionTA);
        this.descriptionScroll.setPreferredSize(new Dimension(400, 200));
        this.availableLbl = new JLabel("Available:");
        this.descriptionLbl = new JLabel("Description:");
        this.selectBtn = new JButton("Select");
        this.selectBtn.setEnabled(false);
        this.cancelBtn = new JButton("Cancel");
    }

    private void layoutComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 2, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.availableLbl, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.descriptionLbl, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 5, 5);
        jPanel.add((Component)this.availableScroll, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.descriptionScroll, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.selectBtn);
        jPanel2.add(this.cancelBtn);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.setAccessory(jPanel);
    }

    private void setListItems() throws Exception {
        File[] fileArray;
        ArrayList<ExportListItem> arrayList = new ArrayList<ExportListItem>();
        File file = this.getSelectedFile();
        if (this.dir != null && file != null && file.getAbsolutePath().equals(this.dir.getAbsolutePath())) {
            return;
        }
        this.dir = file;
        if (this.dir == null) {
            this.availableList.setListData(new ArrayList().toArray());
            return;
        }
        if (!this.dir.isDirectory()) {
            this.dir = this.dir.getAbsoluteFile().getParentFile();
        }
        if ((fileArray = this.dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toUpperCase().endsWith(ExportTemplateDialog.this.extension);
            }
        })) == null) {
            this.availableList.setListData(new ArrayList().toArray());
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            HTMLWriter hTMLWriter = new HTMLWriter(fileArray[i]);
            ExportListItem exportListItem = new ExportListItem(hTMLWriter.getName(), hTMLWriter.getDescription(), fileArray[i].getAbsolutePath());
            arrayList.add(exportListItem);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        this.availableList.setListData(arrayList.toArray());
    }

    private class ExportListItem {
        String name;
        String description;
        String path;

        ExportListItem(String string, String string2, String string3) {
            this.name = string;
            if (string == null) {
                this.name = "[unknown]";
            }
            this.description = string2;
            if (string2 == null) {
                this.description = "No description available.";
            }
            this.path = string3;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.name + " (" + new File(this.path).getName() + ")";
        }
    }
}

