/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.List;
import com.hero.objects.enhancers.Enhancer;
import com.hero.ui.dialog.ListDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnhancerDialog
extends ListDialog {
    private static final long serialVersionUID = -1006747877148119505L;
    private JLabel rollTypeLbl;
    private JComboBox rollTypeCombo;

    public EnhancerDialog(List list, boolean bl) {
        super(list, bl);
        if (bl) {
            this.setTitle("New Skill Enhancer");
        } else {
            this.setTitle(list.getAlias());
        }
        this.init();
        this.displayLbl.setText("List Name:");
        if (bl) {
            this.okBtn.setEnabled(false);
        }
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.carriedCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        this.equipmentPanel.add((Component)this.weightLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.weightTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.equipmentPanel.add((Component)new JLabel(HeroDesigner.getInstance().getPrefs().isMetric() ? "kg" : "lbs"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.priceLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            jPanel.add(this.priceTF);
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        } else {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.priceTF);
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        }
        this.equipmentPanel.setBorder(BorderFactory.createTitledBorder("Equipment Info."));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.displayLbl, gridBagConstraints);
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.displayTF, gridBagConstraints);
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers()) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)this.rollTypeLbl, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.rollTypeCombo, gridBagConstraints);
        }
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        if (this.object.isEquipment()) {
            jPanel.add((Component)this.equipmentPanel, gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.displayTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                EnhancerDialog.this.okBtn.setEnabled(EnhancerDialog.this.displayTF.getText().trim().length() > 0);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                EnhancerDialog.this.okBtn.setEnabled(EnhancerDialog.this.displayTF.getText().trim().length() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                EnhancerDialog.this.okBtn.setEnabled(EnhancerDialog.this.displayTF.getText().trim().length() > 0);
            }
        });
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers()) {
            this.rollTypeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    Enhancer enhancer = (Enhancer)EnhancerDialog.this.object;
                    enhancer.setIntBased(EnhancerDialog.this.rollTypeCombo.getSelectedIndex() == 1);
                }
            });
        }
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.addModifierBtn.setText("Add Common Modifier...");
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers()) {
            this.rollTypeLbl = new JLabel("Roll Base:");
            Vector<String> vector = new Vector<String>();
            vector.add("General (11-)");
            vector.add("INT-based");
            this.rollTypeCombo = new JComboBox(vector);
            Enhancer enhancer = (Enhancer)this.object;
            if (enhancer.getIntBased()) {
                this.rollTypeCombo.setSelectedIndex(1);
            }
        }
    }

    @Override
    protected void layoutComponent() {
        this.layoutExtrasPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.extrasPanel.add((Component)this.adderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.privateAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.extrasPanel.add((Component)this.customAdderPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.extrasPanel.add((Component)this.modifierPanel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.getTopPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.extrasScroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.customAdderBtn);
        jPanel2.add(this.privateAdderBtn);
        jPanel2.add(this.addModifierBtn);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 15;
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.notesBtn);
        jPanel3.add(this.multiplierBtn);
        jPanel3.add(this.okBtn);
        jPanel3.add(this.deleteBtn);
        jPanel3.add(this.cancelBtn);
        jPanel3.add(this.defineBtn);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.setContentPane(jPanel);
    }
}

