/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Duplication;
import com.hero.ui.dialog.PowerDialog;
import com.hero.ui.widgets.LevelTF;
import com.hero.ui.widgets.ModifierPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class DuplicationDialog
extends PowerDialog {
    private static final long serialVersionUID = 4194145930121452594L;
    private JLabel dupPointsLbl;
    private JLabel numberLbl;
    LevelTF dupPointsTF;
    LevelTF numberTF;
    JButton fileAssociationBtn;

    public DuplicationDialog(Duplication duplication, boolean bl) {
        super(duplication, bl, true);
    }

    void checkMods() {
        boolean bl = false;
        for (int i = 0; i < this.modifierPanels.size(); ++i) {
            ModifierPanel modifierPanel = (ModifierPanel)this.modifierPanels.get(i);
            if (GenericObject.findObjectByID(this.power.getAssignedModifiers(), modifierPanel.getModifier().getXMLID()) == null || modifierPanel.isSelected()) continue;
            bl = true;
            break;
        }
        if (bl || this.modifierPanels.size() != this.power.getAssignedModifiers().size()) {
            this.layoutExtrasPanel();
        }
    }

    @Override
    protected JPanel getModsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.fileAssociationBtn);
        jPanel.add(this.customAdderBtn);
        jPanel.add(this.privateAdderBtn);
        jPanel.add(this.addModifierBtn);
        return jPanel;
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel.add((Component)this.dupPointsLbl, gridBagConstraints);
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridy = 50;
        jPanel.add((Component)this.numberLbl, gridBagConstraints);
        gridBagConstraints.gridy = 29;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.damageLbl, gridBagConstraints);
        gridBagConstraints.gridy = 30;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.dupPointsTF, gridBagConstraints);
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridy = 50;
        jPanel.add((Component)this.numberTF, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.fileAssociationBtn.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                Duplication duplication = (Duplication)DuplicationDialog.this.power;
                if (duplication.getFilePath() != null && duplication.getFilePath().trim().length() > 0) {
                    duplication.clearFilePath();
                    DuplicationDialog.this.fileAssociationBtn.setText("Associate File...");
                    DuplicationDialog.this.updateValues();
                    return;
                }
                while (file == null) {
                    int n;
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDC");
                            }

                            @Override
                            public String getDescription() {
                                return "Hero Designer Character Files";
                            }
                        });
                        this.chooser.setApproveButtonText("Associate Character");
                        this.chooser.setDialogTitle("Open");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.getInstance().getPrefs().getSaveDir() != null && HeroDesigner.getInstance().getPrefs().getSaveDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getSaveDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if ((n = this.chooser.showOpenDialog(DuplicationDialog.this)) == 1) {
                        return;
                    }
                    if (n != 0 || (file = this.chooser.getSelectedFile()).exists()) continue;
                    file = null;
                }
                if (file == null || file.isDirectory()) {
                    return;
                }
                ((Duplication)DuplicationDialog.this.power).setFilePath(file.getAbsolutePath());
                DuplicationDialog.this.dupPointsTF.setCurrent(((Duplication)DuplicationDialog.this.power).getPoints());
                DuplicationDialog.this.fileAssociationBtn.setText("Remove File Association");
                DuplicationDialog.this.updateValues();
            }
        });
        this.dupPointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((Duplication)DuplicationDialog.this.power).setPoints(DuplicationDialog.this.dupPointsTF.getCurrent());
                DuplicationDialog.this.updateValues();
                DuplicationDialog.this.checkMods();
            }
        });
        this.numberTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((Duplication)DuplicationDialog.this.power).setMultiples(DuplicationDialog.this.numberTF.getCurrent());
                DuplicationDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        if (this.pointsLbl != null) {
            this.pointsLbl.setVisible(false);
        }
        if (this.pointsTF != null) {
            this.pointsTF.setVisible(false);
        }
        if (this.inputLbl != null) {
            this.inputLbl.setVisible(false);
        }
        if (this.exampleCombo != null) {
            this.exampleCombo.setVisible(false);
        }
        if (this.levelsLbl != null) {
            this.levelsLbl.setVisible(false);
        }
        if (this.levelTF != null) {
            this.levelTF.setVisible(false);
        }
        this.dupPointsLbl = new JLabel("Duplicate Points:");
        this.numberLbl = new JLabel("Number of Multiples:");
        this.dupPointsTF = new LevelTF(((Duplication)this.power).getPoints(), 9999, 0);
        this.numberTF = new LevelTF(((Duplication)this.power).getMultiples(), 9999, 1);
        this.fileAssociationBtn = new JButton("Associate File...");
        Duplication duplication = (Duplication)this.power;
        if (duplication.getFilePath() != null && duplication.getFilePath().trim().length() > 0) {
            this.fileAssociationBtn.setText("Remove File Association");
        }
    }

    @Override
    public void updateValues() {
        super.updateValues();
        Duplication duplication = (Duplication)this.power;
        if (duplication.getFilePath() != null) {
            this.damageLbl.setVisible(true);
            File file = new File(duplication.getFilePath());
            this.damageLbl.setText("(associated with " + file.getName() + ")");
        } else {
            this.damageLbl.setVisible(false);
        }
    }
}

