/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.CustomPower;
import com.hero.ui.dialog.PowerDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CustomPowerDialog
extends PowerDialog {
    private static final long serialVersionUID = -3772005866139357739L;
    protected CustomPower custompower;
    protected JLabel rangeLbl;
    protected JLabel durationLbl;
    protected JLabel targetLbl;
    protected JCheckBox usesENDCB;
    protected JCheckBox visibleCB;
    protected JComboBox rangeCombo;
    protected JComboBox durationCombo;
    protected JComboBox targetCombo;
    protected JLabel endSourceLbl;
    protected JComboBox endSourceCombo;
    protected JCheckBox doesBODYCB;
    protected JCheckBox doesDamageCB;
    protected JCheckBox doesKnockbackCB;
    protected JCheckBox killingCB;
    protected JLabel defenseLbl;
    protected JComboBox defenseCombo;
    protected JCheckBox useCustomColumn3CB;
    protected JLabel customColumn3Lbl;
    protected JTextField customColumn3TF;

    public CustomPowerDialog(CustomPower customPower, boolean bl, boolean bl2) {
        super(customPower, bl, bl2, false);
        this.custompower = customPower;
        this.init();
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.carriedCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        this.equipmentPanel.add((Component)this.weightLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.weightTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.equipmentPanel.add((Component)new JLabel(HeroDesigner.getInstance().getPrefs().isMetric() ? "kg" : "lbs"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.priceLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            jPanel.add(this.priceTF);
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        } else {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.priceTF);
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        }
        this.equipmentPanel.setBorder(BorderFactory.createTitledBorder("Equipment Info."));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.nameLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.nameTF, gridBagConstraints);
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.displayLbl, gridBagConstraints);
        gridBagConstraints.gridy = 25;
        if (this.object.getOptions().size() > 0) {
            jPanel.add((Component)this.optionsLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 30;
        jPanel.add((Component)this.levelsLbl, gridBagConstraints);
        gridBagConstraints.gridy = 37;
        jPanel.add((Component)this.endSourceLbl, gridBagConstraints);
        gridBagConstraints.gridy = 40;
        jPanel.add((Component)this.rangeLbl, gridBagConstraints);
        gridBagConstraints.gridy = 41;
        jPanel.add((Component)this.durationLbl, gridBagConstraints);
        gridBagConstraints.gridy = 42;
        jPanel.add((Component)this.targetLbl, gridBagConstraints);
        gridBagConstraints.gridy = 43;
        jPanel.add((Component)this.defenseLbl, gridBagConstraints);
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.displayTF, gridBagConstraints);
        gridBagConstraints.gridy = 25;
        if (this.object.getOptions().size() > 0) {
            jPanel.add((Component)this.optionsCB, gridBagConstraints);
        }
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.levelTF, gridBagConstraints);
        gridBagConstraints.gridy = 31;
        jPanel.add((Component)this.usesENDCB, gridBagConstraints);
        gridBagConstraints.gridy = 32;
        jPanel.add((Component)this.useCustomColumn3CB, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.customColumn3Lbl);
        jPanel2.add(this.customColumn3TF);
        gridBagConstraints.gridy = 33;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 34;
        jPanel.add((Component)this.visibleCB, gridBagConstraints);
        gridBagConstraints.gridy = 35;
        jPanel.add((Component)this.doesDamageCB, gridBagConstraints);
        gridBagConstraints.gridy = 36;
        jPanel.add((Component)this.doesBODYCB, gridBagConstraints);
        gridBagConstraints.gridy = 37;
        jPanel.add((Component)this.killingCB, gridBagConstraints);
        gridBagConstraints.gridy = 38;
        jPanel.add((Component)this.doesKnockbackCB, gridBagConstraints);
        gridBagConstraints.gridy = 39;
        jPanel.add((Component)this.endSourceCombo, gridBagConstraints);
        gridBagConstraints.gridy = 40;
        jPanel.add((Component)this.rangeCombo, gridBagConstraints);
        gridBagConstraints.gridy = 41;
        jPanel.add((Component)this.durationCombo, gridBagConstraints);
        gridBagConstraints.gridy = 42;
        jPanel.add((Component)this.targetCombo, gridBagConstraints);
        gridBagConstraints.gridy = 43;
        jPanel.add((Component)this.defenseCombo, gridBagConstraints);
        if (this.object.isUserInput()) {
            gridBagConstraints.gridy = 44;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.inputLbl, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.exampleCombo, gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 84;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.quantityLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.quantityTF, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        if (this.object.isEquipment()) {
            jPanel.add((Component)this.equipmentPanel, gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.doesBODYCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPowerDialog.this.custompower.setDoesBODY(CustomPowerDialog.this.doesBODYCB.isSelected());
            }
        });
        this.doesDamageCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPowerDialog.this.custompower.setDoesDamage(CustomPowerDialog.this.doesDamageCB.isSelected());
                CustomPowerDialog.this.doesBODYCB.setEnabled(CustomPowerDialog.this.doesDamageCB.isSelected());
                CustomPowerDialog.this.killingCB.setEnabled(CustomPowerDialog.this.doesDamageCB.isSelected());
            }
        });
        this.doesKnockbackCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPowerDialog.this.custompower.setDoesKnockback(CustomPowerDialog.this.doesKnockbackCB.isSelected());
            }
        });
        this.killingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPowerDialog.this.custompower.setKilling(CustomPowerDialog.this.killingCB.isSelected());
            }
        });
        this.defenseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CustomPowerDialog.this.custompower.setDefense(CustomPowerDialog.this.defenseCombo.getSelectedItem().toString().toUpperCase());
            }
        });
        this.visibleCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPowerDialog.this.custompower.setVisible(CustomPowerDialog.this.visibleCB.isSelected());
            }
        });
        this.usesENDCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomPowerDialog.this.custompower.usesEnd(CustomPowerDialog.this.usesENDCB.isSelected());
                boolean bl = CustomPowerDialog.this.useCustomColumn3CB.isSelected();
                CustomPowerDialog.this.useCustomColumn3CB.setEnabled(!CustomPowerDialog.this.usesENDCB.isSelected());
                CustomPowerDialog.this.customColumn3TF.setEnabled(bl && !CustomPowerDialog.this.usesENDCB.isSelected());
                CustomPowerDialog.this.customColumn3Lbl.setEnabled(bl && !CustomPowerDialog.this.usesENDCB.isSelected());
                CustomPowerDialog.this.updateValues();
            }
        });
        this.endSourceCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CustomPowerDialog.this.custompower.setUseENDReserve(CustomPowerDialog.this.endSourceCombo.getSelectedIndex() == 1);
            }
        });
        this.rangeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CustomPowerDialog.this.rangeCombo.getSelectedIndex() == 0) {
                    CustomPowerDialog.this.custompower.setRange("SELF");
                } else if (CustomPowerDialog.this.rangeCombo.getSelectedIndex() == 1) {
                    CustomPowerDialog.this.custompower.setRange("NO");
                } else if (CustomPowerDialog.this.rangeCombo.getSelectedIndex() == 2) {
                    CustomPowerDialog.this.custompower.setRange("YES");
                } else if (CustomPowerDialog.this.rangeCombo.getSelectedIndex() == 3) {
                    CustomPowerDialog.this.custompower.setRange("LOS");
                }
            }
        });
        this.durationCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CustomPowerDialog.this.durationCombo.getSelectedIndex() == 0) {
                    CustomPowerDialog.this.custompower.setDuration("INSTANT");
                } else if (CustomPowerDialog.this.durationCombo.getSelectedIndex() == 1) {
                    CustomPowerDialog.this.custompower.setDuration("CONSTANT");
                } else if (CustomPowerDialog.this.durationCombo.getSelectedIndex() == 2) {
                    CustomPowerDialog.this.custompower.setDuration("PERSISTENT");
                } else if (CustomPowerDialog.this.durationCombo.getSelectedIndex() == 3) {
                    CustomPowerDialog.this.custompower.setDuration("INHERENT");
                }
            }
        });
        this.targetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CustomPowerDialog.this.targetCombo.getSelectedIndex() == 0) {
                    CustomPowerDialog.this.custompower.setTarget("N/A");
                } else if (CustomPowerDialog.this.targetCombo.getSelectedIndex() == 1) {
                    CustomPowerDialog.this.custompower.setTarget("SELFONLY");
                } else if (CustomPowerDialog.this.targetCombo.getSelectedIndex() == 2) {
                    CustomPowerDialog.this.custompower.setTarget("DCV");
                } else if (CustomPowerDialog.this.targetCombo.getSelectedIndex() == 3) {
                    CustomPowerDialog.this.custompower.setTarget("ECV");
                } else if (CustomPowerDialog.this.targetCombo.getSelectedIndex() == 4) {
                    CustomPowerDialog.this.custompower.setTarget("HEX");
                }
            }
        });
        this.customColumn3TF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CustomPowerDialog.this.custompower.setColumn3Output(CustomPowerDialog.this.customColumn3TF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CustomPowerDialog.this.custompower.setColumn3Output(CustomPowerDialog.this.customColumn3TF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CustomPowerDialog.this.custompower.setColumn3Output(CustomPowerDialog.this.customColumn3TF.getText());
            }
        });
        this.useCustomColumn3CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CustomPowerDialog.this.useCustomColumn3CB.isSelected();
                CustomPowerDialog.this.custompower.setUseCustomColumn3(bl);
                CustomPowerDialog.this.customColumn3TF.setEnabled(bl);
                CustomPowerDialog.this.customColumn3Lbl.setEnabled(bl);
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        this.levelsLbl.setText("Base Cost:");
        this.rangeLbl = new JLabel("Range:");
        this.durationLbl = new JLabel("Duration:");
        this.targetLbl = new JLabel("Target:");
        this.usesENDCB = new JCheckBox("Uses END");
        this.usesENDCB.setSelected(this.custompower.getAPPerEnd() != 0);
        this.visibleCB = HeroDesigner.getActiveTemplate().is6E() ? new JCheckBox("Perceivable") : new JCheckBox("Visible");
        this.visibleCB.setSelected(this.custompower.isVisible());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("Self");
        } else {
            arrayList.add("Self Only");
        }
        arrayList.add("None");
        arrayList.add("Ranged");
        arrayList.add("Line of Sight");
        this.rangeCombo = new JComboBox<Object>(arrayList.toArray());
        if (this.custompower.getRange().equals("SELF")) {
            this.rangeCombo.setSelectedIndex(0);
        } else if (this.custompower.getRange().toUpperCase().equals("NO")) {
            this.rangeCombo.setSelectedIndex(1);
        } else if (this.custompower.getRange().toUpperCase().equals("YES")) {
            this.rangeCombo.setSelectedIndex(2);
        } else if (this.custompower.getRange().toUpperCase().equals("LOS")) {
            this.rangeCombo.setSelectedIndex(3);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("Instant");
        arrayList2.add("Constant");
        arrayList2.add("Persistent");
        arrayList2.add("Inherent");
        this.durationCombo = new JComboBox<Object>(arrayList2.toArray());
        if (this.custompower.getDuration().toUpperCase().equals("INSTANT")) {
            this.durationCombo.setSelectedIndex(0);
        } else if (this.custompower.getDuration().toUpperCase().equals("CONSTANT")) {
            this.durationCombo.setSelectedIndex(1);
        } else if (this.custompower.getDuration().toUpperCase().equals("PERSISTENT")) {
            this.durationCombo.setSelectedIndex(2);
        } else if (this.custompower.getDuration().toUpperCase().equals("INHERENT")) {
            this.durationCombo.setSelectedIndex(3);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("N/A");
        arrayList3.add("Self Only");
        arrayList3.add("DCV");
        if (bl) {
            arrayList3.add("DMCV");
            arrayList3.add("Area");
        } else {
            arrayList3.add("ECV");
            arrayList3.add("HEX");
        }
        this.targetCombo = new JComboBox<Object>(arrayList3.toArray());
        if (this.custompower.getTarget().toUpperCase().equals("N/A")) {
            this.targetCombo.setSelectedIndex(0);
        } else if (this.custompower.getTarget().toUpperCase().equals("SELFONLY")) {
            this.targetCombo.setSelectedIndex(1);
        } else if (this.custompower.getTarget().toUpperCase().equals("DCV")) {
            this.targetCombo.setSelectedIndex(2);
        } else if (this.custompower.getTarget().toUpperCase().equals("ECV")) {
            this.targetCombo.setSelectedIndex(3);
        } else if (this.custompower.getTarget().toUpperCase().equals("HEX")) {
            this.targetCombo.setSelectedIndex(4);
        }
        this.endSourceLbl = new JLabel("END Source:");
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList4.add("Personal END");
        arrayList4.add("END Reserve");
        this.endSourceCombo = new JComboBox<Object>(arrayList4.toArray());
        if (this.custompower.getUseENDReserve()) {
            this.endSourceCombo.setSelectedIndex(1);
        } else {
            this.endSourceCombo.setSelectedIndex(0);
        }
        if (this.custompower.getEndUsage() == 0 || GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") == null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment(), "ENDURANCERESERVE") == null || GenericObject.findObjectByID(this.custompower.getAssignedModifiers(), "ENDRESERVEOREND") != null) {
            this.endSourceLbl.setVisible(false);
            this.endSourceCombo.setVisible(false);
        }
        this.doesDamageCB = new JCheckBox("Does Damage");
        this.doesDamageCB.setSelected(this.custompower.doesDamage());
        this.doesBODYCB = new JCheckBox("Does BODY");
        this.doesBODYCB.setSelected(this.custompower.doesBODY());
        this.doesBODYCB.setEnabled(this.custompower.doesDamage());
        this.doesKnockbackCB = new JCheckBox("Does Knockback");
        this.doesKnockbackCB.setSelected(this.custompower.doesKnockback());
        this.killingCB = new JCheckBox("Does Killing Damage");
        this.killingCB.setSelected(this.custompower.isKilling());
        this.killingCB.setEnabled(this.custompower.doesDamage());
        ArrayList<String> arrayList5 = new ArrayList<String>();
        arrayList5.add("None");
        arrayList5.add("Normal");
        arrayList5.add("Mental");
        arrayList5.add("Power");
        arrayList5.add("Flash");
        this.defenseLbl = new JLabel("Defense:");
        this.defenseCombo = new JComboBox<Object>(arrayList5.toArray());
        if (this.custompower.getDefense().equals("NONE")) {
            this.defenseCombo.setSelectedIndex(0);
        } else if (this.custompower.getDefense().equals("NORMAL")) {
            this.defenseCombo.setSelectedIndex(1);
        } else if (this.custompower.getDefense().equals("MENTAL")) {
            this.defenseCombo.setSelectedIndex(2);
        } else if (this.custompower.getDefense().equals("POWER")) {
            this.defenseCombo.setSelectedIndex(3);
        } else if (this.custompower.getDefense().equals("FLASH")) {
            this.defenseCombo.setSelectedIndex(4);
        }
        this.useCustomColumn3CB = new JCheckBox("Define Custom END Column Output");
        this.useCustomColumn3CB.setSelected(this.custompower.useCustomColumn3());
        this.useCustomColumn3CB.setEnabled(this.custompower.getAPPerEnd() == 0);
        this.customColumn3Lbl = new JLabel("END Column Output:");
        this.customColumn3Lbl.setEnabled(this.custompower.useCustomColumn3());
        this.customColumn3TF = new JTextField(this.custompower.getColumn3Output(), 4);
        this.customColumn3TF.setEnabled(this.custompower.useCustomColumn3());
    }

    @Override
    public void updateValues() {
        super.updateValues();
        if (this.custompower.getEndUsage() == 0 || GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") == null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment(), "ENDURANCERESERVE") == null || GenericObject.findObjectByID(this.custompower.getAssignedModifiers(), "ENDRESERVEOREND") != null) {
            this.endSourceLbl.setVisible(false);
            this.endSourceCombo.setVisible(false);
        } else {
            this.endSourceLbl.setVisible(true);
            this.endSourceCombo.setVisible(true);
        }
    }
}

