/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.martialarts.Maneuver;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.LevelTF;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CustomManeuverDialog
extends GenericDialog {
    private static final long serialVersionUID = -395942732698168110L;
    protected Maneuver maneuver;
    private JLabel phaseLbl;
    JComboBox phaseCombo;
    private JLabel ocvLbl;
    LevelTF ocvTF;
    private JLabel dcvLbl;
    LevelTF dcvTF;
    private JLabel rangeLbl;
    LevelTF rangeTF;
    private JLabel damageTypeLbl;
    private JComboBox damageTypeCombo;
    private JLabel dcLbl;
    private LevelTF dcTF;
    private JLabel rangeInstructions;
    private JLabel effectLbl;
    private JLabel effectInstructionsLbl;
    JTextField effectTF;
    private JLabel typeLbl;
    JComboBox typeCombo;
    private JLabel effectiveActiveCostLbl;
    private LevelTF effectiveActiveCostTF;

    public CustomManeuverDialog(Maneuver maneuver, boolean bl, boolean bl2) {
        super(maneuver, bl, bl2);
        this.maneuver = maneuver;
        this.init();
        this.extrasPanel.setVisible(false);
        this.extrasScroll.setVisible(false);
        this.customAdderBtn.setVisible(false);
        this.addModifierBtn.setVisible(false);
        this.pack();
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel.add((Component)this.typeLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.typeCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 31;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel.add((Component)this.effectiveActiveCostLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.effectiveActiveCostTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 41;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.phaseLbl, gridBagConstraints);
        gridBagConstraints.gridy = 42;
        jPanel.add((Component)this.ocvLbl, gridBagConstraints);
        gridBagConstraints.gridy = 43;
        jPanel.add((Component)this.dcvLbl, gridBagConstraints);
        gridBagConstraints.gridy = 44;
        jPanel.add((Component)this.rangeLbl, gridBagConstraints);
        gridBagConstraints.gridy = 45;
        jPanel.add((Component)this.damageTypeLbl, gridBagConstraints);
        gridBagConstraints.gridy = 46;
        jPanel.add((Component)this.dcLbl, gridBagConstraints);
        gridBagConstraints.gridy = 47;
        jPanel.add((Component)this.effectLbl, gridBagConstraints);
        gridBagConstraints.gridy = 41;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.phaseCombo, gridBagConstraints);
        gridBagConstraints.gridy = 42;
        jPanel.add((Component)this.ocvTF, gridBagConstraints);
        gridBagConstraints.gridy = 43;
        jPanel.add((Component)this.dcvTF, gridBagConstraints);
        gridBagConstraints.gridy = 44;
        jPanel.add((Component)this.rangeTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.rangeInstructions, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 45;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.damageTypeCombo, gridBagConstraints);
        gridBagConstraints.gridy = 46;
        jPanel.add((Component)this.dcTF, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 47;
        jPanel.add((Component)this.effectTF, gridBagConstraints);
        gridBagConstraints.gridy = 48;
        jPanel.add((Component)this.effectInstructionsLbl, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CustomManeuverDialog.this.maneuver.setUseWeapon(CustomManeuverDialog.this.typeCombo.getSelectedIndex() == 1);
                CustomManeuverDialog.this.updateValues();
            }
        });
        this.damageTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CustomManeuverDialog.this.maneuver.setDamageType(CustomManeuverDialog.this.damageTypeCombo.getSelectedIndex());
                CustomManeuverDialog.this.updateValues();
            }
        });
        this.phaseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CustomManeuverDialog.this.maneuver.setPhase(CustomManeuverDialog.this.phaseCombo.getSelectedItem().toString());
            }
        });
        this.effectiveActiveCostTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = CustomManeuverDialog.this.effectiveActiveCostTF.getCurrent();
                CustomManeuverDialog.this.maneuver.setManeuverActiveCost(n);
                CustomManeuverDialog.this.updateValues();
            }
        });
        this.dcTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = CustomManeuverDialog.this.dcTF.getCurrent();
                CustomManeuverDialog.this.maneuver.setDC(n);
            }
        });
        this.ocvTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = CustomManeuverDialog.this.ocvTF.getCurrent();
                String string = "" + n;
                if (n >= 0) {
                    string = "+" + string;
                }
                CustomManeuverDialog.this.maneuver.setOCV(string);
            }
        });
        this.dcvTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = CustomManeuverDialog.this.dcvTF.getCurrent();
                String string = "" + n;
                if (n >= 0) {
                    string = "+" + string;
                }
                CustomManeuverDialog.this.maneuver.setDCV(string);
            }
        });
        this.rangeTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CustomManeuverDialog.this.maneuver.setRanged(CustomManeuverDialog.this.rangeTF.getCurrent());
            }
        });
        this.effectTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CustomManeuverDialog.this.maneuver.setEffect(CustomManeuverDialog.this.effectTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CustomManeuverDialog.this.maneuver.setEffect(CustomManeuverDialog.this.effectTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CustomManeuverDialog.this.maneuver.setEffect(CustomManeuverDialog.this.effectTF.getText());
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.pointsLbl.setText("Cost:");
        this.effectiveActiveCostLbl = new JLabel("Maneuver Active Cost:");
        this.effectiveActiveCostTF = new LevelTF(this.maneuver.getManeuverActiveCost(), 999, 0);
        this.phaseLbl = new JLabel("Phase:");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1/2");
        arrayList.add("1");
        arrayList.add("1+1");
        arrayList.add("var.");
        this.phaseCombo = new JComboBox<Object>(arrayList.toArray());
        this.phaseCombo.setSelectedItem(this.maneuver.getPhase());
        this.ocvLbl = new JLabel("OCV:");
        this.ocvTF = new LevelTF(this.maneuver.getOCVValue(), 10, -10);
        this.dcvLbl = new JLabel("DCV:");
        this.dcvTF = new LevelTF(this.maneuver.getDCVValue(), 10, -10);
        this.rangeLbl = new JLabel("Range:");
        this.rangeTF = new LevelTF(this.maneuver.getRanged(), 10, -1);
        this.rangeInstructions = new JLabel("Use -1 for No Range");
        this.damageTypeLbl = new JLabel("Damage Type:");
        this.dcLbl = new JLabel("DCs:");
        arrayList = new ArrayList();
        arrayList.add("None/Non-Damaging");
        arrayList.add("STR/Exert");
        arrayList.add("Normal Damage");
        arrayList.add("Killing Damage");
        arrayList.add("NND");
        arrayList.add("Flash");
        this.damageTypeCombo = new JComboBox<Object>(arrayList.toArray());
        this.damageTypeCombo.setSelectedIndex(this.maneuver.getDamageType());
        this.dcTF = new LevelTF(this.maneuver.getDC(), 4, 0);
        this.effectLbl = new JLabel("Effect:");
        this.effectTF = new JTextField(this.maneuver.getEffect());
        this.effectInstructionsLbl = new JLabel("[DAMAGE] will insert the maneuver's damage total at the specified point");
        this.typeLbl = new JLabel("Type");
        arrayList = new ArrayList();
        arrayList.add("Empty Hand");
        arrayList.add("Weapon");
        this.typeCombo = new JComboBox<Object>(arrayList.toArray());
        if (this.maneuver.useWeapon()) {
            this.typeCombo.setSelectedIndex(1);
        }
        this.setNameVisible(false);
    }

    @Override
    public void updateValues() {
        super.updateValues();
        this.addModifierBtn.setVisible(this.maneuver.allowsOtherModifiers());
        if (this.maneuver.useWeapon()) {
            this.damageTypeLbl.setVisible(false);
            this.damageTypeCombo.setVisible(false);
        } else {
            this.damageTypeLbl.setVisible(true);
            this.damageTypeCombo.setVisible(true);
        }
    }
}

