/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.model.DoubleDocument;
import com.hero.objects.Multipower;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Power;
import com.hero.ui.CompoundPowerPanel;
import com.hero.ui.GenericObjectList;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CompoundPowerDialog
extends PowerDialog {
    private static final long serialVersionUID = -53753516294513380L;
    CompoundPowerPanel powerPanel;

    public CompoundPowerDialog(Power power, boolean bl) {
        super(power, bl, true, false);
        this.init();
    }

    @Override
    public int display() {
        this.setVisible(true);
        if (this.cancelButtonClicked) {
            return 0;
        }
        if (this.deleteButtonClicked) {
            return -1;
        }
        if (this.okButtonClicked) {
            return 1;
        }
        return 0;
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.carriedCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        this.equipmentPanel.add((Component)this.weightLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.weightTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.equipmentPanel.add((Component)new JLabel(HeroDesigner.getInstance().getPrefs().isMetric() ? "kg" : "lbs"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        this.equipmentPanel.add((Component)this.priceLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            jPanel.add(this.priceTF);
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        } else {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 5, 2);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.priceTF);
            jPanel.add(new JLabel(HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits()));
            this.equipmentPanel.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        }
        this.equipmentPanel.setBorder(BorderFactory.createTitledBorder("Equipment Info."));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.nameLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.nameTF, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 84;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.quantityLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.quantityTF, gridBagConstraints);
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        if (this.object.isEquipment()) {
            jPanel.add((Component)this.equipmentPanel, gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    protected void init() {
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.pack();
        if (HeroDesigner.getInstance().getPrefs().isRememberDialogPosition()) {
            if (HeroDesigner.getInstance().getPrefs().getDialogX() > 50 && HeroDesigner.getInstance().getPrefs().getDialogY() > 50) {
                this.setSize(new Dimension(HeroDesigner.getInstance().getPrefs().getDialogX(), HeroDesigner.getInstance().getPrefs().getDialogY()));
            } else {
                this.setSize(this.getPreferredSize());
            }
            if (HeroDesigner.getInstance().getPrefs().getDialogScreenX() > 0 && HeroDesigner.getInstance().getPrefs().getDialogScreenY() > 0) {
                this.setLocation(HeroDesigner.getInstance().getPrefs().getDialogScreenX(), HeroDesigner.getInstance().getPrefs().getDialogScreenY());
            } else {
                this.setLocationRelativeTo(HeroDesigner.getAppFrame());
            }
        } else {
            this.setSize(this.getPreferredSize());
            this.setLocationRelativeTo(HeroDesigner.getAppFrame());
        }
        if (!HeroDesigner.getActiveHero().getRules().multiplierAllowed()) {
            this.multiplierBtn.setVisible(false);
        } else {
            this.multiplierBtn.setVisible(true);
        }
        this.updateValues();
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.multiplierBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericDialog.MultiplierDialog multiplierDialog = new GenericDialog.MultiplierDialog(CompoundPowerDialog.this);
                multiplierDialog.setLocationRelativeTo(CompoundPowerDialog.this);
                multiplierDialog.setVisible(true);
                multiplierDialog.dispose();
                CompoundPowerDialog.this.updateValues();
            }
        });
        this.powerPanel.addUpdateListener(new GenericObjectList.UpdateListener(this.powerPanel.getSelectionList()){

            @Override
            public void updatePerformed() {
                CompoundPowerDialog.this.updateValues();
            }
        });
        this.carriedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompoundPowerDialog.this.object.setCarried(CompoundPowerDialog.this.carriedCB.isSelected());
            }
        });
        this.priceTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (CompoundPowerDialog.this.priceTF.getText().trim().length() == 0) {
                    CompoundPowerDialog.this.object.setPrice(0.0);
                } else {
                    CompoundPowerDialog.this.object.setPrice(Double.parseDouble(CompoundPowerDialog.this.priceTF.getText()));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (CompoundPowerDialog.this.priceTF.getText().trim().length() == 0) {
                    CompoundPowerDialog.this.object.setPrice(0.0);
                } else {
                    CompoundPowerDialog.this.object.setPrice(Double.parseDouble(CompoundPowerDialog.this.priceTF.getText()));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (CompoundPowerDialog.this.priceTF.getText().trim().length() == 0) {
                    CompoundPowerDialog.this.object.setPrice(0.0);
                } else {
                    CompoundPowerDialog.this.object.setPrice(Double.parseDouble(CompoundPowerDialog.this.priceTF.getText()));
                }
            }
        });
        this.weightTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (CompoundPowerDialog.this.weightTF.getText().trim().length() == 0) {
                    CompoundPowerDialog.this.object.setWeight(0.0);
                } else {
                    CompoundPowerDialog.this.object.setWeight(Double.parseDouble(CompoundPowerDialog.this.weightTF.getText()));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (CompoundPowerDialog.this.weightTF.getText().trim().length() == 0) {
                    CompoundPowerDialog.this.object.setWeight(0.0);
                } else {
                    CompoundPowerDialog.this.object.setWeight(Double.parseDouble(CompoundPowerDialog.this.weightTF.getText()));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (CompoundPowerDialog.this.weightTF.getText().trim().length() == 0) {
                    CompoundPowerDialog.this.object.setWeight(0.0);
                } else {
                    CompoundPowerDialog.this.object.setWeight(Double.parseDouble(CompoundPowerDialog.this.weightTF.getText()));
                }
            }
        });
        this.displayActivePointsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompoundPowerDialog.this.object.setDisplayActiveCost(CompoundPowerDialog.this.displayActivePointsCB.isSelected());
            }
        });
        this.ultraCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompoundPowerDialog.this.object.setUltra(CompoundPowerDialog.this.ultraCB.isSelected());
            }
        });
        this.nameTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CompoundPowerDialog.this.object.setName(CompoundPowerDialog.this.nameTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CompoundPowerDialog.this.object.setName(CompoundPowerDialog.this.nameTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CompoundPowerDialog.this.object.setName(CompoundPowerDialog.this.nameTF.getText());
            }
        });
        this.defineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CompoundPowerDialog.this.object == null) {
                    return;
                }
                if (CompoundPowerDialog.this.object.getDefinition() == null) {
                    return;
                }
                if (CompoundPowerDialog.this.object.getDefinition().trim().length() == 0) {
                    return;
                }
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), CompoundPowerDialog.this.defineBtn, CompoundPowerDialog.this.object.getDefinition(), false);
                popupMessage.setVisible(true);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompoundPowerDialog.this.cancelButtonClicked = true;
                CompoundPowerDialog.this.deleteButtonClicked = false;
                CompoundPowerDialog.this.okButtonClicked = false;
                CompoundPowerDialog.this.setVisible(false);
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompoundPowerDialog.this.cancelButtonClicked = false;
                CompoundPowerDialog.this.deleteButtonClicked = false;
                CompoundPowerDialog.this.okButtonClicked = true;
                CompoundPowerDialog.this.setVisible(false);
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompoundPowerDialog.this.cancelButtonClicked = false;
                CompoundPowerDialog.this.deleteButtonClicked = true;
                CompoundPowerDialog.this.okButtonClicked = false;
                CompoundPowerDialog.this.setVisible(false);
                CompoundPowerDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.multiplierBtn = new JButton("Cost Multiplier");
        this.powerPanel = new CompoundPowerPanel((CompoundPower)this.object);
        this.equipmentPanel = new JPanel(new GridBagLayout());
        this.carriedCB = new JCheckBox("Carried");
        this.carriedCB.setSelected(this.object.isCarried());
        this.priceLbl = new JLabel("Price: ");
        this.weightLbl = new JLabel("Weight: ");
        BigDecimal bigDecimal = new BigDecimal(this.object.getPrice());
        bigDecimal = bigDecimal.setScale(HeroDesigner.getActiveHero().getRules().getEquipmentCostDecimalPlaces(), 4);
        this.priceTF = new JTextField(new DoubleDocument(9.9999999999E10, -9.9999999999E10), bigDecimal.toString(), 6);
        bigDecimal = new BigDecimal(this.object.getWeight());
        bigDecimal = bigDecimal.setScale(2, 4);
        this.weightTF = new JTextField(new DoubleDocument(9.9999999999E10, -9.9999999999E10), bigDecimal.toString(), 6);
        this.activePointsLbl = new JLabel("Active Point:  " + Rounder.roundUp(this.object.getActiveCost()));
        this.realCostLbl = new JLabel("Real Cost:  " + Rounder.roundUp(this.object.getRealCost()));
        this.displayActivePointsCB = new JCheckBox("Display Cost Totals");
        this.displayActivePointsCB.setSelected(this.object.getDisplayActiveCost());
        this.notesBtn = new JButton("Notes...");
        this.okBtn = new JButton("OK");
        this.deleteBtn = new JButton("Delete");
        this.deleteBtn.setVisible(!this.isNew);
        this.cancelBtn = new JButton("Cancel");
        this.defineBtn = new JButton("Define");
        if (this.object.getDefinition() != null && this.object.getDefinition().trim().length() > 0) {
            this.defineBtn.setEnabled(true);
        } else {
            this.defineBtn.setEnabled(false);
        }
        this.nameLbl = new JLabel("Name:");
        this.nameTF = new JTextField(this.object.getName());
        Font font = this.nameTF.getFont();
        font = new Font(font.getFontName(), 2, font.getSize());
        this.nameTF.setFont(font);
        this.ultraCB = HeroDesigner.getActiveTemplate().is6E() ? new JCheckBox("Fixed Slot") : new JCheckBox("Ultra Slot");
        this.ultraCB.setSelected(this.object.isUltra());
    }

    @Override
    protected void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.getTopPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.activePointsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.displayActivePointsCB);
        if (this.isPower && this.object.getParentList() != null && this.object.getParentList() instanceof Multipower) {
            jPanel2.add(this.ultraCB);
        }
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.realCostLbl, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.powerPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 15;
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.notesBtn);
        jPanel3.add(this.multiplierBtn);
        jPanel3.add(this.okBtn);
        jPanel3.add(this.deleteBtn);
        jPanel3.add(this.cancelBtn);
        jPanel3.add(this.defineBtn);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.setContentPane(jPanel);
    }

    @Override
    public void layoutExtrasPanel() {
    }

    @Override
    public void updateValues() {
        if (!this.isShowing()) {
            return;
        }
        if (this.object.getNotes() != null && this.object.getNotes().trim().length() > 0) {
            this.notesBtn.setText("Edit Notes...");
        } else {
            this.notesBtn.setText("Create Notes...");
        }
        this.activePointsLbl.setText("Active Points: " + Rounder.roundUp(this.object.getActiveCost()));
        this.realCostLbl.setText("Real Cost: " + Rounder.roundUp(this.object.getRealCost()));
        this.validate();
    }
}

