/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.skills.CharacteristicChoice;
import com.hero.objects.talents.CombatSense;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Constants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CombatSenseDialog
extends GenericDialog {
    private static final long serialVersionUID = 7679165921370312724L;
    protected CombatSense skill;
    private JLabel characteristicLbl;
    private JLabel rollLbl;
    private JComboBox characteristicCombo;

    public CombatSenseDialog(CombatSense combatSense, boolean bl, boolean bl2) {
        super(combatSense, bl, bl2);
        this.skill = combatSense;
        this.init();
        if (this.pointsLbl != null) {
            this.pointsLbl.setVisible(false);
        }
        if (this.pointsTF != null) {
            this.pointsTF.setVisible(false);
        }
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        if (this.skill.getCharacteristicChoices() != null && this.skill.getCharacteristicChoices().size() > 0) {
            jPanel.add((Component)this.characteristicLbl, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        if (this.skill.getCharacteristicChoices() != null && this.skill.getCharacteristicChoices().size() > 0) {
            if (this.skill.getCharacteristicChoices().size() == 1) {
                CharacteristicChoice characteristicChoice = this.skill.getCharacteristicChoices().get(0);
                if (characteristicChoice.getBaseCost() >= 0.0) {
                    this.skill.setBaseCost(characteristicChoice.getBaseCost());
                }
                this.skill.setCharacteristic(characteristicChoice.getCharacteristic());
                if (characteristicChoice.getLevelCost() >= 0.0) {
                    this.skill.setLevelCost(characteristicChoice.getLevelCost());
                }
                if (characteristicChoice.getLevelValue() >= 0.0) {
                    this.skill.setLevelValue(characteristicChoice.getLevelValue());
                }
                if (characteristicChoice.getMinimumCost() > -999.0) {
                    this.skill.setMinimumCost(characteristicChoice.getMinimumCost());
                }
                if (characteristicChoice.getMinimumLevel() >= 0) {
                    this.skill.setMinimumLevel(characteristicChoice.getMinimumLevel());
                }
                this.updateValues();
                jPanel.add((Component)new JLabel(Constants.getCharacteristicString(characteristicChoice.getCharacteristic())), gridBagConstraints);
            } else {
                jPanel.add((Component)this.characteristicCombo, gridBagConstraints);
            }
        }
        gridBagConstraints.gridy = 70;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        if (this.skill.getRoll().trim().length() > 0) {
            jPanel.add((Component)this.rollLbl, gridBagConstraints);
        }
        gridBagConstraints.gridy = 80;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.characteristicCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CombatSenseDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.characteristicLbl = new JLabel("Characteristic:");
        this.rollLbl = new JLabel("Roll:");
        this.characteristicCombo = new JComboBox<Object>(this.skill.getCharacteristicChoices().toArray());
        this.levelTF.setEnabled(true);
        this.levelsLbl.setEnabled(true);
        if (this.skill.getCharacteristicChoices() != null && this.skill.getCharacteristicChoices().size() > 0) {
            if (this.skill.getCharacteristicChoices().size() == 1) {
                CharacteristicChoice characteristicChoice = this.skill.getCharacteristicChoices().get(0);
                if (characteristicChoice.getBaseCost() >= 0.0) {
                    this.skill.setBaseCost(characteristicChoice.getBaseCost());
                }
                this.skill.setCharacteristic(characteristicChoice.getCharacteristic());
                if (characteristicChoice.getLevelCost() >= 0.0) {
                    this.skill.setLevelCost(characteristicChoice.getLevelCost());
                }
                if (characteristicChoice.getLevelValue() >= 0.0) {
                    this.skill.setLevelValue(characteristicChoice.getLevelValue());
                }
                if (characteristicChoice.getMinimumCost() > -999.0) {
                    this.skill.setMinimumCost(characteristicChoice.getMinimumCost());
                }
                if (characteristicChoice.getMinimumLevel() >= 0) {
                    this.skill.setMinimumLevel(characteristicChoice.getMinimumLevel());
                }
                this.updateValues();
            } else {
                for (int i = 0; i < this.skill.getCharacteristicChoices().size(); ++i) {
                    CharacteristicChoice characteristicChoice = this.skill.getCharacteristicChoices().get(i);
                    if (characteristicChoice.getCharacteristic() != this.skill.getCharacteristic()) continue;
                    this.characteristicCombo.setSelectedIndex(i);
                    break;
                }
                this.updateValues();
            }
        }
    }

    @Override
    public void updateValues() {
        CharacteristicChoice characteristicChoice = (CharacteristicChoice)this.characteristicCombo.getSelectedItem();
        if (characteristicChoice != null) {
            this.skill.setCharacteristic(characteristicChoice.getCharacteristic());
        }
        this.rollLbl.setText(this.skill.getRoll());
        super.updateValues();
    }
}

