/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.Hero;
import com.hero.HeroDesigner;
import com.hero.util.Rounder;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CombatRecordDialog
extends JDialog {
    private static final long serialVersionUID = -8368091814848273922L;
    private JLabel selectCharactersLbl;
    private ArrayList<CharacterCheck> characterChecks;
    private JLabel sortCharactersByLbl;
    private JLabel sortCharactersByLbl2;
    private JComboBox sortOptionsCombo;
    private JComboBox sortOptionsCombo2;
    private JCheckBox ascendingCB;
    private JCheckBox ascendingCB2;
    private JButton doneBtn;
    private JButton cancelBtn;
    private boolean cancelButtonClicked = true;
    private ArrayList<Hero> availableHeroes;
    private Hashtable<Hero, HeroContainer> heroValues;

    public CombatRecordDialog(ArrayList<Hero> arrayList) throws HeadlessException {
        super(HeroDesigner.getAppFrame(), "Combat Record Character Selection", true);
        this.availableHeroes = arrayList;
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    public boolean cancelButtonClicked() {
        return this.cancelButtonClicked;
    }

    public ArrayList<Hero> getCharacters() {
        ArrayList<Hero> arrayList = new ArrayList<Hero>();
        Hero hero = HeroDesigner.getActiveHero();
        this.heroValues = new Hashtable();
        for (int i = 0; i < this.characterChecks.size(); ++i) {
            CharacterCheck characterCheck = this.characterChecks.get(i);
            if (!characterCheck.isSelected()) continue;
            arrayList.add(characterCheck.getHero());
            HeroDesigner.getInstance().setActiveHero(characterCheck.getHero());
            String string = characterCheck.getHero().getCharacterName();
            int n = 0;
            if (characterCheck.getHero().getCharacteristic(2) != null) {
                n = (int)Rounder.roundHalfUp(characterCheck.getHero().getCharacteristic(2).getSecondaryValue());
            }
            int n2 = 0;
            if (characterCheck.getHero().getCharacteristic(11) != null) {
                n2 = (int)Rounder.roundDown(characterCheck.getHero().getCharacteristic(11).getSecondaryValue());
            }
            int n3 = 0;
            n3 = characterCheck.getHero().getBasePoints() + characterCheck.getHero().getDisadPoints() + characterCheck.getHero().getExperience();
            if (HeroDesigner.getActiveTemplate().is6E()) {
                n3 -= characterCheck.getHero().getDisadPoints();
            }
            HeroContainer heroContainer = new HeroContainer(string, n, n2, n3);
            this.heroValues.put(characterCheck.getHero(), heroContainer);
        }
        HeroDesigner.getInstance().setActiveHero(hero);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof Hero && object2 instanceof Hero) {
                    String string;
                    Hero hero = (Hero)object;
                    Hero hero2 = (Hero)object2;
                    HeroContainer heroContainer = (HeroContainer)CombatRecordDialog.this.heroValues.get(hero);
                    HeroContainer heroContainer2 = (HeroContainer)CombatRecordDialog.this.heroValues.get(hero2);
                    String string2 = heroContainer.name1;
                    if (string2 == null || string2.trim().length() == 0) {
                        string2 = "[unknown]";
                    }
                    if ((string = heroContainer2.name1) == null || string.trim().length() == 0) {
                        string = "[unknown]";
                    }
                    int n = heroContainer.dex1;
                    int n2 = heroContainer2.dex1;
                    int n3 = heroContainer.spd1;
                    int n4 = heroContainer2.spd1;
                    int n5 = heroContainer.tot1;
                    int n6 = heroContainer2.tot1;
                    if (CombatRecordDialog.this.sortOptionsCombo.getSelectedIndex() <= 0) {
                        if (string2.compareTo(string) == 0) {
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() <= 0) {
                                return string2.compareTo(string);
                            }
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 1) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return n - n2;
                                }
                                return n2 - n;
                            }
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 2) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return n3 - n4;
                                }
                                return n4 - n3;
                            }
                            if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                return n5 - n6;
                            }
                            return n6 - n5;
                        }
                        if (CombatRecordDialog.this.ascendingCB.isSelected()) {
                            return string2.compareTo(string);
                        }
                        return string.compareTo(string2);
                    }
                    if (CombatRecordDialog.this.sortOptionsCombo.getSelectedIndex() == 1) {
                        if (n == n2) {
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() <= 0) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return string2.compareTo(string);
                                }
                                return string.compareTo(string2);
                            }
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 1) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return n - n2;
                                }
                                return n2 - n;
                            }
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 2) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return n3 - n4;
                                }
                                return n4 - n3;
                            }
                            if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                return n5 - n6;
                            }
                            return n6 - n5;
                        }
                        if (CombatRecordDialog.this.ascendingCB.isSelected()) {
                            return n - n2;
                        }
                        return n2 - n;
                    }
                    if (CombatRecordDialog.this.sortOptionsCombo.getSelectedIndex() == 2) {
                        if (n3 == n4) {
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() <= 0) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return string2.compareTo(string);
                                }
                                return string.compareTo(string2);
                            }
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 1) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return n - n2;
                                }
                                return n2 - n;
                            }
                            if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 2) {
                                if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                    return n3 - n4;
                                }
                                return n4 - n3;
                            }
                            if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                return n5 - n6;
                            }
                            return n6 - n5;
                        }
                        if (CombatRecordDialog.this.ascendingCB.isSelected()) {
                            return n3 - n4;
                        }
                        return n4 - n3;
                    }
                    if (n5 == n6) {
                        if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() <= 0) {
                            if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                return string2.compareTo(string);
                            }
                            return string.compareTo(string2);
                        }
                        if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 1) {
                            if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                return n - n2;
                            }
                            return n2 - n;
                        }
                        if (CombatRecordDialog.this.sortOptionsCombo2.getSelectedIndex() == 2) {
                            if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                                return n3 - n4;
                            }
                            return n4 - n3;
                        }
                        if (CombatRecordDialog.this.ascendingCB2.isSelected()) {
                            return n5 - n6;
                        }
                        return n6 - n5;
                    }
                    if (CombatRecordDialog.this.ascendingCB.isSelected()) {
                        return n5 - n6;
                    }
                    return n6 - n5;
                }
                return object.toString().compareTo(object2.toString());
            }
        };
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private void initListeners() {
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CombatRecordDialog.this.cancelButtonClicked = true;
                CombatRecordDialog.this.setVisible(false);
            }
        });
        this.doneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CombatRecordDialog.this.cancelButtonClicked = false;
                CombatRecordDialog.this.setVisible(false);
            }
        });
    }

    private void initWidgets() {
        this.selectCharactersLbl = new JLabel("Select Characters for Export:");
        this.characterChecks = new ArrayList();
        for (int i = 0; i < this.availableHeroes.size(); ++i) {
            Hero hero = this.availableHeroes.get(i);
            CharacterCheck characterCheck = new CharacterCheck(hero);
            this.characterChecks.add(characterCheck);
        }
        this.sortCharactersByLbl = new JLabel("Sort Characters By");
        this.sortCharactersByLbl2 = new JLabel("Then By");
        String[] stringArray = new String[]{"Name", "DEX", "SPD", "Character Points"};
        this.sortOptionsCombo = new JComboBox<String>(stringArray);
        this.sortOptionsCombo2 = new JComboBox<String>(stringArray);
        this.ascendingCB = new JCheckBox("Ascending");
        this.ascendingCB2 = new JCheckBox("Ascending");
        this.doneBtn = new JButton("Done");
        this.cancelBtn = new JButton("Cancel");
    }

    private void layoutComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.selectCharactersLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        for (CharacterCheck characterCheck : this.characterChecks) {
            jPanel2.add((Component)characterCheck, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JScrollPane(jPanel2), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.sortCharactersByLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.sortOptionsCombo, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.ascendingCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.sortCharactersByLbl2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.sortOptionsCombo2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.ascendingCB2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.doneBtn);
        jPanel3.add(this.cancelBtn);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.setContentPane(jPanel);
    }

    class CharacterCheck
    extends JCheckBox {
        private static final long serialVersionUID = -6546866554165081474L;
        Hero hero;

        public CharacterCheck(Hero hero) {
            super(hero.getCharacterName().trim().length() > 0 ? hero.getCharacterName() : "[unknown]");
            this.hero = hero;
            this.setSelected(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < CombatRecordDialog.this.characterChecks.size(); ++i) {
                        CharacterCheck characterCheck = (CharacterCheck)CombatRecordDialog.this.characterChecks.get(i);
                        if (!characterCheck.isSelected()) continue;
                        CombatRecordDialog.this.doneBtn.setEnabled(true);
                        return;
                    }
                    CombatRecordDialog.this.doneBtn.setEnabled(false);
                }
            });
        }

        public Hero getHero() {
            return this.hero;
        }
    }

    private class HeroContainer {
        public String name1;
        public int dex1;
        public int spd1;
        public int tot1;

        public HeroContainer(String string, int n, int n2, int n3) {
            this.name1 = string;
            this.dex1 = n;
            this.spd1 = n2;
            this.tot1 = n3;
        }
    }
}

