/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.talents.CombatLuck;
import com.hero.ui.dialog.GenericDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CombatLuckDialog
extends GenericDialog {
    private static final long serialVersionUID = 6342766456695234664L;
    protected CombatLuck skill;
    protected JComboBox affectsCombo;
    protected JLabel affectsLbl;
    private JLabel rollLbl;

    public CombatLuckDialog(CombatLuck combatLuck, boolean bl, boolean bl2) {
        super(combatLuck, bl, bl2);
        this.skill = combatLuck;
        this.init();
        if (this.pointsLbl != null) {
            this.pointsLbl.setVisible(false);
        }
        if (this.pointsTF != null) {
            this.pointsTF.setVisible(false);
        }
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 70;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.rollLbl, gridBagConstraints);
        gridBagConstraints.gridy = 80;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 75;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.affectsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.affectsCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.affectsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CombatLuckDialog.this.affectsCombo.getSelectedIndex() == 0) {
                    CombatLuckDialog.this.skill.setAffectPrimary(false);
                    CombatLuckDialog.this.skill.setAffectTotal(true);
                } else if (CombatLuckDialog.this.affectsCombo.getSelectedIndex() == 1) {
                    CombatLuckDialog.this.skill.setAffectPrimary(false);
                    CombatLuckDialog.this.skill.setAffectTotal(false);
                } else {
                    CombatLuckDialog.this.skill.setAffectPrimary(true);
                    CombatLuckDialog.this.skill.setAffectTotal(true);
                }
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.rollLbl = new JLabel("Roll:");
        this.levelTF.setEnabled(true);
        this.levelsLbl.setEnabled(true);
        this.affectsLbl = new JLabel("Totaling Options:");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Add to Secondary Value");
        arrayList.add("Do not add to Totals");
        arrayList.add("Add to Primary Value");
        this.affectsCombo = new JComboBox<Object>(arrayList.toArray());
        if (this.skill.getAffectPrimary()) {
            this.affectsCombo.setSelectedIndex(2);
        } else if (this.skill.getAffectTotal()) {
            this.affectsCombo.setSelectedIndex(0);
        } else {
            this.affectsCombo.setSelectedIndex(1);
        }
        this.updateValues();
    }

    @Override
    public void updateValues() {
        int n = this.skill.getPdIncrease() * this.skill.getLevels() / this.skill.getPdIncreaseLevels();
        int n2 = this.skill.getEdIncrease() * this.skill.getLevels() / this.skill.getEdIncreaseLevels();
        this.rollLbl.setText(n + " PD/" + n2 + " ED");
        super.updateValues();
    }
}

