/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.objects.characteristics.Characteristic;
import com.hero.ui.dialog.GenericDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CharacteristicDialog
extends GenericDialog {
    private static final long serialVersionUID = -4934138382056573402L;
    protected Characteristic characteristic;
    protected JComboBox affectsCombo;
    protected JLabel affectsLbl;
    protected JCheckBox addModifiersToBaseCB;

    public CharacteristicDialog(Characteristic characteristic, boolean bl, boolean bl2) {
        super(characteristic, bl, bl2);
        this.characteristic = characteristic;
        this.init();
    }

    @Override
    protected JPanel getTopPanel() {
        JPanel jPanel = super.getTopPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 75;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.affectsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.affectsCombo, gridBagConstraints);
        gridBagConstraints.gridy = 76;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 2, 2, 5);
        jPanel.add((Component)this.addModifiersToBaseCB, gridBagConstraints);
        gridBagConstraints.gridy = 91;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 70;
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.affectsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CharacteristicDialog.this.affectsCombo.getSelectedIndex() == 0) {
                    CharacteristicDialog.this.characteristic.setAffectPrimary(true);
                    CharacteristicDialog.this.characteristic.setAffectTotal(true);
                } else if (CharacteristicDialog.this.affectsCombo.getSelectedIndex() == 1) {
                    CharacteristicDialog.this.characteristic.setAffectPrimary(false);
                    CharacteristicDialog.this.characteristic.setAffectTotal(true);
                } else {
                    CharacteristicDialog.this.characteristic.setAffectPrimary(false);
                    CharacteristicDialog.this.characteristic.setAffectTotal(false);
                }
            }
        });
        this.addModifiersToBaseCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CharacteristicDialog.this.characteristic.setAddModifiersToBase(CharacteristicDialog.this.addModifiersToBaseCB.isSelected());
                CharacteristicDialog.this.updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.affectsLbl = new JLabel("Totaling Options:");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Add to Primary Value");
        arrayList.add("Add to Secondary Value");
        arrayList.add("Do not add to Totals");
        this.affectsCombo = new JComboBox<Object>(arrayList.toArray());
        if (this.characteristic.getAffectPrimary()) {
            this.affectsCombo.setSelectedIndex(0);
        } else if (this.characteristic.getAffectTotal()) {
            this.affectsCombo.setSelectedIndex(1);
        } else {
            this.affectsCombo.setSelectedIndex(2);
        }
        this.addModifiersToBaseCB = new JCheckBox("Add Modifiers to Base Characteristic");
        if (this.characteristic.addModifiersToBase()) {
            this.addModifiersToBaseCB.setSelected(true);
        }
    }

    @Override
    public void updateValues() {
        super.updateValues();
    }
}

