/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.SelectionList;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.PopupMessage;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class AvailablePowersDialog
extends JDialog {
    private static final long serialVersionUID = 810658576813640608L;
    CompoundPower parent;
    SelectionList selectList;
    JButton selectBtn;
    JButton cancelBtn;
    JButton defineBtn;
    GenericObject selection;

    public AvailablePowersDialog(CompoundPower compoundPower, JDialog jDialog) {
        super(jDialog, "Available Powers", true);
        this.parent = compoundPower;
        this.setDefaultCloseOperation(2);
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.pack();
        this.setSize(400, 500);
        this.setLocationRelativeTo(jDialog);
    }

    private void initListeners() {
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AvailablePowersDialog.this.setVisible(false);
            }
        });
        this.defineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AvailablePowersDialog.this.selectList.getSelection() == null) {
                    return;
                }
                GenericObject genericObject = AvailablePowersDialog.this.selectList.getSelection();
                if (genericObject.getDefinition() == null) {
                    return;
                }
                if (genericObject.getDefinition().trim().length() == 0) {
                    return;
                }
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), AvailablePowersDialog.this.defineBtn, genericObject.getDefinition(), false);
                popupMessage.setVisible(true);
            }
        });
        this.selectList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AvailablePowersDialog.this.selectList.getSelection() != null && !(AvailablePowersDialog.this.selectList.getSelection() instanceof List)) {
                    AvailablePowersDialog.this.selectBtn.setEnabled(true);
                    GenericObject genericObject = AvailablePowersDialog.this.selectList.getSelection();
                    if (genericObject.getDefinition() == null || genericObject.getDefinition().trim().length() == 0) {
                        return;
                    }
                    AvailablePowersDialog.this.defineBtn.setEnabled(true);
                } else {
                    AvailablePowersDialog.this.selectBtn.setEnabled(false);
                    AvailablePowersDialog.this.defineBtn.setEnabled(false);
                }
            }
        });
        this.selectList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AvailablePowersDialog.this.selectBtn.doClick();
                }
            }
        });
        this.selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AvailablePowersDialog.this.selectList.getSelection() != null && !(AvailablePowersDialog.this.selectList.getSelection() instanceof List)) {
                    GenericObject genericObject = AvailablePowersDialog.this.selectList.getSelection();
                    genericObject = genericObject.clone();
                    genericObject.setDisplayActiveCost(HeroDesigner.getInstance().getPrefs().displayActivePoints());
                    genericObject.setMainPower(AvailablePowersDialog.this.parent);
                    GenericDialog genericDialog = genericObject.getDialog(true, genericObject.isPower());
                    genericDialog.setLocationRelativeTo(AvailablePowersDialog.this);
                    genericDialog.setVisible(true);
                    if (!genericDialog.okButtonClicked) {
                        return;
                    }
                    AvailablePowersDialog.this.parent.getPowers().add(genericObject);
                    AvailablePowersDialog.this.selection = genericObject;
                    AvailablePowersDialog.this.setVisible(false);
                }
            }
        });
    }

    private void initWidgets() {
        ArrayList<GenericObject> arrayList = new ArrayList<GenericObject>();
        for (int i = 0; i < HeroDesigner.getActiveTemplate().getPowers().size(); ++i) {
            GenericObject genericObject = HeroDesigner.getActiveTemplate().getPowers().get(i);
            if (genericObject.getXMLID().equals("COMPOUNDPOWER")) continue;
            arrayList.add(genericObject);
        }
        this.selectList = new SelectionList(arrayList);
        this.selectBtn = new JButton("Select");
        this.selectBtn.setEnabled(false);
        this.cancelBtn = new JButton("Cancel");
        this.defineBtn = new JButton("Define");
        this.defineBtn.setEnabled(false);
    }

    private void layoutComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.selectList.getTree(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.selectBtn);
        jPanel2.add(this.defineBtn);
        jPanel2.add(this.cancelBtn);
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.setOpaque(true);
        this.setContentPane(jPanel);
    }
}

