/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.NakedModifier;
import com.hero.ui.SelectionList;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.ui.widgets.PopupMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jdom.Element;

public class AvailableModifiersDialog
extends JDialog {
    private static final long serialVersionUID = 643291338550999573L;
    private static ArrayList<Modifier> recentlySelected;
    GenericObject parent;
    SelectionList advList;
    SelectionList limList;
    SelectionList unAdvList;
    SelectionList unLimList;
    SelectionList recentList;
    JButton selectBtn;
    JButton cancelBtn;
    JButton defineBtn;
    JButton customModifierBtn;
    JButton clearBtn;
    Modifier selection;
    GenericDialog parentDialog;
    JTabbedPane tabPane;
    private boolean privateMods;

    public static ArrayList<Modifier> getRecentlySelectedList() {
        if (recentlySelected == null) {
            recentlySelected = new ArrayList();
        }
        return recentlySelected;
    }

    public static void setRecentlySelectedList(ArrayList<Modifier> arrayList) {
        recentlySelected = arrayList != null ? arrayList : new ArrayList();
    }

    public AvailableModifiersDialog(GenericObject genericObject, GenericDialog genericDialog) {
        this(genericObject, genericDialog, false);
    }

    public AvailableModifiersDialog(GenericObject genericObject, GenericDialog genericDialog, boolean bl) {
        super(genericDialog, "Select Modifiers", true);
        this.privateMods = bl;
        if (recentlySelected == null) {
            recentlySelected = new ArrayList();
        }
        this.parent = genericObject;
        this.parentDialog = genericDialog;
        this.setDefaultCloseOperation(2);
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.pack();
        if (HeroDesigner.getInstance().getPrefs().isRememberDialogPosition()) {
            if (HeroDesigner.getInstance().getPrefs().getModX() > 50 && HeroDesigner.getInstance().getPrefs().getModY() > 50) {
                this.setSize(new Dimension(HeroDesigner.getInstance().getPrefs().getModX(), HeroDesigner.getInstance().getPrefs().getModY()));
            } else {
                this.setSize(400, 500);
            }
            if (HeroDesigner.getInstance().getPrefs().getModScreenX() > 0 && HeroDesigner.getInstance().getPrefs().getModScreenY() > 0) {
                this.setLocation(HeroDesigner.getInstance().getPrefs().getModScreenX(), HeroDesigner.getInstance().getPrefs().getModScreenY());
            } else {
                this.setLocationRelativeTo(genericDialog);
            }
        } else {
            this.setSize(400, 500);
            this.setLocationRelativeTo(genericDialog);
        }
    }

    private String getDefinition(Modifier modifier) {
        if (!HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
            return modifier.getDefinition();
        }
        if (this.parent instanceof List) {
            List list = (List)this.parent;
            if (list.getObjects().size() == 0 || list instanceof VariablePowerPool && modifier.getTypes().contains("VPP") || list instanceof Multipower && modifier.getTypes().contains("MP") || list instanceof ElementalControl && modifier.getTypes().contains("EC") || modifier.getTypes().contains("LIST")) {
                String string = modifier.included(this.parent);
                if (string.trim().length() > 0) {
                    return string;
                }
                return modifier.getDefinition();
            }
            if (!modifier.isLimitation() && this.parent instanceof ElementalControl) {
                return "Advantages cannot be applied directly to an Elemental Control.   Apply them to each slot individually.";
            }
            for (int i = 0; i < list.getObjects().size(); ++i) {
                Object object;
                GenericObject genericObject = list.getObjects().get(i);
                if (genericObject instanceof Maneuver && ((String)(object = modifier.included(this.parent))).trim().length() > 0) {
                    return object;
                }
                if (genericObject instanceof CompoundPower) {
                    object = (CompoundPower)genericObject;
                    for (int j = 0; j < ((CompoundPower)object).getPowers().size(); ++j) {
                        GenericObject genericObject2 = ((CompoundPower)object).getPowers().get(j);
                        String string = modifier.included(genericObject2);
                        if (string.trim().length() <= 0 || GenericObject.findObjectByID(genericObject2.getAssignedModifiers(), modifier.getXMLID()) != null) continue;
                        string = "List contains item which does not allow this Modifier:\n\n" + string;
                        return string;
                    }
                    continue;
                }
                genericObject.setListModCheck(true);
                object = modifier.included(genericObject);
                genericObject.setListModCheck(false);
                if (((String)object).trim().length() <= 0 || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), modifier.getXMLID()) != null) continue;
                object = "List contains item which does not allow this Modifier:\n\n" + (String)object;
                return object;
            }
            return modifier.getDefinition();
        }
        if (this.parent instanceof Characteristic) {
            String string;
            Characteristic characteristic = (Characteristic)this.parent;
            if (characteristic.addModifiersToBase()) {
                characteristic = (Characteristic)characteristic.clone();
                for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
                    Characteristic characteristic2 = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
                    if (!characteristic2.getXMLID().equals(characteristic.getXMLID())) continue;
                    characteristic.setLevels(characteristic.getLevels() + (int)characteristic2.getCharacteristicValue());
                    break;
                }
            }
            if ((string = modifier.included(this.parent)).trim().length() == 0) {
                return modifier.getDefinition();
            }
            return string;
        }
        String string = modifier.included(this.parent);
        if (string.trim().length() == 0 || this.parent instanceof NakedModifier && !this.privateMods) {
            return modifier.getDefinition();
        }
        if (this.parent.getParentList() != null) {
            if (GenericObject.findObjectByID(this.parent.getParentList().getAssignedModifiers(), modifier.getXMLID()) != null) {
                return modifier.getDefinition();
            }
            return string;
        }
        return string;
    }

    private boolean included(Modifier modifier) {
        if (this.parent instanceof List) {
            List list = (List)this.parent;
            if (list.getObjects().size() == 0 || list instanceof VariablePowerPool && modifier.getTypes().contains("VPP") || list instanceof Multipower && modifier.getTypes().contains("MP") || list instanceof ElementalControl && modifier.getTypes().contains("EC") || modifier.getTypes().contains("LIST")) {
                String string = modifier.included(this.parent);
                return string.trim().length() == 0;
            }
            if (!modifier.isLimitation() && this.parent instanceof ElementalControl) {
                return false;
            }
            for (int i = 0; i < list.getObjects().size(); ++i) {
                Object object;
                GenericObject genericObject = list.getObjects().get(i);
                if (genericObject instanceof Maneuver && ((String)(object = modifier.included(this.parent))).trim().length() > 0) {
                    return false;
                }
                if (genericObject instanceof CompoundPower) {
                    object = (CompoundPower)genericObject;
                    for (int j = 0; j < ((CompoundPower)object).getPowers().size(); ++j) {
                        GenericObject genericObject2 = ((CompoundPower)object).getPowers().get(j);
                        String string = modifier.included(genericObject2);
                        if (string.trim().length() <= 0 || GenericObject.findObjectByID(genericObject2.getAssignedModifiers(), modifier.getXMLID()) != null) continue;
                        return false;
                    }
                    continue;
                }
                genericObject.setListModCheck(true);
                object = modifier.included(genericObject);
                genericObject.setListModCheck(false);
                if (((String)object).trim().length() <= 0 || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), modifier.getXMLID()) != null) continue;
                return false;
            }
            return true;
        }
        if (this.parent instanceof Characteristic) {
            String string;
            Characteristic characteristic = (Characteristic)this.parent;
            if (characteristic.addModifiersToBase()) {
                characteristic = (Characteristic)characteristic.clone();
                for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
                    Characteristic characteristic2 = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
                    if (!characteristic2.getXMLID().equals(characteristic.getXMLID())) continue;
                    characteristic.setLevels(characteristic.getLevels() + (int)characteristic2.getCharacteristicValue());
                    break;
                }
            }
            return (string = modifier.included(characteristic)).trim().length() == 0;
        }
        String string = modifier.included(this.parent);
        if (string.trim().length() > 0 && !(this.parent instanceof NakedModifier)) {
            return false;
        }
        if (this.parent instanceof NakedModifier && !this.privateMods) {
            return !modifier.isLimitation();
        }
        return string.trim().length() == 0;
    }

    private void initListeners() {
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                recentlySelected.clear();
                AvailableModifiersDialog.this.recalcMods();
            }
        });
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                switch (AvailableModifiersDialog.this.tabPane.getSelectedIndex()) {
                    case 0: {
                        AvailableModifiersDialog.this.setButtonStates(AvailableModifiersDialog.this.advList.getSelection());
                        AvailableModifiersDialog.this.defineBtn.setText("Define");
                        AvailableModifiersDialog.this.selectBtn.setText("Select");
                        break;
                    }
                    case 1: {
                        AvailableModifiersDialog.this.setButtonStates(AvailableModifiersDialog.this.limList.getSelection());
                        AvailableModifiersDialog.this.defineBtn.setText("Define");
                        AvailableModifiersDialog.this.selectBtn.setText("Select");
                        break;
                    }
                    case 2: {
                        AvailableModifiersDialog.this.setButtonStates(AvailableModifiersDialog.this.limList.getSelection());
                        AvailableModifiersDialog.this.defineBtn.setText("Define");
                        AvailableModifiersDialog.this.selectBtn.setText("Select");
                        break;
                    }
                    case 3: {
                        AvailableModifiersDialog.this.setButtonStates(AvailableModifiersDialog.this.unAdvList.getSelection());
                        AvailableModifiersDialog.this.defineBtn.setText("View Reason");
                        AvailableModifiersDialog.this.selectBtn.setText("Force Add");
                        break;
                    }
                    case 4: {
                        AvailableModifiersDialog.this.setButtonStates(AvailableModifiersDialog.this.unLimList.getSelection());
                        AvailableModifiersDialog.this.defineBtn.setText("View Reason");
                        AvailableModifiersDialog.this.selectBtn.setText("Force Add");
                    }
                }
            }
        });
        this.customModifierBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Modifier modifier = Modifier.getInstance(new Element("MODIFIER"));
                modifier.setDisplay("Custom Modifier");
                modifier.setAlias("Custom Modifier");
                modifier.setBaseCost(0.0);
                modifier.setMinimumCost(-10.0);
                modifier.setMaxCost(10.0);
                modifier.setFixedValue(false);
                modifier.setPrivate(AvailableModifiersDialog.this.privateMods);
                modifier.resetID();
                ModifierDialog modifierDialog = modifier.getDialog(AvailableModifiersDialog.this.parent, true);
                modifierDialog.setLocationRelativeTo(AvailableModifiersDialog.this);
                modifierDialog.setVisible(true);
                if (!modifierDialog.okButtonClicked) {
                    return;
                }
                if (AvailableModifiersDialog.this.privateMods && AvailableModifiersDialog.this.parent instanceof NakedModifier) {
                    modifier.setPrivate(true);
                    AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                } else if (!AvailableModifiersDialog.this.privateMods || !(AvailableModifiersDialog.this.parent instanceof List)) {
                    modifier.setPrivate(false);
                    AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                } else {
                    List list = (List)AvailableModifiersDialog.this.parent;
                    modifier.setPrivate(true);
                    list.getPrivateMods().add(modifier);
                }
                AvailableModifiersDialog.this.parentDialog.recalc();
                try {
                    modifier.setAvailableCheck(true);
                    boolean bl = true;
                    for (int i = 0; i < recentlySelected.size(); ++i) {
                        Modifier modifier2 = (Modifier)recentlySelected.get(i);
                        modifier2.setParent(modifier.getProgenitor());
                        modifier2.setFullDisplay(true);
                        modifier.setFullDisplay(true);
                        if (!modifier2.getXMLID().equals(modifier.getXMLID()) || !modifier2.toString().equals(modifier.toString())) continue;
                        bl = false;
                        break;
                    }
                    modifier.setFullDisplay(false);
                    if (bl) {
                        if (recentlySelected.size() > 39) {
                            recentlySelected.remove(0);
                        }
                        modifier.setAvailableCheck(false);
                        Modifier modifier3 = modifier.clone();
                        modifier3.setFullDisplay(true);
                        recentlySelected.add(modifier3);
                    }
                    modifier.setAvailableCheck(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AvailableModifiersDialog.this.customModifierBtn.setVisible(AvailableModifiersDialog.this.parent.allowsOtherModifiers());
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AvailableModifiersDialog.this.setVisible(false);
            }
        });
        this.defineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Modifier modifier = null;
                switch (AvailableModifiersDialog.this.tabPane.getSelectedIndex()) {
                    case 0: {
                        modifier = (Modifier)AvailableModifiersDialog.this.advList.getSelection();
                        break;
                    }
                    case 1: {
                        modifier = (Modifier)AvailableModifiersDialog.this.limList.getSelection();
                        break;
                    }
                    case 2: {
                        modifier = (Modifier)AvailableModifiersDialog.this.limList.getSelection();
                        break;
                    }
                    case 3: {
                        modifier = (Modifier)AvailableModifiersDialog.this.unAdvList.getSelection();
                        break;
                    }
                    case 4: {
                        modifier = (Modifier)AvailableModifiersDialog.this.unLimList.getSelection();
                    }
                }
                if (modifier == null) {
                    return;
                }
                String string = AvailableModifiersDialog.this.getDefinition(modifier);
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), AvailableModifiersDialog.this.defineBtn, string, false);
                popupMessage.setVisible(true);
            }
        });
        this.recentList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AvailableModifiersDialog.this.recentList.getSelection() != null && AvailableModifiersDialog.this.recentList.getSelection() instanceof Modifier) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.recentList.getSelection();
                    boolean bl = modifier.forceAllow();
                    modifier.setForceAllow(false);
                    boolean bl2 = AvailableModifiersDialog.this.included(modifier);
                    String string = AvailableModifiersDialog.this.getDefinition(modifier);
                    modifier.setForceAllow(bl);
                    AvailableModifiersDialog.this.selectBtn.setEnabled(true);
                    AvailableModifiersDialog.this.selectBtn.setText(bl2 || !HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() ? "Select" : "Force Add");
                    AvailableModifiersDialog.this.defineBtn.setText(bl2 ? "Define" : "View Reason");
                    AvailableModifiersDialog.this.defineBtn.setEnabled(string.trim().length() > 0);
                } else {
                    AvailableModifiersDialog.this.selectBtn.setEnabled(false);
                    AvailableModifiersDialog.this.defineBtn.setEnabled(false);
                }
            }
        });
        this.advList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AvailableModifiersDialog.this.advList.getSelection() != null && AvailableModifiersDialog.this.advList.getSelection() instanceof Modifier) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.advList.getSelection();
                    boolean bl = modifier.forceAllow();
                    modifier.setForceAllow(false);
                    boolean bl2 = AvailableModifiersDialog.this.included(modifier);
                    String string = AvailableModifiersDialog.this.getDefinition(modifier);
                    modifier.setForceAllow(bl);
                    AvailableModifiersDialog.this.selectBtn.setEnabled(true);
                    AvailableModifiersDialog.this.selectBtn.setText(bl2 || !HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() ? "Select" : "Force Add");
                    AvailableModifiersDialog.this.defineBtn.setText(bl2 ? "Define" : "View Reason");
                    AvailableModifiersDialog.this.defineBtn.setEnabled(string.trim().length() > 0);
                } else {
                    AvailableModifiersDialog.this.selectBtn.setEnabled(false);
                    AvailableModifiersDialog.this.defineBtn.setEnabled(false);
                }
            }
        });
        this.limList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AvailableModifiersDialog.this.limList.getSelection() != null && AvailableModifiersDialog.this.limList.getSelection() instanceof Modifier) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.limList.getSelection();
                    boolean bl = modifier.forceAllow();
                    modifier.setForceAllow(false);
                    boolean bl2 = AvailableModifiersDialog.this.included(modifier);
                    String string = AvailableModifiersDialog.this.getDefinition(modifier);
                    modifier.setForceAllow(bl);
                    AvailableModifiersDialog.this.selectBtn.setEnabled(true);
                    AvailableModifiersDialog.this.selectBtn.setText(bl2 || !HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() ? "Select" : "Force Add");
                    AvailableModifiersDialog.this.defineBtn.setText(bl2 ? "Define" : "View Reason");
                    AvailableModifiersDialog.this.defineBtn.setEnabled(string.trim().length() > 0);
                } else {
                    AvailableModifiersDialog.this.selectBtn.setEnabled(false);
                    AvailableModifiersDialog.this.defineBtn.setEnabled(false);
                }
            }
        });
        this.unAdvList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AvailableModifiersDialog.this.unAdvList.getSelection() != null && AvailableModifiersDialog.this.unAdvList.getSelection() instanceof Modifier) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.unAdvList.getSelection();
                    boolean bl = modifier.forceAllow();
                    modifier.setForceAllow(false);
                    boolean bl2 = AvailableModifiersDialog.this.included(modifier);
                    String string = AvailableModifiersDialog.this.getDefinition(modifier);
                    modifier.setForceAllow(bl);
                    AvailableModifiersDialog.this.selectBtn.setEnabled(true);
                    AvailableModifiersDialog.this.selectBtn.setText(bl2 || !HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() ? "Select" : "Force Add");
                    AvailableModifiersDialog.this.defineBtn.setText(bl2 ? "Define" : "View Reason");
                    AvailableModifiersDialog.this.defineBtn.setEnabled(string.trim().length() > 0);
                } else {
                    AvailableModifiersDialog.this.selectBtn.setEnabled(false);
                    AvailableModifiersDialog.this.defineBtn.setEnabled(false);
                }
            }
        });
        this.unLimList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AvailableModifiersDialog.this.unLimList.getSelection() != null && AvailableModifiersDialog.this.unLimList.getSelection() instanceof Modifier) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.unLimList.getSelection();
                    boolean bl = modifier.forceAllow();
                    modifier.setForceAllow(false);
                    boolean bl2 = AvailableModifiersDialog.this.included(modifier);
                    String string = AvailableModifiersDialog.this.getDefinition(modifier);
                    modifier.setForceAllow(bl);
                    AvailableModifiersDialog.this.selectBtn.setEnabled(true);
                    AvailableModifiersDialog.this.selectBtn.setText(bl2 || !HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() ? "Select" : "Force Add");
                    AvailableModifiersDialog.this.defineBtn.setText(bl2 ? "Define" : "View Reason");
                    AvailableModifiersDialog.this.defineBtn.setEnabled(string.trim().length() > 0);
                } else {
                    AvailableModifiersDialog.this.selectBtn.setEnabled(false);
                    AvailableModifiersDialog.this.defineBtn.setEnabled(false);
                }
            }
        });
        this.recentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    Modifier modifier;
                    int n = AvailableModifiersDialog.this.recentList.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0) {
                        AvailableModifiersDialog.this.recentList.setSelectedRow(n);
                    }
                    if ((modifier = (Modifier)AvailableModifiersDialog.this.recentList.getSelection()) == null) {
                        return;
                    }
                    if (!AvailableModifiersDialog.this.included(modifier = modifier.clone()) && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
                        modifier.setForceAllow(true);
                    }
                    modifier.setParent(AvailableModifiersDialog.this.parent);
                    if (AvailableModifiersDialog.this.privateMods && AvailableModifiersDialog.this.parent instanceof NakedModifier) {
                        modifier.setPrivate(true);
                        AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                    } else if (!AvailableModifiersDialog.this.privateMods || !(AvailableModifiersDialog.this.parent instanceof List)) {
                        modifier.setPrivate(false);
                        AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                    } else {
                        List list = (List)AvailableModifiersDialog.this.parent;
                        modifier.setPrivate(true);
                        list.getPrivateMods().add(modifier);
                    }
                    modifier.setAvailableCheck(true);
                    boolean bl = true;
                    for (int i = recentlySelected.size() - 1; i >= 0; --i) {
                        Modifier modifier2 = (Modifier)recentlySelected.get(i);
                        modifier2.setParent(modifier.getProgenitor());
                        modifier2.setFullDisplay(true);
                        modifier.setFullDisplay(true);
                        if (!modifier2.getXMLID().equals(modifier.getXMLID()) || !modifier2.toString().equals(modifier.toString())) continue;
                        recentlySelected.remove(i);
                        recentlySelected.add(0, modifier.clone());
                        bl = false;
                        break;
                    }
                    modifier.setFullDisplay(false);
                    if (bl) {
                        if (recentlySelected.size() > 39) {
                            recentlySelected.remove(0);
                        }
                        modifier.setAvailableCheck(false);
                        Modifier modifier3 = modifier.clone();
                        modifier3.setFullDisplay(true);
                        recentlySelected.add(modifier3);
                    }
                    modifier.setAvailableCheck(false);
                    AvailableModifiersDialog.this.selection = modifier;
                    AvailableModifiersDialog.this.parentDialog.recalc();
                    AvailableModifiersDialog.this.customModifierBtn.setVisible(AvailableModifiersDialog.this.parent.allowsOtherModifiers());
                    AvailableModifiersDialog.this.recalcMods();
                }
                if (mouseEvent.getClickCount() == 2) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.recentList.getSelection();
                    if (modifier == null) {
                        return;
                    }
                    AvailableModifiersDialog.this.selectBtn.doClick();
                }
            }
        });
        this.advList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    Modifier modifier;
                    int n = AvailableModifiersDialog.this.advList.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0) {
                        AvailableModifiersDialog.this.advList.setSelectedRow(n);
                    }
                    if ((modifier = (Modifier)AvailableModifiersDialog.this.advList.getSelection()) != null) {
                        if (!AvailableModifiersDialog.this.included(modifier = modifier.clone()) && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
                            modifier.setForceAllow(true);
                        }
                        modifier.setParent(AvailableModifiersDialog.this.parent);
                        if (AvailableModifiersDialog.this.privateMods && AvailableModifiersDialog.this.parent instanceof NakedModifier) {
                            modifier.setPrivate(true);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else if (!AvailableModifiersDialog.this.privateMods || !(AvailableModifiersDialog.this.parent instanceof List)) {
                            modifier.setPrivate(false);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else {
                            List list = (List)AvailableModifiersDialog.this.parent;
                            modifier.setPrivate(true);
                            list.getPrivateMods().add(modifier);
                        }
                        modifier.setAvailableCheck(true);
                        boolean bl = true;
                        for (int i = recentlySelected.size() - 1; i >= 0; --i) {
                            Modifier modifier2 = (Modifier)recentlySelected.get(i);
                            modifier2.setParent(modifier.getProgenitor());
                            modifier2.setFullDisplay(true);
                            modifier.setFullDisplay(true);
                            if (!modifier2.getXMLID().equals(modifier.getXMLID()) || !modifier2.toString().equals(modifier.toString())) continue;
                            recentlySelected.remove(i);
                            recentlySelected.add(0, modifier.clone());
                            bl = false;
                            break;
                        }
                        modifier.setFullDisplay(false);
                        if (bl) {
                            if (recentlySelected.size() > 39) {
                                recentlySelected.remove(0);
                            }
                            modifier.setAvailableCheck(false);
                            Modifier modifier3 = modifier.clone();
                            modifier3.setFullDisplay(true);
                            recentlySelected.add(modifier3);
                        }
                        modifier.setAvailableCheck(false);
                        AvailableModifiersDialog.this.selection = modifier;
                        AvailableModifiersDialog.this.parentDialog.recalc();
                        AvailableModifiersDialog.this.customModifierBtn.setVisible(AvailableModifiersDialog.this.parent.allowsOtherModifiers());
                        AvailableModifiersDialog.this.recalcMods();
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.advList.getSelection();
                    if (modifier == null) {
                        return;
                    }
                    AvailableModifiersDialog.this.selectBtn.doClick();
                }
            }
        });
        this.limList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    Modifier modifier;
                    int n = AvailableModifiersDialog.this.limList.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0) {
                        AvailableModifiersDialog.this.limList.setSelectedRow(n);
                    }
                    if ((modifier = (Modifier)AvailableModifiersDialog.this.limList.getSelection()) != null) {
                        if (!AvailableModifiersDialog.this.included(modifier = modifier.clone()) && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
                            modifier.setForceAllow(true);
                        }
                        modifier.setParent(AvailableModifiersDialog.this.parent);
                        if (AvailableModifiersDialog.this.privateMods && AvailableModifiersDialog.this.parent instanceof NakedModifier) {
                            modifier.setPrivate(true);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else if (!AvailableModifiersDialog.this.privateMods || !(AvailableModifiersDialog.this.parent instanceof List)) {
                            modifier.setPrivate(false);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else {
                            List list = (List)AvailableModifiersDialog.this.parent;
                            modifier.setPrivate(true);
                            list.getPrivateMods().add(modifier);
                        }
                        modifier.setAvailableCheck(true);
                        boolean bl = true;
                        for (int i = recentlySelected.size() - 1; i >= 0; --i) {
                            Modifier modifier2 = (Modifier)recentlySelected.get(i);
                            modifier2.setParent(modifier.getProgenitor());
                            modifier2.setFullDisplay(true);
                            modifier.setFullDisplay(true);
                            if (!modifier2.getXMLID().equals(modifier.getXMLID()) || !modifier2.toString().equals(modifier.toString())) continue;
                            recentlySelected.remove(i);
                            recentlySelected.add(0, modifier.clone());
                            bl = false;
                            break;
                        }
                        modifier.setFullDisplay(false);
                        if (bl) {
                            if (recentlySelected.size() > 39) {
                                recentlySelected.remove(0);
                            }
                            modifier.setAvailableCheck(false);
                            Modifier modifier3 = modifier.clone();
                            modifier3.setFullDisplay(true);
                            recentlySelected.add(modifier3);
                        }
                        modifier.setAvailableCheck(false);
                        AvailableModifiersDialog.this.selection = modifier;
                        AvailableModifiersDialog.this.parentDialog.recalc();
                        AvailableModifiersDialog.this.customModifierBtn.setVisible(AvailableModifiersDialog.this.parent.allowsOtherModifiers());
                        AvailableModifiersDialog.this.recalcMods();
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.limList.getSelection();
                    if (modifier == null) {
                        return;
                    }
                    AvailableModifiersDialog.this.selectBtn.doClick();
                }
            }
        });
        this.unAdvList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    Modifier modifier;
                    int n = AvailableModifiersDialog.this.unAdvList.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0) {
                        AvailableModifiersDialog.this.unAdvList.setSelectedRow(n);
                    }
                    if ((modifier = (Modifier)AvailableModifiersDialog.this.unAdvList.getSelection()) != null) {
                        if (!AvailableModifiersDialog.this.included(modifier = modifier.clone()) && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
                            modifier.setForceAllow(true);
                        }
                        modifier.setParent(AvailableModifiersDialog.this.parent);
                        if (AvailableModifiersDialog.this.privateMods && AvailableModifiersDialog.this.parent instanceof NakedModifier) {
                            modifier.setPrivate(true);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else if (!AvailableModifiersDialog.this.privateMods || !(AvailableModifiersDialog.this.parent instanceof List)) {
                            modifier.setPrivate(false);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else {
                            List list = (List)AvailableModifiersDialog.this.parent;
                            modifier.setPrivate(true);
                            list.getPrivateMods().add(modifier);
                        }
                        modifier.setAvailableCheck(true);
                        boolean bl = true;
                        for (int i = recentlySelected.size() - 1; i >= 0; --i) {
                            Modifier modifier2 = (Modifier)recentlySelected.get(i);
                            modifier2.setParent(modifier.getProgenitor());
                            modifier2.setFullDisplay(true);
                            modifier.setFullDisplay(true);
                            if (!modifier2.getXMLID().equals(modifier.getXMLID()) || !modifier2.toString().equals(modifier.toString())) continue;
                            recentlySelected.remove(i);
                            recentlySelected.add(0, modifier.clone());
                            bl = false;
                            break;
                        }
                        modifier.setFullDisplay(false);
                        if (bl) {
                            if (recentlySelected.size() > 39) {
                                recentlySelected.remove(0);
                            }
                            modifier.setAvailableCheck(false);
                            Modifier modifier3 = modifier.clone();
                            modifier3.setFullDisplay(true);
                            recentlySelected.add(modifier3);
                        }
                        modifier.setAvailableCheck(false);
                        AvailableModifiersDialog.this.selection = modifier;
                        AvailableModifiersDialog.this.parentDialog.recalc();
                        AvailableModifiersDialog.this.customModifierBtn.setVisible(AvailableModifiersDialog.this.parent.allowsOtherModifiers());
                        AvailableModifiersDialog.this.recalcMods();
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.unAdvList.getSelection();
                    if (modifier == null) {
                        return;
                    }
                    AvailableModifiersDialog.this.selectBtn.doClick();
                }
            }
        });
        this.unLimList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    Modifier modifier;
                    int n = AvailableModifiersDialog.this.unLimList.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0) {
                        AvailableModifiersDialog.this.unLimList.setSelectedRow(n);
                    }
                    if ((modifier = (Modifier)AvailableModifiersDialog.this.unLimList.getSelection()) != null) {
                        if (!AvailableModifiersDialog.this.included(modifier = modifier.clone()) && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
                            modifier.setForceAllow(true);
                        }
                        modifier.setParent(AvailableModifiersDialog.this.parent);
                        if (AvailableModifiersDialog.this.privateMods && AvailableModifiersDialog.this.parent instanceof NakedModifier) {
                            modifier.setPrivate(true);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else if (!AvailableModifiersDialog.this.privateMods || !(AvailableModifiersDialog.this.parent instanceof List)) {
                            modifier.setPrivate(false);
                            AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                        } else {
                            List list = (List)AvailableModifiersDialog.this.parent;
                            modifier.setPrivate(true);
                            list.getPrivateMods().add(modifier);
                        }
                        modifier.setAvailableCheck(true);
                        boolean bl = true;
                        for (int i = recentlySelected.size() - 1; i >= 0; --i) {
                            Modifier modifier2 = (Modifier)recentlySelected.get(i);
                            modifier2.setParent(modifier.getProgenitor());
                            modifier2.setFullDisplay(true);
                            modifier.setFullDisplay(true);
                            if (!modifier2.getXMLID().equals(modifier.getXMLID()) || !modifier2.toString().equals(modifier.toString())) continue;
                            recentlySelected.remove(i);
                            recentlySelected.add(0, modifier.clone());
                            bl = false;
                            break;
                        }
                        modifier.setFullDisplay(false);
                        if (bl) {
                            if (recentlySelected.size() > 39) {
                                recentlySelected.remove(0);
                            }
                            modifier.setAvailableCheck(false);
                            Modifier modifier3 = modifier.clone();
                            modifier3.setFullDisplay(true);
                            recentlySelected.add(modifier3);
                        }
                        modifier.setAvailableCheck(false);
                        AvailableModifiersDialog.this.selection = modifier;
                        AvailableModifiersDialog.this.parentDialog.recalc();
                        AvailableModifiersDialog.this.customModifierBtn.setVisible(AvailableModifiersDialog.this.parent.allowsOtherModifiers());
                        AvailableModifiersDialog.this.recalcMods();
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    Modifier modifier = (Modifier)AvailableModifiersDialog.this.unLimList.getSelection();
                    if (modifier == null) {
                        return;
                    }
                    AvailableModifiersDialog.this.selectBtn.doClick();
                }
            }
        });
        this.selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Modifier modifier = null;
                switch (AvailableModifiersDialog.this.tabPane.getSelectedIndex()) {
                    case 0: {
                        modifier = (Modifier)AvailableModifiersDialog.this.advList.getSelection();
                        break;
                    }
                    case 1: {
                        modifier = (Modifier)AvailableModifiersDialog.this.limList.getSelection();
                        break;
                    }
                    case 2: {
                        modifier = (Modifier)AvailableModifiersDialog.this.recentList.getSelection();
                        break;
                    }
                    case 3: {
                        modifier = (Modifier)AvailableModifiersDialog.this.unAdvList.getSelection();
                        break;
                    }
                    case 4: {
                        modifier = (Modifier)AvailableModifiersDialog.this.unLimList.getSelection();
                    }
                }
                if (modifier != null) {
                    if (!AvailableModifiersDialog.this.included(modifier = modifier.clone()) && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
                        modifier.setForceAllow(true);
                    }
                    modifier.setParent(AvailableModifiersDialog.this.parent);
                    ModifierDialog modifierDialog = modifier.getDialog(AvailableModifiersDialog.this.parent, AvailableModifiersDialog.this.tabPane.getSelectedIndex() != 2);
                    modifierDialog.setLocationRelativeTo(AvailableModifiersDialog.this);
                    modifierDialog.setVisible(true);
                    if (!modifierDialog.okButtonClicked) {
                        return;
                    }
                    if (AvailableModifiersDialog.this.privateMods && AvailableModifiersDialog.this.parent instanceof NakedModifier) {
                        modifier.setPrivate(true);
                        AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                    } else if (!AvailableModifiersDialog.this.privateMods || !(AvailableModifiersDialog.this.parent instanceof List)) {
                        modifier.setPrivate(false);
                        AvailableModifiersDialog.this.parent.getAssignedModifiers().add(modifier);
                    } else {
                        List list = (List)AvailableModifiersDialog.this.parent;
                        modifier.setPrivate(true);
                        list.getPrivateMods().add(modifier);
                    }
                    for (Modifier modifier2 : AvailableModifiersDialog.this.parent.getAssignedModifiers()) {
                        modifier2.setSelectedOption(modifier2.getSelectedOption());
                    }
                    modifier.setAvailableCheck(true);
                    boolean bl = true;
                    for (int i = recentlySelected.size() - 1; i >= 0; --i) {
                        Modifier modifier3 = (Modifier)recentlySelected.get(i);
                        modifier3.setParent(modifier.getProgenitor());
                        modifier3.setFullDisplay(true);
                        modifier.setFullDisplay(true);
                        if (!modifier3.getXMLID().equals(modifier.getXMLID()) || !modifier3.toString().equals(modifier.toString())) continue;
                        recentlySelected.remove(i);
                        recentlySelected.add(0, modifier.clone());
                        bl = false;
                        break;
                    }
                    modifier.setFullDisplay(false);
                    if (bl) {
                        if (recentlySelected.size() > 39) {
                            recentlySelected.remove(0);
                        }
                        modifier.setAvailableCheck(false);
                        Modifier modifier4 = modifier.clone();
                        modifier4.setFullDisplay(true);
                        recentlySelected.add(modifier4);
                    }
                    modifier.setAvailableCheck(false);
                    AvailableModifiersDialog.this.selection = modifier;
                    AvailableModifiersDialog.this.parentDialog.recalc();
                    AvailableModifiersDialog.this.customModifierBtn.setVisible(AvailableModifiersDialog.this.parent.allowsOtherModifiers());
                    AvailableModifiersDialog.this.recalcMods();
                }
            }
        });
    }

    private void initWidgets() {
        this.tabPane = new JTabbedPane();
        this.advList = new SelectionList(new ArrayList());
        this.limList = new SelectionList(new ArrayList());
        this.unAdvList = new SelectionList(new ArrayList());
        this.unLimList = new SelectionList(new ArrayList());
        this.recentList = new SelectionList(new ArrayList());
        this.clearBtn = new JButton("Clear List");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.recentList.getTree(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.clearBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.tabPane.addTab("Advantages", this.advList.getTree());
        this.tabPane.addTab("Limitations", this.limList.getTree());
        this.tabPane.addTab("Recently Selected", jPanel);
        this.tabPane.addTab(HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() ? "Unavailable Advantages" : "Non-Recommended Avantages", this.unAdvList.getTree());
        this.tabPane.addTab(HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() ? "Unavailable Limitations" : "Non-Recommended Limitations", this.unLimList.getTree());
        this.tabPane.setTabPlacement(2);
        this.selectBtn = new JButton("Select");
        this.selectBtn.setEnabled(false);
        this.cancelBtn = new JButton("Done");
        this.defineBtn = new JButton("Define");
        this.customModifierBtn = new JButton("Custom Modifier");
        this.customModifierBtn.setVisible(this.parent.allowsOtherModifiers());
        this.defineBtn.setEnabled(false);
        this.recalcMods();
    }

    private void layoutComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.tabPane, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.selectBtn);
        jPanel2.add(this.customModifierBtn);
        jPanel2.add(this.defineBtn);
        jPanel2.add(this.cancelBtn);
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.setOpaque(true);
        this.setContentPane(jPanel);
    }

    private void recalcMods() {
        Modifier modifier;
        int n;
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        ArrayList<Modifier> arrayList2 = new ArrayList<Modifier>();
        ArrayList<Modifier> arrayList3 = new ArrayList<Modifier>();
        ArrayList<Modifier> arrayList4 = new ArrayList<Modifier>();
        ArrayList<Modifier> arrayList5 = new ArrayList<Modifier>();
        List list = this.parent.getParentList();
        block0: for (n = recentlySelected.size() - 1; n >= 0; --n) {
            Modifier modifier2;
            int n2;
            modifier = recentlySelected.get(n);
            modifier.setAvailableCheck(true);
            if (!modifier.getXMLID().equals("MODIFIER") && GenericObject.findObjectByID(this.parent.getAssignedModifiers(), modifier.getXMLID()) != null && modifier.isExclusive()) {
                modifier.setAvailableCheck(false);
                continue;
            }
            modifier.setAvailableCheck(false);
            if (this.included(modifier) || !HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
                modifier.setParent(this.parent);
                for (n2 = 0; n2 < this.parent.getAssignedModifiers().size(); ++n2) {
                    modifier2 = this.parent.getAssignedModifiers().get(n2);
                    if (modifier2.getColumn2Output().equals(modifier.getColumn2Output())) continue block0;
                }
                arrayList.add(modifier);
                continue;
            }
            if (list == null || GenericObject.findObjectByID(list.getAssignedModifiers(), modifier.getXMLID()) == null) continue;
            modifier.setParent(this.parent);
            for (n2 = 0; n2 < this.parent.getAssignedModifiers().size(); ++n2) {
                modifier2 = this.parent.getAssignedModifiers().get(n2);
                if (modifier2.getColumn2Output().equals(modifier.getColumn2Output())) continue block0;
            }
            arrayList.add(modifier);
        }
        Collections.sort(arrayList);
        for (n = 0; n < this.parent.getAvailableModifiers().size(); ++n) {
            modifier = this.parent.getAvailableModifiers().get(n);
            modifier.setAvailableCheck(true);
            if (GenericObject.findObjectByID(this.parent.getAssignedModifiers(), modifier.getXMLID()) != null && modifier.isExclusive()) {
                modifier.setAvailableCheck(false);
                continue;
            }
            modifier.setAvailableCheck(false);
            if (this.included(modifier)) {
                if (modifier.isLimitation()) {
                    arrayList3.add(modifier);
                    continue;
                }
                arrayList2.add(modifier);
                continue;
            }
            if (list != null && GenericObject.findObjectByID(list.getAssignedModifiers(), modifier.getXMLID()) != null) {
                if (modifier.isLimitation()) {
                    arrayList3.add(modifier);
                    continue;
                }
                arrayList2.add(modifier);
                continue;
            }
            if (modifier.isLimitation()) {
                arrayList5.add(modifier);
                continue;
            }
            arrayList4.add(modifier);
        }
        for (n = 0; n < HeroDesigner.getActiveTemplate().getModifiers().size(); ++n) {
            modifier = (Modifier)HeroDesigner.getActiveTemplate().getModifiers().get(n);
            modifier.setAvailableCheck(true);
            if (GenericObject.findObjectByID(this.parent.getAssignedModifiers(), modifier.getXMLID()) != null && modifier.isExclusive() || GenericObject.findObjectByID(this.parent.getAvailableModifiers(), modifier.getXMLID()) != null) {
                modifier.setAvailableCheck(false);
                continue;
            }
            modifier.setAvailableCheck(false);
            if (this.included(modifier)) {
                if (modifier.isLimitation()) {
                    arrayList3.add(modifier);
                    continue;
                }
                arrayList2.add(modifier);
                continue;
            }
            if (list != null && GenericObject.findObjectByID(list.getAssignedModifiers(), modifier.getXMLID()) != null) {
                if (modifier.isLimitation()) {
                    arrayList3.add(modifier);
                    continue;
                }
                arrayList2.add(modifier);
                continue;
            }
            if (modifier.isLimitation()) {
                arrayList5.add(modifier);
                continue;
            }
            arrayList4.add(modifier);
        }
        Collections.sort(arrayList3);
        Collections.sort(arrayList2);
        Collections.sort(arrayList5);
        Collections.sort(arrayList4);
        this.recentList.setAvailableList(arrayList);
        this.advList.setAvailableList(arrayList2);
        this.limList.setAvailableList(arrayList3);
        this.unAdvList.setAvailableList(arrayList4);
        this.unLimList.setAvailableList(arrayList5);
    }

    private void setButtonStates(GenericObject genericObject) {
        if (genericObject == null || !(genericObject instanceof Modifier)) {
            this.selectBtn.setEnabled(false);
            this.defineBtn.setEnabled(false);
        } else {
            String string = this.getDefinition((Modifier)genericObject);
            this.defineBtn.setEnabled(string.trim().length() > 0);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            HeroDesigner.getInstance().getPrefs().setModX(this.getSize().width);
            HeroDesigner.getInstance().getPrefs().setModY(this.getSize().height);
            HeroDesigner.getInstance().getPrefs().setModScreenX((int)this.getLocation().getX());
            HeroDesigner.getInstance().getPrefs().setModScreenY((int)this.getLocation().getY());
        }
        super.setVisible(bl);
    }
}

