/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui.dialog;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.ExportTemplateDialog;
import com.hero.ui.widgets.LevelTF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AppPrefsDialog
extends JDialog {
    private static final long serialVersionUID = 806993432175986846L;
    private JCheckBox restoreWindowCB;
    private JCheckBox rememberDialogCB;
    private JCheckBox loadCharactersCB;
    private JCheckBox loadPrefabsCB;
    private JCheckBox useWindowDecorationsCB;
    private JLabel tabPlacementLbl;
    private JComboBox tabPlacementCombo;
    private JLabel numberDigitsLbl;
    private LevelTF numberDigitsTF;
    private JCheckBox modifierIntelligenceCB;
    private JCheckBox checkModsDuringEditCB;
    private JCheckBox removeIllegalModsCB;
    private JPanel modifierIntelligencePanel;
    private JLabel templateDirLbl;
    private JTextField templateDirTF;
    private JButton templateBrowseBtn;
    private JLabel browserPathLbl;
    private JTextField browserPathTF;
    private JButton browserPathBrowseBtn;
    private JLabel defaultRulesDirLbl;
    private JTextField defaultRulesDirTF;
    private JButton defaultRulesDirBrowseBtn;
    private JLabel defaultExportDirLbl;
    private JTextField defaultExportDirTF;
    private JButton defaultExportDirBrowseBtn;
    private ExportTemplateDialog formatDialog;
    private JLabel defaultAIExportLbl;
    private JTextField defaultAIExportTF;
    private JButton defaultAIExportBrowseBtn;
    private JLabel defaultAutomatonExportLbl;
    private JTextField defaultAutomatonExportTF;
    private JButton defaultAutomatonExportBrowseBtn;
    private JLabel defaultBaseExportLbl;
    private JTextField defaultBaseExportTF;
    private JButton defaultBaseExportBrowseBtn;
    private JLabel defaultComputerExportLbl;
    private JTextField defaultComputerExportTF;
    private JButton defaultComputerExportBrowseBtn;
    private JLabel defaultHeroicExportLbl;
    private JTextField defaultHeroicExportTF;
    private JButton defaultHeroicExportBrowseBtn;
    private JLabel defaultNormalExportLbl;
    private JTextField defaultNormalExportTF;
    private JButton defaultNormalExportBrowseBtn;
    private JLabel defaultSuperheroicExportLbl;
    private JTextField defaultSuperheroicExportTF;
    private JButton defaultSuperheroicExportBrowseBtn;
    private JLabel defaultVehicleExportLbl;
    private JTextField defaultVehicleExportTF;
    private JButton defaultVehicleExportBrowseBtn;
    private JPanel generalPanel;
    private JPanel systemPanel;
    private JPanel displayPanel;
    private JCheckBox metricCB;
    private JCheckBox displayActivePointsCB;
    private JCheckBox useAbbreviationsCB;
    private JCheckBox showPopupDefinitionsCB;
    private JCheckBox useQuickAssignCB;
    private JCheckBox confirmDeleteCB;
    private JComboBox refreshTemplateOnRestoreCB;
    private JLabel refreshTemplateOnRestoreLbl;
    private JComboBox refreshRulesOnRestoreCB;
    private JLabel refreshRulesOnRestoreLbl;
    private JCheckBox warnOnMultipleCB;
    private JCheckBox useWGCB;
    private JCheckBox flagForcedModifiersCB;
    private JCheckBox showCommonLimitationsCB;
    private JPanel templatePanel;
    private JTabbedPane tabPane;
    private JButton doneBtn;
    private JCheckBox showPowersPrefabsOnEquipmentCB;
    private JCheckBox showEquipmentPrefabsOnPowersCB;
    private JCheckBox promptForImageExportCB;
    private JSlider memorySlider;
    private JLabel memoryLbl;

    public AppPrefsDialog() {
        super(HeroDesigner.getAppFrame(), "Preferences", true);
        HeroDesigner.getInstance().getPrefs().setSources(HeroDesigner.getInstance().getPrefs().getSources());
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.pack();
        this.setSize(640, this.getPreferredSize().height);
        this.setLocationRelativeTo(HeroDesigner.getAppFrame());
    }

    private void initListeners() {
        this.promptForImageExportCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setPromptToExportImage(AppPrefsDialog.this.promptForImageExportCB.isSelected());
            }
        });
        this.showPowersPrefabsOnEquipmentCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setShowPowersPrefabsOnEquipment(AppPrefsDialog.this.showPowersPrefabsOnEquipmentCB.isSelected());
            }
        });
        this.showEquipmentPrefabsOnPowersCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setShowEquipmentPrefabsOnPowers(AppPrefsDialog.this.showEquipmentPrefabsOnPowersCB.isSelected());
            }
        });
        this.tabPlacementCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HeroDesigner.getInstance().getPrefs().setTabPosition(AppPrefsDialog.this.tabPlacementCombo.getSelectedIndex() + 1);
                AppPrefsDialog.this.tabPane.setTabPlacement(AppPrefsDialog.this.tabPlacementCombo.getSelectedIndex() + 1);
            }
        });
        this.confirmDeleteCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setConfirmDelete(AppPrefsDialog.this.confirmDeleteCB.isSelected());
            }
        });
        this.warnOnMultipleCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setWarnOnMultiple(AppPrefsDialog.this.warnOnMultipleCB.isSelected());
            }
        });
        this.useQuickAssignCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setUseQuickAssign(AppPrefsDialog.this.useQuickAssignCB.isSelected());
            }
        });
        this.useWGCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setUseWG(AppPrefsDialog.this.useWGCB.isSelected());
            }
        });
        this.flagForcedModifiersCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setFlagForcedModifiers(AppPrefsDialog.this.flagForcedModifiersCB.isSelected());
            }
        });
        this.useAbbreviationsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setUseAbbreviations(AppPrefsDialog.this.useAbbreviationsCB.isSelected());
            }
        });
        this.showPopupDefinitionsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setShowPopupDefinitions(AppPrefsDialog.this.showPopupDefinitionsCB.isSelected());
            }
        });
        this.metricCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setMetric(AppPrefsDialog.this.metricCB.isSelected());
            }
        });
        this.displayActivePointsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setDisplayActivePoints(AppPrefsDialog.this.displayActivePointsCB.isSelected());
            }
        });
        this.showCommonLimitationsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setShowCommonLimitations(AppPrefsDialog.this.showCommonLimitationsCB.isSelected());
            }
        });
        this.modifierIntelligenceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setModifierIntelligenceOn(AppPrefsDialog.this.modifierIntelligenceCB.isSelected());
                AppPrefsDialog.this.checkModsDuringEditCB.setEnabled(AppPrefsDialog.this.modifierIntelligenceCB.isSelected());
                AppPrefsDialog.this.removeIllegalModsCB.setEnabled(AppPrefsDialog.this.modifierIntelligenceCB.isSelected() && AppPrefsDialog.this.checkModsDuringEditCB.isSelected());
            }
        });
        this.checkModsDuringEditCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setCheckModsDuringEdit(AppPrefsDialog.this.checkModsDuringEditCB.isSelected());
                AppPrefsDialog.this.removeIllegalModsCB.setEnabled(AppPrefsDialog.this.modifierIntelligenceCB.isSelected() && AppPrefsDialog.this.checkModsDuringEditCB.isSelected());
            }
        });
        this.removeIllegalModsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setRemoveIllegalMods(AppPrefsDialog.this.removeIllegalModsCB.isSelected());
            }
        });
        this.restoreWindowCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setRestoreWindow(AppPrefsDialog.this.restoreWindowCB.isSelected());
            }
        });
        this.useWindowDecorationsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File("HeroDesigner.lax");
                if (file.exists()) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byte[] byArray = new byte[(int)file.length()];
                        fileInputStream.read(byArray);
                        String string = new String(byArray);
                        fileInputStream.close();
                        if (string.indexOf("lax.command.line.args") > 0) {
                            String string2 = string.substring(0, string.indexOf("lax.command.line.args"));
                            String string3 = string.substring(string.indexOf("\n", string.indexOf("lax.command.line.args")), string.length());
                            String string4 = string2 + "lax.command.line.args=$CMD_LINE_ARGUMENTS$";
                            string4 = AppPrefsDialog.this.useWindowDecorationsCB.isSelected() ? string4 + "\n" : string4 + " noDecorations\n";
                            string4 = string4 + string3;
                            RandomAccessFile randomAccessFile = new RandomAccessFile("HeroDesigner.lax", "rw");
                            randomAccessFile.writeBytes(string4);
                            randomAccessFile.setLength(randomAccessFile.getFilePointer());
                            randomAccessFile.close();
                            JOptionPane.showMessageDialog(AppPrefsDialog.this, "You must restart for this change to take effect.", "Restart Needed", 1);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                }
            }
        });
        this.rememberDialogCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setRememberDialogPosition(AppPrefsDialog.this.rememberDialogCB.isSelected());
            }
        });
        this.loadCharactersCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setLoadCharacters(AppPrefsDialog.this.loadCharactersCB.isSelected());
            }
        });
        this.loadPrefabsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.getInstance().getPrefs().setLoadPrefabs(AppPrefsDialog.this.loadPrefabsCB.isSelected());
            }
        });
        this.templateBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setApproveButtonText("Select");
                jFileChooser.setDialogTitle("Select Character Template Directory");
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getTemplateDir()));
                jFileChooser.setSelectedFile(new File(HeroDesigner.getInstance().getPrefs().getTemplateDir()));
                int n = jFileChooser.showDialog(AppPrefsDialog.this, "Select");
                if (n == 1) {
                    return;
                }
                if (n == 0) {
                    HeroDesigner.getInstance().getPrefs().setTemplateDir(jFileChooser.getSelectedFile().getAbsolutePath());
                    AppPrefsDialog.this.templateDirTF.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.browserPathTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getInstance().getPrefs().setBrowserExecutablePath(AppPrefsDialog.this.browserPathTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getInstance().getPrefs().setBrowserExecutablePath(AppPrefsDialog.this.browserPathTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getInstance().getPrefs().setBrowserExecutablePath(AppPrefsDialog.this.browserPathTF.getText());
            }
        });
        this.browserPathBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setApproveButtonText("Select");
                jFileChooser.setDialogTitle("Select Browser Executable");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                if (HeroDesigner.getInstance().getPrefs().getBrowserExecutablePath() != null) {
                    jFileChooser.setSelectedFile(new File(HeroDesigner.getInstance().getPrefs().getBrowserExecutablePath()));
                }
                if ((n = jFileChooser.showDialog(AppPrefsDialog.this, "Select")) == 1) {
                    return;
                }
                if (n == 0) {
                    HeroDesigner.getInstance().getPrefs().setBrowserExecutablePath(jFileChooser.getSelectedFile().getAbsolutePath());
                    AppPrefsDialog.this.browserPathTF.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.defaultRulesDirBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setApproveButtonText("Select");
                jFileChooser.setDialogTitle("Select Default Campaign Rules Directory");
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getDefaultRulesDir()));
                jFileChooser.setSelectedFile(new File(HeroDesigner.getInstance().getPrefs().getDefaultRulesDir()));
                int n = jFileChooser.showDialog(AppPrefsDialog.this, "Select");
                if (n == 1) {
                    return;
                }
                if (n == 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultRulesDir(jFileChooser.getSelectedFile().getAbsolutePath());
                    AppPrefsDialog.this.defaultRulesDirTF.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.defaultExportDirBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setApproveButtonText("Select");
                jFileChooser.setDialogTitle("Select Default Export Template Directory");
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setCurrentDirectory(new File(HeroDesigner.getInstance().getPrefs().getDefaultExportDir()));
                jFileChooser.setSelectedFile(new File(HeroDesigner.getInstance().getPrefs().getDefaultExportDir()));
                int n = jFileChooser.showDialog(AppPrefsDialog.this, "Select");
                if (n == 1) {
                    return;
                }
                if (n == 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultExportDir(jFileChooser.getSelectedFile().getAbsolutePath());
                    AppPrefsDialog.this.defaultExportDirTF.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.defaultAIExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default AI Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultAIFormatPath(string);
                    AppPrefsDialog.this.defaultAIExportTF.setText(string);
                }
            }
        });
        this.defaultAutomatonExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default Automaton Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultAutomatonFormatPath(string);
                    AppPrefsDialog.this.defaultAutomatonExportTF.setText(string);
                }
            }
        });
        this.defaultBaseExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default Base Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultBaseFormatPath(string);
                    AppPrefsDialog.this.defaultBaseExportTF.setText(string);
                }
            }
        });
        this.defaultComputerExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default Computer Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultComputerFormatPath(string);
                    AppPrefsDialog.this.defaultComputerExportTF.setText(string);
                }
            }
        });
        this.defaultHeroicExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default Heroic Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultHeroicFormatPath(string);
                    AppPrefsDialog.this.defaultHeroicExportTF.setText(string);
                }
            }
        });
        this.defaultNormalExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default Normal Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultNormalFormatPath(string);
                    AppPrefsDialog.this.defaultNormalExportTF.setText(string);
                }
            }
        });
        this.defaultSuperheroicExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default Superheroic Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultSuperheroicFormatPath(string);
                    AppPrefsDialog.this.defaultSuperheroicExportTF.setText(string);
                }
            }
        });
        this.defaultVehicleExportBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AppPrefsDialog.this.formatDialog == null) {
                    AppPrefsDialog.this.formatDialog = new ExportTemplateDialog();
                }
                AppPrefsDialog.this.formatDialog.setDialogTitle("Select Default Vehicle Export Format");
                AppPrefsDialog.this.formatDialog.showOpenDialog(AppPrefsDialog.this);
                if (AppPrefsDialog.this.formatDialog.canceled()) {
                    return;
                }
                String string = AppPrefsDialog.this.formatDialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getInstance().getPrefs().setDefaultVehicleFormatPath(string);
                    AppPrefsDialog.this.defaultVehicleExportTF.setText(string);
                }
            }
        });
        this.doneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppPrefsDialog.this.setVisible(false);
                AppPrefsDialog.this.dispose();
            }
        });
        this.numberDigitsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HeroDesigner.getInstance().getPrefs().setNumberDigitsForRounding(AppPrefsDialog.this.numberDigitsTF.getCurrent());
            }
        });
        this.refreshTemplateOnRestoreCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HeroDesigner.getInstance().getPrefs().setRefreshTemplateOnRestore(AppPrefsDialog.this.refreshTemplateOnRestoreCB.getSelectedIndex() + 1);
            }
        });
        this.refreshRulesOnRestoreCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HeroDesigner.getInstance().getPrefs().setRefreshRulesOnRestore(AppPrefsDialog.this.refreshRulesOnRestoreCB.getSelectedIndex() + 1);
            }
        });
        this.memorySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HeroDesigner.getInstance().getPrefs().setMaximumHeapSize(AppPrefsDialog.this.memorySlider.getValue());
                if (!AppPrefsDialog.this.memorySlider.getValueIsAdjusting()) {
                    JOptionPane.showMessageDialog(AppPrefsDialog.this, "Please restart HERODesigner for these changes to take effect.", "Restart HD", 2);
                }
            }
        });
    }

    private void initWidgets() {
        this.memorySlider = new JSlider(64, 512);
        this.memorySlider.setMajorTickSpacing(64);
        this.memorySlider.setMinorTickSpacing(16);
        this.memorySlider.setOrientation(0);
        this.memorySlider.setPaintLabels(true);
        this.memorySlider.setPaintTicks(true);
        this.memorySlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(64, new JLabel("64MB"));
        hashtable.put(128, new JLabel("128MB"));
        hashtable.put(192, new JLabel("192MB"));
        hashtable.put(256, new JLabel("256MB"));
        hashtable.put(320, new JLabel("320MB"));
        hashtable.put(384, new JLabel("384MB"));
        hashtable.put(448, new JLabel("448MB"));
        hashtable.put(512, new JLabel("512MB"));
        this.memorySlider.setLabelTable(hashtable);
        this.memorySlider.setValue(HeroDesigner.getInstance().getPrefs().getMaximumHeapSize());
        this.memorySlider.setToolTipText("<html>This is an advanced setting and should only be changed by experienced users.<br />The default value of 64MB should suffice for normal operations of HERODesigner.</html>");
        this.memoryLbl = new JLabel("Maximum memory for HERO Designer process (MB) [ADVANCED USERS ONLY -- 64MB strongly recommended]:");
        this.promptForImageExportCB = new JCheckBox("Prompt to export image file when exporting character");
        this.promptForImageExportCB.setSelected(HeroDesigner.getInstance().getPrefs().getPromptToExportImage());
        this.tabPane = new JTabbedPane();
        this.tabPane.setTabPlacement(HeroDesigner.getInstance().getPrefs().getTabPosition());
        this.tabPlacementLbl = new JLabel("Tab Placement");
        this.tabPlacementCombo = new JComboBox();
        this.tabPlacementCombo.addItem("Top");
        this.tabPlacementCombo.addItem("Left");
        this.tabPlacementCombo.addItem("Bottom");
        this.tabPlacementCombo.addItem("Right");
        this.tabPlacementCombo.setSelectedIndex(HeroDesigner.getInstance().getPrefs().getTabPosition() - 1);
        this.useWindowDecorationsCB = new JCheckBox("Use Java window decorations (requires restart)");
        this.useWindowDecorationsCB.setSelected(JFrame.isDefaultLookAndFeelDecorated());
        this.restoreWindowCB = new JCheckBox("Restore window position on startup");
        this.restoreWindowCB.setSelected(HeroDesigner.getInstance().getPrefs().isRestoreWindow());
        this.rememberDialogCB = new JCheckBox("Remember dialog position and size");
        this.rememberDialogCB.setSelected(HeroDesigner.getInstance().getPrefs().isRememberDialogPosition());
        this.loadCharactersCB = new JCheckBox("Load characters on startup");
        this.loadCharactersCB.setSelected(HeroDesigner.getInstance().getPrefs().isLoadCharacters());
        this.loadPrefabsCB = new JCheckBox("Load prefabs on startup");
        this.loadPrefabsCB.setSelected(HeroDesigner.getInstance().getPrefs().isLoadPrefabs());
        this.metricCB = new JCheckBox("Use metric units of measurement for character Height and Weight");
        this.metricCB.setSelected(HeroDesigner.getInstance().getPrefs().isMetric());
        this.displayActivePointsCB = new JCheckBox("Display Active Points on abilities (by default)");
        this.displayActivePointsCB.setSelected(HeroDesigner.getInstance().getPrefs().displayActivePoints());
        this.showCommonLimitationsCB = new JCheckBox("Show Common Limitations in slots on Lists/Frameworks");
        this.showCommonLimitationsCB.setSelected(HeroDesigner.getInstance().getPrefs().showCommonLimitations());
        this.useAbbreviationsCB = new JCheckBox("Use Abbreviations (where available)");
        this.useAbbreviationsCB.setSelected(HeroDesigner.getInstance().getPrefs().useAbbreviations());
        this.showPopupDefinitionsCB = new JCheckBox("Show Popup definitions in selection lists");
        this.showPopupDefinitionsCB.setSelected(HeroDesigner.getInstance().getPrefs().showPopupDefinitions());
        this.showPowersPrefabsOnEquipmentCB = new JCheckBox("Show Powers Prefabs on the Equipment Tab");
        this.showPowersPrefabsOnEquipmentCB.setSelected(HeroDesigner.getInstance().getPrefs().getShowPowersPrefabsOnEquipment());
        this.showEquipmentPrefabsOnPowersCB = new JCheckBox("Show Equipment Prefabs on the Powers Tab");
        this.showEquipmentPrefabsOnPowersCB.setSelected(HeroDesigner.getInstance().getPrefs().getShowEquipmentPrefabsOnPowers());
        this.useQuickAssignCB = new JCheckBox("Use \"Quick Assign\" on abilities (where available)");
        this.useQuickAssignCB.setSelected(HeroDesigner.getInstance().getPrefs().useQuickAssign());
        this.confirmDeleteCB = new JCheckBox("Confirm deletions (recommended)");
        this.confirmDeleteCB.setSelected(HeroDesigner.getInstance().getPrefs().confirmDelete());
        this.warnOnMultipleCB = new JCheckBox("Warn on duplicate purchases");
        this.warnOnMultipleCB.setSelected(HeroDesigner.getInstance().getPrefs().warnOnMultiple());
        this.useWGCB = new JCheckBox("Use strict Writers' Guidelines compliance");
        this.useWGCB.setSelected(HeroDesigner.getInstance().getPrefs().useWG());
        this.flagForcedModifiersCB = new JCheckBox("Flag Forced Modifiers");
        this.flagForcedModifiersCB.setSelected(HeroDesigner.getInstance().getPrefs().flagForcedModifiers());
        this.modifierIntelligenceCB = new JCheckBox("Use 'Modifier Intelligence' (strongly recommended)");
        this.modifierIntelligenceCB.setSelected(HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn());
        this.checkModsDuringEditCB = new JCheckBox("Check Modifiers during ability edit (recommended)");
        this.checkModsDuringEditCB.setSelected(HeroDesigner.getInstance().getPrefs().checkModsDuringEdit());
        this.checkModsDuringEditCB.setEnabled(HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn());
        this.removeIllegalModsCB = new JCheckBox("Remove Modifiers which fail validity check (recommended)");
        this.removeIllegalModsCB.setSelected(HeroDesigner.getInstance().getPrefs().removeIllegalMods());
        this.removeIllegalModsCB.setEnabled(HeroDesigner.getInstance().getPrefs().checkModsDuringEdit());
        this.modifierIntelligencePanel = new JPanel(new GridBagLayout());
        this.refreshTemplateOnRestoreLbl = new JLabel("Refresh character template from file during load?");
        this.refreshRulesOnRestoreLbl = new JLabel("Refresh campaign rules from file during load?");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Always");
        arrayList.add("Prompt");
        arrayList.add("Never");
        this.refreshTemplateOnRestoreCB = new JComboBox<Object>(arrayList.toArray());
        this.refreshTemplateOnRestoreCB.setSelectedIndex(HeroDesigner.getInstance().getPrefs().getRefreshTemplateOnRestore() - 1);
        this.refreshRulesOnRestoreCB = new JComboBox<Object>(arrayList.toArray());
        this.refreshRulesOnRestoreCB.setSelectedIndex(HeroDesigner.getInstance().getPrefs().getRefreshRulesOnRestore() - 1);
        this.numberDigitsLbl = new JLabel("Number of decimal places for rounding:");
        this.numberDigitsTF = new LevelTF(HeroDesigner.getInstance().getPrefs().getNumberDigitsForRounding(), 10, 0);
        this.templateDirLbl = new JLabel("Character template directory:");
        this.templateDirTF = new JTextField(HeroDesigner.getInstance().getPrefs().getTemplateDir());
        this.templateDirTF.setEnabled(false);
        this.templateBrowseBtn = new JButton("Browse...");
        this.browserPathLbl = new JLabel("Browser executable (override default):");
        this.browserPathTF = new JTextField(HeroDesigner.getInstance().getPrefs().getBrowserExecutablePath());
        this.browserPathTF.setEnabled(true);
        this.browserPathBrowseBtn = new JButton("Browse...");
        this.defaultRulesDirLbl = new JLabel("Default Campaign Rules directory:");
        this.defaultRulesDirTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultRulesDir());
        this.defaultRulesDirTF.setEnabled(false);
        this.defaultRulesDirBrowseBtn = new JButton("Browse...");
        this.defaultExportDirLbl = new JLabel("Default Export Template directory:");
        this.defaultExportDirTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultExportDir());
        this.defaultExportDirTF.setEnabled(false);
        this.defaultExportDirBrowseBtn = new JButton("Browse...");
        this.defaultAIExportLbl = new JLabel("Default AI Export Format:");
        this.defaultAIExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultAIFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultAIFormatPath() : "");
        this.defaultAIExportTF.setEnabled(false);
        this.defaultAIExportBrowseBtn = new JButton("Browse...");
        this.defaultAutomatonExportLbl = new JLabel("Default Automaton Export Format:");
        this.defaultAutomatonExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultAutomatonFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultAutomatonFormatPath() : "");
        this.defaultAutomatonExportTF.setEnabled(false);
        this.defaultAutomatonExportBrowseBtn = new JButton("Browse...");
        this.defaultBaseExportLbl = new JLabel("Default Base Export Format:");
        this.defaultBaseExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultBaseFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultBaseFormatPath() : "");
        this.defaultBaseExportTF.setEnabled(false);
        this.defaultBaseExportBrowseBtn = new JButton("Browse...");
        this.defaultComputerExportLbl = new JLabel("Default Computer Export Format:");
        this.defaultComputerExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultComputerFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultComputerFormatPath() : "");
        this.defaultComputerExportTF.setEnabled(false);
        this.defaultComputerExportBrowseBtn = new JButton("Browse...");
        this.defaultHeroicExportLbl = new JLabel("Default Heroic Export Format:");
        this.defaultHeroicExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultHeroicFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultHeroicFormatPath() : "");
        this.defaultHeroicExportTF.setEnabled(false);
        this.defaultHeroicExportBrowseBtn = new JButton("Browse...");
        this.defaultNormalExportLbl = new JLabel("Default Normal Export Format:");
        this.defaultNormalExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultNormalFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultNormalFormatPath() : "");
        this.defaultNormalExportTF.setEnabled(false);
        this.defaultNormalExportBrowseBtn = new JButton("Browse...");
        this.defaultSuperheroicExportLbl = new JLabel("Default Superheroic Export Format:");
        this.defaultSuperheroicExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultSuperheroicFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultSuperheroicFormatPath() : "");
        this.defaultSuperheroicExportTF.setEnabled(false);
        this.defaultSuperheroicExportBrowseBtn = new JButton("Browse...");
        this.defaultVehicleExportLbl = new JLabel("Default Vehicle Export Format:");
        this.defaultVehicleExportTF = new JTextField(HeroDesigner.getInstance().getPrefs().getDefaultVehicleFormatPath() != null ? HeroDesigner.getInstance().getPrefs().getDefaultVehicleFormatPath() : "");
        this.defaultVehicleExportTF.setEnabled(false);
        this.defaultVehicleExportBrowseBtn = new JButton("Browse...");
        this.generalPanel = new JPanel(new GridBagLayout());
        this.systemPanel = new JPanel(new GridBagLayout());
        this.displayPanel = new JPanel(new GridBagLayout());
        this.doneBtn = new JButton("Done");
        this.templatePanel = new JPanel(new GridBagLayout());
    }

    private void layoutComponent() {
        JPanel jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 2, 5);
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        this.generalPanel.add((Component)this.restoreWindowCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.generalPanel.add((Component)this.rememberDialogCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.generalPanel.add((Component)this.loadCharactersCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        this.generalPanel.add((Component)this.loadPrefabsCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        this.generalPanel.add((Component)this.tabPlacementLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.generalPanel.add((Component)this.tabPlacementCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        if (System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0) {
            this.generalPanel.add((Component)this.memoryLbl, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.generalPanel.add((Component)this.memorySlider, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        this.generalPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.displayPanel.add((Component)this.useWGCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.displayPanel.add((Component)this.flagForcedModifiersCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.displayPanel.add((Component)this.metricCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.displayPanel.add((Component)this.displayActivePointsCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.displayPanel.add((Component)this.showCommonLimitationsCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.displayPanel.add((Component)this.useAbbreviationsCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.displayPanel.add((Component)this.showPopupDefinitionsCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.displayPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        this.systemPanel.add((Component)this.confirmDeleteCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.systemPanel.add((Component)this.warnOnMultipleCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.systemPanel.add((Component)this.useQuickAssignCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.systemPanel.add((Component)this.promptForImageExportCB, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.browserPathLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.browserPathBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.browserPathTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.refreshTemplateOnRestoreLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.systemPanel.add((Component)this.refreshTemplateOnRestoreCB, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.refreshRulesOnRestoreLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.systemPanel.add((Component)this.refreshRulesOnRestoreCB, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.numberDigitsLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.systemPanel.add((Component)this.numberDigitsTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.templateDirLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.templateBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.templateDirTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultRulesDirLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultRulesDirBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultRulesDirTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultExportDirLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultExportDirBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultExportDirTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultAIExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultAIExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultAIExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultAutomatonExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultAutomatonExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultAutomatonExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultBaseExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultBaseExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultBaseExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultComputerExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultComputerExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultComputerExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultHeroicExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultHeroicExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultHeroicExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultNormalExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultNormalExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultNormalExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultSuperheroicExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultSuperheroicExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultSuperheroicExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultVehicleExportLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)this.defaultVehicleExportBrowseBtn, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.systemPanel.add((Component)this.defaultVehicleExportTF, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        this.systemPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.modifierIntelligencePanel.add((Component)this.modifierIntelligenceCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.modifierIntelligencePanel.add((Component)this.checkModsDuringEditCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.modifierIntelligencePanel.add((Component)this.removeIllegalModsCB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.modifierIntelligencePanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.tabPane.addTab("General", new JScrollPane(this.generalPanel));
        this.tabPane.addTab("System", new JScrollPane(this.systemPanel));
        this.tabPane.addTab("Display", new JScrollPane(this.displayPanel));
        this.tabPane.addTab("Modifier Intelligence", new JScrollPane(this.modifierIntelligencePanel));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Collections.sort(GenericObject.getAllSources());
        jPanel2.add((Component)this.showPowersPrefabsOnEquipmentCB, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.showEquipmentPrefabsOnPowersCB, gridBagConstraints2);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        jPanel2.add((Component)new JPanel(), gridBagConstraints2);
        this.tabPane.add("Prefabs", new JScrollPane(jPanel2));
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            jPanel = new JPanel(new GridBagLayout());
            Collections.sort(GenericObject.getAllSources());
            for (int i = 0; i < GenericObject.getAllSources().size(); ++i) {
                SourceCheckBox sourceCheckBox = new SourceCheckBox(GenericObject.getAllSources().get(i).toString());
                jPanel.add((Component)sourceCheckBox, gridBagConstraints2);
                ++gridBagConstraints2.gridy;
            }
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            this.templatePanel.add((Component)jPanel, gridBagConstraints2);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            this.templatePanel.add((Component)new JPanel(), gridBagConstraints2);
            jPanel.setBorder(BorderFactory.createTitledBorder("Allowed Source Books (5th Edition Rules only)"));
            this.tabPane.add("Template", new JScrollPane(this.templatePanel));
        }
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.tabPane), "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.doneBtn);
        jPanel.add((Component)jPanel3, "South");
        this.setContentPane(jPanel);
    }

    private class SourceCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = -6843140849309040619L;
        private String source;

        public SourceCheckBox(String string) {
            super(string);
            this.source = string;
            this.setSelected(HeroDesigner.getInstance().getPrefs().getSources().contains(this.source));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceCheckBox.this.isSelected()) {
                        if (HeroDesigner.getInstance().getPrefs().getSources().contains(SourceCheckBox.this.source)) {
                            return;
                        }
                        HeroDesigner.getInstance().getPrefs().getSources().add(SourceCheckBox.this.source);
                    } else {
                        HeroDesigner.getInstance().getPrefs().getSources().remove(SourceCheckBox.this.source);
                    }
                }
            });
        }
    }
}

