/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;
import com.hero.ui.AbilityPanel;
import com.hero.ui.GenericObjectList;
import com.hero.ui.SkillList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SkillsPanel
extends AbilityPanel {
    private static final long serialVersionUID = 8264817429833117811L;
    JMenu skillEnhancersMenu;

    protected void checkIndices() {
        this.selectionList.checkIndices();
        ((SkillList)this.selectionList).setEnhancerLists();
    }

    @Override
    protected GenericObjectList createSelectionList() {
        return new SkillList();
    }

    @Override
    protected String getAvailableLabel() {
        return "Skills";
    }

    @Override
    protected ArrayList<GenericObject> getAvailableObjects() {
        return HeroDesigner.getActiveTemplate().getSkills();
    }

    @Override
    protected ArrayList<GenericObject> getAvailablePrefabs() {
        return HeroDesigner.getInstance().getPrefabSkills();
    }

    @Override
    protected ArrayList<GenericObject> getObjects() {
        return HeroDesigner.getActiveHero().getSkills();
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.skillEnhancersMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                for (int i = 0; i < SkillsPanel.this.skillEnhancersMenu.getItemCount(); ++i) {
                    boolean bl = false;
                    SkillEnhancerMenuItem skillEnhancerMenuItem = (SkillEnhancerMenuItem)SkillsPanel.this.skillEnhancersMenu.getItem(i);
                    for (int j = 0; j < HeroDesigner.getActiveHero().getSkills().size(); ++j) {
                        GenericObject genericObject = HeroDesigner.getActiveHero().getSkills().get(j);
                        if (!genericObject.getXMLID().equals(skillEnhancerMenuItem.getXMLID())) continue;
                        bl = true;
                        break;
                    }
                    skillEnhancerMenuItem.setSelected(bl);
                }
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.skillEnhancersMenu = new JMenu("Skill Enhancers");
        ArrayList<GenericObject> arrayList = HeroDesigner.getActiveTemplate().getSkillEnhancers();
        for (int i = 0; i < arrayList.size(); ++i) {
            GenericObject genericObject = arrayList.get(i);
            if (genericObject.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) continue;
            SkillEnhancerMenuItem skillEnhancerMenuItem = new SkillEnhancerMenuItem(this, genericObject.getDisplay(), genericObject.getXMLID());
            for (int j = 0; j < HeroDesigner.getActiveHero().getSkills().size(); ++j) {
                GenericObject genericObject2 = HeroDesigner.getActiveHero().getSkills().get(j);
                if (!genericObject2.getXMLID().equals(genericObject.getXMLID())) continue;
                skillEnhancerMenuItem.setSelected(true);
            }
            this.skillEnhancersMenu.add(skillEnhancerMenuItem);
        }
        this.menuBar.add(this.skillEnhancersMenu);
    }

    @Override
    protected boolean isEquipment() {
        return false;
    }

    @Override
    protected boolean isPower() {
        return false;
    }

    @Override
    public void reset() {
        this.selectionList.setData(HeroDesigner.getActiveHero().getSkills());
        this.availableList.setAvailableList(HeroDesigner.getActiveTemplate().getSkills());
        this.skillEnhancersMenu.removeAll();
        ArrayList<GenericObject> arrayList = HeroDesigner.getActiveTemplate().getSkillEnhancers();
        for (int i = 0; i < arrayList.size(); ++i) {
            GenericObject genericObject = arrayList.get(i);
            if (genericObject.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) continue;
            SkillEnhancerMenuItem skillEnhancerMenuItem = new SkillEnhancerMenuItem(this, genericObject.getDisplay(), genericObject.getXMLID());
            for (int j = 0; j < HeroDesigner.getActiveHero().getSkills().size(); ++j) {
                GenericObject genericObject2 = HeroDesigner.getActiveHero().getSkills().get(j);
                if (!genericObject2.getXMLID().equals(genericObject.getXMLID())) continue;
                skillEnhancerMenuItem.setSelected(true);
            }
            this.skillEnhancersMenu.add(skillEnhancerMenuItem);
        }
        this.skillEnhancersMenu.setVisible(this.skillEnhancersMenu.getItemCount() > 0);
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers()) {
            this.skillEnhancersMenu.setText("Skill Multipliers");
        } else {
            this.skillEnhancersMenu.setText("Skill Enhancers");
        }
    }

    class SkillEnhancerMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 737095613566716564L;
        SkillsPanel parent;
        String xmlID;

        public SkillEnhancerMenuItem(SkillsPanel skillsPanel2, String string, String string2) {
            super(string);
            this.xmlID = string2;
            this.parent = skillsPanel2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList<GenericObject> arrayList = HeroDesigner.getActiveHero().getSkills();
                    if (SkillEnhancerMenuItem.this.isSelected()) {
                        GenericObject genericObject;
                        int n;
                        for (n = 0; n < arrayList.size(); ++n) {
                            genericObject = arrayList.get(n);
                            if (!genericObject.getXMLID().equals(SkillEnhancerMenuItem.this.xmlID)) continue;
                            return;
                        }
                        for (n = 0; n < HeroDesigner.getActiveTemplate().getSkillEnhancers().size(); ++n) {
                            genericObject = HeroDesigner.getActiveTemplate().getSkillEnhancers().get(n);
                            if (!genericObject.getXMLID().equals(SkillEnhancerMenuItem.this.xmlID)) continue;
                            GenericObject genericObject2 = genericObject.clone();
                            SkillEnhancerMenuItem.this.parent.selectionList.addObject(genericObject2);
                            break;
                        }
                    } else {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            GenericObject genericObject = arrayList.get(i);
                            if (!genericObject.getXMLID().equals(SkillEnhancerMenuItem.this.xmlID)) continue;
                            Enhancer enhancer = (Enhancer)genericObject;
                            for (int j = 0; j < enhancer.getObjects().size(); ++j) {
                                GenericObject genericObject3 = enhancer.getObjects().get(j);
                                genericObject3.setParent(null);
                            }
                            arrayList.remove(i);
                            HeroDesigner.getActiveHero().setDirty(true);
                            break;
                        }
                    }
                    SkillEnhancerMenuItem.this.parent.selectionList.updateTotal();
                }
            });
        }

        public String getXMLID() {
            return this.xmlID;
        }
    }
}

