/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.ui.widgets.PopupMessage;
import com.hero.ui.widgets.TipTree;
import com.hero.util.Rounder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SelectionList
extends JComponent {
    private static final ImageIcon stop = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("stop.gif")));
    private static final ImageIcon warn = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("warning.gif")));
    private static final ImageIcon black = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("black.gif")));
    private static final ImageIcon green = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("green.gif")));
    private static final ImageIcon yellow = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("yellow.gif")));
    private static final ImageIcon open = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("openfolder.gif")));
    private static final ImageIcon closed = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("closefolder.gif")));
    private static final long serialVersionUID = -278664391861564657L;
    protected TipTree listTree;
    protected TreeSelectionListener treeListener;
    protected ActionListener defineListener;
    private JScrollPane listScroll;
    protected JButton selectBtn;
    protected JButton defineBtn;
    protected boolean prefab = false;
    private ArrayList<? extends GenericObject> listData;

    public SelectionList(ArrayList<? extends GenericObject> arrayList) {
        this.setLayout(new GridBagLayout());
        this.listData = arrayList;
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    public SelectionList(ArrayList<GenericObject> arrayList, boolean bl) {
        this(arrayList);
        this.prefab = bl;
    }

    public void addActionListener(ActionListener actionListener) {
        this.selectBtn.addActionListener(actionListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.listTree.addMouseListener(mouseListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listTree.addTreeSelectionListener(treeSelectionListener);
    }

    public GenericObject getSelection() {
        if (this.listTree.getSelectionPath() != null) {
            TreePath treePath = this.listTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object != null) {
                GenericObject genericObject = (GenericObject)object;
                try {
                    object = genericObject.clone();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return (GenericObject)object;
            }
            return null;
        }
        return null;
    }

    public JScrollPane getTree() {
        return this.listScroll;
    }

    private void initListeners() {
        this.listScroll.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ((DefaultTreeModel)SelectionList.this.listTree.getModel()).reload();
            }
        });
        this.listTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (SelectionList.this.getSelection() != null && keyEvent.getKeyChar() == '\n') {
                    SelectionList.this.selectBtn.doClick();
                }
            }
        });
        this.treeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (SelectionList.this.getSelection() != null) {
                    SelectionList.this.listTree.scrollPathToVisible(SelectionList.this.listTree.getSelectionPath());
                    if (!(SelectionList.this.getSelection() instanceof List)) {
                        GenericObject genericObject = SelectionList.this.getSelection();
                        if (genericObject.getDefinition() != null && genericObject.getDefinition().trim().length() > 0) {
                            SelectionList.this.defineBtn.setEnabled(true);
                        } else {
                            SelectionList.this.defineBtn.setEnabled(false);
                        }
                        SelectionList.this.selectBtn.setEnabled(true);
                    } else {
                        GenericObject genericObject = SelectionList.this.getSelection();
                        if (genericObject.getDefinition() != null && genericObject.getDefinition().trim().length() > 0) {
                            SelectionList.this.defineBtn.setEnabled(true);
                        } else {
                            SelectionList.this.defineBtn.setEnabled(false);
                        }
                        SelectionList.this.selectBtn.setEnabled(false);
                    }
                } else {
                    SelectionList.this.defineBtn.setEnabled(false);
                    SelectionList.this.selectBtn.setEnabled(false);
                }
            }
        };
        this.listTree.addTreeSelectionListener(this.treeListener);
        this.defineListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObject genericObject = SelectionList.this.getSelection();
                if (genericObject == null) {
                    return;
                }
                String string = genericObject.getNotes();
                if (string == null || string.trim().length() == 0) {
                    string = genericObject.getDefinition();
                }
                if (string == null) {
                    return;
                }
                if (string.trim().length() == 0) {
                    return;
                }
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), SelectionList.this.defineBtn, string, false);
                popupMessage.setVisible(true);
            }
        };
        this.defineBtn.addActionListener(this.defineListener);
    }

    private void initWidgets() {
        if (this.listData == null) {
            this.listData = new ArrayList();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.listTree = new TipTree(defaultMutableTreeNode);
        this.listTree.setToolTipText("Blah");
        this.listTree.setRowHeight(-1);
        this.listTree.setCellRenderer(new Renderer());
        this.listTree.setRootVisible(false);
        this.listTree.setShowsRootHandles(true);
        this.listTree.getSelectionModel().setSelectionMode(1);
        this.listTree.setBackground(Color.white);
        this.listTree.setOpaque(true);
        this.setAvailableList(this.listData);
        this.listScroll = new JScrollPane(this.listTree);
        this.listScroll.setPreferredSize(new Dimension(200, 200));
        this.listTree.setLargeModel(true);
        this.selectBtn = new JButton("Select");
        this.selectBtn.setEnabled(false);
        this.defineBtn = new JButton("Define");
        this.defineBtn.setEnabled(false);
    }

    private void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listScroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.selectBtn);
        jPanel.add(this.defineBtn);
        this.add((Component)jPanel, gridBagConstraints);
    }

    private void populateNode(ArrayList<? extends GenericObject> arrayList, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (GenericObject genericObject : arrayList) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            if (genericObject instanceof List) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(genericObject, true);
                List list = (List)genericObject;
                list.updateChildPositions();
                ArrayList<GenericObject> arrayList2 = list.getObjects();
                this.populateNode(arrayList2, defaultMutableTreeNode2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(genericObject, false);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public int rowAtPoint(Point point) {
        return this.listTree.getRowForLocation((int)point.getX(), (int)point.getY());
    }

    public void setAvailableList(ArrayList<? extends GenericObject> arrayList) {
        this.listData = arrayList == null ? new ArrayList() : arrayList;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.listTree.getModel().getRoot();
        defaultMutableTreeNode.removeAllChildren();
        this.populateNode(this.listData, defaultMutableTreeNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.listTree.setModel(defaultTreeModel);
        this.listTree.treeDidChange();
    }

    public void setDefineListener(ActionListener actionListener) {
        this.defineBtn.removeActionListener(this.defineListener);
        this.defineBtn.addActionListener(actionListener);
        this.defineListener = actionListener;
    }

    public void setSelectedRow(int n) {
        this.listTree.setSelectionRow(n);
    }

    public void setTreeListener(TreeSelectionListener treeSelectionListener) {
        this.listTree.removeTreeSelectionListener(this.treeListener);
        this.listTree.addTreeSelectionListener(treeSelectionListener);
        this.treeListener = treeSelectionListener;
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -4025726727839447542L;

        private Renderer() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (!SelectionList.this.prefab || this.getText() == null) {
                return dimension;
            }
            int n = 80;
            if (SelectionList.this.listScroll != null && ((SelectionList)SelectionList.this).listScroll.getSize().width - n > 0 && dimension.width > ((SelectionList)SelectionList.this).listScroll.getSize().width - n) {
                int n2;
                int n3;
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n4 = fontMetrics.stringWidth(this.getText());
                int n5 = n3 = fontMetrics.getHeight();
                int n6 = (int)Rounder.roundUp(n4 / (((SelectionList)SelectionList.this).listScroll.getSize().width - n));
                if (n6 < 1) {
                    n6 = 1;
                }
                int n7 = 2;
                int n8 = n4 / n6;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                for (n2 = 0; n2 < this.getText().length(); ++n2) {
                    String string = this.getText().substring(n10, n2);
                    if (string.length() > 0 && Character.isWhitespace(string.charAt(string.length() - 1))) {
                        n9 = n2;
                    }
                    if (fontMetrics.stringWidth(string) < n8 - 30) continue;
                    ++n7;
                    n10 = n9;
                    if (n9 != n11) {
                        n2 = n9;
                        n11 = n9;
                        continue;
                    }
                    ++n7;
                }
                n5 = n2 = n3 * n7;
                dimension = new Dimension(((SelectionList)SelectionList.this).listScroll.getSize().width - n, n5);
            }
            return dimension;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof GenericObject) {
                    GenericObject genericObject = (GenericObject)defaultMutableTreeNode.getUserObject();
                    if (genericObject.isStopSign()) {
                        this.setIcon(stop);
                    } else if (genericObject.isWarnSign()) {
                        this.setIcon(warn);
                    } else if (!(genericObject instanceof List)) {
                        this.setIcon(bl ? (genericObject.showBuildDialog() ? yellow : green) : black);
                    } else if (genericObject.getName().trim().length() == 0 && ((List)genericObject).getObjects().size() == 0) {
                        this.setIcon(bl ? green : black);
                        this.setText("(separator)");
                    } else if (bl2) {
                        this.setIcon(open);
                    } else {
                        this.setIcon(closed);
                    }
                }
                if (!bl) {
                    this.setBackground(Color.white);
                    this.setOpaque(true);
                } else {
                    this.setOpaque(false);
                }
            }
            this.setVerticalAlignment(1);
            this.setVerticalTextPosition(1);
            return this;
        }
    }
}

