/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.ui.AbilityPanel;
import com.hero.ui.GenericObjectList;
import com.hero.ui.PowersList;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.MultipowerDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PowersPanel
extends AbilityPanel {
    private static final long serialVersionUID = 189480006160974586L;
    private JMenuItem elementalControlMI;
    private JMenuItem multipowerMI;
    private JMenu powerFrameworksMenu;
    private JMenuItem vppMI;

    protected void checkIndices() {
        this.selectionList.checkIndices();
    }

    @Override
    protected GenericObjectList createSelectionList() {
        return new PowersList();
    }

    @Override
    protected String getAvailableLabel() {
        return "Powers";
    }

    @Override
    protected ArrayList<GenericObject> getAvailableObjects() {
        return HeroDesigner.getActiveTemplate().getPowers();
    }

    @Override
    protected ArrayList<GenericObject> getAvailablePrefabs() {
        return HeroDesigner.getInstance().getPrefabPowers();
    }

    @Override
    protected ArrayList<GenericObject> getObjects() {
        return HeroDesigner.getActiveHero().getPowers();
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.multipowerMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Multipower multipower = new Multipower("Multipower");
                MultipowerDialog multipowerDialog = new MultipowerDialog(multipower, true);
                multipowerDialog.setLocationRelativeTo(PowersPanel.this);
                multipowerDialog.setVisible(true);
                if (multipowerDialog.okButtonClicked) {
                    PowersPanel.this.selectionList.addObject(multipower);
                }
            }
        });
        this.elementalControlMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ElementalControl elementalControl = new ElementalControl("Elemental Control");
                GenericDialog genericDialog = elementalControl.getDialog(true, true);
                genericDialog.setLocationRelativeTo(PowersPanel.this);
                genericDialog.setVisible(true);
                if (genericDialog.okButtonClicked) {
                    PowersPanel.this.selectionList.addObject(elementalControl);
                }
            }
        });
        this.vppMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariablePowerPool variablePowerPool = new VariablePowerPool("Variable Power Pool");
                GenericDialog genericDialog = variablePowerPool.getDialog(true, true);
                genericDialog.setLocationRelativeTo(PowersPanel.this);
                genericDialog.setVisible(true);
                if (genericDialog.okButtonClicked) {
                    PowersPanel.this.selectionList.addObject(variablePowerPool);
                }
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.powerFrameworksMenu = new JMenu("Power Frameworks");
        this.multipowerMI = new JMenuItem("New Multipower...");
        this.elementalControlMI = new JMenuItem("New Elemental Control...");
        this.vppMI = new JMenuItem("New Variable Power Pool...");
        this.powerFrameworksMenu.add(this.multipowerMI);
        this.powerFrameworksMenu.add(this.elementalControlMI);
        this.powerFrameworksMenu.add(this.vppMI);
        this.menuBar.add(this.powerFrameworksMenu);
    }

    @Override
    protected boolean isEquipment() {
        return false;
    }

    @Override
    protected boolean isPower() {
        return true;
    }

    @Override
    public void reset() {
        this.selectionList.setData(HeroDesigner.getActiveHero().getPowers());
        this.availableList.setAvailableList(HeroDesigner.getActiveTemplate().getPowers());
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            this.elementalControlMI.setVisible(true);
        }
        if (HeroDesigner.getInstance().getPrefs().getSources().contains("Hero System Fifth Edition Rule Book") || HeroDesigner.getInstance().getPrefs().getSources().contains("Sidekick")) {
            this.multipowerMI.setVisible(true);
            this.elementalControlMI.setVisible(true);
            this.powerFrameworksMenu.setVisible(true);
        } else {
            this.multipowerMI.setVisible(false);
            this.elementalControlMI.setVisible(false);
            this.powerFrameworksMenu.setVisible(false);
        }
        if (HeroDesigner.getActiveTemplate().is6E()) {
            this.elementalControlMI.setVisible(false);
        }
        if (HeroDesigner.getInstance().getPrefs().getSources().contains("Hero System Fifth Edition Rule Book")) {
            this.vppMI.setVisible(true);
        } else {
            this.vppMI.setVisible(false);
        }
    }
}

