/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.martialarts.ExtraDamageClasses;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.martialarts.RangedDamageClasses;
import com.hero.objects.martialarts.WeaponElement;
import com.hero.ui.GenericObjectList;
import com.hero.ui.widgets.PopupMessage;

public class PowersList
extends GenericObjectList {
    private static final long serialVersionUID = -2671634213943363405L;

    public PowersList() {
        super("Powers", "Cost", "Power", "END", HeroDesigner.getActiveHero().getPowers());
    }

    @Override
    public void addObject(GenericObject genericObject) {
        double d;
        if (HeroDesigner.getActiveHero().isPrefab()) {
            super.addObject(genericObject);
            return;
        }
        genericObject.setPower(true);
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (rules.getPowerMaxResponse() > 0) {
            Object object;
            int n;
            d = 0.0;
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                object = HeroDesigner.getActiveHero().getPowers().get(n);
                d += ((GenericObject)object).getRealCostPreList();
            }
            n = rules.getPowerMaxValue();
            if (d > (double)n && genericObject.getRealCostPreList() > 0.0) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "Total points of purchased Powers exceeds allowed maximum.", rules.getPowerMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                bl = rules.getPowerMaxResponse() == 1;
            } else if (d + genericObject.getRealCostPreList() > (double)n && genericObject.getRealCostPreList() > 0.0) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total Powers points used over the allowable limit.", rules.getPowerMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                boolean bl3 = bl = rules.getPowerMaxResponse() == 1;
            }
        }
        if (!bl2 && rules.getAvailTotalPointsResponse() > 0 && (d = genericObject.getRealCostPreList()) > 0.0) {
            double d2 = HeroDesigner.getActiveHero().getSpentTotal();
            d2 += d;
            double d3 = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
            if (HeroDesigner.getActiveTemplate().is6E()) {
                d3 -= (double)HeroDesigner.getActiveHero().getDisadPoints();
            }
            if (d2 > d3) {
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total points used over the available total for the character.", rules.getAvailTotalPointsResponse() == 1);
                popupMessage.setVisible(true);
                bl2 = true;
                boolean bl4 = bl = rules.getAvailTotalPointsResponse() == 1;
            }
        }
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl5 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl6 = bl = rules.getDefenseAPMaxResponse() == 1;
        }
        if (bl) {
            super.addObject(genericObject);
        }
    }

    @Override
    protected boolean checkPaste() {
        GenericObject genericObject = HeroDesigner.getCopyBuffer();
        if (genericObject == null) {
            return false;
        }
        if (genericObject instanceof Maneuver || genericObject instanceof ExtraDamageClasses || genericObject instanceof RangedDamageClasses || genericObject instanceof WeaponElement) {
            return false;
        }
        if (genericObject instanceof Enhancer) {
            return false;
        }
        if (genericObject instanceof List) {
            List list = (List)genericObject;
            for (int i = 0; i < list.getObjects().size(); ++i) {
                if (!(list.getObjects().get(i) instanceof Maneuver) && !(list.getObjects().get(i) instanceof ExtraDamageClasses) && !(list.getObjects().get(i) instanceof RangedDamageClasses) && !(list.getObjects().get(i) instanceof WeaponElement)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected boolean checkReplace(GenericObject genericObject, GenericObject genericObject2) {
        double d;
        if (HeroDesigner.getActiveHero().isPrefab()) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (rules.getPowerMaxResponse() > 0) {
            Object object;
            int n;
            d = 0.0;
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                object = HeroDesigner.getActiveHero().getPowers().get(n);
                d += ((GenericObject)object).getRealCostPreList();
            }
            n = rules.getPowerMaxValue();
            if (d > (double)n && genericObject.getRealCostPreList() > genericObject2.getRealCostPreList()) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This edit puts the total Power points used over the allowed limit.", rules.getPowerMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                bl = rules.getPowerMaxResponse() == 1;
            } else if (d - genericObject2.getRealCostPreList() + genericObject.getRealCostPreList() > (double)n) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This edit puts the total Powers points used over the allowed limit.", rules.getPowerMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                boolean bl3 = bl = rules.getPowerMaxResponse() == 1;
            }
        }
        if (!bl2 && rules.getAvailTotalPointsResponse() > 0) {
            d = genericObject2.getRealCostPreList();
            double d2 = genericObject.getRealCostPreList();
            if (d2 > d) {
                double d3 = HeroDesigner.getActiveHero().getSpentTotal();
                d3 -= d;
                d3 += d2;
                double d4 = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
                if (HeroDesigner.getActiveTemplate().is6E()) {
                    d4 -= (double)HeroDesigner.getActiveHero().getDisadPoints();
                }
                if (d3 > d4) {
                    PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This edit puts the total points used over the available total for the character.", rules.getAvailTotalPointsResponse() == 1);
                    popupMessage.setVisible(true);
                    bl2 = true;
                    boolean bl4 = bl = rules.getAvailTotalPointsResponse() == 1;
                }
            }
        }
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue() && d > genericObject2.getActiveCost()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl5 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue() && d > genericObject2.getActiveCost()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            bl = rules.getDefenseAPMaxResponse() == 1;
        }
        return bl;
    }

    @Override
    public void setTotalCost() {
        super.setTotalCost();
        HeroDesigner.getInstance().getMainPanel().updateCharacteristics();
    }
}

