/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;
import com.hero.ui.AbilityPanel;
import com.hero.ui.GenericObjectList;
import com.hero.ui.PerksList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class PerksPanel
extends AbilityPanel {
    private static final long serialVersionUID = 6252023160245160014L;
    JMenu perkEnhancersMenu;

    protected void checkIndices() {
        this.selectionList.checkIndices();
    }

    @Override
    protected GenericObjectList createSelectionList() {
        return new PerksList();
    }

    @Override
    protected String getAvailableLabel() {
        return "Perks";
    }

    @Override
    protected ArrayList<GenericObject> getAvailableObjects() {
        return HeroDesigner.getActiveTemplate().getPerks();
    }

    @Override
    protected ArrayList<GenericObject> getAvailablePrefabs() {
        return HeroDesigner.getInstance().getPrefabPerks();
    }

    @Override
    protected ArrayList<GenericObject> getObjects() {
        return HeroDesigner.getActiveHero().getPerks();
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.perkEnhancersMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                block0: for (int i = 0; i < PerksPanel.this.perkEnhancersMenu.getItemCount(); ++i) {
                    boolean bl = false;
                    PerkEnhancerMenuItem perkEnhancerMenuItem = (PerkEnhancerMenuItem)PerksPanel.this.perkEnhancersMenu.getItem(i);
                    for (int j = 0; j < HeroDesigner.getActiveHero().getPerks().size(); ++j) {
                        GenericObject genericObject = HeroDesigner.getActiveHero().getPerks().get(j);
                        if (genericObject.getXMLID().equals(perkEnhancerMenuItem.getXMLID())) {
                            bl = true;
                            continue block0;
                        }
                        perkEnhancerMenuItem.setSelected(bl);
                    }
                }
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.perkEnhancersMenu = new JMenu("Perk Enhancers");
        ArrayList<GenericObject> arrayList = HeroDesigner.getActiveTemplate().getSkillEnhancers();
        for (int i = 0; i < arrayList.size(); ++i) {
            GenericObject genericObject = arrayList.get(i);
            if (!genericObject.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) continue;
            PerkEnhancerMenuItem perkEnhancerMenuItem = new PerkEnhancerMenuItem(this, genericObject.getDisplay(), genericObject.getXMLID());
            for (int j = 0; j < HeroDesigner.getActiveHero().getPerks().size(); ++j) {
                GenericObject genericObject2 = HeroDesigner.getActiveHero().getPerks().get(j);
                if (!genericObject2.getXMLID().equals(genericObject.getXMLID())) continue;
                perkEnhancerMenuItem.setSelected(true);
            }
            this.perkEnhancersMenu.add(perkEnhancerMenuItem);
        }
        this.menuBar.add(this.perkEnhancersMenu);
    }

    @Override
    protected boolean isEquipment() {
        return false;
    }

    @Override
    protected boolean isPower() {
        return false;
    }

    @Override
    public void reset() {
        this.selectionList.setData(HeroDesigner.getActiveHero().getPerks());
        this.availableList.setAvailableList(HeroDesigner.getActiveTemplate().getPerks());
        this.perkEnhancersMenu.removeAll();
        ArrayList<GenericObject> arrayList = HeroDesigner.getActiveTemplate().getSkillEnhancers();
        for (int i = 0; i < arrayList.size(); ++i) {
            GenericObject genericObject = arrayList.get(i);
            if (!genericObject.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) continue;
            PerkEnhancerMenuItem perkEnhancerMenuItem = new PerkEnhancerMenuItem(this, genericObject.getDisplay(), genericObject.getXMLID());
            for (int j = 0; j < HeroDesigner.getActiveHero().getPerks().size(); ++j) {
                GenericObject genericObject2 = HeroDesigner.getActiveHero().getPerks().get(j);
                if (!genericObject2.getXMLID().equals(genericObject.getXMLID())) continue;
                perkEnhancerMenuItem.setSelected(true);
            }
            this.perkEnhancersMenu.add(perkEnhancerMenuItem);
        }
        this.perkEnhancersMenu.setVisible(this.perkEnhancersMenu.getItemCount() > 0);
    }

    private class PerkEnhancerMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = -907338421826327588L;
        PerksPanel parent;
        String xmlID;

        public PerkEnhancerMenuItem(PerksPanel perksPanel2, String string, String string2) {
            super(string);
            this.xmlID = string2;
            this.parent = perksPanel2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList<GenericObject> arrayList = HeroDesigner.getActiveHero().getPerks();
                    if (PerkEnhancerMenuItem.this.isSelected()) {
                        GenericObject genericObject;
                        int n;
                        for (n = 0; n < arrayList.size(); ++n) {
                            genericObject = arrayList.get(n);
                            if (!genericObject.getXMLID().equals(PerkEnhancerMenuItem.this.xmlID)) continue;
                            return;
                        }
                        for (n = 0; n < HeroDesigner.getActiveTemplate().getSkillEnhancers().size(); ++n) {
                            genericObject = HeroDesigner.getActiveTemplate().getSkillEnhancers().get(n);
                            if (!genericObject.getXMLID().equals(PerkEnhancerMenuItem.this.xmlID)) continue;
                            GenericObject genericObject2 = genericObject.clone();
                            PerkEnhancerMenuItem.this.parent.selectionList.addObject(genericObject2);
                            break;
                        }
                    } else {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            GenericObject genericObject = arrayList.get(i);
                            if (!genericObject.getXMLID().equals(PerkEnhancerMenuItem.this.xmlID)) continue;
                            Enhancer enhancer = (Enhancer)genericObject;
                            for (int j = 0; j < enhancer.getObjects().size(); ++j) {
                                GenericObject genericObject3 = enhancer.getObjects().get(j);
                                genericObject3.setParent(null);
                            }
                            arrayList.remove(i);
                            HeroDesigner.getActiveHero().setDirty(true);
                            break;
                        }
                    }
                    PerkEnhancerMenuItem.this.parent.selectionList.updateTotal();
                }
            });
        }

        public String getXMLID() {
            return this.xmlID;
        }
    }
}

