/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.perks.Perk;
import com.hero.ui.GenericObjectList;
import com.hero.ui.widgets.PopupMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;

public class PerksList
extends GenericObjectList {
    private static final long serialVersionUID = 7713792309636509748L;

    public PerksList() {
        super("Perks", "Cost", "Perk", null, HeroDesigner.getActiveHero().getPerks());
    }

    @Override
    public void addObject(GenericObject genericObject) {
        double d;
        if (HeroDesigner.getActiveHero().isPrefab()) {
            super.addObject(genericObject);
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (rules.getPerkMaxResponse() > 0) {
            Object object;
            int n;
            d = 0.0;
            for (n = 0; n < HeroDesigner.getActiveHero().getPerks().size(); ++n) {
                object = HeroDesigner.getActiveHero().getPerks().get(n);
                d += ((GenericObject)object).getRealCostPreList();
            }
            n = rules.getPerkMaxValue();
            if (d > (double)n && genericObject.getRealCostPreList() > 0.0) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "Total points of purchased Perks exceeds allowed maximum.", rules.getPerkMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                bl = rules.getPerkMaxResponse() == 1;
            } else if (d + genericObject.getRealCostPreList() > (double)n && genericObject.getRealCostPreList() > 0.0) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total Perks points used over the allowable limit.", rules.getPerkMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                boolean bl3 = bl = rules.getPerkMaxResponse() == 1;
            }
        }
        if (!bl2 && rules.getAvailTotalPointsResponse() > 0 && (d = genericObject.getRealCostPreList()) > 0.0) {
            double d2 = HeroDesigner.getActiveHero().getSpentTotal();
            d2 += d;
            double d3 = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
            if (HeroDesigner.getActiveTemplate().is6E()) {
                d3 -= (double)HeroDesigner.getActiveHero().getDisadPoints();
            }
            if (d2 > d3) {
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total points used over the available total for the character.", rules.getAvailTotalPointsResponse() == 1);
                popupMessage.setVisible(true);
                bl2 = true;
                boolean bl4 = bl = rules.getAvailTotalPointsResponse() == 1;
            }
        }
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl5 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl6 = bl = rules.getDefenseAPMaxResponse() == 1;
        }
        if (bl) {
            super.addObject(genericObject);
            this.setEnhancerLists();
        }
    }

    @Override
    public boolean checkPaste() {
        if (HeroDesigner.getCopyBuffer() instanceof Enhancer) {
            int n;
            for (n = 0; n < HeroDesigner.getActiveHero().getPerks().size(); ++n) {
                GenericObject genericObject = HeroDesigner.getActiveHero().getPerks().get(n);
                if (!genericObject.getXMLID().equals(HeroDesigner.getCopyBuffer().getXMLID())) continue;
                return false;
            }
            n = 0;
            for (int i = 0; i < HeroDesigner.getActiveTemplate().getSkillEnhancers().size(); ++i) {
                GenericObject genericObject = HeroDesigner.getActiveTemplate().getSkillEnhancers().get(i);
                if (!genericObject.getXMLID().equals(HeroDesigner.getCopyBuffer().getXMLID())) continue;
                n = 1;
            }
            return n != 0;
        }
        if (HeroDesigner.getCopyBuffer() instanceof List) {
            List list = (List)HeroDesigner.getCopyBuffer();
            for (int i = 0; i < list.getObjects().size(); ++i) {
                if (list.getObjects().get(i) instanceof Perk) continue;
                return false;
            }
            return true;
        }
        return HeroDesigner.getCopyBuffer() instanceof Perk;
    }

    @Override
    protected boolean checkReplace(GenericObject genericObject, GenericObject genericObject2) {
        double d;
        if (HeroDesigner.getActiveHero().isPrefab()) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (rules.getPerkMaxResponse() > 0) {
            Object object;
            int n;
            d = 0.0;
            for (n = 0; n < HeroDesigner.getActiveHero().getPerks().size(); ++n) {
                object = HeroDesigner.getActiveHero().getPerks().get(n);
                d += ((GenericObject)object).getRealCostPreList();
            }
            n = rules.getPerkMaxValue();
            if (d > (double)n && genericObject.getRealCostPreList() > genericObject2.getRealCostPreList()) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This edit puts the total Perks points used over the allowed limit.", rules.getPerkMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                bl = rules.getPerkMaxResponse() == 1;
            } else if (d - genericObject2.getRealCostPreList() + genericObject.getRealCostPreList() > (double)n) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This edit puts the total Perks points used over the allowed limit.", rules.getPerkMaxResponse() == 1);
                ((PopupMessage)object).setVisible(true);
                bl2 = true;
                boolean bl3 = bl = rules.getPerkMaxResponse() == 1;
            }
        }
        if (!bl2 && rules.getAvailTotalPointsResponse() > 0) {
            d = genericObject2.getRealCostPreList();
            double d2 = genericObject.getRealCostPreList();
            if (d2 > d) {
                double d3 = HeroDesigner.getActiveHero().getSpentTotal();
                d3 -= d;
                d3 += d2;
                double d4 = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
                if (HeroDesigner.getActiveTemplate().is6E()) {
                    d4 -= (double)HeroDesigner.getActiveHero().getDisadPoints();
                }
                if (d3 > d4) {
                    PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This edit puts the total points used over the available total for the character.", rules.getAvailTotalPointsResponse() == 1);
                    popupMessage.setVisible(true);
                    bl2 = true;
                    boolean bl4 = bl = rules.getAvailTotalPointsResponse() == 1;
                }
            }
        }
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue() && d > genericObject2.getActiveCost()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl5 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue() && d > genericObject2.getActiveCost()) {
            PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            bl = rules.getDefenseAPMaxResponse() == 1;
        }
        return bl;
    }

    @Override
    public void setData(ArrayList<GenericObject> arrayList) {
        super.setData(arrayList);
        this.setEnhancerLists();
    }

    public void setEnhancerLists() {
        ArrayList arrayList;
        GenericObject genericObject;
        int n;
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        boolean bl = false;
        for (n = HeroDesigner.getActiveHero().getPerks().size() - 1; n >= 0; --n) {
            genericObject = HeroDesigner.getActiveHero().getPerks().get(n);
            genericObject.setPosition(n);
            if (genericObject instanceof Enhancer) {
                arrayList2.add(genericObject);
                bl = true;
                continue;
            }
            if (genericObject.getEnhancerApplied() == null) continue;
            Enhancer enhancer = genericObject.getEnhancerApplied();
            if (genericObject.getParentList() != null && genericObject.getParentList().getID() == enhancer.getID()) continue;
            if (genericObject.getParentList() != null) {
                genericObject.getParentList().getObjects().remove(genericObject);
                genericObject.setParent(enhancer);
            }
            bl = true;
            if (hashtable.get(enhancer.getXMLID()) == null) {
                arrayList = new ArrayList();
                hashtable.put(enhancer.getXMLID(), arrayList);
            } else {
                arrayList = (ArrayList)hashtable.get(enhancer.getXMLID());
            }
            arrayList.add(genericObject);
        }
        Collections.sort(HeroDesigner.getActiveHero().getPerks(), new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof GenericObject && object2 instanceof GenericObject) {
                    GenericObject genericObject = (GenericObject)object;
                    GenericObject genericObject2 = (GenericObject)object2;
                    if (genericObject.getEnhancerApplied() != null) {
                        if (genericObject2.getEnhancerApplied() != null) {
                            if (genericObject.getEnhancerApplied().equals(genericObject2.getEnhancerApplied())) {
                                return genericObject.getTextOutput().compareTo(genericObject2.getTextOutput());
                            }
                            return this.compare(genericObject.getEnhancerApplied(), genericObject2.getEnhancerApplied());
                        }
                        if (genericObject.getEnhancerApplied().equals(genericObject2)) {
                            return 1;
                        }
                        return this.compare(genericObject.getEnhancerApplied(), genericObject2);
                    }
                    if (genericObject2.getEnhancerApplied() != null) {
                        if (genericObject.equals(genericObject2.getEnhancerApplied())) {
                            return -1;
                        }
                        return this.compare(genericObject, genericObject2.getEnhancerApplied());
                    }
                    return genericObject.getPosition() - genericObject2.getPosition();
                }
                return object.toString().compareTo(object2.toString());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        for (n = 0; n < arrayList2.size() && bl; ++n) {
            genericObject = (Enhancer)arrayList2.get(n);
            genericObject.setParent(null);
            int n2 = genericObject.getPosition() + 1;
            if (hashtable.get(genericObject.getXMLID()) == null) continue;
            arrayList = (ArrayList)hashtable.get(genericObject.getXMLID());
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                GenericObject genericObject2 = (GenericObject)arrayList.get(i);
                if (!((List)genericObject).getObjects().contains(genericObject2)) {
                    ((List)genericObject).addObject(genericObject2);
                }
                genericObject2.setParent((List)genericObject);
                genericObject2.setPosition(n2);
                HeroDesigner.getActiveHero().getPerks().remove(genericObject2);
                if (HeroDesigner.getActiveHero().getPerks().size() > n2) {
                    HeroDesigner.getActiveHero().getPerks().add(n2, genericObject2);
                } else {
                    HeroDesigner.getActiveHero().getPerks().add(genericObject2);
                }
                ++n2;
            }
        }
    }
}

