/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.ui.AbilityFrame;
import com.hero.ui.BackgroundPanel;
import com.hero.ui.BasicInfoPanel;
import com.hero.ui.CharacteristicsPanel;
import com.hero.ui.DisadsPanel;
import com.hero.ui.EquipmentPanel;
import com.hero.ui.ManeuversPanel;
import com.hero.ui.PerksPanel;
import com.hero.ui.PowersPanel;
import com.hero.ui.SkillsPanel;
import com.hero.ui.TalentsPanel;
import com.hero.util.Utility;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MainContentPanel
extends JTabbedPane {
    private static final long serialVersionUID = -5478235386418277609L;
    public BackgroundPanel backgroundPanel;
    public BasicInfoPanel basicInfoPanel;
    public CharacteristicsPanel characteristicsPanel;
    public DisadsPanel disadsPanel;
    public EquipmentPanel equipmentPanel;
    public ManeuversPanel maneuversPanel;
    public PerksPanel perksPanel;
    public PowersPanel powersPanel;
    public SkillsPanel skillsPanel;
    public TalentsPanel talentsPanel;
    JTextArea notes1TA;
    JTextArea notes2TA;
    JTextArea notes3TA;
    JTextArea notes4TA;
    JTextArea notes5TA;
    JScrollPane backgroundScroll;
    JScrollPane basicInfoScroll;
    JScrollPane characteristicsScroll;
    JScrollPane disadsScroll;
    JScrollPane equipmentScroll;
    JScrollPane maneuversScroll;
    JScrollPane perksScroll;
    JScrollPane powersScroll;
    JScrollPane skillsScroll;
    JScrollPane talentsScroll;
    JScrollPane notes1Scroll;
    JScrollPane notes2Scroll;
    JScrollPane notes3Scroll;
    JScrollPane notes4Scroll;
    JScrollPane notes5Scroll;
    private long lastEdit;
    public Hashtable states = new Hashtable();
    public Hashtable<JScrollPane, String> components = new Hashtable();
    public Hashtable<JScrollPane, AbilityFrame> frames = new Hashtable();

    public MainContentPanel() {
        super(1, 1);
        this.initWidgets();
        this.initListeners();
        this.setTabLayoutPolicy(0);
    }

    public void hideFrames() {
        Container container;
        Serializable serializable;
        Enumeration<JScrollPane> enumeration = this.frames.keys();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            container = this.frames.get(serializable);
            container.setVisible(false);
            container.dispose();
            this.frames.remove(serializable);
        }
        serializable = HeroDesigner.getInstance().getPrefs().getTearOffPrefs();
        enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            container = enumeration.nextElement();
            String string = this.components.get(container);
            if (((Hashtable)serializable).get(string) == null || this.states.get(container) == null) continue;
            Integer[] integerArray = (Integer[])((Hashtable)serializable).get(string);
            int n = Integer.parseInt(this.states.get(container).toString());
            integerArray[4] = new Integer(n);
            ((Hashtable)serializable).put(string, integerArray);
        }
    }

    private void initListeners() {
        this.notes1TA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes1(MainContentPanel.this.notes1TA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes1(MainContentPanel.this.notes1TA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes1(MainContentPanel.this.notes1TA.getText());
            }
        });
        this.notes2TA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes2(MainContentPanel.this.notes2TA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes2(MainContentPanel.this.notes2TA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes2(MainContentPanel.this.notes2TA.getText());
            }
        });
        this.notes3TA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes3(MainContentPanel.this.notes3TA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes3(MainContentPanel.this.notes3TA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes3(MainContentPanel.this.notes3TA.getText());
            }
        });
        this.notes4TA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes4(MainContentPanel.this.notes4TA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes4(MainContentPanel.this.notes4TA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes4(MainContentPanel.this.notes4TA.getText());
            }
        });
        this.notes5TA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes5(MainContentPanel.this.notes5TA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes5(MainContentPanel.this.notes5TA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setNotes5(MainContentPanel.this.notes5TA.getText());
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = MainContentPanel.this.getSelectedIndex();
                if (n < 0 || MainContentPanel.this.getTabCount() < 4) {
                    return;
                }
                if (n >= 0 && n <= 9) {
                    HeroDesigner.getActiveHero().setLastTabIndex(n);
                }
                MainContentPanel.this.tabChanged(MainContentPanel.this.getComponentAt(n));
            }
        });
    }

    private void initWidgets() {
        this.basicInfoPanel = new BasicInfoPanel();
        this.basicInfoScroll = new JScrollPane(this.basicInfoPanel);
        this.characteristicsPanel = new CharacteristicsPanel();
        this.characteristicsScroll = new JScrollPane(this.characteristicsPanel);
        this.backgroundPanel = new BackgroundPanel();
        this.backgroundScroll = new JScrollPane(this.backgroundPanel);
        this.skillsPanel = new SkillsPanel();
        this.skillsScroll = new JScrollPane(this.skillsPanel);
        this.maneuversPanel = new ManeuversPanel();
        this.maneuversScroll = new JScrollPane(this.maneuversPanel);
        this.perksPanel = new PerksPanel();
        this.perksScroll = new JScrollPane(this.perksPanel);
        this.talentsPanel = new TalentsPanel();
        this.talentsScroll = new JScrollPane(this.talentsPanel);
        this.powersPanel = new PowersPanel();
        this.powersScroll = new JScrollPane(this.powersPanel);
        this.equipmentPanel = new EquipmentPanel();
        this.equipmentScroll = new JScrollPane(this.equipmentPanel);
        this.disadsPanel = new DisadsPanel();
        this.disadsScroll = new JScrollPane(this.disadsPanel);
        this.notes1TA = new JTextArea();
        this.notes1TA.setLineWrap(true);
        this.notes1TA.setWrapStyleWord(true);
        this.notes1TA.setTabSize(3);
        this.notes1Scroll = new JScrollPane(this.notes1TA);
        this.notes2TA = new JTextArea();
        this.notes2TA.setLineWrap(true);
        this.notes2TA.setWrapStyleWord(true);
        this.notes2TA.setTabSize(3);
        this.notes2Scroll = new JScrollPane(this.notes2TA);
        this.notes3TA = new JTextArea();
        this.notes3TA.setLineWrap(true);
        this.notes3TA.setWrapStyleWord(true);
        this.notes3TA.setTabSize(3);
        this.notes3Scroll = new JScrollPane(this.notes3TA);
        this.notes4TA = new JTextArea();
        this.notes4TA.setLineWrap(true);
        this.notes4TA.setWrapStyleWord(true);
        this.notes4TA.setTabSize(3);
        this.notes4Scroll = new JScrollPane(this.notes4TA);
        this.notes5TA = new JTextArea();
        this.notes5TA.setLineWrap(true);
        this.notes5TA.setWrapStyleWord(true);
        this.notes5TA.setTabSize(3);
        this.notes5Scroll = new JScrollPane(this.notes5TA);
        this.addTab("Basic Info.", this.basicInfoScroll);
        this.addTab("Background", this.backgroundScroll);
        this.addTab("Characteristics", this.characteristicsScroll);
        this.addTab("Skills", this.skillsScroll);
        this.addTab("Perks", this.perksScroll);
        this.addTab("Talents", this.talentsScroll);
        this.addTab("Martial Arts", this.maneuversScroll);
        this.addTab("Powers", this.powersScroll);
        this.addTab(HeroDesigner.getActiveTemplate().is6E() ? "Complications" : "Disadvantages", this.disadsScroll);
        this.addTab("Equipment", this.equipmentScroll);
        this.addTab(HeroDesigner.getActiveHero().getRules().getNotes1Label(), this.notes1Scroll);
        this.addTab(HeroDesigner.getActiveHero().getRules().getNotes2Label(), this.notes2Scroll);
        this.addTab(HeroDesigner.getActiveHero().getRules().getNotes3Label(), this.notes3Scroll);
        this.addTab(HeroDesigner.getActiveHero().getRules().getNotes4Label(), this.notes4Scroll);
        this.addTab(HeroDesigner.getActiveHero().getRules().getNotes5Label(), this.notes5Scroll);
        this.components.put(this.basicInfoScroll, "Basic Info.");
        this.components.put(this.backgroundScroll, "Background");
        this.components.put(this.characteristicsScroll, "Characteristics");
        this.components.put(this.skillsScroll, "Skills");
        this.components.put(this.perksScroll, "Perks");
        this.components.put(this.talentsScroll, "Talents");
        this.components.put(this.maneuversScroll, "Martial Arts");
        this.components.put(this.powersScroll, "Powers");
        this.components.put(this.disadsScroll, "Disadvantages");
        this.components.put(this.equipmentScroll, "Equipment");
        this.components.put(this.notes1Scroll, HeroDesigner.getActiveHero().getRules().getNotes1Label());
        this.components.put(this.notes2Scroll, HeroDesigner.getActiveHero().getRules().getNotes2Label());
        this.components.put(this.notes3Scroll, HeroDesigner.getActiveHero().getRules().getNotes3Label());
        this.components.put(this.notes4Scroll, HeroDesigner.getActiveHero().getRules().getNotes4Label());
        this.components.put(this.notes5Scroll, HeroDesigner.getActiveHero().getRules().getNotes5Label());
        this.states.put(this.basicInfoScroll, "0");
        this.states.put(this.backgroundScroll, "0");
        this.states.put(this.characteristicsScroll, "0");
        this.states.put(this.skillsScroll, "0");
        this.states.put(this.perksScroll, "0");
        this.states.put(this.talentsScroll, "0");
        this.states.put(this.maneuversScroll, "0");
        this.states.put(this.powersScroll, "0");
        this.states.put(this.disadsScroll, "0");
        this.states.put(this.equipmentScroll, "0");
        this.states.put(this.notes1Scroll, "0");
        this.states.put(this.notes2Scroll, "0");
        this.states.put(this.notes3Scroll, "0");
        this.states.put(this.notes4Scroll, "0");
        this.states.put(this.notes5Scroll, "0");
    }

    public void recalcAll() {
        if (!this.isShowing()) {
            return;
        }
        if (this.characteristicsPanel != null) {
            this.characteristicsPanel.updateTotal();
        }
        if (this.skillsPanel != null) {
            this.skillsPanel.updateTotal();
        }
        if (this.perksPanel != null) {
            this.perksPanel.updateTotal();
        }
        if (this.talentsPanel != null) {
            this.talentsPanel.updateTotal();
        }
        if (this.powersPanel != null) {
            this.powersPanel.updateTotal();
        }
        if (this.maneuversPanel != null) {
            this.maneuversPanel.updateTotal();
        }
        if (this.disadsPanel != null) {
            this.disadsPanel.updateTotal();
        }
        if (this.equipmentPanel != null) {
            this.equipmentPanel.updateTotal();
        }
        if (this.basicInfoPanel != null) {
            this.basicInfoPanel.updateTotal();
        }
        this.lastEdit = System.currentTimeMillis();
    }

    public void reset() {
        int n;
        AbilityFrame abilityFrame;
        this.removeAll();
        this.backgroundPanel.reset();
        this.basicInfoPanel.reset();
        this.characteristicsPanel.reset();
        this.disadsPanel.reset();
        this.equipmentPanel.reset();
        this.maneuversPanel.reset();
        this.perksPanel.reset();
        this.powersPanel.reset();
        this.skillsPanel.reset();
        this.talentsPanel.reset();
        this.notes1TA.setText(HeroDesigner.getActiveHero().getNotes1());
        this.notes2TA.setText(HeroDesigner.getActiveHero().getNotes2());
        this.notes3TA.setText(HeroDesigner.getActiveHero().getNotes3());
        this.notes4TA.setText(HeroDesigner.getActiveHero().getNotes4());
        this.notes5TA.setText(HeroDesigner.getActiveHero().getNotes5());
        if (this.states.get(this.basicInfoScroll).equals("0")) {
            this.addTab("Basic Info.", this.basicInfoScroll);
            if (this.frames.get(this.basicInfoScroll) != null) {
                abilityFrame = this.frames.get(this.basicInfoScroll);
                abilityFrame.setVisible(false);
                abilityFrame.dispose();
                this.frames.remove(this.basicInfoScroll);
            }
        } else if (this.frames.get(this.basicInfoScroll) != null) {
            abilityFrame = this.frames.get(this.basicInfoScroll);
            abilityFrame.setContentPane(this.basicInfoScroll);
            if (!abilityFrame.isShowing()) {
                abilityFrame.setVisible(true);
            } else {
                abilityFrame.validate();
            }
        } else {
            abilityFrame = new AbilityFrame(this.components.get(this.basicInfoScroll).toString(), this.basicInfoScroll);
            this.frames.put(this.basicInfoScroll, abilityFrame);
            abilityFrame.pack();
            abilityFrame.setVisible(true);
        }
        if (HeroDesigner.getActiveTemplate().isBackgroundAllowed() && !HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.backgroundScroll).equals("0")) {
                this.addTab("Background", this.backgroundScroll);
                if (this.frames.get(this.backgroundScroll) != null) {
                    abilityFrame = this.frames.get(this.backgroundScroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.backgroundScroll);
                }
            } else if (this.frames.get(this.backgroundScroll) != null) {
                abilityFrame = this.frames.get(this.backgroundScroll);
                abilityFrame.setContentPane(this.backgroundScroll);
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(this.components.get(this.backgroundScroll).toString(), this.backgroundScroll);
                this.frames.put(this.backgroundScroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.backgroundScroll) != null) {
            abilityFrame = this.frames.get(this.backgroundScroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.backgroundScroll);
        }
        if (!HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.characteristicsScroll).equals("0")) {
                this.addTab("Characteristics", this.characteristicsScroll);
                if (this.frames.get(this.characteristicsScroll) != null) {
                    abilityFrame = this.frames.get(this.characteristicsScroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.characteristicsScroll);
                }
            } else if (this.frames.get(this.characteristicsScroll) != null) {
                abilityFrame = this.frames.get(this.characteristicsScroll);
                abilityFrame.setContentPane(this.characteristicsScroll);
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(this.components.get(this.characteristicsScroll).toString(), this.characteristicsScroll);
                this.frames.put(this.characteristicsScroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.characteristicsScroll) != null) {
            abilityFrame = this.frames.get(this.characteristicsScroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.characteristicsScroll);
        }
        if (this.states.get(this.skillsScroll).equals("0")) {
            this.addTab("Skills", this.skillsScroll);
            if (this.frames.get(this.skillsScroll) != null) {
                abilityFrame = this.frames.get(this.skillsScroll);
                abilityFrame.setVisible(false);
                abilityFrame.dispose();
                this.frames.remove(this.skillsScroll);
            }
        } else if (this.frames.get(this.skillsScroll) != null) {
            abilityFrame = this.frames.get(this.skillsScroll);
            abilityFrame.setContentPane(this.skillsScroll);
            if (!abilityFrame.isShowing()) {
                abilityFrame.setVisible(true);
            } else {
                abilityFrame.validate();
            }
        } else {
            abilityFrame = new AbilityFrame(this.components.get(this.skillsScroll).toString(), this.skillsScroll);
            this.frames.put(this.skillsScroll, abilityFrame);
            abilityFrame.pack();
            abilityFrame.setVisible(true);
        }
        if (this.states.get(this.perksScroll).equals("0")) {
            this.addTab("Perks", this.perksScroll);
            if (this.frames.get(this.perksScroll) != null) {
                abilityFrame = this.frames.get(this.perksScroll);
                abilityFrame.setVisible(false);
                abilityFrame.dispose();
                this.frames.remove(this.perksScroll);
            }
        } else if (this.frames.get(this.perksScroll) != null) {
            abilityFrame = this.frames.get(this.perksScroll);
            abilityFrame.setContentPane(this.perksScroll);
            if (!abilityFrame.isShowing()) {
                abilityFrame.setVisible(true);
            } else {
                abilityFrame.validate();
            }
        } else {
            abilityFrame = new AbilityFrame(this.components.get(this.perksScroll).toString(), this.perksScroll);
            this.frames.put(this.perksScroll, abilityFrame);
            abilityFrame.pack();
            abilityFrame.setVisible(true);
        }
        if (this.states.get(this.talentsScroll).equals("0")) {
            this.addTab("Talents", this.talentsScroll);
            if (this.frames.get(this.talentsScroll) != null) {
                abilityFrame = this.frames.get(this.talentsScroll);
                abilityFrame.setVisible(false);
                abilityFrame.dispose();
                this.frames.remove(this.talentsScroll);
            }
        } else if (this.frames.get(this.talentsScroll) != null) {
            abilityFrame = this.frames.get(this.talentsScroll);
            abilityFrame.setContentPane(this.talentsScroll);
            if (!abilityFrame.isShowing()) {
                abilityFrame.setVisible(true);
            } else {
                abilityFrame.validate();
            }
        } else {
            abilityFrame = new AbilityFrame(this.components.get(this.talentsScroll).toString(), this.talentsScroll);
            this.frames.put(this.talentsScroll, abilityFrame);
            abilityFrame.pack();
            abilityFrame.setVisible(true);
        }
        if (this.states.get(this.maneuversScroll).equals("0")) {
            this.addTab("Martial Arts", this.maneuversScroll);
            if (this.frames.get(this.maneuversScroll) != null) {
                abilityFrame = this.frames.get(this.maneuversScroll);
                abilityFrame.setVisible(false);
                abilityFrame.dispose();
                this.frames.remove(this.maneuversScroll);
            }
        } else if (this.frames.get(this.maneuversScroll) != null) {
            abilityFrame = this.frames.get(this.maneuversScroll);
            abilityFrame.setContentPane(this.maneuversScroll);
            if (!abilityFrame.isShowing()) {
                abilityFrame.setVisible(true);
            } else {
                abilityFrame.validate();
            }
        } else {
            abilityFrame = new AbilityFrame(this.components.get(this.maneuversScroll).toString(), this.maneuversScroll);
            this.frames.put(this.maneuversScroll, abilityFrame);
            abilityFrame.pack();
            abilityFrame.setVisible(true);
        }
        if (this.states.get(this.powersScroll).equals("0")) {
            this.addTab("Powers", this.powersScroll);
            if (this.frames.get(this.powersScroll) != null) {
                abilityFrame = this.frames.get(this.powersScroll);
                abilityFrame.setVisible(false);
                abilityFrame.dispose();
                this.frames.remove(this.powersScroll);
            }
        } else if (this.frames.get(this.powersScroll) != null) {
            abilityFrame = this.frames.get(this.powersScroll);
            abilityFrame.setContentPane(this.powersScroll);
            if (!abilityFrame.isShowing()) {
                abilityFrame.setVisible(true);
            } else {
                abilityFrame.validate();
            }
        } else {
            abilityFrame = new AbilityFrame(this.components.get(this.powersScroll).toString(), this.powersScroll);
            this.frames.put(this.powersScroll, abilityFrame);
            abilityFrame.pack();
            abilityFrame.setVisible(true);
        }
        if (this.states.get(this.disadsScroll).equals("0")) {
            this.addTab(HeroDesigner.getActiveTemplate().is6E() ? "Complications" : "Disadvantages", this.disadsScroll);
            if (this.frames.get(this.disadsScroll) != null) {
                abilityFrame = this.frames.get(this.disadsScroll);
                abilityFrame.setVisible(false);
                abilityFrame.dispose();
                this.frames.remove(this.disadsScroll);
            }
        } else if (this.frames.get(this.disadsScroll) != null) {
            abilityFrame = this.frames.get(this.disadsScroll);
            abilityFrame.setContentPane(this.disadsScroll);
            if (!abilityFrame.isShowing()) {
                abilityFrame.setVisible(true);
            } else {
                abilityFrame.validate();
            }
        } else {
            abilityFrame = new AbilityFrame(HeroDesigner.getActiveTemplate().is6E() ? "Complications" : "Disadvantages", this.disadsScroll);
            this.frames.put(this.disadsScroll, abilityFrame);
            abilityFrame.pack();
            abilityFrame.setVisible(true);
        }
        if (HeroDesigner.getActiveHero().getRules().isEquipmentAllowed() || HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.equipmentScroll).equals("0")) {
                this.addTab("Equipment", this.equipmentScroll);
                if (this.frames.get(this.equipmentScroll) != null) {
                    abilityFrame = this.frames.get(this.equipmentScroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.equipmentScroll);
                }
            } else if (this.frames.get(this.equipmentScroll) != null) {
                abilityFrame = this.frames.get(this.equipmentScroll);
                abilityFrame.setContentPane(this.equipmentScroll);
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(this.components.get(this.equipmentScroll).toString(), this.equipmentScroll);
                this.frames.put(this.equipmentScroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.equipmentScroll) != null) {
            abilityFrame = this.frames.get(this.equipmentScroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.equipmentScroll);
        }
        if (HeroDesigner.getActiveHero().getRules().useNotes1() && !HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.notes1Scroll).equals("0")) {
                this.addTab(HeroDesigner.getActiveHero().getRules().getNotes1Label(), this.notes1Scroll);
                if (this.frames.get(this.notes1Scroll) != null) {
                    abilityFrame = this.frames.get(this.notes1Scroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.notes1Scroll);
                }
            } else if (this.frames.get(this.notes1Scroll) != null) {
                abilityFrame = this.frames.get(this.notes1Scroll);
                abilityFrame.setContentPane(this.notes1Scroll);
                abilityFrame.setTitle(HeroDesigner.getActiveHero().getRules().getNotes1Label());
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(HeroDesigner.getActiveHero().getRules().getNotes1Label(), this.notes1Scroll);
                this.frames.put(this.notes1Scroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.notes1Scroll) != null) {
            abilityFrame = this.frames.get(this.notes1Scroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.notes1Scroll);
        }
        if (HeroDesigner.getActiveHero().getRules().useNotes2() && !HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.notes2Scroll).equals("0")) {
                this.addTab(HeroDesigner.getActiveHero().getRules().getNotes2Label(), this.notes2Scroll);
                if (this.frames.get(this.notes2Scroll) != null) {
                    abilityFrame = this.frames.get(this.notes2Scroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.notes2Scroll);
                }
            } else if (this.frames.get(this.notes2Scroll) != null) {
                abilityFrame = this.frames.get(this.notes2Scroll);
                abilityFrame.setContentPane(this.notes2Scroll);
                abilityFrame.setTitle(HeroDesigner.getActiveHero().getRules().getNotes2Label());
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(HeroDesigner.getActiveHero().getRules().getNotes2Label(), this.notes2Scroll);
                this.frames.put(this.notes2Scroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.notes2Scroll) != null) {
            abilityFrame = this.frames.get(this.notes2Scroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.notes2Scroll);
        }
        if (HeroDesigner.getActiveHero().getRules().useNotes3() && !HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.notes3Scroll).equals("0")) {
                this.addTab(HeroDesigner.getActiveHero().getRules().getNotes3Label(), this.notes3Scroll);
                if (this.frames.get(this.notes3Scroll) != null) {
                    abilityFrame = this.frames.get(this.notes3Scroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.notes3Scroll);
                }
            } else if (this.frames.get(this.notes3Scroll) != null) {
                abilityFrame = this.frames.get(this.notes3Scroll);
                abilityFrame.setContentPane(this.notes3Scroll);
                abilityFrame.setTitle(HeroDesigner.getActiveHero().getRules().getNotes3Label());
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(HeroDesigner.getActiveHero().getRules().getNotes3Label(), this.notes3Scroll);
                this.frames.put(this.notes3Scroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.notes3Scroll) != null) {
            abilityFrame = this.frames.get(this.notes3Scroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.notes3Scroll);
        }
        if (HeroDesigner.getActiveHero().getRules().useNotes4() && !HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.notes4Scroll).equals("0")) {
                this.addTab(HeroDesigner.getActiveHero().getRules().getNotes4Label(), this.notes4Scroll);
                if (this.frames.get(this.notes4Scroll) != null) {
                    abilityFrame = this.frames.get(this.notes4Scroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.notes4Scroll);
                }
            } else if (this.frames.get(this.notes4Scroll) != null) {
                abilityFrame = this.frames.get(this.notes4Scroll);
                abilityFrame.setContentPane(this.notes4Scroll);
                abilityFrame.setTitle(HeroDesigner.getActiveHero().getRules().getNotes4Label());
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(HeroDesigner.getActiveHero().getRules().getNotes4Label(), this.notes4Scroll);
                this.frames.put(this.notes4Scroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.notes4Scroll) != null) {
            abilityFrame = this.frames.get(this.notes4Scroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.notes4Scroll);
        }
        if (HeroDesigner.getActiveHero().getRules().useNotes5() && !HeroDesigner.getActiveHero().isPrefab()) {
            if (this.states.get(this.notes5Scroll).equals("0")) {
                this.addTab(HeroDesigner.getActiveHero().getRules().getNotes5Label(), this.notes5Scroll);
                if (this.frames.get(this.notes5Scroll) != null) {
                    abilityFrame = this.frames.get(this.notes5Scroll);
                    abilityFrame.setVisible(false);
                    abilityFrame.dispose();
                    this.frames.remove(this.notes5Scroll);
                }
            } else if (this.frames.get(this.notes5Scroll) != null) {
                abilityFrame = this.frames.get(this.notes5Scroll);
                abilityFrame.setContentPane(this.notes5Scroll);
                abilityFrame.setTitle(HeroDesigner.getActiveHero().getRules().getNotes5Label());
                if (!abilityFrame.isShowing()) {
                    abilityFrame.setVisible(true);
                } else {
                    abilityFrame.validate();
                }
            } else {
                abilityFrame = new AbilityFrame(HeroDesigner.getActiveHero().getRules().getNotes5Label(), this.notes5Scroll);
                this.frames.put(this.notes5Scroll, abilityFrame);
                abilityFrame.pack();
                abilityFrame.setVisible(true);
            }
        } else if (this.frames.get(this.notes5Scroll) != null) {
            abilityFrame = this.frames.get(this.notes5Scroll);
            abilityFrame.setVisible(false);
            abilityFrame.dispose();
            this.frames.remove(this.notes5Scroll);
        }
        for (n = 0; n < this.getTabCount() && n < 9; ++n) {
            this.setMnemonicAt(n, String.valueOf(n + 1).charAt(0));
        }
        if (this.getTabCount() > 9) {
            this.setMnemonicAt(9, 48);
        }
        this.components.put(this.notes1Scroll, HeroDesigner.getActiveHero().getRules().getNotes1Label());
        this.components.put(this.notes2Scroll, HeroDesigner.getActiveHero().getRules().getNotes2Label());
        this.components.put(this.notes3Scroll, HeroDesigner.getActiveHero().getRules().getNotes3Label());
        this.components.put(this.notes4Scroll, HeroDesigner.getActiveHero().getRules().getNotes4Label());
        this.components.put(this.notes5Scroll, HeroDesigner.getActiveHero().getRules().getNotes5Label());
        n = HeroDesigner.getActiveHero().getLastTabIndex();
        if (n >= 0 && n < this.getTabCount()) {
            this.setSelectedIndex(n);
        } else {
            this.setSelectedIndex(0);
        }
        this.setTabPlacement(HeroDesigner.getInstance().getPrefs().getTabPosition());
        this.updatePrefabs();
        this.lastEdit = System.currentTimeMillis();
        HeroDesigner.getInstance().fireDisplayReset();
    }

    public void setState(Object object, boolean bl) {
        if (bl) {
            this.states.put(object, "1");
        } else {
            this.states.put(object, "0");
        }
        this.reset();
    }

    public void setStates() {
        Hashtable<String, Integer[]> hashtable = HeroDesigner.getInstance().getPrefs().getTearOffPrefs();
        Enumeration<JScrollPane> enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            JScrollPane jScrollPane = enumeration.nextElement();
            String string = this.components.get(jScrollPane);
            if (hashtable.get(string) == null || this.states.get(jScrollPane) == null) continue;
            Integer[] integerArray = hashtable.get(string);
            this.states.put(jScrollPane, integerArray[4].toString());
        }
    }

    public void tabChanged(Object object) {
        try {
            if (object.equals(this.skillsScroll)) {
                this.skillsPanel.getSelectionList().setSelected(true);
            } else if (object.equals(this.perksScroll)) {
                this.perksPanel.getSelectionList().setSelected(true);
            } else if (object.equals(this.talentsScroll)) {
                this.talentsPanel.getSelectionList().setSelected(true);
            } else if (object.equals(this.maneuversScroll)) {
                this.maneuversPanel.getSelectionList().setSelected(true);
            } else if (object.equals(this.powersScroll)) {
                this.powersPanel.getSelectionList().setSelected(true);
            } else if (object.equals(this.disadsScroll)) {
                this.disadsPanel.getSelectionList().setSelected(true);
            } else if (object.equals(this.equipmentScroll)) {
                this.equipmentPanel.getSelectionList().setSelected(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        if (HeroDesigner.lastEdit > 0L && (this.lastEdit <= 0L || this.lastEdit < HeroDesigner.lastEdit)) {
            if (object.equals(this.basicInfoScroll)) {
                this.basicInfoPanel.updateTotal();
            } else if (object.equals(this.characteristicsScroll)) {
                this.characteristicsPanel.updateTotal();
            } else if (object.equals(this.skillsScroll)) {
                this.skillsPanel.updateTotal();
            } else if (object.equals(this.perksScroll)) {
                this.perksPanel.updateTotal();
            } else if (object.equals(this.talentsScroll)) {
                this.talentsPanel.updateTotal();
            } else if (object.equals(this.maneuversScroll)) {
                this.maneuversPanel.updateTotal();
            } else if (object.equals(this.powersScroll)) {
                this.powersPanel.updateTotal();
            } else if (object.equals(this.disadsScroll)) {
                this.disadsPanel.updateTotal();
            } else if (object.equals(this.equipmentScroll)) {
                this.equipmentPanel.updateTotal();
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String string;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (HeroDesigner.getActiveHero() != null) {
                                MainContentPanel.this.updateFrames(HeroDesigner.getAppFrame());
                            }
                        }
                    });
                    int n = MainContentPanel.this.getSelectedIndex();
                    if (n < 0 || n >= MainContentPanel.this.getTabCount()) {
                        n = 0;
                    }
                    String string2 = string = n < MainContentPanel.this.getTabCount() ? MainContentPanel.this.getTitleAt(n) : "";
                    if (!string.equals("Basic Info.")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.basicInfoPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Characteristics")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.characteristicsPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Skills")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.skillsPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Perks")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.perksPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Talents")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.talentsPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Martial Arts")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.maneuversPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Powers")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.powersPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Disadvantages") && !string.equals("Complications")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.disadsPanel.updateTotal();
                                }
                            }
                        });
                    }
                    if (!string.equals("Equipment")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (HeroDesigner.getActiveHero() != null) {
                                    MainContentPanel.this.equipmentPanel.updateTotal();
                                }
                            }
                        });
                    }
                }
            });
            thread.start();
            this.lastEdit = System.currentTimeMillis();
            Utility.garbageCollect("Change to " + this.components.get(object) + " tab");
            HeroDesigner.getInstance().fireTabChanged();
        }
    }

    public void tearOff() {
        if (this.getSelectedIndex() < 0) {
            return;
        }
        this.states.put(this.getComponentAt(this.getSelectedIndex()), "1");
        this.reset();
    }

    public void updateCharacteristics() {
        if (this.characteristicsPanel != null) {
            this.characteristicsPanel.updateTotal();
        }
    }

    public void updateFrames(Container container) {
        Object object;
        if (!this.isShowing()) {
            return;
        }
        if (HeroDesigner.getActiveHero().isLoading()) {
            return;
        }
        boolean bl = false;
        for (Container container2 = container.getParent(); container2 != null; container2 = container2.getParent()) {
            if (!(container2 instanceof AbilityFrame)) continue;
            bl = true;
            break;
        }
        if (bl && this.getSelectedIndex() >= 0 && !container.equals(this.getComponentAt(this.getSelectedIndex()))) {
            object = this.getComponentAt(this.getSelectedIndex());
            if (this.characteristicsPanel != null && object.equals(this.characteristicsScroll)) {
                this.characteristicsPanel.updateTotal();
            }
            if (this.skillsPanel != null && object.equals(this.skillsScroll)) {
                this.skillsPanel.updateTotal();
            }
            if (this.perksPanel != null && object.equals(this.perksScroll)) {
                this.perksPanel.updateTotal();
            }
            if (this.talentsPanel != null && object.equals(this.talentsScroll)) {
                this.talentsPanel.updateTotal();
            }
            if (this.powersPanel != null & object.equals(this.powersScroll)) {
                this.powersPanel.updateTotal();
            }
            if (this.maneuversPanel != null && object.equals(this.maneuversScroll)) {
                this.maneuversPanel.updateTotal();
            }
            if (this.disadsPanel != null && object.equals(this.disadsScroll)) {
                this.disadsPanel.updateTotal();
            }
            if (this.equipmentPanel != null && object.equals(this.equipmentScroll)) {
                this.equipmentPanel.updateTotal();
            }
            if (this.basicInfoPanel != null & object.equals(this.basicInfoScroll)) {
                this.basicInfoPanel.updateTotal();
            }
        }
        object = this.frames.keys();
        while (object.hasMoreElements()) {
            AbilityFrame abilityFrame;
            JScrollPane jScrollPane = object.nextElement();
            if (jScrollPane.equals(container) || !(abilityFrame = this.frames.get(jScrollPane)).isShowing()) continue;
            if (this.characteristicsPanel != null && jScrollPane.equals(this.characteristicsScroll)) {
                this.characteristicsPanel.updateTotal();
            }
            if (this.skillsPanel != null && jScrollPane.equals(this.skillsScroll)) {
                this.skillsPanel.updateTotal();
            }
            if (this.perksPanel != null && jScrollPane.equals(this.perksScroll)) {
                this.perksPanel.updateTotal();
            }
            if (this.talentsPanel != null && jScrollPane.equals(this.talentsScroll)) {
                this.talentsPanel.updateTotal();
            }
            if (this.powersPanel != null & jScrollPane.equals(this.powersScroll)) {
                this.powersPanel.updateTotal();
            }
            if (this.maneuversPanel != null && jScrollPane.equals(this.maneuversScroll)) {
                this.maneuversPanel.updateTotal();
            }
            if (this.disadsPanel != null && jScrollPane.equals(this.disadsScroll)) {
                this.disadsPanel.updateTotal();
            }
            if (this.equipmentPanel != null && jScrollPane.equals(this.equipmentScroll)) {
                this.equipmentPanel.updateTotal();
            }
            if (!(this.basicInfoPanel != null & jScrollPane.equals(this.basicInfoScroll))) continue;
            this.basicInfoPanel.updateTotal();
        }
    }

    public void updatePrefabs() {
        if (this.skillsPanel != null) {
            this.skillsPanel.updatePrefabs();
        }
        if (this.perksPanel != null) {
            this.perksPanel.updatePrefabs();
        }
        if (this.talentsPanel != null) {
            this.talentsPanel.updatePrefabs();
        }
        if (this.powersPanel != null) {
            this.powersPanel.updatePrefabs();
        }
        if (this.maneuversPanel != null) {
            this.maneuversPanel.updatePrefabs();
        }
        if (this.disadsPanel != null) {
            this.disadsPanel.updatePrefabs();
        }
        if (this.equipmentPanel != null) {
            this.equipmentPanel.updatePrefabs();
        }
    }

    public void updateTabs() {
        if (!this.isShowing()) {
            return;
        }
        int n = this.getSelectedIndex();
        String string = this.getTitleAt(n);
        if (string.equals("Basic Info.") && HeroDesigner.getActiveHero() != null) {
            this.basicInfoPanel.updateTotal();
        } else if (string.equals("Characteristics") && HeroDesigner.getActiveHero() != null) {
            this.characteristicsPanel.updateTotal();
        } else if (string.equals("Skills") && HeroDesigner.getActiveHero() != null) {
            this.skillsPanel.updateTotal();
        } else if (string.equals("Perks") && HeroDesigner.getActiveHero() != null) {
            this.perksPanel.updateTotal();
        } else if (string.equals("Talents") && HeroDesigner.getActiveHero() != null) {
            this.talentsPanel.updateTotal();
        } else if (string.equals("Martial Arts") && HeroDesigner.getActiveHero() != null) {
            this.maneuversPanel.updateTotal();
        } else if (string.equals("Powers") && HeroDesigner.getActiveHero() != null) {
            this.powersPanel.updateTotal();
        } else if ((string.equals("Disadvantages") || string.equals("Complications")) && HeroDesigner.getActiveHero() != null) {
            this.disadsPanel.updateTotal();
        } else if (string.equals("Equipment") && HeroDesigner.getActiveHero() != null) {
            this.equipmentPanel.updateTotal();
        }
    }

    public void verify() {
        this.disadsPanel.checkIndices();
        this.equipmentPanel.checkIndices();
        this.maneuversPanel.checkIndices();
        this.perksPanel.checkIndices();
        this.powersPanel.checkIndices();
        this.skillsPanel.checkIndices();
        this.talentsPanel.checkIndices();
    }
}

